/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// There's a lot of kppp stuff in here.  Many thanks to the developers and maintainers
// For such a decent and trustworthy dialer.

#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <assert.h>
#include <signal.h>
#include <paths.h>
#include <stdio.h>
#include <sys/socket.h>


#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <assert.h>

#ifdef _XPG4_2
#define __xnet_connect	connect
#endif

#include <errno.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#ifdef __linux__
#include "runtests.h"
#endif

#include <kprocess.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kmainwindow.h>
#include <kiconview.h>
#include <klocale.h>
#include <kapplication.h>
#include <stdlib.h>
#include <errno.h>

#include "runtests.h"
#include "openingdialog.h"
#include "prefdialog.h"
#include "docking.h"
#include "knet.h"
#include "auth.h"
#include "pppdata.h"
#include "opener.h"
#include "requester.h"
#include "pppstats.h"
#include "main.h"
#include "modem.h"
#include "utils.h"
#include "ethernetscan.h"
#include "ethernetConfig.h"
#include "networkConfig.h"
#include "modemscan.h"
#include "networkdev.h"
#include "auth.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qregexp.h>

// delay disconnection for a second
#define DISCONNECT_DELAY 1000

 int rogueConnection;
 extern DockWidget* dock_widget;
 extern knet *p_knet;
 extern EthernetScan* ethernetscan;
 extern openingDialog* openingdialog;
 extern PPPStats* stats;
 extern PrefDialog* m_prefDialog;
 QString old_hostname;
 bool modified_hostname;
// knet::knet(QWidget *parent, const char *name)
// : KDialogBase(0, i18n("Preferences"), Ok|Apply|Cancel, NoDefault , parent, name)
//   knet::knet(QWidget *parent, const char *name)
// : KDialogBase(parent, name, QString::null)
knet::knet(QWidget *parent, const char *name )
   : QWidget(parent, name),
    m_prefDialog(0),
    myreadbuffer(""),
    main_timer_ID(0),
    vmain(0),
    substate(-1),
    scriptindex(0),
    loopnest(0),
    loopend(false),
    semaphore(false),
    expecting(false),
    readbuffer(""),
    scanvar(""),
    scanning(false),
    pausing(false),
    dialnumber(0)
//    stats(st)
{

  int result = runTests();
  if(result == TEST_CRITICAL)
    exit(4);


  openingLayout = new QGridLayout( this, 1, 1, 11, 6, "openingLayout");
  openingdialog = new openingDialog(this, "openingdialog");
  openingLayout->addWidget(openingdialog,0,0,0);
  resize( QSize(100, 100).expandedTo(minimumSizeHint()) );    

  debugwindow = new DebugWidget(0,"debugwindow");
//  KWin::setIcons(debugwindow->winId(), kapp->icon(), kapp->miniIcon());
  debugwindow->hide();

  clearWState( WState_Polished );  
   
//      openingdialog = new openingDialog(this);
   
//      networkdev->reparent(this,0,QPoint(0,0), true);
//      setMainWidget(openingdialog); 
//    resize( QSize(200, 300).expandedTo(minimumSizeHint()) ); 
  (void)new Modem;	        

  
//    ethernetscan->ethernetDetails();
  installEventFilter(this);
  stats = new PPPStats;
  this->show();
 // openingdialog->logCheckBox->setEnabled(FALSE);
  dock_widget = new DockWidget(this, "dockw", stats);

    connect(dock_widget,SIGNAL( iconDisconnect() ), this, SLOT (discon()));
    connect(dock_widget,SIGNAL( iconConnect() ), this, SLOT (startProcess()));

    connect(stats, SIGNAL( lostConnection() ), this, SLOT(lostConnection()));  
    connect(stats, SIGNAL( resetStatus() ), this, SLOT(getStats()));
    connect(stats, SIGNAL( interfaceUp() ), this, SLOT(interfaceUp()));
    connect( openingdialog->setupButton, SIGNAL( clicked() ), this, SLOT( expandbutton() ) );
    connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );
    connect(kapp, SIGNAL(shutDown()),
	  this, SLOT(shutDown())); 
    connect(kapp, SIGNAL(saveYourself()),
	  this, SLOT(saveMyself()));
    connect(dock_widget, SIGNAL( configSetup() ), this, SLOT (expandbutton() ) );	  
    connect (openingdialog->internetIconView , SIGNAL( clicked(QIconViewItem*, const QPoint&)), this, SLOT(accountselected(QIconViewItem*) ));	  	  
    connect (openingdialog->logCheckBox, SIGNAL(toggled(bool)), this, SLOT(log_window_toggled(bool)));
    openingdialog->logCheckBox->setChecked(gpppdata.get_show_log_window());
//  clocktimer = new QTimer(this);
//  connect(clocktimer, SIGNAL(timeout()), SLOT(timeclick())); 
   connect(this, SIGNAL(closeDebugWindow()),
	  debugwindow, SLOT(hide()));
  connect(this, SIGNAL(debugMessage(const QString &)),
	  debugwindow, SLOT(statusLabel(const QString &)));
  connect(this, SIGNAL(toggleDebugWindow()),
	  debugwindow, SLOT(toggleVisibility()));
  connect(this, SIGNAL(debugPutChar(unsigned char)),
	  debugwindow, SLOT(addChar(unsigned char)));
   kapp->processEvents();

  timeout_timer = new QTimer(this);
  connect(timeout_timer, SIGNAL(timeout()), SLOT(script_timed_out()));
  
  inittimer = new QTimer(this);
  connect(inittimer, SIGNAL(timeout()), SLOT(init()));  
  
  if_timeout_timer = new QTimer(this);
  connect(if_timeout_timer, SIGNAL(timeout()), SLOT(if_waiting_timed_out()));

  connect(this,SIGNAL(if_waiting_signal()),this,SLOT(if_waiting_slot()));
 
  pausetimer = new QTimer(this);
  connect(pausetimer, SIGNAL(timeout()), SLOT(pause()));
 
   if_timer = new QTimer(this);
  connect(if_timer,SIGNAL(timeout()), SLOT(if_waiting_slot()));
  resetAccounts();

  dock_widget->show(); 
  networkscan();
  rogueConnection=0;
  if(gpppdata.pppdRunning()==FALSE )
     if(gpppdata.storeConnect()==1){
        if(gpppdata.accname().isEmpty())
	 return;
	 else
      startProcess();

	}

}

void knet::log_window_toggled(bool on) {
  gpppdata.set_show_log_window(on);
  if(openingdialog->logCheckBox->isChecked() )
  debugwindow->show();
  else
  debugwindow->hide();

}

void knet::networkscan()
{
  // We Test to see if there are any Internet Connections currently running on the system.  If they are, offer the user some choices.

	FILE* fp = fopen("/proc/net/dev", "r");

//	QStringList list;

	char interface[8];
	char buffer[128];

	// Ignore header...
	fgets(buffer, sizeof(buffer), fp);
	fgets(buffer, sizeof(buffer), fp);
	while(fgets(buffer, sizeof(buffer), fp))
	{
		sscanf(buffer, " %[^ \t\r\n:]", interface);

	QString ethDev = interface;
		if((ethDev)=="ppp0") {

	int response = KMessageBox::Yes; // Monitor the Connection

 	response = KMessageBox::questionYesNo(this, i18n("It appears an internet connection is currently running on %1.\n  Would you like to delete this connection or would you like Knet to monitor this connection?").arg(ethDev) ,
        i18n("Internet Connection detected"), i18n("Delete"), i18n("Monitor"));
	if (response == KMessageBox::Yes ) {
          Requester::rq->killRoguePppd();
          rogueConnection= 0;
          discon();

	  }

	if (response == KMessageBox::No ) { //Kill the existing connetion
	// Here we connect the status stuff to the internet connection, and give it a fake name of ppp0.
//	     KMessageBox::information(this, i18n("Testing the Monitoring section in kdsl.cpp"));
	  gpppdata.setConnectedAccount("ppp0");
 
          KStandardDirs *dirs = KGlobal::dirs();  
          QString Icons = dirs->findResource ("data","../icons/default.kde/64x64/apps/kppp.png" );
//	  QString icon = "/opt/kde-3.3.2/share/icons/crystalsvg/64x64/apps/kppp.png";// dirs->findResource("icon", "kppp.png");

          gpppdata.setConnectedAccountIconName(Icons);
       	  stats->setUnit(0);
	  stats->ifIsUp();
          stats->start();
	  interfaceUp();
          openingdialog->internetStatusLabel->setText(i18n("Connected to ppp0") );
          openingdialog->connectButton->setText(i18n("Disconnect"));
          connect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
          disconnect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );
          dock_widget->conToProv->setEnabled(FALSE);
          dock_widget->disFromProv->setEnabled(TRUE);
	  dock_widget->refreshIcon();
          gpppdata.setpppdRunning(true); 
	  rogueConnection = 1;
  		  } 

	}
		}

    }

void knet::testOSD()
{
    dock_widget->addBalloon();
}

void knet::interfaceUp()
{
     stats->start();
     dock_widget->take_stats();
     dock_widget->addBalloon();
     openingdialog->internetStatusLabel->setText(i18n("Connected to %1").arg(gpppdata.accname() ) );
     dock_widget->refreshIcon();
} 

void knet::if_waiting_timed_out()
{
//  KMessageBox::information(this, i18n("%1 seconds for timeout").arg(gpppdata.pppdTimeout()) );
  if_timer->stop();
  if_timeout_timer->stop();
  gpppdata.setpppdError(E_IF_TIMEOUT);   
  Requester::rq->killPPPDaemon();
//  discon();
}

void knet::script_timed_out()
{
  if(vmain == 20) { // we are in the 'wait for the user to cancel' state
    timeout_timer->stop();
    return;
  }
  if(gpppdata.storedAccType()=="dialup")
     Modem::modem->hangup();
  vmain = 0;
  substate = -1;
}

void knet::getStats()
{
		stats->stop();
	  	openingdialog->internetStatusLabel->setText( tr2i18n( "Failed to Connect" ) );
                openingdialog->internetIconView->setEnabled(TRUE);
}

bool knet::execppp()
{

  openingdialog->internetIconView->setEnabled(FALSE);
  QString pppddir = "/usr/lib/pppd/" + gpppdata.pppdVersion();
  QString command;
  command = "pppd";
  command += " ";

  if (gpppdata.storedAccType()=="dialup")
     {

  command += " ";
  command += gpppdata.device();
//	KMessageBox::information(this, i18n("Tessting Dialup stuff in execppp()"));
        command += " " + gpppdata.speed();
//        command += " -detach";
//        command += " ";
//  if(gpppdata.subnetmask() != "0.0.0.0")
//    command += " netmask " + gpppdata.subnetmask();

  if(gpppdata.flowcontrol() != "None") {
    if(gpppdata.flowcontrol() == "Hardware [CRTSCTS]")
      command += " crtscts";
    else
      command += " xonxoff";
  }

  if(gpppdata.defaultroute())
    command += " defaultroute";

  if(gpppdata.autoDNS())
    command += " usepeerdns";

  QStringList &arglist = gpppdata.pppdArgument();
  for ( QStringList::Iterator it = arglist.begin();
        it != arglist.end();
        ++it )
  {
    command += " " + *it;
  }

  // Callback settings
  if(gpppdata.callbackType() && !gpppdata.waitCallback()) {
    if(!gpppdata.pppdVersionMin(2, 4, 2)) {
      command += " +callback";
      if(gpppdata.callbackType() == CBTYPE_USER)
        command += " callback " + gpppdata.callbackPhone();
    } else {
      command += " callback ";
      command += gpppdata.callbackType() == CBTYPE_ADMIN ?
                 QString("0") : gpppdata.callbackPhone();
    }
    

  } else
    gpppdata.setWaitCallback(false);

  // PAP settings
  if(gpppdata.authMethod() == AUTH_PAP) {
    command += " -chap user ";
    command = command + "\"" + gpppdata.storedUsername() + "\"";
  }

  // CHAP settings
  if(gpppdata.authMethod() == AUTH_CHAP) {
    command += " -pap user ";
    command = command + "\"" + gpppdata.storedUsername() + "\"";
  }

  // PAP/CHAP settings
  if(gpppdata.authMethod() == AUTH_PAPCHAP) {
    command += " user ";
    command = command + "\"" + gpppdata.storedUsername() + "\"";
  }

  // check for debug
  if(gpppdata.getPPPDebug())
    command += " debug";

  command += " ";
  command += "-detach";
  command += " ";

  if (command.length() > MAX_CMDLEN) {
    KMessageBox::error(this, i18n(
			      "pppd command + command-line arguments exceed "
			      "2024 characters in length."
			      ));

    return false; // nonsensically long command which would bust my buffer buf.
    }	
     }

  if (gpppdata.storedAccType()=="DSL")
    {
  if (gpppdata.protocol()=="PPPoE"){
  command += "plugin";
  command += " ";
  command += pppddir + "/rp-pppoe.so";
  command += " ";
  command += gpppdata.device();
  command += " ";
  }

  if (gpppdata.protocol()=="PPPoA"){
  command += "plugin";
  command += " ";
  command +=  pppddir + "/pppoatm.so";
  command += " ";
//  command += gpppdata.device();
//  command += " ";
  QString vpi= QString::number(gpppdata.vpi());
  QString vci= QString::number(gpppdata.vci());
  command += vpi;
  command += ".";
  command += vci;
  command += " ";
  }


  if(gpppdata.defaultroute()==1){
  command += "defaultroute";
  command += " ";
  }

  if (gpppdata.get_noauth()==0) {
  command += "noauth";
  command += " ";
  }

  if (gpppdata.autoDNS()==1) {
  command += "usepeerdns";
  command += " ";
  }
  
  command += "hide-password";
  command += " ";

  QString max= QString::number(gpppdata.maxfail());
  command += "maxfail";
  command += " ";
  command += max; //gpppdata.echo_failure();
  command += " ";

  QString mru= QString::number(gpppdata.mru());
  command += "mru";
  command += " ";
  command += mru;
  command += " ";

  QString mtu= QString::number(gpppdata.mtu());
  command += "mtu";
  command += " ";
  command += mtu;
  command += " ";

  QString f= QString::number(gpppdata.echo_failure());
  command += "lcp-echo-failure";
  command += " ";
  command += f; //gpppdata.echo_failure();
  command += " ";

  QString i= QString::number(gpppdata.echo_interval());
  command += "lcp-echo-interval";
  command += " ";
  command += i;
  command += " ";

  if (gpppdata.get_noccp()==1) {
  command += "noccp";
  command += " ";
  }

  if (gpppdata.get_nopcomp()==1) {
  command += "nopcomp";
  command += " ";
  }

  if (gpppdata.get_novj()==1) {
  command += "novj";
  command += " ";
  }

  if (gpppdata.get_novjccomp()==1) {
  command += "novjccomp";
  command += " ";
  }

  if (gpppdata.get_nobsdcomp()==1) {
  command += "nobsdcomp";
  command += " ";
  }

  if (gpppdata.get_nodeflate()==1) {
  command += "nodeflate";
  command += " ";
  }

  if (gpppdata.get_noipdefault()==1) {
  command += "noipdefault";
  command += " ";
  }

  if (gpppdata.get_persist()==1) {
  command += "persist";
  command += " ";
  QString hold = QString::number(gpppdata.holdoff());
  command += "holdoff";
  command += " ";
  command += hold;
  command += " ";
  }

  command += "-detach";
  command += " ";

  command += " user ";
  command = command + "\"" + gpppdata.storedUsername() + "\"";
  }

  if (gpppdata.storedAccType()=="SCRIPT")
   {
    command += " ";
    command += gpppdata.scriptArg();
    command += " ";
    command += "-detach";
    command += " ";

    command += " user ";
    command = command + "\"" + gpppdata.storedUsername() + "\"";
   }
  kdDebug("knet") << command << endl;
  kapp->flushX();
  return Requester::rq->execPPPDaemon(command);
	
}

void knet::setScan(const QString &n) {
  scanning = true;
  scanstr = n;
  scanbuffer = "";

  QString ts = i18n("Scanning: %1").arg(n);
  emit debugMessage(ts);
}

void knet::setExpect(const QString &n) {
  expecting = true;
  expectstr = n;

  QString ts = i18n("Expecting: %1").arg(n);
  ts.replace(QRegExp("\n"), "<LF>");
  emit debugMessage(ts);

  // check if the expected string is in the read buffer already.
  checkBuffers();
}



void knet::writeline(const QString &s) {
  Modem::modem->writeLine(s.local8Bit());
}

void knet::timerEvent(QTimerEvent*)
{

  if (semaphore || pausing)
    return;

  if(vmain == 0) {
#ifdef DEBUG_WO_DIALING
    vmain = 10;
    return;
#endif

    assert(PPPData::NumInitStrings > 0);
    // first init string ?
    if(substate == -1) {
      openingdialog->internetStatusLabel->setText(i18n("Initializing modem..."));
      emit debugMessage(i18n("Initializing modem..."));
      substate = 0;
    }

    QString initStr = gpppdata.modemInitStr(substate);
    if (!initStr.isEmpty()) {
	// send a carriage return and then wait a bit so that the modem will
	// let us issue commands.
	if(gpppdata.modemPreInitDelay() > 0) {
	    usleep(gpppdata.modemPreInitDelay() * 5000);
	    writeline("");
	    usleep(gpppdata.modemPreInitDelay() * 5000);
	}
	setExpect(gpppdata.modemInitResp());
	writeline(initStr);
	usleep(gpppdata.modemInitDelay() * 10000); // 0.01 - 3.0 sec
    }

    substate++;

    /*
     * FIXME after 3.0: Make it possible to disable ATS11 since it
     * seems to be incompatible with some ISDN adapters (e.g. DataBox
     * Speed Dragon). Even better would be to detect this when doing
     * a "Modem Query"
     */

    if (MODEM_TONEDURATION != gpppdata.modemToneDuration())
        vmain = 5;
    else
        vmain = 3;

    return;
  }

  if (vmain == 5) {
    if(!expecting) {
        QString sToneDuration = "ATS11=" + QString::number(gpppdata.modemToneDuration());
        QString msg = i18n("Setting ") + sToneDuration;
        openingdialog->internetStatusLabel->setText(msg);
	emit debugMessage(msg);
	setExpect(gpppdata.modemInitResp());
	writeline(sToneDuration);
      }
    vmain = 3;
    return;
  }

  if(vmain == 3) {
    if(!expecting) {
      // done with all init strings ?
      if(substate < PPPData::NumInitStrings) {
	vmain = 0;
	return;
      }
      substate = -1;
      // skip setting the volume if command is empty
      if(gpppdata.volumeInitString().isEmpty()) {
        vmain = 4;
        return;
      }
      openingdialog->internetStatusLabel->setText(i18n("Setting speaker volume..."));
      emit debugMessage(i18n("Setting speaker volume..."));
      setExpect(gpppdata.modemInitResp());
      QString vol("AT");
      vol += gpppdata.volumeInitString();
      writeline(vol);
      usleep(gpppdata.modemInitDelay() * 10000); // 0.01 - 3.0 sec
      vmain = 4;
      return;
    }
  }

  if(vmain == 4) {
    if(!expecting) {
      if(!gpppdata.waitForDialTone() || gpppdata.waitCallback()) {
	QString msg = i18n("Turning off dial tone waiting...");
	openingdialog->internetStatusLabel->setText(msg);
	emit debugMessage(msg);
	setExpect(gpppdata.modemInitResp());
	writeline(gpppdata.modemNoDialToneDetectionStr());
      }
      vmain = 1;
      return;
    }
  }

  // dial the number and wait to connect
  if(vmain == 1) {
    if(!expecting) {

      timeout_timer->stop();
      timeout_timer->start(gpppdata.modemTimeout()*1000);

      if(gpppdata.waitCallback()) {
        QString msg = i18n("Waiting for callback...");
        openingdialog->internetStatusLabel->setText(msg);
        emit debugMessage(msg);
        setExpect(gpppdata.modemRingResp());
        vmain = 102;
        return;
      }

      QString plist = gpppdata.phonenumber();
//      QString bmarg= gpppdata.dialPrefix();
//      bmarg += *plist.at(dialnumber);
      QString bm = i18n("Dialing %1").arg(gpppdata.phonenumber());
      openingdialog->internetStatusLabel->setText(bm);
      emit debugMessage(bm);

      QString pn = gpppdata.modemDialStr();
//      pn += gpppdata.dialPrefix();
      pn += plist;
      writeline(pn);

      setExpect(gpppdata.modemConnectResp());
      vmain = 100;
      return;
    }
  }

  // wait for connect, but redial if BUSY or wait for user cancel
  // if NO CARRIER or NO DIALTONE
  if(vmain == 100) {
    if(!expecting) {
      myreadbuffer = gpppdata.modemConnectResp();
      setExpect("\n");
      vmain = 101;
      return;
    }

    if(readbuffer.contains(gpppdata.modemBusyResp())) {
      timeout_timer->stop();
      timeout_timer->start(gpppdata.modemTimeout()*1000);

      openingdialog->internetStatusLabel->setText(i18n("Line busy. Hanging up..."));
      emit debugPutChar('\n');
      Modem::modem->hangup();

      if(gpppdata.busyWait() > 0) {
	QString bm = i18n("Line busy. Waiting: %1 seconds").arg(gpppdata.busyWait());
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	pausing = true;

	pausetimer->start(gpppdata.busyWait()*1000, true);
	timeout_timer->stop();
      }

      Modem::modem->setDataMode(false);
      vmain = 0;
      substate = -1;
      gpppdata.setWaitCallback(false);
      return;
    }

    if(readbuffer.contains(gpppdata.modemNoDialtoneResp())) {
      timeout_timer->stop();

      openingdialog->internetStatusLabel->setText(i18n("No Dial Tone"));
      vmain = 20;
      Modem::modem->unlockdevice();
      gpppdata.setWaitCallback(false);
      return;
    }

    if(readbuffer.contains(gpppdata.modemNoCarrierResp())) {
      if (gpppdata.get_redial_on_nocarrier()) {
        timeout_timer->stop();
        timeout_timer->start(gpppdata.modemTimeout()*1000);

        if(gpppdata.busyWait() > 0) {
	  QString bm = i18n("No carrier. Waiting: %1 seconds").arg(gpppdata.busyWait());
	  openingdialog->internetStatusLabel->setText(bm);
	  emit debugMessage(bm);

	  pausing = true;

	  pausetimer->start(gpppdata.busyWait()*1000, true);
	  timeout_timer->stop();
        }

        Modem::modem->setDataMode(false);
        vmain = 0;
        substate = -1;
        return;
      } else {
        timeout_timer->stop();

        openingdialog->internetStatusLabel->setText(i18n("No Carrier"));
        vmain = 20;
        Modem::modem->unlockdevice();
        gpppdata.setWaitCallback(false);
      }
      return;
    }

    if(readbuffer.contains(gpppdata.modemDLPResp())) {
      timeout_timer->stop();

      openingdialog->internetStatusLabel->setText(i18n("Digital Line Protection Detected."));
      vmain = 20;
      Modem::modem->unlockdevice();
      KMessageBox::error(this,
                         i18n("A Digital Line Protection (DLP) error response "
			      "has been detected.\n"
                              "Please disconnect the phone line.\n\n"
                              "Do NOT connect this modem to a digital phone "
			      "line or the modem could get permanently "
			      "damaged"));
      gpppdata.setWaitCallback(false);
      return;
    }


  }

  // wait for newline after CONNECT response (so we get the speed)
  if(vmain == 101) {
    if(!expecting) {
      Modem::modem->setDataMode(true); // modem will no longer respond to AT commands

//      emit startAccounting();
//      p_kppp->con_win->startClock();

      vmain = 2;
      scriptTimeout=gpppdata.modemTimeout()*1000;
      return;
    }
  }

  // send answer on callback phase
  if(vmain == 102) {
    if(!expecting) {
      writeline(gpppdata.modemAnswerStr());
      setExpect(gpppdata.modemConnectResp());
      vmain = 100;
      return;
    }
  }

  // execute the script
  if(vmain == 2) {
    if(!expecting && !pausing && !scanning) {

      timeout_timer->stop();
      timeout_timer->start(scriptTimeout);
//	KMessageBox::information(this, i18n("Vmain 2"));

      if((unsigned) scriptindex < comlist->count()) {
        scriptCommand = *(comlist->at(scriptindex));
        scriptArgument = *(arglist->at(scriptindex));
      } else {
        kdDebug("knet") << "End of script" << endl;
	vmain = 10;
        return;
      }

      if (scriptCommand == "Scan") {
	QString bm = i18n("Scanning %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

        setScan(scriptArgument);
	scriptindex++;
        return;
      }

      if (scriptCommand == "Save") {
	QString bm = i18n("Saving %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	if (scriptArgument.lower() == "password") {
	  gpppdata.setPassword(scanvar);
	  if(gpppdata.storePassword())
	    gpppdata.setStoredPassword(scanvar);
	  firstrunPW = true;
	}

	scriptindex++;
        return;
      }


      if (scriptCommand == "Send" || scriptCommand == "SendNoEcho") {
	QString bm = i18n("Sending %1");

	// replace %USERNAME% and %PASSWORD%
	QString arg = scriptArgument;
	QRegExp re1("%USERNAME%");
	QRegExp re2("%PASSWORD%");
	arg = arg.replace(re1, gpppdata.storedUsername());
	arg = arg.replace(re2, gpppdata.storedPassword());

	if (scriptCommand == "Send")
	  bm = bm.arg(scriptArgument);
	else {
	  for(uint i = 0; i < scriptArgument.length(); i++)
	    bm = bm.arg("*");
	}

	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	writeline(scriptArgument);
	scriptindex++;
        return;
      }

      if (scriptCommand == "Expect") {
        QString bm = i18n("Expecting %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	// The incrementing of the scriptindex MUST be before the
	// call to setExpect otherwise the expect will miss a string that is
	// already in the buffer.
	scriptindex++;
	setExpect(scriptArgument);
        return;
      }


      if (scriptCommand == "Pause") {
	QString bm = i18n("Pause %1 seconds").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	pausing = true;

	pausetimer->start(scriptArgument.toInt()*1000, true);
	timeout_timer->stop();

	scriptindex++;
	return;
      }

      if (scriptCommand == "Timeout") {

	timeout_timer->stop();

	QString bm = i18n("Timeout %1 seconds").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	scriptTimeout=scriptArgument.toInt()*1000;
        timeout_timer->start(scriptTimeout);

	scriptindex++;
	return;
      }

      if (scriptCommand == "Hangup") {
	openingdialog->internetStatusLabel->setText(i18n("Hangup"));
	emit debugMessage(i18n("Hangup"));

	writeline(gpppdata.modemHangupStr());
	setExpect(gpppdata.modemHangupResp());

	scriptindex++;
	return;
      }

      if (scriptCommand == "Answer") {

	timeout_timer->stop();

	openingdialog->internetStatusLabel->setText(i18n("Answer"));
	emit debugMessage(i18n("Answer"));

	setExpect(gpppdata.modemRingResp());
	vmain = 150;
	return;
      }

      if (scriptCommand == "ID") {
	QString bm = i18n("ID %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	QString idstring = gpppdata.storedUsername();

	if(!idstring.isEmpty() && firstrunID) {
	  // the user entered an Id on the main kppp dialog
	  writeline(idstring);
	  firstrunID = false;
	  scriptindex++;
	}
//	else {
	  // the user didn't enter and Id on the main kppp dialog
	  // let's query for an ID
	     /* if not around yet, then post window... */
//	     if (prompt->Consumed()) {
//	       if (!(prompt->isVisible())) {
//		 prompt->setPrompt(scriptArgument);
//		 prompt->setEchoModeNormal();
//		 prompt->show();
//	       }
//	     } else {
	       /* if prompt withdrawn ... then, */
//	       if(!(prompt->isVisible())) {
//		 writeline(prompt->text());
//		 prompt->setConsumed();
//		 scriptindex++;
//		 return;
//	       }
	       /* replace timeout value */
//	     }
//	} 
      }

      if (scriptCommand == "Password") {
	QString bm = i18n("Password %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	QString pwstring = gpppdata.password();

	if(!pwstring.isEmpty() && firstrunPW) {
	  // the user entered a password on the main kppp dialog
	  writeline(pwstring);
	  firstrunPW = false;
	  scriptindex++;
	}
//	else {
	  // the user didn't enter a password on the main kppp dialog
	  // let's query for a password
	     /* if not around yet, then post window... */
//	     if (prompt->Consumed()) {
//	       if (!(prompt->isVisible())) {
//		 prompt->setPrompt(scriptArgument);
//		 prompt->setEchoModePassword();
//		 prompt->show();
//	       }
//	     } else {
	       /* if prompt withdrawn ... then, */
//	       if(!(prompt->isVisible())) {
//		 p_kppp->setPW_Edit(prompt->text());
//		 writeline(prompt->text());
//		 prompt->setConsumed();
//		 scriptindex++;
//		 return;
//	       }
	       /* replace timeout value */
//	     }
//	}
      }

      if (scriptCommand == "Prompt") {
	QString bm = i18n("Prompting %1");

        // if the scriptindex (aka the prompt text) includes a ## marker
        // this marker should get substituted with the contents of our stored
        // variable (from the subsequent scan).

	QString ts = scriptArgument;
	int vstart = ts.find( "##" );
	if( vstart != -1 ) {
		ts.remove( vstart, 2 );
		ts.insert( vstart, scanvar );
	}

	bm = bm.arg(ts);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	/* if not around yet, then post window... */
//	if (prompt->Consumed()) {
//	   if (!(prompt->isVisible())) {
//		prompt->setPrompt( ts );
//		prompt->setEchoModeNormal();
//	        prompt->show();
//	   }
//	} else {
	    /* if prompt withdrawn ... then, */
//	    if (!(prompt->isVisible())) {
//	    	writeline(prompt->text());
//	        prompt->setConsumed();
//	        scriptindex++;
//        	return;
//	    }
	    /* replace timeout value */
//	}
      }

      if (scriptCommand == "PWPrompt") {
	QString bm = i18n("PW Prompt %1").arg(scriptArgument);
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

	/* if not around yet, then post window... */
//	if (prompt->Consumed()) {
//	   if (!(prompt->isVisible())) {
//		prompt->setPrompt(scriptArgument);
//		prompt->setEchoModePassword();
//	        prompt->show();
//	   }
//	} else {
	    /* if prompt withdrawn ... then, */
//	    if (!(prompt->isVisible())) {
//	    	writeline(prompt->text());
//	        prompt->setConsumed();
//	        scriptindex++;
//        	return;
//	    }
	    /* replace timeout value */
//	}
      }

      if (scriptCommand == "LoopStart") {

        QString bm = i18n("Loop Start %1").arg(scriptArgument);

	// The incrementing of the scriptindex MUST be before the
	// call to setExpect otherwise the expect will miss a string that is
	// already in the buffer.
	scriptindex++;

	if ( loopnest > (MAXLOOPNEST-2) ) {
		bm += i18n("ERROR: Nested too deep, ignored.");
		vmain=20;
		discon();
	        KMessageBox::error(0, i18n("Loops nested too deeply."));
	} else {
        	setExpect(scriptArgument);
		loopstartindex[loopnest] = scriptindex;
		loopstr[loopnest] = scriptArgument;
		loopend = false;
		loopnest++;
	}
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

      } 

      if (scriptCommand == "LoopEnd") {
        QString bm = i18n("Loop End %1").arg(scriptArgument);
	if ( loopnest <= 0 ) {
		bm = i18n("LoopEnd without matching Start. Line: %1").arg(bm);
		vmain=20;
		discon();
	        KMessageBox::error(0, bm);
		return;
	} else {
	        // NB! The incrementing of the scriptindex MUST be before the
	        // call to setExpect otherwise the expect will miss a string
	        // that is already in the buffer.
        	scriptindex++;
        	setExpect(scriptArgument);
		loopnest--;
		loopend = true;
	}
	openingdialog->internetStatusLabel->setText(bm);
	emit debugMessage(bm);

      } 
    }
  }

  // this is a subroutine for the "Answer" script option

  if(vmain == 150) {
    if(!expecting) {
      writeline(gpppdata.modemAnswerStr());
      setExpect(gpppdata.modemAnswerResp());

      vmain = 2;
      scriptindex++;
      return;
    }
  }

  if(vmain == 30) {
//    if (termwindow->isVisible())
//      return;
//    if (termwindow->pressedContinue())
      vmain = 10;
//    else
 //     cancelbutton();
  }

  if(vmain == 10) {
    if(!expecting) {
      int result;
      timeout_timer->stop();
      if_timeout_timer->stop(); // better be sure.
      // stop reading of data
      Modem::modem->stop();
      // Close the tty. This prevents the QTimer::singleShot() in
      // Modem::readtty() from re-enabling the socket notifier.
      // The port is still held open by the helper process.
      Modem::modem->closetty();
      killTimer( main_timer_ID );
      if_timeout_timer->start(gpppdata.pppdTimeout()*1000);
      kdDebug("knet") << "started if timeout timer with " << gpppdata.pppdTimeout()*1000 << endl;
      stats->setUnit(pppInterfaceNumber());
      kapp->flushX();
      semaphore = true;
      result = execppp();
      emit debugMessage(i18n("Starting pppd..."));
      kdDebug("knet") << "execppp() returned with return-code " << result << endl;
      if(result) {
        if(!gpppdata.autoDNS())
          adddns();
	// O.K we are done here, let's change over to the if_waiting loop
	// where we wait for the ppp if (interface) to come up.
	emit if_waiting_signal();
      } else {
	// starting pppd wasn't successful. Error messages were
	// handled by execppp();
	if_timeout_timer->stop();
 		disconnect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
                connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );		

	kapp->processEvents();
	Modem::modem->hangup();
	Modem::modem->closetty();
        Modem::modem->unlockdevice();
      }
      return;
      }
      }


      if(vmain == 20) {
        gpppdata.setWaitCallback(false);
      }
}

void knet::pause() {
  pausing = false;
  pausetimer->stop();
}

void knet::if_waiting_slot() {
  openingdialog->internetStatusLabel->setText(i18n("Logging on to network..."));

  if(!stats->ifIsUp()) {
    if(gpppdata.pppdError() != 0) {
     disconnect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
     connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );		
	if_timer->stop();
	if_timeout_timer->stop();
	return;
    }

    if_timer->start(100, TRUE);
    return;
  }

  if_timeout_timer->stop();
  if_timer->stop();
  usleep(200000);

  if(gpppdata.autoDNS())
    addpeerdns();
    
  emit closeDebugWindow();
  auto_hostname();
  Requester::rq->removeSecret(AUTH_PAP);
  Requester::rq->removeSecret(AUTH_CHAP);
  emit debugMessage(i18n("Done"));
  Modem::modem->closetty();

//  if(stats->ifIsUp()) {
//    if_timeout_timer->stop();
//       if_timer->stop();
//         stats->start();
//       dock_widget->refreshIcon();
//    kapp->flushX();
//  return;
//  }
//  else {
//    if(gpppdata.pppdError() != 0) {
      // we are here if pppd died immediately after starting it.
//     lostConnection();
//     KMessageBox::error(this, i18n("kdsl.cpp  We should not be getting this"));
//     if_timer->stop();
//     if_timeout_timer->stop();
//     openingdialog->internetStatusLabel->setText(i18n("Disconnected with error code %1" ).arg(gpppdata.pppdError() ) );
//     openingdialog->connectButton->setText(i18n("Connect"));
//     disconnect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
//     connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );	
      // error message handled in main.cpp: sigPPPDDied()
//     return;
//   }

//   if_timer->start(100, TRUE); // single shot{

   return;
//   }

  }

void knet::lostConnection()
{
    stats->stop();
     dock_widget->conToProv->setEnabled(TRUE);
     dock_widget->disFromProv->setEnabled(FALSE);
     dock_widget->stop_stats();
     interruptConnection();
//    discon();
}

void knet::discon()
{
       kapp->processEvents();
       Requester::rq->killPPPDaemon();
       if(rogueConnection==0)
       Requester::rq->killPPPDaemon();
       if(rogueConnection==1)
       Requester::rq->killRoguePppd();
       QApplication::flushX();
       Requester::rq->removeSecret(AUTH_PAP);
       Requester::rq->removeSecret(AUTH_CHAP);
       interruptConnection();
       Modem::modem->unlockdevice();
}

void knet::init()
{
      gpppdata.setpppdError(0);
      inittimer->stop();
      vmain = 0;
      substate = -1;
      expecting = false;
      pausing = false;
      scriptindex = 0;
      myreadbuffer = "";
      scanning = false;
      scanvar = "";
      firstrunID = true;
      firstrunPW = true;
      stats->totalbytes = 0;
      dialnumber = 0;

//      kapp->processEvents();

      comlist = &gpppdata.scriptType();
      arglist = &gpppdata.script();

      kapp->processEvents();
      if(gpppdata.storedAccType()=="DSL"){
      vmain = 10;
      semaphore = false;
      main_timer_ID = startTimer(10);
      return;
      }

     if(gpppdata.storedAccType()=="SCRIPT"){
      vmain = 10;
      semaphore = false;
      main_timer_ID = startTimer(10);
      return;
      }

    if(gpppdata.storedAccType()=="dialup") { 
        gpppdata.setModem(gpppdata.device() );
	openingdialog->internetStatusLabel->setText(i18n( "Initializing Modem" ) );



        int lock = Modem::modem->lockdevice();
        if (lock == 1) {
	    openingdialog->internetStatusLabel->setText(i18n( "Modem is locked or in use" ) );
            vmain = 20;
            return ;
        }

        if (lock == -1) {
            openingdialog->internetStatusLabel->setText(i18n("Unable to create modem lock file."));
            vmain = 20;
            return ;
        }
	  if(Modem::modem->opentty()) {
          openingdialog->internetStatusLabel->setText(Modem::modem->modemMessage());
          kapp->processEvents();
          if(Modem::modem->hangup()) {

             kapp->processEvents();
             semaphore = false;
             Modem::modem->stop();
             Modem::modem->notify(this, SLOT(readChar(unsigned char)));

      // if we are stuck anywhere we will time out
             timeout_timer->start(gpppdata.modemTimeout()*1000);

      // this timer will run the script etc.
             main_timer_ID = startTimer(10);

             return ;
             }
           }
	openingdialog->internetStatusLabel->setText(Modem::modem->modemMessage());
        vmain = 20;
        Modem::modem->unlockdevice();
//	KMessageBox::information(this, i18n("Dialup Account"));
    }

	
}

void knet::readChar(unsigned char c) {
  if(semaphore)
    return;
    readbuffer += c;
    myreadbuffer += c;

    // While in scanning mode store each char to the scan buffer
    // for use in the prompt command
    if( scanning )
       scanbuffer += c;

    // add to debug window
    emit debugPutChar(c);

    checkBuffers();
}


void knet::checkBuffers() {
  // Let's check if we are finished with scanning:
  // The scanstring have to be in the buffer and the latest character
  // was a carriage return or an linefeed (depending on modem setup)
  if( scanning && scanbuffer.contains(scanstr) &&
      ( scanbuffer.right(1) == "\n" || scanbuffer.right(1) == "\r") ) {
      scanning = false;

      int vstart = scanbuffer.find( scanstr ) + scanstr.length();
      scanvar = scanbuffer.mid( vstart, scanbuffer.length() - vstart);
      scanvar = scanvar.stripWhiteSpace();

      // Show the Variabel content in the debug window
      QString sv = i18n("Scan Var: %1").arg(scanvar);
      emit debugMessage(sv);
  }

  if(expecting) {
    if(readbuffer.contains(expectstr)) {
      expecting = false;
      // keep everything after the expected string
      readbuffer.remove(0, readbuffer.find(expectstr) + expectstr.length());

      QString ts = i18n("Found: %1").arg(expectstr);
      emit debugMessage(ts);
      if (loopend) {
	loopend=false;
      }
    }
    if (loopend && readbuffer.contains(loopstr[loopnest])) {
      expecting = false;
      readbuffer = "";
      QString ts = i18n("Looping: %1").arg(loopstr[loopnest]);
      emit debugMessage(ts);
      scriptindex = loopstartindex[loopnest];
      loopend = false;
      loopnest++;
    }

    // notify event loop if expected string was found
    if(!expecting)
      timerEvent((QTimerEvent *) 0);
     }
  }


void adddns()
{
  int fd;

  if ((fd = Requester::rq->openResolv(O_WRONLY|O_APPEND)) >= 0) {
    QStringList &dnslist = gpppdata.dns();
    for ( QStringList::Iterator it = dnslist.begin();
          it != dnslist.end();
          ++it )
    {
      QCString dns = "nameserver " + (*it).local8Bit() +
		     " \t#knet temp entry\n";
      write(fd, dns.data(), dns.length());
    }
    close(fd);
  }

  add_domain(gpppdata.domain());
}

void addpeerdns() {
  int fd, fd2;

  if((fd = Requester::rq->openResolv(O_WRONLY|O_APPEND)) >= 0) {
    if((fd2 = open("/etc/ppp/resolv.conf", O_RDONLY)) >= 0) {
      char c;
      int i = 0;
      while(i++ < 100 && read(fd2, &c, 1) == 1) {
        if(c == '\n')
          write(fd, "\t#knet temp entry\n", 18);
        else
          write(fd, &c, 1);
      }
      close(fd2);
    } else
      fprintf(stderr, "failed to read from /etc/ppp/resolv.conf\n");
    close(fd);
  }
  add_domain(gpppdata.domain());
}

void removedns() {

  int fd;
  char c;
  QString resolv[MAX_RESOLVCONF_LINES];

  if((fd = Requester::rq->openResolv(O_RDONLY)) >= 0) {

    int i=0;
    while(read(fd, &c, 1) == 1 && i < MAX_RESOLVCONF_LINES) {
      if(c == '\n') {
	i++;
      }
      else {
	resolv[i] += c;
      }
    }
    close(fd);

    if((fd = Requester::rq->openResolv(O_WRONLY|O_TRUNC)) >= 0) {
      for(int j=0; j < i; j++) {
	if(resolv[j].contains("#knet temp entry")) continue;
	if(resolv[j].contains("#entry disabled by knet")) {
          QCString tmp = resolv[j].local8Bit();
	  write(fd, tmp.data()+2, tmp.length() - 27);
	  write(fd, "\n", 1);
	}
	else {
	  QCString tmp = resolv[j].local8Bit() + "\n";
	  write(fd, tmp, tmp.length());
	}
      }
    }
    close(fd);

  }

  if (  modified_hostname ) {
    Requester::rq->setHostname(old_hostname);
    modified_hostname = FALSE;
  }

}


void add_domain(const QString &domain) {

  int fd;
  char c;
  QString resolv[MAX_RESOLVCONF_LINES];

  if (domain.isEmpty())
    return;

  if((fd = Requester::rq->openResolv(O_RDONLY)) >= 0) {

    int i=0;
    while((read(fd, &c, 1) == 1) && (i < MAX_RESOLVCONF_LINES)) {
      if(c == '\n') {
	i++;
      }
      else {
	resolv[i] += c;
      }
    }
    close(fd);
    if ((c != '\n') && (i < MAX_RESOLVCONF_LINES)) i++;

    if((fd = Requester::rq->openResolv(O_WRONLY|O_TRUNC)) >= 0) {
      QCString tmp = "domain " + domain.local8Bit() +
		     " \t\t#knet temp entry\n";
      write(fd, tmp.data(), tmp.length());

      for(int j=0; j < i; j++) {
	if((resolv[j].contains("domain") ||
	      ( resolv[j].contains("nameserver")
		&& !resolv[j].contains("#knet temp entry")
		&& gpppdata.exDNSDisabled()))
	        && !resolv[j].contains("#entry disabled by knet")) {
	  QCString tmp = "# " + resolv[j].local8Bit() +
			 " \t#entry disabled by knet\n";
	  write(fd, tmp, tmp.length());
	}
	else {
	  QCString tmp = resolv[j].local8Bit() + "\n";
	  write(fd, tmp, tmp.length());
	}
      }
    }
    close(fd);
  }
}

void auto_hostname() {
  struct in_addr local_ip;
  struct hostent *hostname_entry;
  QString new_hostname;
  int    dot;
  char   tmp_str[100]; // buffer overflow safe

  gethostname(tmp_str, sizeof(tmp_str));
  tmp_str[sizeof(tmp_str)-1]=0; // panic
  old_hostname=tmp_str; // copy to QString

  if (!p_knet->stats->local_ip_address.isEmpty() && gpppdata.autoname()) {
    local_ip.s_addr=inet_addr(p_knet->stats->local_ip_address.ascii());
    hostname_entry=gethostbyaddr((const char *)&local_ip,sizeof(in_addr),AF_INET);

    if (hostname_entry != 0L) {
      new_hostname=hostname_entry->h_name;
      dot=new_hostname.find('.');
      new_hostname=new_hostname.remove(dot,new_hostname.length()-dot);
      Requester::rq->setHostname(new_hostname);
      modified_hostname = TRUE;

      new_hostname=hostname_entry->h_name;
      new_hostname.remove(0,dot+1);

      add_domain(new_hostname);
    }
  }

}

void knet::resetAccounts()
{
  KStandardDirs *dirs = KGlobal::dirs();  
  if(gpppdata.backgroundPixmap()==""){
  openingdialog->internetIconView->setPaletteBackgroundPixmap(QPixmap( dirs->findResource ("data","knet/pics/splash_top.png" )) );
  }
  else {
  openingdialog->internetIconView->setPaletteBackgroundPixmap(QPixmap(gpppdata.backgroundPixmap() ));
  }

      openingdialog->internetIconView->clear();
      //firstly, lets iterate the account list
      for(int i=0; i <= gpppdata.accountCount()-1; i++) {
        gpppdata.setAccountByIndex(i);  
        QString themePath;
        QFont internetIconView_font(  openingdialog->internetIconView->font() );
        internetIconView_font.setBold( FALSE );           
        (void) new QIconViewItem( openingdialog->internetIconView, (  gpppdata.accname()) , DesktopIcon(gpppdata.accountIconName() ) );
        openingdialog->internetStatusLabel->setText(i18n("%1 is the Default Account").arg(gpppdata.defaultAccount()) );
      }
}

knet::~knet()
{
  delete stats;
}


void knet::accountselected(QIconViewItem *item)
{
if(!item)
return;
gpppdata.setDefaultAccount(item->text() );
openingdialog->internetStatusLabel->setText(i18n("%1 is the Default Account").arg(gpppdata.defaultAccount()) );
gpppdata.setAccount(item->text() );
if(gpppdata.storedAccType()=="dialup")
   gpppdata.setModem(gpppdata.device() );
gpppdata.save();

}


void knet::expandbutton()
{
  setup();
}

void knet::executePreferencesDlg()
{
    if (m_prefDialog==0){
        m_prefDialog=new PrefDialog(this);
	}
	connect(m_prefDialog, SIGNAL( resetaccounts() ), this, SLOT(resetAccounts()));
        connect(m_prefDialog, SIGNAL (OSDTesting() ), this, SLOT(testOSD() ) );
}

void knet::setup()
{
   executePreferencesDlg();
   if(m_prefDialog->exec()) {
      gpppdata.save();
      resetAccounts();
   }
   else
      gpppdata.cancel();
      resetAccounts(); 
}


bool knet::eventFilter(QObject *o, QEvent *e) {
  if(e->type() == QEvent::User) {
    switch(((SignalEvent*)e)->sigType()) {
    case SIGINT:
      kdDebug("knet") << "Received a SIGINT" << endl;
      interruptConnection();
      break;
    case SIGCHLD:
      sigChld();
      break;
    case SIGUSR1:
      sigPPPDDied();
      break;
    }
    return true;
  }
    return false;
}

void knet::saveMyself() {
    gpppdata.save();
}

void knet::shutDown() {
    saveMyself();
    signal(SIGINT, sighandler);
    signal(SIGCHLD, sighandler);
    signal(SIGUSR1, sighandler);
    signal(SIGTERM, SIG_IGN);
    kapp->processEvents();
    Requester::rq->killPPPDaemon();
    QApplication::flushX();	 

}

void knet::startProcess()
{
   if(openingdialog->logCheckBox->isChecked() )
   debugwindow->show();
   gpppdata.setAccount(gpppdata.defaultAccount());
   gpppdata.setPassword(gpppdata.storedPassword());
   gpppdata.setConnectedAccount(gpppdata.accname() );
   gpppdata.setConnectedAccountIconName(gpppdata.accountIconName() );
   gpppdata.setAuthMethod(4); //we set pap/chap for authentication here
      if(!Requester::rq->setSecret(gpppdata.authMethod(),
				   encodeWord(gpppdata.storedUsername()),
				   encodeWord(gpppdata.password()))) {
	QString s;
	s = i18n("Cannot create PAP/CHAP authentication\n"
				     "file \"%1\"").arg(PAP_AUTH_FILE);
	KMessageBox::error(this, s);
	return;
      }
     openingdialog->internetStatusLabel->setText(i18n("Connecting to %1 account %2").arg(gpppdata.storedAccType() ).arg(gpppdata.defaultAccount()) );
     openingdialog->connectButton->setText(i18n("Disconnect"));
     disconnect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );
     connect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
     dock_widget->conToProv->setEnabled(FALSE);
     dock_widget->disFromProv->setEnabled(TRUE);
     openingdialog->connectButton->setText(i18n("Disconnect"));  //I know this is in twice... The writing wasnt changing back to 'Connect' even though we told it too......  strange!
     inittimer->start(100);

}

void knet::dialupStart()
  {
  if (gpppdata.phonenumber().isEmpty()) {
    QString s = i18n("You must specify a telephone number.");
    KMessageBox::error(this, s);
    return;
  }

	return;
  }
void knet::interruptConnection() {

//      if (gpppdata.storedAccType()=="dialup")
//	{
         Modem::modem->stop();
         killTimer(main_timer_ID);
         timeout_timer->stop();
         if_timer->stop();
         if_timeout_timer->stop();	
         openingdialog->internetStatusLabel->setText(i18n("One moment please..."));
         // just to be sure
         Requester::rq->removeSecret(AUTH_PAP);
         Requester::rq->removeSecret(AUTH_CHAP);
         removedns();
         Requester::rq->killPPPDaemon();
         Modem::modem->hangup();
         Modem::modem->closetty();
         Modem::modem->unlockdevice();
	 stats->clear();
//	 }

       openingdialog->internetStatusLabel->setText(i18n("Disconnected from %1" ).arg(gpppdata.accname() ) );
       openingdialog->connectButton->setText(i18n("Connect"));
       disconnect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
       connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );	
       openingdialog->internetIconView->setEnabled(TRUE);
}

void knet::sigPPPDDied() {

      kdDebug("knet") << "Received a SIGUSR1" << endl;

    // if we are not connected pppdpid is -1 so have have to check for that
    // in the followin line to make sure that we don't raise a false alarm
    // such as would be the case when the log file viewer exits.
    if(gpppdata.pppdRunning() || gpppdata.pppdError()) {
      kdDebug("knet") << "It was pppd that terminated" << endl;
//      lostConnection();
//	this->show();
      
          // when we killpppd() on Cancel in ConnectWidget
      // we set pppid to -1 so we won't
      // enter this block

      // just to be sure
      Requester::rq->removeSecret(AUTH_PAP);
      Requester::rq->removeSecret(AUTH_CHAP);

      gpppdata.setpppdRunning(false);

      kdDebug("knet") << "Executing command on disconnect since pppd has died." << endl;
      QApplication::flushX();
      execute_command(gpppdata.command_on_disconnect());

        if(!gpppdata.pppdError())
        gpppdata.setpppdError(E_PPPD_DIED);
        removedns();
      Modem::modem->unlockdevice();
      Requester::rq->pppdExitStatus();

      gpppdata.setWaitCallback(gpppdata.callbackType() && Requester::rq->lastStatus == E_CBCP_WAIT);
      if(!gpppdata.waitCallback()) {
        gpppdata.setpppdRunning(false);	
	QString msg;
	if (gpppdata.pppdError() == E_IF_TIMEOUT)
	    msg = i18n("Timeout expired while waiting for the PPP interface "
                       "to come up.");
	else {
	    msg = i18n("<p>The pppd daemon died unexpectedly!</p>");
	    Requester::rq->pppdExitStatus();
	    if (Requester::rq->lastStatus != 99) {	// more recent pppds only
	    	     msg = (i18n("Connection Timed Out"));
	    if(Requester::rq->lastStatus == 1)
	    msg = (i18n("<qt><center><b><h3>Knet could not fully execute the pppd process.</h3></b><br>Usually this occurs if some ppp modules are not loaded.<br>Please check your Setup.</center></qt>"));
    
	    if(Requester::rq->lastStatus ==2)
	    msg = (i18n("<qt><center>pppd did not recognise at least one of the options<br>in the options file.<br><br>Please look at the log file for more details</center></qt>"));

	    if(Requester::rq->lastStatus ==4)
	    msg = (i18n("<qt><center>The kernel does not support PPP.<br><br>Check the kernel drivers are loaded or compiled into the kernel</center></qt>"));	    
	    if(Requester::rq->lastStatus == 5)
	    msg = (i18n("<qt><center>pppd was sent a disconnect signal</center></qt>"));	    

	    if(Requester::rq->lastStatus == 6)
	    msg = (i18n("<qt><center>The modem device could not be locked\nEdit your account and uncheck the lock modem option.</center></qt>"));		    
	    if(Requester::rq->lastStatus == 7)
	    msg = (i18n("<qt><center>The serial port your modem is connected to\ncould not be opened.</center></qt>"));	    
	    	    
	    if(Requester::rq->lastStatus == 8)
	    msg = (i18n("<qt><center>Knet's connection script failed</center></qt>"));	 
	      	    	    
	    if(Requester::rq->lastStatus ==9)
	    msg = (i18n("<qt><center>A command in the connection script could not be executed<br></center></qt>"));	 
	       
	    if(Requester::rq->lastStatus ==12)
	    msg = (i18n("<qt><center>Knet has disconnected because the idle timeout has been reached.<br></center></qt>"));
	    
	    if(Requester::rq->lastStatus ==16)
	    msg = (i18n("<qt><center>The modem has hung up<br></center></qt>"));	    
	    
	    if(Requester::rq->lastStatus == 19) 
	    msg =( i18n("<qt><center><b><h3>Authentication Failure</h3></b>Please check your Username and password</center></qt>"));
	}
	}
	KMessageBox::error(0, (msg));
	}
	else
	{
        if(gpppdata.waitCallback())
          kdDebug("knet") << "Waiting for callback... " << endl;
        else
          kdDebug("knet") << "Trying to reconnect... " << endl;
        if(gpppdata.authMethod() == AUTH_PAP ||
	   gpppdata.authMethod() == AUTH_CHAP ||
	   gpppdata.authMethod() == AUTH_PAPCHAP)
          Requester::rq->setSecret(gpppdata.authMethod(),
				   encodeWord(gpppdata.storedUsername()),
				   encodeWord(gpppdata.password()));
	gpppdata.setpppdRunning(false);

/*        gpppdata.setpppdRunning(false);
		QString msg;
 	if (gpppdata.pppdError() == E_IF_TIMEOUT)
	    msg = i18n("Timeout expired while waiting for the PPP interface "
                       "to come up!");
	else {
	    msg = i18n("<p>The pppd daemon died unexpectedly!</p>");
	    Requester::rq->pppdExitStatus();
	    if (Requester::rq->lastStatus != 99) {	// more recent pppds only
	    	     msg = (i18n("Connection Timed Out"));

	    if(Requester::rq->lastStatus == 1)
	    msg = (i18n("<qt><center><b><h3>Knet could not fully execute the pppd process.</h3></b><br>Usually this occurs if some ppp modules are not loaded.<br>Please check your Setup.</center></qt>"));
    
	    if(Requester::rq->lastStatus ==2)
	    msg = (i18n("<qt><center>pppd did not recognise at least one of the options<br>in the options file.<br><br>Please look at the log file for more details</center></qt>"));

	    if(Requester::rq->lastStatus ==4)
	    msg = (i18n("<qt><center>The kernel does not support PPP.<br><br>Check the kernel drivers are loaded or compiled into the kernel</center></qt>"));	    
	    if(Requester::rq->lastStatus == 5)
	    msg = (i18n("<qt><center>pppd was sent a disconnect signal</center></qt>"));	    

	    if(Requester::rq->lastStatus == 6)
	    msg = (i18n("<qt><center>The modem device could not be locked\nEdit your account and uncheck the lock modem option.</center></qt>"));		    
	    if(Requester::rq->lastStatus == 7)
	    msg = (i18n("<qt><center>The serial port your modem is connected to\ncould not be opened.</center></qt>"));	    
	    	    
	    if(Requester::rq->lastStatus == 8)
	    msg = (i18n("<qt><center>Knet's connection script failed</center></qt>"));	 
	      	    	    
	    if(Requester::rq->lastStatus ==9)
	    msg = (i18n("<qt><center>A command in the connection script could not be executed<br></center></qt>"));	 
	       
	    if(Requester::rq->lastStatus ==12)
	    msg = (i18n("<qt><center>Knet has disconnected because the idle timeout has been reached.<br></center></qt>"));
	    
	    if(Requester::rq->lastStatus ==16)
	    msg = (i18n("<qt><center>The modem has hung up<br></center></qt>"));	    
	    
	    
	    if(Requester::rq->lastStatus == 19) 
	    msg =( i18n("<qt><center><b><h3>Authentication Failure</h3></b>Please check your Username and password</center></qt>"));

	}
	} */
	
//	KMessageBox::error(this, i18n("%1").arg(msg));
//        Requester::rq->killRoguePppd();  //Killing the process just in case.
	}
    }
  gpppdata.setpppdError(0);
     disconnect(openingdialog->connectButton, SIGNAL( clicked()), this, SLOT(discon() ) );
     connect( openingdialog->connectButton, SIGNAL( clicked() ), this, SLOT( startProcess() ) );
  interruptConnection();
}


void knet::sigChld() {
  kdDebug("knet") << "sigchld()" << endl;

    QString msg = i18n("knet's helper process just died.\n"
                       "Since further execution would be pointless, "
                       "knet will shut down now.");
    KMessageBox::error(0L, msg);
    remove_pidfile();
    exit(1);

}

QString knet::encodeWord(const QString &s) {
    QString r = s;
    r.replace(QRegExp("\\"), "\\\\");
    return r;
}

#include "knet.moc"
