/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <sys/types.h>

 
#include <termios.h>
#include <string.h> 
#include <unistd.h>

#include "networkdev.h"
#include "openingdialog.h"
#include "networkConfig.h"
#include "ethernetscan.h"
#include "modemscan.h"
#include "dsldialog.h"
#include "kurlrequester.h"
#include "pppdata.h" 
#include "internetsetup.h"
#include "devices.h" 
#include "modem.h"
#include "settingsdialog.h"
#include "knet.h"
#include "internetConfig.h"

#include <klineedit.h>
#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kiconloader.h>    // for KIconLoader
#include <kglobal.h>
#include <kpushbutton.h>
#include <kcombobox.h>
#include <kapplication.h>
#include <klistbox.h>
#include <kstandarddirs.h>
#include <ktextedit.h>
#include <kcolorbutton.h>
#include <kfontrequester.h>
#include <knuminput.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qmovie.h>
#include <qlabel.h>
#include <qfile.h>
#include <qtextedit.h>
#include <qradiobutton.h>
#include <qregexp.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qslider.h>

 extern knet *m_knet;
 extern EthernetScan* ethernetscan;
 extern openingDialog* openingdialog;
 extern modemScan* modemscan;
 extern internetSetup* internetsetup;
 extern accountSetup* accountsetup;
 extern internetWidget* scriptsetup;
// extern PrefDialog* prefDialog;
 //extern SettingsDialog* settingsdialog;
 QString ethString;
 QStringList cardlist;
 int l = 0;


// QStringList ethlistcard;
//      QMovie* mymovie = new QMovie( "/root/eggputer.gif");

//     QPixmap bg;
     QString newmovie; 
     QString page = "none";
//      stream = newmovie;

NetworkDev::NetworkDev(QWidget *parent, const char *name, const QStringList &)
 : networkWidget(parent, name)
{
    networkListBox->setRootIsDecorated( true );
  
    settingsMenu = new KPopupMenu();
    connect (networkListBox, SIGNAL( rightButtonClicked(QListViewItem*, const QPoint&, int)), this, SLOT(popupMenu(QListViewItem*) ));
    connect (networkListBox, SIGNAL( clicked(QListViewItem*, const QPoint&, int)), this, SLOT(itemSelected(QListViewItem*) ));

   scripttimer = new QTimer(this);
  connect(scripttimer, SIGNAL(timeout()), SLOT(do_script()));
  step = 0;
    
    
//    connect (networkListBox, SIGNAL( clicked(QListViewItem*, const QPoint&, int)), this, SLOT(slotConfigure()    ));
    ethernetscan = new EthernetScan(frame17, "NetworkDev");  
     frame17Layout->addWidget(ethernetscan,0,0,0);   
  
    ethernetscan->hide();
    modemscan = new modemScan(frame17, "OpeningDialog");
      frame17Layout->addWidget(modemscan,0,0,0);   
//    resize( QSize(449, 234).expandedTo(minimumSizeHint()) );
//   QPixmap mypixmap;
//    &mypixmap = new QPixmap( "/root/eggputer.gif");
    modemscan->modemPixmapLabel->setPixmap( QPixmap( "kcmpci"));  
     modeminsert();
     modemscan->hide();

     scriptsetup = new internetWidget(frame17, "ScriptSetup");
      frame17Layout->addWidget(scriptsetup,0,0,0);
       scriptsetup->hide();
 
     settingsdialog = new SettingsDialog(frame17, "settingsDialog");
     frame17Layout->addWidget(settingsdialog,0,0,0);
     connect(settingsdialog->backgroundURLRequester, SIGNAL(textChanged (const QString&)), this, SLOT(setBackground(const QString &)) );

//     connect(settingsdialog->osdFontColorButton, SIGNAL(changed(const QColor &)),this, SLOT(colorChanged(const QColor & )));
     KStandardDirs *dirs = KGlobal::dirs();  
     if(gpppdata.backgroundPixmap()==""){
     settingsdialog->pixmapLabel1->setPixmap( dirs->findResource ("data","knet/pics/splash_top.png" ) );
     settingsdialog->backgroundURLRequester->setURL(dirs->findResource ("data","knet/pics/splash_top.png" ) ); 
     gpppdata.setOSDBackgroundColor(settingsdialog->osdBGColorButton->color() );
     gpppdata.setOSDForegroundColor(settingsdialog->osdFontColorButton->color() );
  }
  else {
  settingsdialog->pixmapLabel1->setPixmap(gpppdata.backgroundPixmap() );
  settingsdialog->backgroundURLRequester->setURL(gpppdata.backgroundPixmap() );
  }
     QFont font;
     QColor fg, bg;
     gpppdata.OSDForegroundColor(fg);
     gpppdata.OSDBackgroundColor(bg);
     gpppdata.OSDFont(font);
     settingsdialog->autostartCheckBox->setChecked(gpppdata.storeAutostart()); // To start KNet when KDE starts
     settingsdialog->autoconnectCheckBox->setChecked(gpppdata.storeConnect()); // Connect to the default account on startup

     settingsdialog->osdFontColorButton->setColor(fg);
     settingsdialog->osdBGColorButton->setColor(bg);
     settingsdialog->kFontRequester1->setFont(font);
     settingsdialog->kIntNumInput2->setRelativeValue(gpppdata.transperancy() );
     connect(settingsdialog->testOSDButton, SIGNAL(clicked()), this, SLOT(testOSD() ) );
     settingsdialog->hide();

     accountsetup = new accountSetup(frame17, "accountSetup");
     frame17Layout->addWidget(accountsetup,0,0,0);    
     
   QString version = gpppdata.pppdVersion();
   if(version == "0.0.0")
   version = "unknown";
   accountsetup->pppdVersionLineEdit->setText(version);
   accountsetup->hide();
     
    internetsetup = new internetSetup(frame17, "internetSetup");
      frame17Layout->addWidget(internetsetup,0,0,0);   
//    resize( QSize(600, 800).expandedTo(minimumSizeHint()) );    
     connect(internetsetup->dslRadioButton, SIGNAL(clicked()), this, SLOT(newAccount() ));      
     connect(internetsetup->dialupRadioButton, SIGNAL(clicked()), this, SLOT(newDialupConnection() ));
     connect(internetsetup->scriptRadioButton, SIGNAL(clicked()), this, SLOT(newScriptAccount() ));
      const QPixmap backg = (dirs->findResource ("data","knet/pics/internetbrowser.png" ) );


     internetsetup->pixmapLabel2->setPixmap(backg);
 //    iterateList(ethlist);
 //   ethernetscan->ethernetDetails();  
     ethernetscan->netmaskEntered();
    

   iterateList();
}			 

NetworkDev::~NetworkDev()
{// extern DockWidget* dock_widget;
//widgetStack1->addWidget(startwin,0,0,0);

//    ethernetLayout = new QGridLayout( frame17, 1,1,11,6, "ethernetLayout");
delete settingsMenu;
}

void NetworkDev::setBackground(const QString & url)
{
   settingsdialog->pixmapLabel1->setPixmap(url);
   gpppdata.setBackgroundPixmap(url);
   gpppdata.save();

}

void NetworkDev::modeminsert()
{
     bool deviceExist = false;
     modemscan->modemComboBox->clear();
     for(int k = 0; devices[k]; k++)
  {
      if ( devices[k] == gpppdata.modemDevice())
          deviceExist = true;
     modemscan->modemComboBox->insertItem(devices[k]);
  }
     if ( deviceExist==FALSE )
     modemscan->modemComboBox->insertItem(gpppdata.modemDevice()); 
     static const char *baudrates[] = {

#ifdef B460800
    "460800",
#endif

#ifdef B230400
    "230400",
#endif

#ifdef B115200
    "115200",
#endif

#ifdef B57600
    "57600",
#endif

    "38400",
    "19200",
    "9600",
    "2400",
    0};
  modemscan->speedComboBox->clear();
  for(int k = 0; baudrates[k]; k++)
  modemscan->speedComboBox->insertItem(baudrates[k]);
  modemscan->speedComboBox->setCurrentItem(3);     

  modemscan->lineComboBox->clear();
  modemscan->lineComboBox->insertItem("CR");
  modemscan->lineComboBox->insertItem("LF");
  modemscan->lineComboBox->insertItem("CR/LF");

  modemscan->flowComboBox->clear();
  modemscan->flowComboBox->insertItem(i18n("Hardware [CRTSCTS]")); // sync with pppdata.cpp
  modemscan->flowComboBox->insertItem(i18n("Software [XON/XOFF]"));
  modemscan->flowComboBox->insertItem(i18n("None"));

  if(gpppdata.modname() )
    modemscan->modemComboBox->setCurrentItem(gpppdata.modname() );
  else 
    modemscan->modemComboBox->setCurrentItem(0);
  if(gpppdata.speed() )
    modemscan->speedComboBox->setCurrentItem(gpppdata.speed() );
  else
    modemscan->speedComboBox->setCurrentItem(0);
  if(gpppdata.enter() )
    modemscan->lineComboBox->setCurrentItem(gpppdata.enter() );
  else
    modemscan->lineComboBox->setCurrentItem(0);
  if(gpppdata.flowcontrol() )
    modemscan->flowComboBox->setCurrentItem(gpppdata.flowcontrol() );
  else
     modemscan->flowComboBox->setCurrentItem(0);
}

void NetworkDev::testOSD()
{
     emit OSDTest();
}

void NetworkDev::iterateList()
{
    accountsetup->kComboBox6->clear();
    networkListBox->clear();
    QListViewItem* ethcards = new QListViewItem( networkListBox,i18n(  "   Network Cards"));
       ethcards->setPixmap( 0, DesktopIcon( "kcmpci"));
       ethcards->setOpen( true );
    QListViewItem* modems = new QListViewItem( networkListBox,i18n(  "   Modems"));
        modems->setPixmap( 0, DesktopIcon( "kppp"));	
        modems->setOpen( true );	
    QListViewItem* internet = new QListViewItem( networkListBox,i18n(  "   Internet"));
        internet->setPixmap( 0, DesktopIcon( "connect_creating"));		
        internet->setOpen( true );
    QListViewItem* settings = new QListViewItem( networkListBox, i18n( "   KNet Settings"));
        settings->setPixmap( 0, DesktopIcon( "package_settings"));
        settings->setOpen( true );
	
	FILE* fp = fopen("/proc/net/dev", "r");

	QStringList list;

	char interface[8];
	char buffer[128];

	// Ignore header...
	fgets(buffer, sizeof(buffer), fp);
	fgets(buffer, sizeof(buffer), fp);
	while(fgets(buffer, sizeof(buffer), fp))
	{
		sscanf(buffer, " %[^ \t\r\n:]", interface);
	QString ethDev = interface;
		if((ethDev)!="lo")  if((ethDev)!="ppp0") if((ethDev)!="ppp1") {
		
       QListViewItem* item = new QListViewItem(ethcards, interface);	
       accountsetup->kComboBox6->insertItem(interface);
       		item->setPixmap( 0, SmallIcon( "kcmpci"));
		}
		list.append(interface);
 

    }
     if(gpppdata.accountCount() > 0) {
    for(int i=0; i <= gpppdata.accountCount()-1; i++) {
      gpppdata.setAccountByIndex(i); 
       QListViewItem* item = new QListViewItem(internet, gpppdata.accname());	
       		item->setPixmap( 0, SmallIcon(gpppdata.accountIconName()) );
      }
         }  
	 
      if(gpppdata.modemCount() > 0) {
    for(int i=0; i <= gpppdata.modemCount()-1; i++) {
      gpppdata.setModemByIndex(i); 
       QListViewItem* item = new QListViewItem(modems, gpppdata.modname());	
       		item->setPixmap( 0, SmallIcon( "kdsl") );
      }
         }
}


void NetworkDev::slotConfigure()
{
    page = "ethernet";
    if(accountsetup->isShown())
     accountsetup->hide();
    if(internetsetup->isShown())
     internetsetup->hide();
    if(modemscan->isShown()) {
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotEnableDevice() ));
     }   
     modemscan->hide();
    if(settingsdialog->isShown());
     settingsdialog->hide();
     ethernetscan->show(); 
     ethernetscan->IPLineEdit->clear();
     ethernetscan->netmaskLineEdit->clear();
     ethernetscan->broadcastLineEdit->clear();
     ethernetscan->hostnameLineEdit->clear();
     ethernetscan->kListView->clear();
     ethernetscan->dns1LineEdit->clear();
     ethernetscan->dns2LineEdit->clear();
     ethernetscan->checkBox1->setChecked(FALSE);
     ethernetscan->checkBox2->setChecked(FALSE);
     ethernetscan->ethernetDetails(ethString);


}

void NetworkDev::slotModemSetup()
{
     page = "modemnew";
    if(accountsetup->isShown())
      accountsetup->hide();
    if(ethernetscan->isShown());
       ethernetscan->hide();
    if(internetsetup->isShown());
       internetsetup->hide();              
    if(settingsdialog->isShown());
      settingsdialog->hide();
      KStandardDirs *dirs = KGlobal::dirs();
      newmovie = (dirs->findResource ("data","knet/pics/eggputer.mng" ) );
      movie=QMovie(newmovie);
      modemscan->modemPixmapLabel->setMovie( movie );   
      modemscan->show();
      modeminsert();
      modemscan->pushButton5->setEnabled(TRUE);
      modemscan->modemComboBox->setEnabled(TRUE);
      connect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(init() ));       
      QPixmap pm = movie.framePixmap();    
      movie.step(); 

}


void NetworkDev::slotInternetSetup()
{
    page = "none";
    if(scriptsetup->isShown());
     scriptsetup->hide();
    if(accountsetup->isShown())
     accountsetup->hide();
    if(ethernetscan->isShown());   
     ethernetscan->hide();
    if(settingsdialog->isShown());
     settingsdialog->hide();
    if(modemscan->isShown()){
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotEnableDevice() ));      
     modemscan->hide();
     }
     internetsetup->show();
     internetsetup->scriptRadioButton->setChecked(false);
     internetsetup->dialupRadioButton->setChecked(false);
     internetsetup->dslRadioButton->setChecked(false);     
     internetsetup->cableRadioButton->setChecked(false);  
     internetsetup->isdnRadioButton->setChecked(false);       
     connect(internetsetup->dslRadioButton, SIGNAL(clicked()), this, SLOT(newAccount() ));
     connect(internetsetup->dialupRadioButton, SIGNAL(clicked()), this, SLOT(newDialupConnection() ));
     connect(internetsetup->scriptRadioButton, SIGNAL(clicked()), this, SLOT(newScriptAccount() ));

}

void NetworkDev::readtty() {

  if (step == 0)
    return;

  readbuffer.replace(QRegExp("[\n\r]")," ");         // remove stray \n and \r
  readbuffer = readbuffer.stripWhiteSpace(); // strip of leading or trailing white
                                                 // space

  if(step <= NUM_OF_ATI)
    ati_query_strings[step-1] = readbuffer.copy();

  readbuffer = "";
}

void NetworkDev::ati_done() {
  scripttimer->stop();
  Modem::modem->closetty();
  Modem::modem->unlockdevice();
  QString name;
  
  for(int i = 0; i < NUM_OF_ATI; i++) {
  modemscan->textEdit2->append(ati_query_strings[i]);
 
  name.append(ati_query_strings[i]);  
  }
  if (name=="") {   //Modem does not exist
     gpppdata.deleteModem();
//     gpppdata.deleteModem(gpppdata.modname() );
     }
   else	
   {
    modemscan->kListBox2->insertItem(gpppdata.modemDevice() );
    iterateList();
    gpppdata.save();
   }


}

void NetworkDev::do_script() {
  QString msg;
  QString query;

  switch(step) {
  case 0:
    readtty();
    modemscan->textEdit2->append("ATI...");
//    progressBar->advance(1);
    Modem::modem->writeLine("ATI\n");
    break;

  case 1:
  case 2:
  case 3:
  case 4:
  case 5:
  case 6:
  case 7:  

    readbuffer.replace(QRegExp("[\n\r]")," ");         // remove stray \n and \r
    readbuffer = readbuffer.stripWhiteSpace();
    msg.sprintf("ATI %d ...", step);
    query.sprintf("ATI%d\n", step);
    ati_query_strings[step-1] = readbuffer.copy();
    modemscan->textEdit2->append(msg);
    modemscan->textEdit2->append(readbuffer.copy());
    readbuffer.remove(readbuffer.copy());
    Modem::modem->writeLine(query.local8Bit());
    break;
    default:
    readtty();
    ati_done();
  l++; 
  slotEnableDevice();
  }
  step++;
}


void NetworkDev::init() {
     modemscan->frame35->setEnabled(FALSE);
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(init() ));   
     connect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotDisableDevice() ));     
     modemscan->pushButton5->setText(i18n("Stop Scan"));
     movie.unpause();   
     modemscan->textEdit2->clear();
     slotEnableDevice();
}


void NetworkDev::slotEnableDevice()
{
    for(int k = l; devices[k]; )
    if (step < 7) {

     // ******* Here we scan all the known devices until we find a modem, and then we add it to the modem list.  
     // ******* Last modem found will be made the default  
    if(gpppdata.modname()==devices[k])
    {
     modemscan->textEdit2->append(i18n("%1 already exists").arg(devices[k]) );
     step=0;
     l++;
     k++;
     }

    if(gpppdata.isUniqueModname(devices[k])) {
    gpppdata.newmodem();
    gpppdata.setModname(devices[k]);
    gpppdata.setModemDevice(devices[k]);
    modemscan->textEdit2->append(i18n("\nScanning %1").arg(devices[k]));
    applyModem();
    kapp->processEvents();

  if(Modem::modem->opentty()) {

    if(Modem::modem->hangup()) {
      usleep(100000);  // wait 0.1 secs  exit;
      Modem::modem->writeLine("ATE0Q1V1"); // E0 don't echo the commands I send ...
      modemscan->textEdit2->append(i18n("Modem Ready"));
      kapp->processEvents();
      usleep(100000);  // wait 0.1 secs
      kapp->processEvents();
      step = 0;       
      scripttimer->start(1000);	 	// this one does the ati query
      Modem::modem->flush();
      Modem::modem->notify(this, SLOT(readChar(unsigned char)));
      return;
    }

  }
  else {
      if(!scripttimer->isActive() ) {
  modemscan->textEdit2->append(Modem::modem->modemMessage());
  Modem::modem->unlockdevice();
  gpppdata.deleteModem();
    k++;
    step = 0;
    }
    }
   }
   else {
     modemscan->textEdit2->append(i18n("%1 already exists").arg(devices[k]) );
     scripttimer->stop();
     step=0;
     l++;
     k++;
     }
   }
   else {  //We've reached the 7th ATI Scan
     modemscan->textEdit2->append(Modem::modem->modemMessage());

   Modem::modem->unlockdevice();   
    step = 0;
    }
    slotDisableDevice();    
    page="none";

}

void NetworkDev::slotDisableDevice()
{
     modemscan->frame35->setEnabled(TRUE);
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotDisableDevice() ));
     connect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(init() ));  
     movie.restart();
     movie.step();
     modemscan->pushButton5->setText(i18n("Scan"));     
     modemscan->textEdit2->append(i18n("Ending Modem Scan"));
     l = 0;
     Modem::modem->hangup();
     Modem::modem->closetty();
     Modem::modem->unlockdevice();
//     gpppdata.deleteModem();
     page="none";
//     scripttimer->stop();
//     iterateList();
}

void NetworkDev::readChar(unsigned char c) {
  if(readbuffer.length() < 255)
    readbuffer += c;
}

void NetworkDev::slotDocking()
{


}

void NetworkDev::itemSelected(QListViewItem* item)
{
     if(!item)  // We use this to avoid crashes when we invoke the right mouse button with no item selected
     return;

     if(item->text(0)=="   Network Cards" )
     return;

     if(item->text(0)=="   Modems" ) {
     slotModemSetup();    
     return;
     }
     if(item->text(0)=="   Internet" ) {
     slotInternetSetup();
     return;
     }
     if(item->text(0)=="   KNet Settings" ) {
     slotSettingsSetup();
     return;
     }
     if(item->parent()->text(0)=="   Internet"  ) {
     gpppdata.setAccount(item->text(0) );
        editAccount();
     return;
        }     
     if(item->parent()->text(0)=="   Modems"  ) {
     gpppdata.setModem(item->text(0) );
     gpppdata.setModname(item->text(0) );
//     gpppdata.setDevice(item->text(0) );
     gpppdata.setModemDevice(item->text(0) );
     modemSettings();
     return;
        }
     if(item->parent()->text(0)=="   Network Cards"  ) {
      ethString=item->text(0);
      slotConfigure( );
      return;
      }

}


void NetworkDev::popupMenu(QListViewItem* item)
{
    if(!item)  // We use this to avoid crashes when we invoke the right mouse button with no item selected
     return;

    ethString=item->text(0);
    settingsMenu = new KPopupMenu();
    
     
     settingsMenu->insertTitle( item->text(0),0,0);    
     if(item->text(0)=="   Network Cards" ) { 
       if(ethernetscan->isShown());       
       ethernetscan->hide();
     internetsetup->show();
   
	 return;
     }
     QRegExp regexp( "^eth" );
     int ret = regexp.search(item->text(0));
     if( ret != -1 ) {
     settingsMenu->insertItem( i18n("&Configure"), this, SLOT( slotConfigure( ) ));
//     settingsMenu->insertItem( "&Enable Device", this, SLOT( slotEnableDevice() ) );
     settingsMenu->insertItem( i18n("&Disable Device"), this, SLOT( slotDisableDevice() ) );       
     settingsMenu->insertItem( i18n("&Dock into System Tray"), this, SLOT( slotDocking() ) );   
     }      	 
     if(item->text(0)=="   Modems" )
     settingsMenu->insertItem( i18n("&Scan for modems"), this, SLOT( slotModemSetup( ) ));
     if(item->text(0)=="   Internet" ) 
     settingsMenu->insertItem( i18n("&Create a new Connection"), this, SLOT( slotInternetSetup( ) ));     
     
     if(gpppdata.accountCount() > 0) {
        for(int i=0; i <= gpppdata.accountCount()-1; i++) {
          gpppdata.setAccountByIndex(i); 
             if(item->text(0)==gpppdata.accname() ) {
                 settingsMenu->insertItem( i18n("&Delete Account"), this, SLOT (deleteAccount() ) );   
                 settingsMenu->insertItem( i18n("&Edit Account"), this, SLOT ( settings() ));   
             }
        }
     }
     if(gpppdata.modemCount() >0) {
	for(int i=0; i <= gpppdata.modemCount()-1; i++) {
	  gpppdata.setModemByIndex(i);
	     if(item->text(0)==gpppdata.modname() ) {
	         settingsMenu->insertItem( i18n("&Delete Modem"), this, SLOT (deleteModem() ) );   
                 settingsMenu->insertItem( i18n("&Edit Modem"), this, SLOT ( preModemSettings() ));   
	     }
	}
     }

    settingsMenu->exec( QCursor::pos() );

}

void NetworkDev::newScriptAccount()
{
    page = "scriptnew";
    scriptConnection();
}


void NetworkDev::newAccount()
{
     page = "dslnew";
     dslConnection();

}

void NetworkDev::newDialupConnection()
{
     page = "dialupnew";
     dialupConnection();
     bool deviceExist = false;
     for(int k = 0; devices[k]; k++)
  {
      if ( devices[k] == gpppdata.modemDevice())
          deviceExist = true;
     accountsetup->kComboBox6->insertItem(devices[k]);
  }
  if ( !deviceExist )
      modemscan->modemComboBox->insertItem(gpppdata.modemDevice());
}

void NetworkDev::preModemSettings()
{
     gpppdata.setModem(settingsMenu->title(0));
     gpppdata.setModemDevice(settingsMenu->title(0));
//     gpppdata.setDevice(settingsMenu->title(0));
     gpppdata.setDefaultModem(settingsMenu->title(0));
     modemSettings();
}

void NetworkDev::modemSettings()
{
     page = "modem";
     if(scriptsetup->isShown());    
     scriptsetup->hide();
     if(internetsetup->isShown());    
     internetsetup->hide();   
     if(ethernetscan->isShown());       
     ethernetscan->hide(); 
     if(accountsetup->isShown()){
     accountsetup->hide();
     }
     if(settingsdialog->isShown() );
     settingsdialog->hide();
     modemscan->show();
     KStandardDirs *dirs = KGlobal::dirs();
      newmovie = (dirs->findResource ("data","knet/pics/eggputer.mng" ) );
      movie=QMovie(newmovie);
      modemscan->modemPixmapLabel->setMovie( movie );   
      modemscan->show();
 //     modeminsert();
      modemscan->pushButton5->setEnabled(TRUE);
      modemscan->modemComboBox->setEnabled(TRUE);
      connect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(init() ));
      disconnect(modemscan->pushButton5, SIGNAL(clicked()),this, SLOT(slotDisableDevice() ));
      QPixmap pm = movie.framePixmap();    
      movie.step(); 

     modeminsert();
     modemscan->pushButton5->setEnabled(FALSE);
     modemscan->speedComboBox->setCurrentText(gpppdata.speed() );
     modemscan->flowComboBox->setCurrentText(gpppdata.flowcontrol() );
     modemscan->lineComboBox->setCurrentText(gpppdata.enter() );
     modemscan->dialtoneCheckBox->setChecked(gpppdata.waitForDialTone() );
     modemscan->checkBox4->setChecked(gpppdata.modemLockFile() );
     modemscan->modemComboBox->setCurrentText(gpppdata.modname() );
     modemscan->modemComboBox->setEnabled(FALSE);
     modemscan->preInitNumInput->setValue(gpppdata.modemPreInitDelay() );
     modemscan->init1LineEdit->setText(gpppdata.modemInitStr(0) );
     modemscan->init2LineEdit->setText(gpppdata.modemInitStr(1) );
     modemscan->modemSlider->setValue(gpppdata.volume() );
     modemscan->postInitNumInput->setValue(gpppdata.modemInitDelay() );
    // Havent connected the dialing speed yet

     modemscan->initResponseLineEdit->setText(gpppdata.modemInitResp() );
     modemscan->noDialToneLineEdit->setText(gpppdata.modemNoDialToneDetectionStr() );
     modemscan->dialStringLineEdit->setText(gpppdata.modemDialStr() );
     modemscan->connectResponseLineEdit->setText(gpppdata.modemConnectResp() );
     modemscan->busyResponseLineEdit->setText(gpppdata.modemBusyResp() );

     modemscan->noDialtoneResponseLineEdit->setText(gpppdata.modemNoDialtoneResp() );
     modemscan->hangupLineEdit->setText(gpppdata.modemHangupStr() );
     modemscan->hangupResponseLineEdit->setText(gpppdata.modemHangupResp() );
     modemscan->answerLineEdit->setText(gpppdata.modemAnswerStr() );
     modemscan->ringResponseLineEdit->setText(gpppdata.modemRingResp() );
     modemscan->answerResponseLineEdit->setText(gpppdata.modemAnswerResp() );
     modemscan->noCarrierResponseLineEdit->setText(gpppdata.modemNoCarrierResp() );
     modemscan->escapeStringLineEdit->setText(gpppdata.modemEscapeStr() );
     modemscan->escapeResponseLineEdit->setText(gpppdata.modemEscapeResp() );
     modemscan->guardTimeNumInput->setValue(gpppdata.modemEscapeGuardTime() );

     modemscan->dlpResponseLineEdit->setText(gpppdata.modemDLPResp() );
     modemscan->volumeOffLineEdit->setText(gpppdata.volumeOff() );
     modemscan->volumeLowLineEdit->setText(gpppdata.volumeMedium() );
     modemscan->volumeHighLineEdit->setText(gpppdata.volumeHigh() );
     modemscan->kIntNumInput6->setValue(gpppdata.busyWait() );
}

void NetworkDev::applyModem()
{
    gpppdata.setSpeed(modemscan->speedComboBox->currentText());
    gpppdata.setEnter(modemscan->lineComboBox->currentText());
    gpppdata.setFlowcontrol(modemscan->flowComboBox->currentText());
    gpppdata.setModemLockFile(modemscan->checkBox4->isChecked() );
    gpppdata.setModemTimeout(30);
    gpppdata.setWaitForDialTone(modemscan->dialtoneCheckBox->isChecked() );

    gpppdata.setModemPreInitDelay(modemscan->preInitNumInput->value() );
    gpppdata.setModemInitStr(0,modemscan->init1LineEdit->text() );
    gpppdata.setModemInitStr(1,modemscan->init2LineEdit->text() );
    gpppdata.setModemInitDelay(modemscan->postInitNumInput->value() );
    // Havent connected the dialing speed yet

    gpppdata.setModemInitResp(modemscan->initResponseLineEdit->text() );
    gpppdata.setModemNoDialToneDetectionStr(modemscan->noDialToneLineEdit->text() );
    gpppdata.setModemDialStr(modemscan->dialStringLineEdit->text() );
    gpppdata.setModemConnectResp(modemscan->connectResponseLineEdit->text() );
    gpppdata.setModemBusyResp(modemscan->busyResponseLineEdit->text() );

    gpppdata.setModemNoDialtoneResp(modemscan->noDialtoneResponseLineEdit->text() );
    gpppdata.setModemHangupStr(modemscan->hangupLineEdit->text() );
    gpppdata.setModemHangupResp(modemscan->hangupResponseLineEdit->text() );
    gpppdata.setModemAnswerStr(modemscan->answerLineEdit->text() );
    gpppdata.setModemRingResp(modemscan->ringResponseLineEdit->text() );
    gpppdata.setModemAnswerResp(modemscan->answerResponseLineEdit->text() );
    gpppdata.setModemNoCarrierResp(modemscan->noCarrierResponseLineEdit->text() );
    gpppdata.setModemEscapeStr(modemscan->escapeStringLineEdit->text() );
    gpppdata.setModemEscapeResp(modemscan->escapeResponseLineEdit->text() );
    gpppdata.setModemEscapeGuardTime(modemscan->guardTimeNumInput->value() );

    gpppdata.setModemDLPResp(modemscan->dlpResponseLineEdit->text() );
    gpppdata.setVolumeOff(modemscan->volumeOffLineEdit->text() );
    gpppdata.setVolumeMedium(modemscan->volumeLowLineEdit->text() );
    gpppdata.setVolumeHigh(modemscan->volumeHighLineEdit->text() );
    gpppdata.setVolume(modemscan->modemSlider->value() );
    gpppdata.setbusyWait(modemscan->kIntNumInput6->value() );
    gpppdata.save();
}

void NetworkDev::deleteModem()
{
    QString s = i18n("Are you sure you want to delete\nthe modem \"%1\"?").arg(settingsMenu->title(0)); 
    if(KMessageBox::warningYesNo(this, s, i18n("Confirm Delete")) != KMessageBox::Yes) {
       return;
    }
    gpppdata.deleteModem(settingsMenu->title(0) );
    iterateList();
    }	


void NetworkDev::deleteAccount()
{
    gpppdata.setAccount(settingsMenu->title(0));
    QString s = i18n("Are you sure you want to delete\nthe account \"%1\"?").arg(settingsMenu->title(0)); 
    if(KMessageBox::warningYesNo(this, s, i18n("Confirm Delete")) != KMessageBox::Yes) {
       return;
    }
    gpppdata.deleteAccount(settingsMenu->title(0) );
    iterateList();
 
}

void NetworkDev::slotSettingsSetup()
{
    page="settings";
     if(scriptsetup->isShown());    
     scriptsetup->hide();
    if(accountsetup->isShown())
     accountsetup->hide();
    if(ethernetscan->isShown());   
     ethernetscan->hide();
    if(modemscan->isShown()){
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotEnableDevice() ));      
     modemscan->hide();        
     }
    if(internetsetup->isShown())
     internetsetup->hide();
    settingsdialog->show();
}

void NetworkDev::settings()
{
    gpppdata.setAccount(settingsMenu->title(0));
    editAccount();
}


void NetworkDev::editAccount()
{
 if(gpppdata.storedAccType()=="SCRIPT") {
   page="script";
   scriptConnection();
   return;
 }
 if(gpppdata.storedAccType()=="dialup") 
    page="dialup";
 if(gpppdata.storedAccType()=="DSL") 
    page="dsl"; 
    dslConnection();
 if(gpppdata.storedAccType()=="dialup") {
    page="dialup";
    dialupConnection();
    accountsetup->textLabel6->setText(i18n("Phone Number")); 
    accountsetup->networkLineEdit->setText(gpppdata.phonenumber() );
     bool deviceExist = false;
     for(int k = 0; devices[k]; k++)
  {
      if ( devices[k] == gpppdata.modemDevice())
          deviceExist = true;
     accountsetup->kComboBox6->insertItem(devices[k]);
  }
  if ( !deviceExist )
      modemscan->modemComboBox->insertItem(gpppdata.modemDevice());       
    }
            
 if(gpppdata.storedAccType()=="DSL") {
    page="dsl"; 
    accountsetup->kComboBox6->clear();
    accountsetup->textLabel6->setText(i18n("Network"));  
    accountsetup->networkLineEdit->setText(gpppdata.storedNetwork() );
 	FILE* fp = fopen("/proc/net/dev", "r");

	QStringList list;

	char interface[8];
	char buffer[128];

	// Ignore header...
	fgets(buffer, sizeof(buffer), fp);
	fgets(buffer, sizeof(buffer), fp);
	while(fgets(buffer, sizeof(buffer), fp))
	{
		sscanf(buffer, " %[^ \t\r\n:]", interface);
	QString ethDev = interface;
		if((ethDev)!="lo")  if((ethDev)!="ppp0") if((ethDev)!="ppp1") {
		
       accountsetup->kComboBox6->insertItem(interface);

		}
		list.append(interface);
 
    }    
    }
 accountsetup->connectionNameLineEdit->setText(gpppdata.accname()) ;
 accountsetup->usernameLineEdit->setText(gpppdata.storedUsername() );
 accountsetup->passwordLineEdit->setText(gpppdata.storedPassword() );
 accountsetup->iconPixmapLabel->setPixmap(gpppdata.accountIconName() );
 accountsetup->iconURLRequester->setURL(gpppdata.accountIconName() );
 accountsetup->kComboBox6->insertItem(gpppdata.device() ); 
 accountsetup->kComboBox6->setCurrentText(gpppdata.device() );
 accountsetup->checkBox7->setChecked(gpppdata.autoDNS() );
 accountsetup->dns1LineEdit->setText(gpppdata.dns().first());
 accountsetup->dns2LineEdit->setText(gpppdata.dns().last());
 accountsetup->defaultrouteCheckBox->setChecked(gpppdata.get_defaultroute() );
 accountsetup->noauthCheckBox->setChecked(gpppdata.get_noauth() );
 accountsetup->noccpCheckBox->setChecked(gpppdata.get_noccp() );
 accountsetup->nopcompCheckBox->setChecked(gpppdata.get_nopcomp() );
 accountsetup->novjCheckBox->setChecked(gpppdata.get_novj() );
 accountsetup->novjccompCheckBox->setChecked(gpppdata.get_novjccomp() );
 accountsetup->noipdefaultCheckBox->setChecked(gpppdata.get_noipdefault() );
 accountsetup->nobsdcompCheckBox->setChecked(gpppdata.get_nobsdcomp() );
 accountsetup->nodeflateCheckBox->setChecked(gpppdata.get_nodeflate() );
 accountsetup->persistCheckBox->setChecked(gpppdata.get_persist() );
 accountsetup->vpiSpinBox->setValue(gpppdata.vpi() );
 accountsetup->vciSpinBox->setValue(gpppdata.vci() );
 accountsetup->holdoffSpinBox->setValue(gpppdata.holdoff() );
 accountsetup->maxfailSpinBox->setValue(gpppdata.maxfail() );
 accountsetup->mruSpinBox->setValue(gpppdata.mru() );
 accountsetup->mtuSpinBox->setValue(gpppdata.mtu() );
 accountsetup->echofailureSpinBox->setValue(gpppdata.echo_failure() );
 accountsetup->echointervalSpinBox->setValue(gpppdata.echo_interval() );
 accountsetup->pluginComboBox->setCurrentText(gpppdata.protocol() );


 }

void NetworkDev::scriptConnection()
{
     if(accountsetup->isShown());    
     accountsetup->hide();	
     if(internetsetup->isShown());    
     internetsetup->hide();   
     if(ethernetscan->isShown());       
     ethernetscan->hide(); 
     if(modemscan->isShown()){
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotEnableDevice() ));      
     modemscan->hide();
     }
     if(settingsdialog->isShown() );
     settingsdialog->hide();
     scriptsetup->show();
     connect(scriptsetup->iconURLRequester, SIGNAL(textChanged (const QString&)), this, SLOT(setIcon(const QString &)) );
     if(page=="script") {
     scriptsetup->connectionNameLineEdit->setText(gpppdata.accname() );
     scriptsetup->usernameLineEdit->setText(gpppdata.storedUsername() );
     scriptsetup->passwordLineEdit->setText(gpppdata.storedPassword() );
     scriptsetup->iconPixmap->setPixmap(gpppdata.accountIconName() );
     scriptsetup->iconURLRequester->setURL(gpppdata.accountIconName() );
     scriptsetup->scriptargLineEdit->setText(gpppdata.scriptArg() );
     }
}

void NetworkDev::dslConnection()
{
     if(scriptsetup->isShown());    
     scriptsetup->hide();	
     if(internetsetup->isShown());    
     internetsetup->hide();   
     if(ethernetscan->isShown());       
     ethernetscan->hide(); 
     if(modemscan->isShown()){
     disconnect(modemscan->pushButton5, SIGNAL(clicked()), this, SLOT(slotEnableDevice() ));      
     modemscan->hide();
     }
     if(settingsdialog->isShown() );
     settingsdialog->hide();
     accountsetup->show();
     accountsetup->connectionNameLineEdit->clear();
     accountsetup->usernameLineEdit->clear();
     accountsetup->passwordLineEdit->clear();
     accountsetup->networkLineEdit->clear();
     accountsetup->dns1LineEdit->clear();
     accountsetup->dns2LineEdit->clear();   
     accountsetup->iconPixmapLabel->clear();
     accountsetup->iconURLRequester->clear();
     accountsetup->textLabel6->setText(i18n("Network"));       
     connect(accountsetup->iconURLRequester, SIGNAL(textChanged (const QString&)), this, SLOT(setIcon(const QString &)) );
     accountsetup->pluginComboBox->clear();
        if((page=="dialup") or (page=="dialupnew") )
//     accountsetup->pluginComboBox->clear();
            accountsetup->pluginComboBox->insertItem("DialUp");
//        }
//     KMessageBox::information(this, i18n(page));
        if((page=="dslnew") or (page=="dsl") )
        {
	QString pppddir;
	pppddir = "/usr/lib/pppd/" + gpppdata.pppdVersion();
	QDir d(pppddir);
        d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
        d.setSorting( QDir::Size | QDir::Reversed );
        d.setNameFilter("*ppp*");
        const QFileInfoList *list = d.entryInfoList();
        QFileInfoListIterator it( *list );
        QFileInfo *fi;

//        printf( "     Bytes Filename\n" );
           while ( (fi = it.current()) != 0 ) {
           if(fi->fileName()=="rp-pppoe.so")
               accountsetup->pluginComboBox->insertItem("PPPoE");
           if(fi->fileName()=="pppoe.so")
               accountsetup->pluginComboBox->insertItem("PPPoE");
           if(fi->fileName()=="pppoatm.so")
               accountsetup->pluginComboBox->insertItem("PPPoA");
               ++it;
           }
         }



     
}

void NetworkDev::dialupConnection()
{
     dslConnection();
     accountsetup->textLabel6->setText(i18n("Phone Number"));
     accountsetup->kComboBox6->clear();
  
}

void NetworkDev::isdnConnection()
{

}

void NetworkDev::cableConnection()
{

}

void NetworkDev::setIcon(const QString &b)
{
  if((page=="script") or (page=="scriptnew"))
    scriptsetup->iconPixmap->setPixmap(b);
  else  
    accountsetup->iconPixmapLabel->setPixmap(b);

}
