/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _REQUESTER_H_
#define _REQUESTER_H_

class Requester {

public:
  Requester(int);
  ~Requester();

  int  openModem(const QString & dev);
  int  openLockfile(const QString & dev, int flags = 0);
  bool removeLockfile();
  int  openResolv(int flags);
  int  openSysLog();
  bool setSecret(int method, const QString & name, const QString & password);
  bool removeSecret(int authMethode);
  bool setHostname(const QString & name);
  bool execPPPDaemon(const QString & arguments);
  bool killPPPDaemon();
  int  pppdExitStatus();
  bool stop();
  bool killRoguePppd();
  bool checkPassword(const QString & password);

public:
  static Requester *rq;
  int lastStatus;
  int previousStatus;

private:
  bool sendRequest(struct RequestHeader *request, int len);
  bool recvResponse();
  int  recvFD();
  int  indexDevice(const QString & dev);
  int  socket;
  bool expect_alarm;
};

void recv_timeout(int);

#endif
