/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CHARTFRAME_H
#define CHARTFRAME_H

#include <qframe.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qtimer.h>
/**
@author yodor
*/
class ChartFrame : public QWidget
{
Q_OBJECT
public:
    ChartFrame(QWidget *parent = 0, const char *name = 0);
    ~ChartFrame();


	int nextValue();
	float getMaxRate();
	void setMaxRate(float mrate);
	void setValue(int index, float speed);
	float getValue(int index);
	void init();

public slots:
	void clearChart();

protected:
	void paintEvent(QPaintEvent *);

private:
	float *values;
	int w;
	int offset_w;	
	float maxRate;
};

#endif
