/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "alarmsdialog.h"
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>

#include <kconfig.h>
#include <kapplication.h>
#include <knuminput.h>
#include <kmessagebox.h>
#include <qlabel.h>


extern QString abv[];
extern QString sz_abv;

extern double getScaleString(const Q_ULLONG value, QString& c);

AlarmsDialog::AlarmsDialog(QWidget* parent, const char* name, WFlags fl)
: AlarmsWidget(parent,name,fl), dev_name(name)
{
	connect(btnClose, SIGNAL(clicked()), this, SLOT(hide()));
	connect(chkEnabled, SIGNAL(toggled(bool)), this, SLOT(toggleEnabled(bool)));
	connect(cboQnty, SIGNAL(activated(int)), this, SLOT(qntyChanged(int)));

	for (int a=0;a<8;a++){

		cboQnty->insertItem(abv[a]);
	}
	m_bytes=0;
	readAlarm();
	setCaption("Alarm: "+dev_name);

}

AlarmsDialog::~AlarmsDialog()
{
}

void AlarmsDialog::readAlarm()
{
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	alarmEnabled = cfg->readEntry("alarmEnabled",false);
	traffic =  cfg->readNumEntry("alarmTraffic",0);
	qntIndex = cfg->readNumEntry("alarmQntIndex",0);
	alarmExec= cfg->readEntry("alarmExec",false);
	cfg->sync();
	cboQnty->setCurrentItem(qntIndex);
}
void AlarmsDialog::saveAlarm()
{
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("alarmEnabled",alarmEnabled);
	cfg->writeEntry("alarmTraffic",traffic);
	cfg->writeEntry("alarmQntIndex",qntIndex);
	cfg->writeEntry("alarmExec",alarmExec);
	cfg->sync();
}

void AlarmsDialog::toggleEnabled(bool mode)
{
	double val = txtTraffic->value();
	if (mode==true){
		QString msg = "";
		if (val==0) {
			msg = "Unable to alarm with zero traffic";
		}
		else{
			bool ret = testAlarm();
			if (ret)
			{
				msg = "Current traffic already exceed alarm value?";
			}
		}
		if ( QString::compare(msg,"") != 0 ) {
			KMessageBox::error(this,msg);
			chkEnabled->setChecked(false);
			return;
		}
	}
	else
	{
		alarmExec=false;	
	}
	alarmEnabled=mode;

	frmAlarm->setEnabled(!mode);
	
	saveAlarm();
}



void AlarmsDialog::qntyChanged(int index )
{
	qntIndex=index;
}

void AlarmsDialog::update(const KNetDockIf * nif)
{
	m_bytes=nif->total.bytes;
	QString sc="";
	double scaled = getScaleString(m_bytes,sc);
	txtCurrTraffic->setText(QString("%1").arg(scaled,0,'f',2)+sc+"B");

	if (alarmEnabled){
		if (!alarmExec){
			bool ret = testAlarm();
			if (ret){
				alarmExec=true;
				alarmEnabled=false;
				chkEnabled->setChecked(false);
				KMessageBox::information(0,"Interface traffic reached alarm limit.");
				
			}
		}
	}
	
}

bool AlarmsDialog::testAlarm()
{

	
	QString sc="";
	double scaled = getScaleString(m_bytes,sc);
	int pos_s = sz_abv.find(sc);
	
	QString qc = cboQnty->currentText().mid(0,1);
	int pos_c = sz_abv.find(qc);	
	double sel_val = txtTraffic->value();

	if (sel_val<scaled){
		if (pos_s<=pos_c){
			
				return true;
			
		}
	}
	return false;
}
