/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef DEVICESTATDIALOG_H
#define DEVICESTATDIALOG_H


#include "chartframe.h"
#include "dockif.h"
#include "speedframe.h"
#include "propspane.h"
#include "trafficpane.h"


#include <qdict.h>
#include <qtimer.h>
#include <qcheckbox.h>
#include <qtabwidget.h>

#include "alarmsdialog.h"

class DeviceStatDialog : public QWidget
{
  Q_OBJECT

public:
  DeviceStatDialog(QWidget *parent=0, const char* name = 0, WFlags fl = 0 );
  ~DeviceStatDialog();
	bool isDockShown();
	void showdock(bool);
	

signals:
	void removeDetails(const QString&);
	void dockVisible(const QString&, bool);
	
	void showAllDevices();
	void quitAllDevices();

public slots:
  void hide();
	void update();
	void quitDock();
	void toggleDock(bool mode);
	void showAllEmitter();
	void quitAllEmitter();
	void toggleCheckbox(bool mode);
	void toggleTip();
	void toggleUseChart();
	void alarmsConfig();	


private:
AlarmsDialog *alarms;
	QTimer *t;
ChartFrame *c;
SpeedFrame *s;
QString dev_name;
DockIf *dock;

QCheckBox *chkdock;
QTabWidget *tabs;
PropsPane *props_pane;
TrafficPane *traffic_pane;
int tipMenuID;
int chartMenuID;


};




#endif

