/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "trafficpane.h"
#include <qlayout.h>

extern double getScaleString(const unsigned long long int value, QString& c);


TrafficPane::TrafficPane(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
QGridLayout *mainGrid = new QGridLayout(this,7,3,5 );
	QLabel *l1 = new QLabel("",this);
	mainGrid->addWidget(l1, 0,0);

	QLabel *l2 = new QLabel("Input     ",this);
	mainGrid->addWidget(l2, 0,1);

	QLabel *l3 = new QLabel("Output    ",this);
	mainGrid->addWidget(l3, 0,2);

	QLabel *l4 = new QLabel("Bytes",this);
	mainGrid->addWidget(l4,1,0);
	bytesIN = new QLabel("0",this);
	mainGrid->addWidget(bytesIN,1,1);
	bytesOUT = new QLabel("0",this);
	mainGrid->addWidget(bytesOUT,1,2);

	QLabel *l5 = new QLabel("Packets",this);
	mainGrid->addWidget(l5,2,0);
	pktsIN = new QLabel("0",this);
	mainGrid->addWidget(pktsIN,2,1);
	pktsOUT = new QLabel("0",this);
	mainGrid->addWidget(pktsOUT,2,2);

	QLabel *l6 = new QLabel("Error",this);
	mainGrid->addWidget(l6,3,0);
	errIN = new QLabel("0",this);
	mainGrid->addWidget(errIN,3,1);
	errOUT = new QLabel("0",this);
	mainGrid->addWidget(errOUT,3,2);

	QLabel *l7 = new QLabel("Drop",this);
	mainGrid->addWidget(l7,4,0);
	dropIN = new QLabel("0",this);
	mainGrid->addWidget(dropIN,4,1);
	dropOUT = new QLabel("0",this);
	mainGrid->addWidget(dropOUT,4,2);

	QLabel *l8 = new QLabel("Compr",this);
	mainGrid->addWidget(l8,5,0);
	comprIN = new QLabel("0",this);
	mainGrid->addWidget(comprIN,5,1);
	comprOUT = new QLabel("0",this);
	mainGrid->addWidget(comprOUT,5,2);

	QLabel *l9 = new QLabel("Speed",this);
	mainGrid->addWidget(l9,6,0);
	speedIN = new QLabel("0",this);
	mainGrid->addWidget(speedIN,6,1);
	speedOUT = new QLabel("0",this);
	mainGrid->addWidget(speedOUT,6,2);
}


TrafficPane::~TrafficPane()
{
}
void TrafficPane::update(const KNetDockIf *nif)
{
	if (!nif)return;

		QString c="";
		double ret=0;

		ret=getScaleString(nif->total.bytes_in,c);
		bytesIN->setText(QString("%1 %2B").arg(ret,0,'f',2).arg(c));
		c="";
		ret=getScaleString(nif->total.bytes_out,c);
		bytesOUT->setText(QString("%1 %2B").arg(ret,0,'f',2).arg(c));
		c="";
	
		QString b="Bps";
		int mult=1;
		if (nif->useBPS){
			mult=8;
			b="bps";
		}
		ret=getScaleString(nif->total.speed_in * mult, c);

		speedIN->setText(QString("%1").arg(ret,0,'f',2) + c + b);
		c="";
		ret=getScaleString(nif->total.speed_out * mult, c);
		speedOUT->setText(QString("%1").arg(ret,0,'f',2) + c +b);


		pktsIN->setText(QString("%1").arg(nif->stats.rx_packets));
		pktsOUT->setText(QString("%1").arg(nif->stats.tx_packets));
		
		errIN->setText(QString("%1").arg(nif->stats.rx_errors));
		errOUT->setText(QString("%1").arg(nif->stats.tx_errors));
		
		dropIN->setText(QString("%1").arg(nif->stats.rx_dropped));
		dropOUT->setText(QString("%1").arg(nif->stats.tx_dropped));
		
		comprIN->setText(QString("%1").arg(nif->stats.rx_compressed));
		comprOUT->setText(QString("%1").arg(nif->stats.tx_compressed));
}

