/***************************************************************************
                          knightstextview.cpp  -  description
                             -------------------
    begin                : Sun Dec 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knightstextview.moc"
#include "definitions.h"
#include "resource.h"
#include <kdebug.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kurl.h>
#include <krun.h>

// Used for printing functionality
#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include <qfontmetrics.h>
#include <kprinter.h>
#include <qsimplerichtext.h>

KnightsTextView::KnightsTextView(QWidget *parent, resource *Rsrc ) : QTextBrowser(parent)
{
	myResource = Rsrc;
	setReadOnly( TRUE );
	setTextFormat( Qt::RichText );
	menuView = new KPopupMenu( this );
	/*
		Configure functions in the View right click menu
	*/
	menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("editcopy"), KIcon::Small ) ),
												i18n( "&Copy" ), this, SLOT( menuFunct(int) ), CTRL+Key_C, MENU_COPY );
	menuView->insertItem( i18n("Select &All"), this, SLOT( menuFunct(int) ), CTRL+Key_A, MENU_SELECT_ALL );
	menuView->insertSeparator();
	menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("fileprint"), KIcon::Small ) ),
												i18n( "&Print" ), this, SLOT( menuFunct(int) ), CTRL+Key_P, MENU_PRINT );
//  menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("find"), KIcon::Small ) ),
//                        i18n( "&Find" ), this, SLOT( menuFunct(int) ), CTRL+Key_F, MENU_FIND );
//	menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("next"), KIcon::Small ) ),
//												i18n( "Find &Next" ), this, SLOT( menuFunct(int) ), Key_F3, MENU_FIND_NEXT );
//  menuView->insertSeparator();
	menuView->insertSeparator();
	menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("viewmag+"), KIcon::Small ) ),
												i18n( "Zoom &In" ), this, SLOT( menuFunct(int) ), 0, MENU_ZOOM_IN );
	menuView->insertItem( QIconSet( Rsrc->LoadIcon( QString("viewmag-"), KIcon::Small ) ),
												i18n( "Zoom &Out" ), this, SLOT( menuFunct(int) ), 0, MENU_ZOOM_OUT );

  /* disconnect the linkClicked signal so we can replace it with our own */
	disconnect(this, SIGNAL(linkClicked(const QString&)),this ,0);
	/* connect the linkClicked signal to displayLink slot */
	connect(this, SIGNAL(linkClicked(const QString&)), this, SLOT(displayLink(const QString&)));

	show();
}

KnightsTextView::~KnightsTextView()
{
	delete menuView;
}

///////////////////////////////////////
//
//	KnightsTextView::viewportMousePressEvent
//
///////////////////////////////////////
void KnightsTextView::viewportMousePressEvent( QMouseEvent *e )
{
	if( e->button() == RightButton )
	{
		emit rightButtonClicked( e->globalPos() );
		display_menuView( e->globalPos() );
	}
	QTextEdit::viewportMousePressEvent( e );
}
///////////////////////////////////////
//
//	KnightsTextView::display_menuView
//
///////////////////////////////////////
void KnightsTextView::display_menuView( const QPoint &Pos )
{
	if( hasSelectedText() )
	{
		menuView->setItemEnabled( MENU_COPY, TRUE );
	}
	else
	{
		menuView->setItemEnabled( MENU_COPY, FALSE );
	}
	menuView->popup( Pos );
}
///////////////////////////////////////
//
//	KnightsTextView::menuFunct
//
///////////////////////////////////////
void KnightsTextView::menuFunct( int funct )
{
	switch( funct )
	{
		case MENU_COPY:
			copy();
			break;
		case MENU_SELECT_ALL:
			selectAll();
			break;
		case MENU_ZOOM_IN:
			zoomIn();
			break;
		case MENU_ZOOM_OUT:
			zoomOut();
			break;
		case MENU_PRINT:
			print();
			break;
		default:
			break;
	}
}
///////////////////////////////////////
//
//	KnightsTextView::pageMove
//
///////////////////////////////////////
void KnightsTextView::pageMove( Qt::Key key )
{
	int NewY;
	if( key == Key_PageUp )
	{
		NewY = contentsY() - visibleHeight();
		if( NewY < 0 )
			NewY = 0;
	}
	else
	{
		NewY = contentsY() + visibleHeight();
		if( NewY > ( contentsHeight() - visibleHeight() ) )
			NewY = contentsHeight() - visibleHeight();
	}
	setContentsPos( 0, NewY );
	updateContents( 0, NewY, visibleWidth(), visibleHeight() );
}

///////////////////////////////////////
//
//	KnightsTextView::displayLink(QString url)
//
///////////////////////////////////////
void KnightsTextView::displayLink(const QString& urlString)
{
	KURL url(urlString);
	new KRun(url);
}

///////////////////////////////////////
//
//	KnightsTextView::print
//
///////////////////////////////////////
void KnightsTextView::print( void )
{
	KPrinter printer( true, QPrinter::ScreenResolution );
	viewport()->setCursor( waitCursor );

	/* Make sure we want to print */
	if( printer.setup() )
	{
		QPainter paint( &printer );
		QPaintDeviceMetrics pageMetrics( paint.device() );

		/* Setup sizes */
		int dpix = pageMetrics.logicalDpiX();
		int dpiy = pageMetrics.logicalDpiY();
		const int margin = 36; // pt
		QRect body( margin * dpix / 72, margin * dpiy / 72,
								pageMetrics.width() - margin * dpix / 72 * 2,
								pageMetrics.height() - margin * dpiy / 72 * 2 );
		QRect view( body );

		printer.setFullPage( true );
		printer.setCreator( "Knights" );
		QSimpleRichText simpText( this->text(), this->font() );
		simpText.setWidth( view.width() );

		/* Count Pages */
		int currentPage = 1;
		int totalPages = simpText.height() / view.height();
		if( view.height() * totalPages < simpText.height() )
		{
			totalPages++;
		}

		/* Print */
		while( 1 )
		{
			/* Print the Contents */
			paint.setClipRect( body );
			simpText.draw( &paint, body.left(), body.top(), view, colorGroup() );
			paint.setClipping( false );
			view.moveBy( 0, body.height() );
			paint.translate( 0, -body.height() );

			/* Print the Page Number */
			paint.setFont( myResource->FONT_Standard );
			paint.setPen( myResource->COLOR_Black );
			QString pageCount = i18n( "Page %1 of %2" ).arg( currentPage ).arg( totalPages );
			paint.drawText( view.width() - paint.fontMetrics().width( pageCount ),
											view.bottom() + paint.fontMetrics().ascent() + 5, pageCount );
			if( view.top() >= simpText.height() )
			{
				break;
			}
			printer.newPage();
			currentPage++;
		}
	}

	/* Restore Playground */
	viewport()->unsetCursor();
}

void QTextBrowser::setSource(const QString&)
{
	/* overwrote this to stop clicked links from clearing the
 		 console */
}
