/***************************************************************************
                          tabbox.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabbox.moc"
#include "tabpage.h"
#include "resource.h"
#include "accel.h"
#include <klocale.h>
#include <qstyle.h>
#include <qtabwidget.h>

TabBox::TabBox( resource *rsrc ) : QVBox(0,"TabBox",Qt::WDestructiveClose)
{
	myResource = rsrc;
	setMargin( QApplication::style().defaultFrameWidth() );

	myTabs = new QTabWidget( this, "myTabs" );
	myTabs->setTabShape( QTabWidget::Rounded );
	myTabs->setTabPosition( QTabWidget::Top );

	myAccel = new Accel( this, myResource->myAccel );

	connect( myTabs, SIGNAL( currentChanged( QWidget* ) ), this, SLOT( changeMyCaption( QWidget* ) ) );
	connect( this, SIGNAL( focus( const QChar& ) ), myResource->myAccel, SIGNAL( focus( const QChar& ) ) );
}
TabBox::~TabBox()
{
	while( myTabs->count() )
	{
		removeTab( myTabs->page(0), TRUE );
	}
	delete myAccel;
}
///////////////////////////////////////
//
//	TabBox::keyPressEvent
//
///////////////////////////////////////
void TabBox::keyPressEvent( QKeyEvent *e )
{
	QChar input;

	if( ( e->state() | Qt::ShiftButton ) == Qt::ShiftButton )
	{
		input = e->text().at(0);
		if( input.isLetterOrNumber() )
		{
			emit focus( input );
			e->accept();
			return;
		}
	}
	e->ignore();
}
///////////////////////////////////////
//
//	TabBox::addTab
//
///////////////////////////////////////
void TabBox::addTab( QWidget *child, const QString &caption )
{
	if( QString( child->className() ) == "TabPage" )
	{
		myTabs->addTab( child, caption );
		myTabs->showPage( child );
		changeMyCaption( child );
		connect( child, SIGNAL( newParent( TabBox* ) ), this, SIGNAL( newTabBox( TabBox* ) ) );
		connect( child, SIGNAL( requestDestruction() ), this, SLOT( destroyChild() ) );
	}
	else
	{
		TabPage *newPage = new TabPage( (QWidget*)this, child, myResource );
		newPage->setCaption( caption );

		myTabs->addTab( newPage, caption );
		myTabs->showPage( newPage );
		changeMyCaption( newPage );
		connect( newPage, SIGNAL( newParent( TabBox* ) ), this, SIGNAL( newTabBox( TabBox* ) ) );
		connect( newPage, SIGNAL( requestDestruction() ), this, SLOT( destroyChild() ) );
	}
}
///////////////////////////////////////
//
//	TabBox::removeTab
//
///////////////////////////////////////
void TabBox::removeTab( QWidget *child, bool deleteChild )
{
	if( QString( child->className() ) == "TabPage" )
	{
		emit saveTabGeometry( QString( ((TabPage*)child)->getChild()->className() ), size() );
		myTabs->removePage( child );
	}
	else
	{
		emit saveTabGeometry( QString( child->className() ), size() );
		myTabs->removePage( child->parentWidget() );
	}

	/* Delete it if requested */
	if( deleteChild )
	{
		delete child;
	}
}
///////////////////////////////////////
//
//	TabBox::showTab
//
///////////////////////////////////////
void TabBox::showTab( QWidget *child )
{
	if( isChild( child ) )
		myTabs->showPage( child->parentWidget() );
}
///////////////////////////////////////
//
//	TabBox::destroyChild
//
///////////////////////////////////////
void TabBox::destroyChild( void )
{
	QObject *child = ((QObject*)sender());

	/* Be careful... make sure we have a valid child calling us */
	if( child == NULL )
		return;
	if( !child->isWidgetType() )
		return;
	if( !isChild( ((QWidget*)child) ) )
		return;

	/* Nuke it */
	removeTab( ((QWidget*)child), TRUE );

	if( count() == 0 )
	{
		/* TabManager will be notified of the delete via QObject::destroyed(QObject*) */
		delete this;
	}
}
///////////////////////////////////////
//
//	TabBox::changeMyCaption
//
///////////////////////////////////////
void TabBox::changeMyCaption( QWidget *child )
{
	setCaption( i18n("%1 - Knights").arg( myTabs->tabLabel( child ) ) );
}
///////////////////////////////////////
//
//	TabBox::count
//
///////////////////////////////////////
int TabBox::count( void )
{
	return myTabs->count();
}
///////////////////////////////////////
//
//	TabBox::isChild
//
///////////////////////////////////////
bool TabBox::isChild( QWidget *child )
{
	for( int tmp=0; tmp < myTabs->count(); tmp++ )
	{
		if( myTabs->page(tmp) == child )
			return TRUE;
		if( ((TabPage*)myTabs->page(tmp))->getChild() == child )
			return TRUE;
	}
	return FALSE;
}
///////////////////////////////////////
//
//	TabBox::changeCaption
//
///////////////////////////////////////
void TabBox::changeCaption( QWidget *child, const QString &caption )
{
	if( QString( child->className() ) == "TabPage" )
	{
		((TabPage*)child)->setCaption( caption );
		myTabs->setTabLabel( child, caption );
	}
	else if( isChild( child ) )
	{
		((TabPage*)child->parentWidget())->setCaption( caption );
		myTabs->setTabLabel( child->parentWidget(), caption );
	}
	changeMyCaption( myTabs->currentPage() );
}
