// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include <hk_classes.h>
#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <qlistbox.h>
#include <qdialog.h>
#include "hk_kdemessages.h"
#include "hk_kdegrid.h"
#include "knodawin.h"
#include "knodaprogram.h"
#include "knodamaindockwindow.h"
#include "hk_kdedriverselect.h"
#include <klocale.h>
#include <kconfig.h>
#include <kmimetype.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#if HAVE_CONFIG_H
#include <config.h>
#endif
static KCmdLineOptions options[] =
{
    { "d <driver>", I18N_NOOP("Specifies the database driver"), 0 },
    { "b <database>", I18N_NOOP("Specifies a database"), 0 },
    { "f <form>", I18N_NOOP("Specifies a form (only in combination with -b)"), 0 },
    { "runtime", I18N_NOOP("No design mode"), 0 },
    { "strongruntime",I18N_NOOP("No design mode and no database control window"),0},
    { "classic", I18N_NOOP("SDI look"), 0 },
    { "classic-mdi", I18N_NOOP("use MDI (deprecated)"), 0 },
    { "print-sql", I18N_NOOP("prints the SQL statements to the standard ouput"), 0 },
#ifdef HK_DEBUG
    { "debug", I18N_NOOP("debug"), 0 },
#endif
     {"+[database]",I18N_NOOP("local database file (SQLite)"),0},
    KCmdLineLastOption
};


int main(int argc,char** argv)
{
        umask(0077);

    KAboutData aboutData("knoda", 
    I18N_NOOP("knoda"),
        VERSION, I18N_NOOP("knoda is a database management system"), 
	KAboutData::License_GPL,
        "(c) 2000-2005 Horst Knorr",0,"http://www.knoda.org","hk_classes@knoda.org");
    aboutData.addAuthor("Horst Knorr",I18N_NOOP("Author"), "hk_classes@knoda.org","http://www.knoda.org");
    aboutData.setTranslator(I18N_NOOP("NAME OF TRANSLATOR"),I18N_NOOP("EMAIL OF TRANSLATOR"));
    aboutData.addCredit ("Anirban Biswas",I18N_NOOP("Postgresql driver"), "utpal@cal2.vsnl.net.in");
    aboutData.addCredit ("Tilman Linneweh",I18N_NOOP("FreeBSD port"), "tilman@arved.de");

    QString database;
    QString form;
    hk_string driver;
    KCmdLineArgs::init(argc,argv,&aboutData);
    KCmdLineArgs::addCmdLineOptions(options);
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KApplication anwendung;
    struct_commands commands;
    bool d =args->isSet("d");
    bool db = args->isSet("b");
    bool f  = args->isSet("f");
    bool mdi= args->isSet("classic-mdi");
    bool classic= args->isSet("classic");
    if (mdi) classic=true;
    mdi=false;
    bool nolistwindow=args->isSet("strongruntime"); 
    bool runtime=args->isSet("runtime");
    bool printsql=args->isSet("print-sql"); 
    if (db) database=args->getOption("b");
    if (f) form=args->getOption("f");
    if (d)  driver = args->getOption("d");
    if (printsql)  hk_data::set_print_sqlstatements(true);
    if (args->count()>0 && !db)
      {
        db=true;
	database=args->arg(0);
      }
    KMimeType::Ptr ptr = KMimeType::findByFileContent(database);
    QString mimename = ptr.data()->name();
    if (mimename=="application/x-hk_classes-sqlite3")
    {
      driver="sqlite3";
      d=true;
    }  
    else
    if (mimename=="application/x-hk_classes-sqlite2")
    {
     driver="sqlite2";
     d=true;
    } 
    
    if (!d&&(db||f))
    {
        cerr <<i18n("Please specifiy a database driver!")<<endl;
        return -1;

    }
    if (f&&!db)
    {
        cerr <<i18n("Specifying a form only works in combination with specifying a database")<<endl;
        return -1;

    }


#ifdef HK_DEBUG
    if (args->isSet("debug")) hk_class::set_generaldebug(true);
#endif
    set_kdestandarddialogs();
    parameters p;
    p.driver=driver;
    p.database=database;
    p.form=form;
    p.runtime=runtime;
    p.classic_mdi=mdi;
    p.classic=classic;
    if (nolistwindow)p.runtime=true;
    struct_commandlinefields cp;
    cp.driver=driver;
    cp.database=database.local8Bit().data();
    cp.form=form.local8Bit().data();
    cp.runtime_only=runtime;
    if (nolistwindow)cp.runtime_only=true;
    commands.p_showlistwindow=!nolistwindow;
    cp.p_guicommands=&commands;
    int result=0;
    if (p.classic_mdi || p.classic)
    {      
    knodaprogram* widget=new knodaprogram(0,0,0,&p);
    widget->show();
    if (driver.size()>0) widget->connect_clicked();
    result=anwendung.exec();
    anwendung.config()->sync();

    delete widget;
    }
    else
    {
      knodamaindockwindow* w=new knodamaindockwindow(&cp);
      w->show();
      if (driver.size()==0)
      {
        hk_kdedriverselect* select=new hk_kdedriverselect(w);
	if (select->exec()==QDialog::Accepted)
	{
	   w->set_drivername(select->driverlist->currentText().local8Bit().data());
	}
        delete select;
      }
    result=anwendung.exec();
    anwendung.config()->sync();
    }
    return  result;

}
