// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.33 $
#include <hk_datasource.h>

#include <hk_kdeboolean.h>
#include <hk_kdeboolean.moc>
#include <qkeycode.h>
#include <hk_form.h>
#include <klocale.h>

hk_kdeboolean::hk_kdeboolean(QWidget* wid,hk_form* form)
:QCheckBox(wid),
hk_dsboolean(form)

{
#ifdef HK_DEBUG
    hkdebug("hk_kdeboolean::hk_kdeboolean");
#endif
    QObject::connect(this,SIGNAL(clicked()),this,SLOT(slot_data_changed()));
    p_widget_specific_row_change=true;
    setEnabled(false);

    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);

}


hk_kdeboolean::~hk_kdeboolean(void)
{

}


void hk_kdeboolean::keyPressEvent( QKeyEvent * e )
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeboolean::keyPressEvent");
#endif

    if (e->key()==Key_Return)
    {
        if (e->state()&ControlButton)
            focusNextPrevChild(false);
        else
            focusNextPrevChild(true);

    }
    else
    {
        if (column()!=NULL) if (column()->is_readonly())return;
        if (is_readonly()) return;
        QCheckBox::keyPressEvent(e);
    }
}


bool hk_kdeboolean::widget_specific_row_change(void)
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::widget_specific_row_change");
#endif
    hk_column* c=column();
    p_widget_specific_row_change=true;
    if (c!=NULL)
    {
        setChecked((c->has_changed()?c->changed_data_asbool():c->asbool()));
    }

    p_widget_specific_row_change=false;
    return true;

}


void hk_kdeboolean::slot_data_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::slotDataChanged");
#endif
    if (!p_widget_specific_row_change)
    {
#ifdef HK_DEBUG
        hkdebug("kdeboolean::data has changed!");
#endif
        if (column()!=NULL)
        {
#ifdef HK_DEBUG
            hkdebug("kdeboolean::data will be updated");
#endif
            column()->set_asbool(isChecked());
        }
    }

}


void hk_kdeboolean::widget_specific_enable_disable()
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::widget_specific_enable_disable");
#endif
    if ((datasource()!=NULL)&&(column()!=NULL))
    {
#ifdef HK_DEBUG
        hkdebug("kdeboolean::if ((datasource()!=NULL)&&(column()!=NULL))");
#endif

        if (datasource()->is_enabled()>0)
        {
            setEnabled(true);
            widget_specific_row_change();
        }
        else setEnabled(false);
    }
    else
    {
        setEnabled(false);
        setChecked(false);
    }

/* if (p_presentation!=NULL) if (p_presentation->state()==hk_form::design)
 {
    setFocusPolicy(NoFocus);
    setEnabled(true);
  }
  else
*/
    setFocusPolicy(StrongFocus);

}


void hk_kdeboolean::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::resizeEvent");
#endif
    QCheckBox::resizeEvent(event);
    reposition();

}


void  hk_kdeboolean::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::moveEvent");
#endif
    QCheckBox::moveEvent(event);
    reposition();
}


void hk_kdeboolean::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdeboolean::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QCheckBox::x()):QCheckBox::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QCheckBox::y()):QCheckBox::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QCheckBox::height()):QCheckBox::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QCheckBox::width()):QCheckBox::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


bool hk_kdeboolean::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeboolean::widget_specific_coordinates");
#endif
    setGeometry(px,py,pwidth,pheight);
    qApp->processEvents();
    return true;
}


void    hk_kdeboolean::widget_specific_label_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeboolean::widget_specific_label_changed");
#endif
    if (label().size()>0)setText(QString::fromLocal8Bit (label().c_str()));
    else setText(i18n("label"));
}


void hk_kdeboolean::widget_specific_font_changed(void)
{
    setFont(QFont(QString::fromLocal8Bit (hk_dsboolean::font().fontname().c_str()),hk_dsboolean::font().fontsize()));
}


void    hk_kdeboolean::widget_specific_insert_mode(void)
{
    blockSignals(true);
    setChecked(use_defaultvalue()?(raw_defaultvalue()=="%TRUE%"):false);
    blockSignals(false);
}


void hk_kdeboolean::mousePressEvent(QMouseEvent* m)
{
    if (column()!=NULL) if (column()->is_readonly()||is_readonly()) return;
    QCheckBox::mousePressEvent(m);
       if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && m->button()== LeftButton)
           action_on_click();

}



void  hk_kdeboolean::mouseDoubleClickEvent(QMouseEvent* event)
{
   QCheckBox::mouseDoubleClickEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_doubleclick();
}




void hk_kdeboolean::widget_specific_row_added(void)
{
    widget_specific_row_change();
}


void hk_kdeboolean::widget_specific_row_deleted(void)
{
    widget_specific_row_change();
}


void    hk_kdeboolean::widget_specific_backgroundcolour_changed(const hk_colour& )
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);

}


void    hk_kdeboolean::widget_specific_foregroundcolour_changed(const hk_colour& )
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

}
