// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
// $Revision: 1.29 $

#include "hk_kdegridcolumndialog.h"

#include <hk_kdegrid.h>
#include <hk_datasource.h>
#include <hk_class.h>
#include <hk_database.h>
#include <hk_presentation.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qcombobox.h>
#include <qspinbox.h>

/*
 *  Constructs a hk_kdegridcolumndialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdegridcolumndialog::hk_kdegridcolumndialog( hk_kdegrid* parent,  const char* name, bool modal, WFlags fl )
: hk_kdegridcolumndialogbase( parent, name, modal, fl )
{
    QString no=i18n("no");
    QString yes=i18n("yes");
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_grid=parent;
    leftlabel->setText(i18n("Invisible columns:"));
    rightlabel->setText(i18n("Shown columns:"));
    rightbox->addColumn( i18n( "Column" ) );
//    rightbox->addColumn( i18n( "Default value" ).c_str() );
    rightbox->addColumn( i18n( "Columntype" ) );
    rightbox->setSorting(-1);
    setCaption(i18n("Column select"));
    addbutton->setPixmap( loader->loadIcon("1rightarrow",KIcon::Desktop   ) );
    deletebutton->setPixmap( loader->loadIcon("1leftarrow",KIcon::Desktop   ) );

    columntypefield->insertItem(i18n("edit"));
    columntypefield->insertItem(i18n("bool"));
    columntypefield->insertItem(i18n("combo"));
    listdatasourcetypefield->insertItem(i18n("table"));
    listdatasourcetypefield->insertItem(i18n("query"));
    alignmentfield->insertItem(i18n("Left"));
    alignmentfield->insertItem(i18n("Center"));
    alignmentfield->insertItem(i18n("Right"));
    separatorfield->insertItem(yes);
    separatorfield->insertItem(no);
    readonlyfield->insertItem(yes);
    readonlyfield->insertItem(no);
    readonlylabel->setText(i18n("Read only:"));
    separatorlabel->setText(i18n("Separator:"));
    displaylabel->setText(i18n("Displayname:"));
    columntypelabel->setText(i18n("Columntype:"));
    digitlabel->setText(i18n("Digits:"));
    definitionlabel->setText(i18n("Columndefinition:"));
    listdatasourcetypelabel->setText(i18n("Listdatasourcetype:"));
    TabWidget->changeTab(formattab,i18n("&Format"));
    TabWidget->changeTab(combotab,i18n("&Combobox"));

    connect( columntypefield, SIGNAL( activated(int) ), this, SLOT( columntype_changed() ) );
    p_currentfieldit=fields.end();
    if (p_grid && p_grid->presentationdatasource()==-1) listdatasourcetype_changed();
    else   load_presentationdatasources();
    set_columnvalues();
    rightbox->setFocus();
    rightbox->setCurrentItem(0);
    rightbox->setSelected(rightbox->currentItem(),true);
    rightbox_selectionchanged(   rightbox->selectedItem());

}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdegridcolumndialog::~hk_kdegridcolumndialog()
{
// no need to delete child widgets, Qt does it all for us
}


/*
 * public slot
 */
void hk_kdegridcolumndialog::addbutton_clicked()
{
    if (leftbox->currentText().isEmpty())return;

    fieldstruct f;
    f.name=leftbox->currentText().local8Bit().data();
    fields.insert(fields.end(),f);
    rightbox->setSelected(rightbox->lastItem(),true);
    QListViewItem* feld=new QListViewItem(rightbox,rightbox->lastItem(),leftbox->currentText(),i18n("edit"));
    leftbox->removeItem(leftbox->currentItem());
    listentries_changed();
    rightbox->setSelected(feld,true);
}


/*
 * public slot
 */
void hk_kdegridcolumndialog::deletebutton_clicked()
{
    if (rightbox->currentItem()==NULL)return;

    QListViewItem* f=rightbox->currentItem();

//QListViewItem* p=NULL;
    if (f==NULL||p_currentfieldit==NULL)  return;
    f->itemBelow();

    if (p_currentfieldit!=fields.end()&&p_currentfieldit!=NULL)
    {
        fields.erase(p_currentfieldit);
        p_currentfieldit=fields.end();
    };                                            //else cout <<"p_currentfieldit==end"<<endl;

    leftbox->insertItem(rightbox->currentItem()->text(0),leftbox->currentItem()+1);
//    rightbox->removeItem(rightbox->currentItem());
    QListViewItem* nextitem =rightbox->currentItem()->nextSibling();
    delete rightbox->currentItem();
    listentries_changed();

    if (!nextitem)  nextitem=rightbox->lastItem();

    rightbox->setCurrentItem(nextitem);
    rightbox->setSelected(nextitem,true);

}


/*
 * public slot
 */
void hk_kdegridcolumndialog::exitbutton_clicked()
{
    close();
}


/*
 * public slot
 */
void hk_kdegridcolumndialog::okbutton_clicked()
{
    list<hk_string> p_l;
    list<fieldstruct>::iterator it=fields.begin();
    while (it!=fields.end())
    {
        p_l.insert(p_l.end(),(*it).name);
        it++;
    }

    p_grid->set_gridcolumns(p_l);

    it=fields.begin();
    unsigned int k=0;
    while (it!=fields.end())
    {
        hk_dsgridcolumn* gc=p_grid->gridcolumn(k);
        if (gc!=NULL)
        {
//	    if((*it).defaultvalue.size()==0) gc->reset_default();
//	    else
            gc->set_defaultvalue((*it).defaultvalue);
            gc->set_columntype((*it).columntype);
            gc->set_alignment((*it).alignment);
            gc->set_numberformat((*it).use_separators,(*it).digits);
            gc->set_displayname((*it).displayname);
            gc->set_readonly((*it).readonly);

            if ((*it).columntype==hk_dsgridcolumn::columncombo)
            {
                if (p_grid->presentation())
                {                                 //cout <<"ds: "<<(*it).listdatasource<<endl;
                    hk_datasource* ds=p_grid->presentation()->get_datasource((*it).listdatasource);
                    if (ds) gc->set_listpresentationdatasource(ds->presentationnumber());
//else cout <<"listpresentationds == NULL!"<<endl;
                }

                gc->set_listdatasource((*it).listdatasource,(*it).listdatasourcetype_is_table);
                gc->set_listcolumnname((*it).listcolumn);
                gc->set_viewcolumnname((*it).viewcolumn);
            }
        }
        it++;k++;

    }

    accept();
}


void hk_kdegridcolumndialog::listentries_changed(void)
{
    addbutton->setEnabled(leftbox->count()>0);
    deletebutton->setEnabled(rightbox->childCount()>0);
    storebutton->setEnabled(rightbox->childCount()>0);
    bool b=(columntypefield->currentItem()==2);
    combotab->setEnabled(b);
    listdatasourcetypefield->setEnabled((p_grid->presentationdatasource()==-1));
}


void hk_kdegridcolumndialog::set_columnvalues()
{
    if (p_grid==NULL) return;

    leftbox->clear();
    rightbox->clear();
    fields.erase(fields.begin(),fields.end());
    p_currentfieldit=fields.end();
    list<hk_string>* p_visiblelist =p_grid->visible_columns();
    list<hk_string>::iterator it=p_visiblelist->begin();
    int i=0;
    QString def,type;
    while (it!=p_visiblelist->end())
    {
        fieldstruct f;
        hk_dsgridcolumn* gc=p_grid->gridcolumn(i);
        if (gc==NULL) def="";
        else def=QString::fromLocal8Bit (gc->raw_defaultvalue().c_str());

        switch (gc->columntype())
        {
            case hk_dsgridcolumn::columnbool : type =i18n("bool");
            break;
            case hk_dsgridcolumn::columncombo : type =i18n("combo");
            break;
            default : type =i18n("edit");
            break;

        }
        f.name=gc->columnname();
        f.defaultvalue=gc->raw_defaultvalue();
        f.alignment=gc->alignment();
        f.use_separators=gc->use_numberseparator();
        f.displayname=gc->displayname();
        f.readonly=gc->is_readonly();
        f.digits=gc->commadigits();
        f.listdatasourcetype_is_table=gc->listdatasource_is_table();
        f.listdatasource=gc->listdatasourcename();
        f.listcolumn=gc->listcolumnname();
        f.viewcolumn=gc->viewcolumnname();
        f.columntype=gc->columntype();
        fields.insert(fields.end(),f);

        QListViewItem* feld=NULL;
        feld=new QListViewItem(rightbox,rightbox->lastItem(),QString::fromLocal8Bit ((*it).c_str()),type);
// rightbox->insertItem((*it).c_str());
        it++;i++;
    }

    list<hk_string>* p_nonvisiblelist =p_grid->nonvisible_columns();
    it=p_nonvisiblelist->begin();

    while (it!=p_nonvisiblelist->end())
    {
        leftbox->insertItem(QString::fromLocal8Bit ((*it).c_str()));
        it++;
    }

    listentries_changed();

}


void hk_kdegridcolumndialog::defaultvalue_changed()
{

    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).defaultvalue=defaultfield->text().local8Bit().data();

}


void hk_kdegridcolumndialog::columntype_changed()
{
    hk_dsgridcolumn::enum_columntype t=hk_dsgridcolumn::columnedit;
    switch (columntypefield->currentItem())
    {
        case 0 : t=hk_dsgridcolumn::columnedit;break;
        case 1 : t=hk_dsgridcolumn::columnbool;break;
        case 2 : t=hk_dsgridcolumn::columncombo;break;
        default : t=hk_dsgridcolumn::columnedit;
    }
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).columntype=t;
    else cout <<"Warnung: p_currentfieldit==.end"<<endl;

    combotab->setEnabled(t==2);

    rightbox->currentItem()->setText(1,columntypefield->currentText());
    listentries_changed();
}


void hk_kdegridcolumndialog::rightbox_selectionchanged(QListViewItem* i)
{

//      QListViewItem* i=rightbox->currentItem();
    if (i==NULL)return;

    list<fieldstruct>::iterator it=fields.begin();
    bool found=false;
    hk_string nn=i->text(0).local8Bit().data();
    while (it!=fields.end()&&!found)
    {
        if ((*it).name==nn)
        {
            p_currentfieldit=it;
            found=true;
        }
        it++;
    }
    if (p_currentfieldit==fields.end()) return;
    defaultfield->blockSignals(true);
    defaultfield->setText( QString::fromLocal8Bit ((*p_currentfieldit).defaultvalue.c_str()));
    defaultfield->blockSignals(false);

    displayfield->blockSignals(true);
    displayfield->setText( QString::fromLocal8Bit ((*p_currentfieldit).displayname.c_str()));
    displayfield->blockSignals(false);

    readonlyfield->blockSignals(true);
    readonlyfield->setCurrentItem( ((*p_currentfieldit).readonly?0:1));
    readonlyfield->blockSignals(false);

    columntypefield->blockSignals(true);
    int p=0;
    switch ((*p_currentfieldit).columntype)
    {
        case hk_dsgridcolumn::columnbool :p=1;break;
        case hk_dsgridcolumn::columncombo :p=2;break;
        default : p=0;
    }
    combotab->setEnabled(p==2);

    columntypefield->setCurrentItem(p);
    columntypefield->blockSignals(false);
    alignmentfield->blockSignals(true);
    p=0;
    switch ((*p_currentfieldit).alignment)
    {
        case hk_dsdatavisible::aligncenter :p=1;break;
        case hk_dsdatavisible::alignright :p=2;break;
        default : p=0;
    }

    alignmentfield->setCurrentItem(p);
    alignmentfield->blockSignals(false);

    separatorfield->blockSignals(true);
    separatorfield->setCurrentItem((*p_currentfieldit).use_separators?0:1);
    separatorfield->blockSignals(false);

    digitfield->blockSignals(true);
    digitfield->setValue((*p_currentfieldit).digits);
    digitfield->blockSignals(false);

    if (p_grid->presentationdatasource()==-1)
    {
        listdatasourcetypefield->blockSignals(true);
        listdatasourcetypefield->setCurrentItem((*p_currentfieldit).listdatasourcetype_is_table?0:1);
        listdatasourcetypefield->blockSignals(false);
        listdatasourcetype_changed();
    }
    reload_listdatasource();
    set_currentlistdatasource();

    listcolumnfield->blockSignals(true);
    listcolumnfield->setCurrentText(QString::fromLocal8Bit ((*p_currentfieldit).listcolumn.c_str()));
    listcolumnfield->blockSignals(false);

    viewcolumnfield->blockSignals(true);
    viewcolumnfield->setCurrentText(QString::fromLocal8Bit ((*p_currentfieldit).viewcolumn.c_str()));
    viewcolumnfield->blockSignals(false);

    listentries_changed();

}


void hk_kdegridcolumndialog::alignment_changed()
{
    hk_dsdatavisible::alignmenttype a;
    switch (alignmentfield->currentItem())
    {
        case 1 :a=hk_dsdatavisible::aligncenter;
        break;
        case 2 : a=hk_dsdatavisible::alignright;
        break;
        default : a=hk_dsdatavisible::alignleft;
    }
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).alignment=a;
}


void hk_kdegridcolumndialog::displayname_changed()
{
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).displayname=displayfield->text().local8Bit().data();

}


void hk_kdegridcolumndialog::digits_changed()
{
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).digits=digitfield->value();

}


void hk_kdegridcolumndialog::separator_changed()
{
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).use_separators=(separatorfield->currentItem()==0);

}


void hk_kdegridcolumndialog::readonly_changed()
{
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).readonly=(readonlyfield->currentItem()==0);

}


void hk_kdegridcolumndialog::listdatasource_changed()
{
    QString f=listdatasourcefield->currentText();
    if (f.isEmpty()) f="";
    if (p_currentfieldit!=fields.end())
    {
        (*p_currentfieldit).listdatasource=f.local8Bit().data();
//cout <<"(*p_currentfieldit).listdatasource gesetzt " <<(*p_currentfieldit).listdatasource<<endl;
    }
    reload_listdatasource();

}


void hk_kdegridcolumndialog::reload_listdatasource(void)
{

    listcolumnfield->blockSignals(true);
    listcolumnfield->clear();
    listcolumnfield->blockSignals(false);
    viewcolumnfield->blockSignals(true);
    viewcolumnfield->clear();
    viewcolumnfield->blockSignals(false);
    if (!p_grid) return;
    if (!p_grid->datasource())return;
    hk_datasource* ds= NULL;
    if ( !p_grid->presentation())
    {
//no presentation
//      cout <<"no presentation"<<endl;
        hk_database* db=p_grid->datasource()->database();
        if (db==NULL) return;
        QString f=listdatasourcefield->text(listdatasourcefield->currentItem());
        if (f.isEmpty()) f="";
        if (p_grid->presentation())p_grid->presentation()->get_datasource(f.local8Bit().data());
        else
        {
            ds=db->load_datasource(f.local8Bit().data(),listdatasourcetypefield->currentItem()!=0);
        }
        if (ds==NULL) return;
    }
    else
    {                                             // a presenation

    }

    list<hk_column*>* v=NULL;
    if (p_grid->presentation()&&p_currentfieldit!=fields.end())
    {
        ds=p_grid->presentation()->get_datasource((*p_currentfieldit).listdatasource);

//cout <<"ds: "<<ds <<" dsname: "<< (*p_currentfieldit).listdatasource<<endl;
    }
    hk_string tempfilter;
    bool usetempfilter=false;
    if(ds)
    {
        if (ds->type()!=hk_datasource::ds_table)
        {
            tempfilter=ds->temporaryfilter();
            usetempfilter=ds->use_temporaryfilter();
            ds->set_temporaryfilter("0=1");

            ds->set_use_temporaryfilter(true);
            ds->enable();
        }
        v=ds->columns();
    }
    if (v==NULL)
    {
        if (ds&& ds->type()!=hk_datasource::ds_table)
        {
            ds->disable();
            ds->set_temporaryfilter(tempfilter);
            ds->set_use_temporaryfilter(usetempfilter);
        }

        return;
    }
    listcolumnfield->blockSignals(true);
    viewcolumnfield->blockSignals(true);
    listcolumnfield->insertItem("");
    viewcolumnfield->insertItem("");
    list<hk_column*>::iterator it=v->begin();
    while (it!=v->end())
    {
        listcolumnfield->insertItem(QString::fromLocal8Bit ((*it)->name().c_str()));
        viewcolumnfield->insertItem(QString::fromLocal8Bit ((*it)->name().c_str()));
        it++;
    }
    listcolumnfield->blockSignals(false);
    viewcolumnfield->blockSignals(false);

    if (ds && ds->type()!=hk_datasource::ds_table)
    {
        ds->disable();
        ds->set_temporaryfilter(tempfilter);
        ds->set_use_temporaryfilter(usetempfilter);
    }

}


void hk_kdegridcolumndialog::listdatasourcetype_changed()
{
    if (!p_grid->datasource())return;
    hk_database* db=p_grid->datasource()->database();
    if (db==NULL) return;
    vector<hk_string>* v=NULL;
    if (listdatasourcetypefield->currentItem()==0)
        v=db->tablelist();
    else v=db->querylist();
    if (p_currentfieldit!=fields.end())
        (*p_currentfieldit).listdatasourcetype_is_table=(listdatasourcetypefield->currentItem()==0);
    listdatasourcefield->blockSignals(true);
    listdatasourcefield->clear();
    vector<hk_string>::iterator it=v->begin();
    int p=0;
    while (it!=v->end())
    {
        listdatasourcefield->insertItem(QString::fromLocal8Bit ((*it).c_str()));
    if (p_currentfieldit!=fields.end())
        if ((*p_currentfieldit).listdatasource==(*it))listdatasourcefield->setCurrentItem(p);
        it++;++p;
    }
    //listdatasourcefield->setCurrentItem(0);
    listdatasourcefield->blockSignals(false);
//   listdatasource_changed();
    reload_listdatasource();
    listdatasource_changed();
}


void hk_kdegridcolumndialog::set_currentlistdatasource(void)
{
    int current=0;
    int counter=0;
    int c= listdatasourcefield->count();
    while (counter<c)
    {
        if (p_currentfieldit!=fields.end())
        {
            if ( listdatasourcefield->text(counter)== QString::fromLocal8Bit ((*p_currentfieldit).listdatasource.c_str()))
                current=counter;
        }                                         //else cout <<"p_currentfieldit!=fields.end()"<<endl;
        counter++;
    }
    listdatasourcefield->blockSignals(true);
    listdatasourcefield->setCurrentItem(current);
    listdatasourcefield->blockSignals(false);

}


void hk_kdegridcolumndialog::viewcolumn_changed()
{
    if (p_currentfieldit!=fields.end())
    {
        (*p_currentfieldit).viewcolumn=viewcolumnfield->currentText().local8Bit().data();
//cout <<"viewcolumn_changed auf  "<<(*p_currentfieldit).viewcolumn<<endl;
    }
}


void hk_kdegridcolumndialog::listcolumn_changed()
{
    if (p_currentfieldit!=fields.end())
    {
        (*p_currentfieldit).listcolumn=listcolumnfield->currentText().local8Bit().data();
//cout <<"listcolumn_changed auf  "<<(*p_currentfieldit).listcolumn<<endl;
    }
}


void hk_kdegridcolumndialog::load_presentationdatasources(void)
{

//load datasources from hk_presentation
//cout <<"mit presentation"<<endl;
    listdatasourcefield->blockSignals(true);
    listdatasourcefield->clear();
    listdatasourcefield->blockSignals(false);

    list<hk_datasource*>* dslist = p_grid->presentation()->datasources();
    if (dslist==NULL)   return;
    list<hk_datasource*>::iterator it=dslist->begin();
    while (it!=dslist->end())
    {
        QString name= QString::fromLocal8Bit (p_grid->presentation()->unique_datasourcename((*it)->presentationnumber()).c_str());
        listdatasourcefield->insertItem(name);
        it++;
    }

}
