// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.47 $

#include "hk_kdereport.h"
#include "hk_kdetoolbar.h"
#include "hk_kdesimplereport.h"
#include "hk_kdereportsectiondialog.h"

#include <hk_database.h>
#include <hk_connection.h>
#include <hk_datasource.h>

#include <qscrollview.h>
#include <qbuttongroup.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwidgetstack.h>

#include <klibloader.h>
#include <kmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kmdichildview.h>
#include <kglobal.h>
#include <kiconloader.h>


class hk_kdereportscrollview :public QScrollView
{
    public:
        hk_kdereportscrollview ( QWidget * parent=0, const char * name=0, WFlags f=0 )
            :QScrollView(parent,name,f)
        {
            p_report =NULL;
        }
        void set_report(hk_kdesimplereport* r){p_report=r;}
    protected:

        virtual void viewportMousePressEvent ( QMouseEvent * )
        {
            if (p_report!=NULL) p_report->set_focus2property();
        }
        hk_kdesimplereport* p_report;
};

hk_kdereport::hk_kdereport (QWidget* parent,  const char* name, WFlags fl )
: KParts::DockMainWindow( parent, name, fl ) ,hk_class()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::hk_kdereport");
#endif

    resize( 800, 600 );
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    setXMLFile(locate("data","hk_kdeclasses/hk_kdereport.rc"));
    p_whilepreview=false;
    p_closewindow=false;
    p_previewpart=NULL;
    p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(set_designmode()),actionCollection(),"designmode");
    p_designaction->setEnabled(!runtime_only());
    p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(set_viewmode()),actionCollection(),"viewmode");
    p_printaction=new KAction(i18n("&Print"),"fileprint",0,this,SLOT(print_report()),actionCollection(),"printreport");
    p_printaction->setEnabled(false);
    p_sectionaction=new KAction(i18n("Sectionselect"),loader->loadIcon("reportsection",KIcon::User),0,this,SLOT(select_section()),actionCollection(),"sectionselect");
    p_sectionaction->setToolTip(i18n("sections"));
    p_designaction->setExclusiveGroup("mode");
    p_viewaction->setExclusiveGroup("mode");
    p_designaction->setChecked(true);
    p_saveaction=new KAction(i18n("&Save"),"filesave",0,this,SLOT(save_report()),actionCollection(),"savereport");
    p_saveaction->setEnabled(!runtime_only());
    p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,this,SLOT(saveas_report()),actionCollection(),"saveas");
    p_saveasaction->setEnabled(!runtime_only());
    p_closeaction=new KAction(i18n("&Close"),loader->loadIcon("exit",KIcon::User),0,this,SLOT(close_report()),actionCollection(),"closereport");

    p_pointeraction=new KRadioAction("Pointer",loader->loadIcon("pfeil",KIcon::User),0,this,SLOT(pointerbutton_clicked()),actionCollection(),"pointer");
    p_fieldaction=new KRadioAction("Field",loader->loadIcon("edit",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"fieldbutton");
    p_pointeraction->setToolTip(i18n("select"));
    p_pointeraction->setExclusiveGroup("design");
    p_fieldaction->setExclusiveGroup("design");
    p_fieldaction->setToolTip(i18n("new field"));
    p_pointeraction->setChecked(true);
    p_bulkaction=new KActionMenu(i18n("Set to all"),0,actionCollection(),"bulk");
    p_bulkfontaction=new KAction(i18n("Font"),0,0,this,SLOT(bulkfont_clicked()),actionCollection(),"bulkfont");
    p_bulkforegroundcolouraction=new KAction(i18n("Foregroundcolour"),0,0,this,SLOT(bulkforegroundcolour_clicked()),actionCollection(),"bulkforeground");
    p_bulkbackgroundcolouraction=new KAction(i18n("Backgroundcolour"),0,0,this,SLOT(bulkbackgroundcolour_clicked()),actionCollection(),"bulkbackground");
    p_bulkaction->insert(p_bulkfontaction);
    p_bulkaction->insert(p_bulkforegroundcolouraction);
    p_bulkaction->insert(p_bulkbackgroundcolouraction);

    QPixmap p;
    KDockWidget* maindock=createDockWidget("",p,0,"");
    maindock->setEnableDocking(KDockWidget::DockNone);
    maindock->setDockSite(KDockWidget::DockCorner);
    setView(maindock);
    setMainDockWidget(maindock);
    p_stack= new QWidgetStack(maindock);
    maindock->setWidget(p_stack);
    
    
    p_scrollview = new hk_kdereportscrollview(p_stack);
    p_stack->addWidget(p_scrollview,0);
    p_report = new hk_kdesimplereport( p_scrollview->viewport() );
    p_report->set_kdereport(this);
    p_scrollview->set_report(p_report);

    p_reportpropertyaction=new KAction(i18n("&Propertyeditor"),loader->loadIcon("propertyeditor",KIcon::User),0,p_report,SLOT(show_property()),actionCollection(),"viewproperty");

    //setCentralWidget(p_scrollview);
    set_reporttoolbar();
    p_scrollview->addChild(p_report);
    set_nodesignmode(runtime_only());
    p_report->set_reporttype("Postscript",false);
    createGUI(0L);
    toolBar("designtoolbar")->setBarPos(KToolBar::Left);
}


hk_kdereport::~hk_kdereport(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::~hk_kdereport");
#endif


}


void hk_kdereport::viewbutton_clicked(void)
{
    set_mode(hk_presentation::viewmode);
}


void hk_kdereport::designbutton_clicked(void)
{
    if (p_nodesignmode)  set_mode(hk_presentation::viewmode);
    else set_mode(hk_presentation::designmode);

}


void hk_kdereport::set_reporttoolbar(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::set_reporttoolbar");
#endif

    connect( p_report, SIGNAL( signalfield_created() ), this, SLOT( field_created() ) );

}


bool    hk_kdereport::set_presentationdatasource(long n, bool r)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::set_presentationdatasource(n)");
#endif
    bool res=true;
    if (r) res= p_report->set_presentationdatasource(n,false);
    return res;
}


long    hk_kdereport::presentationdatasource(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::presentationdatasource(n)");
#endif
    return p_report->presentationdatasource();
}


void hk_kdereport::set_database(hk_database* db)
{
    p_report->set_database(db);
}


hk_database* hk_kdereport::database(void)
{
    return p_report->database();
}


void hk_kdereport::closeEvent ( QCloseEvent* e)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::closeEvent");
#endif
    if (p_report->has_changed())
    {
        p_report->save_report();
    }

    if(!p_whilepreview)
    {
        //setCentralWidget(NULL);
        if(p_previewpart!=NULL)
        {
            p_stack->removeWidget(p_previewpart->widget());
	    delete p_previewpart;
	    p_previewpart=NULL;
        }
        QWidget::closeEvent(e);
    } else p_closewindow=true;
   emit signal_closed(this);
}


void hk_kdereport::fieldbutton_clicked(void)
{
    p_report->set_field2create(p_fieldaction->isChecked());
}


void hk_kdereport::set_nodesignmode(bool d)
{
    p_nodesignmode=d;

}


void    hk_kdereport::set_mode(hk_presentation::enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereport::set_mode(s)");
#endif
    //if (s==p_report->mode()&&!runtime_only())return;

    if (s==hk_presentation::viewmode)
    {
        if (!p_report->set_mode(s))
        {
            p_designaction->setChecked(true);
            return;
        }
        toolBar("designtoolbar")->hide();
        
        p_reportpropertyaction->setEnabled(false);
        p_viewaction->setChecked(true);
        KLibFactory*    p_factory=KLibLoader::self()->factory("libkghostview");
        if (!p_factory) p_factory=KLibLoader::self()->factory("libkghostviewpart");
        if (p_factory)
        {
            if (p_previewpart!=NULL)
	    {
		createGUI(0L);
		p_stack->removeWidget(p_previewpart->widget());
	        delete p_previewpart;
	        p_previewpart=NULL;
	    }
            p_previewpart=(KParts::ReadOnlyPart*) p_factory->create(this,"kgvpart","KParts::ReadOnlyPart");
            if (p_previewpart!=NULL)
            {
                p_whilepreview=true;
                p_stack->addWidget(p_previewpart->widget(),1);
		p_stack->raiseWidget(p_previewpart->widget());
                createGUI(p_previewpart);
                p_previewpart->openURL(QString::fromLocal8Bit(p_report->outputfile().c_str()));
                p_previewpart->widget()->show();
                p_whilepreview=false;
                if (p_closewindow) close();
                p_printaction->setEnabled(true);
                set_caption();
            }
        }
        else
        {
            show_warningmessage(hk_translate("KGhostview could not be found!\nPlease install the kdegraphics package"));
        }
        p_bulkaction->setEnabled(false);
    }
    else
    {                                             //design mode
//setCaption(QString::fromLocal8Bit(p_report->hk_presentation::name().c_str()));
        p_report->set_mode(s);
	p_printaction->setEnabled(false);
        createGUI(NULL);

        p_designaction->setChecked(true);
        p_bulkaction->setEnabled(true);
        if (!p_whilepreview)
        {
            toolBar("designtoolbar")->show();
            p_reportpropertyaction->setEnabled(true);
            p_stack->raiseWidget(p_scrollview);
            //p_report->set_mode(s);
        }
        else      p_viewaction->setChecked(true);

    }
    p_report->repaint(0,0,p_report->QWidget::width(),p_report->QWidget::height(),true);
}


void hk_kdereport::set_designmode(void)
{
    set_mode(hk_presentation::designmode);
}


void hk_kdereport::set_viewmode(void)
{
    set_mode(hk_presentation::viewmode);
}


void hk_kdereport::field_created(void)
{
    p_pointeraction->setChecked(true);
}


hk_kdesimplereport* hk_kdereport::simplereport(void)
{
    return p_report;
}


void    hk_kdereport::save_report(void)
{
    p_report->save_report("",false);
    set_caption();
}


void hk_kdereport::saveas_report(void)
{
    hk_string oldname=p_report->hk_presentation::name();
    p_report->set_name("");
    if (p_report->save_report("",false))
    {
        set_caption();
    }
    else
    {

        p_report->set_name(oldname);
    }

}


bool hk_kdereport::load_report(const hk_string& name)
{
    bool res=p_report->load_report(name);
    set_caption();
    return res;
}


void hk_kdereport::close_report(void)
{
    close();
}


void hk_kdereport::slot_showtoolbar(void)
{

}


void hk_kdereport::pointerbutton_clicked(void)
{

}


void hk_kdereport::print_report(void)
{
    hk_string buf=p_report->printcommand();
    p_report->set_printcommand("kprinter -j none");
    p_report->print_report(false);
    p_report->set_printcommand(buf);
}


void hk_kdereport::select_section(void)
{
    p_report->clearfocus();
    hk_kdereportsectiondialog* d= new hk_kdereportsectiondialog(p_report,this,0,true);
    d->exec();

    delete d;
}


void hk_kdereport::set_caption(void)
{
   KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
 
    QString reportname=i18n( "Report: "  );
    hk_datasource* d=p_report->datasource();
    if (d!=NULL)
    {
        if (!v) reportname=QString::fromLocal8Bit(d->database()->connection()->drivername().c_str())+" "+reportname;
        reportname+=QString::fromLocal8Bit (p_report->hk_presentation::name().c_str());
        reportname+=" (";
        hk_string driver=d->database()->name();
        reportname+=QString::fromLocal8Bit(driver.c_str());
        reportname+=")";

    }
    else reportname+=QString::fromLocal8Bit (p_report->hk_presentation::name().c_str());
    setCaption( reportname  );
    if (v) v->setCaption(reportname);

}


void hk_kdereport::bulkfont_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkfont);
}


void hk_kdereport::bulkforegroundcolour_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkforeground);

}


void hk_kdereport::bulkbackgroundcolour_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkbackground);

}
