// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDETABLE_H
#define HK_KDETABLE_H

#include <kparts/mainwindow.h>
#include <qvariant.h>
#include <qwidget.h>
//#include <qwidgetstack.h>
#include <hk_dstable.h>
class hk_kdetabledesign;
class hk_kdegrid;
class hk_kdegridpart;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QTable;
class hk_kdetoolbar;

/**
 *
 *@short  KDE high level widget to display and alter tables.
 *@version $Revision: 1.19 $
 *@author Horst Knorr (hk_classes@knoda.org)

 *hk_kdetable is a high level widget to display the content of tables and to define and alter the
 *table structure.
 *
 */

class hk_kdetable : public KParts::MainWindow ,public hk_dstable
{
    Q_OBJECT

        public:
        hk_kdetable(QWidget* w=0,const char* n=0,WFlags f=0);
        virtual    ~hk_kdetable();
        virtual bool            set_mode(enum_mode s);

/**
 * true if the design window is shown
 */
	bool in_designmode(void){return p_designmode;}
        virtual void set_datasource(hk_datasource*);
        hk_datasource* datasource(void);
/**
 *when the datasource vanishes (i.e. will be destroyed) and autoclose is true, the hk_kdetable will be
 *closed otherwise it still is on your screen.
 */

        void set_autoclose(bool c){p_autoclose=c;}
/**
 *if the designwindow should not be shown set this true. Default is false.
 */
        void set_nodesignmode(bool n);
	hk_dsgrid* grid(void);

    signals:
        void signal_closed(QWidget*);
    
    public slots:
        void designbutton_clicked(void);
        void tablebutton_clicked(void);
        void close_table(void);

    protected:
        virtual void before_source_vanishes(void);
        void closeEvent ( QCloseEvent* e);
        hk_kdetoolbar* toolbar;
        hk_kdegrid* p_grid;
        hk_kdetabledesign* p_design;

    private:
        void set_caption(void);
        bool p_designmode;
        bool p_autoclose;
        bool p_nodesignmode;
        KRadioAction* p_designaction;
        KRadioAction* p_viewaction;
        KAction*      p_filterdefinitionaction;
        KToggleAction*    p_filterexecaction;
        KAction*      p_closeaction;
        KAction*  p_printaction;
        KParts::ReadWritePart* p_part;

};
#endif                                            // HK_KDETABLE_H
