// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.5 $
#ifndef KNODAMAINDOCKWINDOW_H
#define KNODAMAINDOCKWINDOW_H
#include "knodamaindockwindowbase.h"

class hk_kdetable;
class hk_kdequery;
class hk_kdeform;
class hk_kdereport;



class knodamaindockwindow : public knodamaindockwindowbase
{
Q_OBJECT

public:
knodamaindockwindow(hk_connection* c,QWidget* parent=0L,const char* name=0L, WFlags f=WType_TopLevel|WDestructiveClose,const QString& dbname="",const QString& form="");
virtual ~knodamaindockwindow();
 
 hk_kdetable* new_table(void);
 hk_kdequery* new_query(void);
 hk_kdeform*  new_form(void);
 hk_kdereport*new_report(void);


public slots:

 virtual void slot_new_database(void);
 virtual void slot_delete_database(const QString&);


 virtual void slot_new_table(void);
 virtual void slot_delete_table(const QString&);
 virtual void slot_designmode_table(const QString&);
 virtual void slot_viewmode_table(const QString&);

 virtual void slot_new_query(void);
 virtual void slot_delete_query(const QString&);
 virtual void slot_designmode_query(const QString&);
 virtual void slot_viewmode_query(const QString&);

 virtual void slot_new_form(void);
 virtual void slot_delete_form(const QString&);
 virtual void slot_designmode_form(const QString&);
 virtual void slot_viewmode_form(const QString&);

 virtual void slot_new_report(void);
 virtual void slot_delete_report(const QString&);
 virtual void slot_designmode_report(const QString&);
 virtual void slot_viewmode_report(const QString&);
 
virtual void rename_clicked();
virtual void importcsv_clicked();
virtual void exportcsv_clicked();
virtual void exportxml_clicked();
virtual void newpassworddialog_selected(void);
virtual void copy_clicked(void);
virtual void paste_clicked(void);
virtual void clipboarddata_has_changed(void);
virtual void slot_listbox_popup(QListViewItem*,const QPoint&);
virtual void databasesettings_clicked(void);
virtual void objecthandler_clicked(void);
 
 void slot_childClosed(QWidget*);
 void slot_childClosed(KMdiChildView*);
 
  
 protected slots:
 
 void slot_selection_changed(void);
 
 private:
};


#endif //KNODAMAINDOCKWINDOW_H
