// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.8 $

#include "hk_kdetablepartwidget.h"
#include <hk_datasource.h>
#include <hk_database.h>
#include <hk_connection.h>
#include "hk_kdetablepartwidget.moc"
#include "hk_kdetabledesign.h"
#include "hk_kdegrid.h"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include "hk_kdetoolbar.h"
#include <kparts/genericfactory.h>
#include "../hk_kdetablepart/hk_kdetablepart.h"
#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kmdichildview.h>
/*
 *  Constructs a hk_kdetablepartwidget which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdetablepartwidget::hk_kdetablepartwidget(QWidget* w,const char* n,WFlags f):QWidgetStack(w,n,f),hk_dstable()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdetablepartwidget::hk_kdetablepartwidget");
    hkclassname("hk_kdetablepartwidget");
#endif
    setName( "hk_kdetablepartwidget" );
    resize( 596, 480 );
    setFocusPolicy(StrongFocus);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_designaction=NULL;
    p_viewaction=NULL;
    p_printaction=NULL;
    p_filterdefinitionaction=NULL;
    p_filterexecaction=NULL;
    p_findaction=NULL;
    p_copyaction=NULL;
    p_pasteaction=NULL;
    p_columndialogaction=NULL;
    p_saveaction=NULL;
    p_autoclose=true;
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );
    p_gridpart=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdegridpart", "KParts::ReadWritePart");
    //p_gridpart->embed(this);

    if (!p_gridpart)
    {
     show_warningmessage(hk_translate("Fatal error! Grid part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now..."));
     exit(1);
    }
     p_grid = (hk_kdegrid*)p_gridpart->widget();
     p_grid->set_enablingbehaviour(true,true);
    p_design = new hk_kdetabledesign(this,0,WDestructiveClose);
    addWidget(p_design);
    addWidget(p_grid);
    raiseWidget(p_design);
    p_toolbar = new hk_kdetoolbar( this, "p_toolbar" );
    p_toolbar->set_nodesignmode(runtime_only());
    internal_designbutton_clicked();
    connect (p_design,SIGNAL(signal_has_changed()),this,SLOT(slot_has_changed()));
    connect (p_design,SIGNAL(signal_tablename_changed()),this,SLOT(set_caption()));
}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdetablepartwidget::~hk_kdetablepartwidget()
{
// no need to delete child widgets, Qt does it all for us
    p_design->alter_table();
    hk_datasource* d=p_grid->datasource();
    if (d!=NULL)
    {
        if (d->name().size()>0)p_grid->save_table(d->name(),false);
        if (!d->presentation())d->disable();
    }
    delete p_design;
}


void hk_kdetablepartwidget::set_datasource(hk_datasource* d)
{
    hk_dsmodevisible::set_datasource(d);
    p_grid->set_datasource(d);
    p_design->set_datasource(d);
    p_toolbar->set_datasource(d);
    if (d!=NULL)
    {
        p_grid->load_table();
        p_toolbar->set_filter(QString::fromUtf8(l2u(d->temporaryfilter()).c_str()));
    }
	p_grid->set_font(hk_font());
    set_caption();
}


hk_datasource* hk_kdetablepartwidget::datasource(void)
{

    return hk_dsmodevisible::datasource();
}


void hk_kdetablepartwidget::internal_designbutton_clicked(void)
{
    if (runtime_only())
    {
        set_mode(viewmode);
        return;
    }
    hk_datasource* d=p_grid->datasource();
    if (d!=NULL)
    {
        if (d->is_enabled())d->store_changed_data();
        d->disable();
    }

    p_design->set_designmode();
    raiseWidget(p_design);
    p_design->setFocus();
    p_toolbar->set_designmode();
    if (p_designaction)
    p_designaction->setChecked(true);
    if (p_printaction)
     p_printaction->setEnabled(false);
//   p_filterdefinitionaction->setEnabled(false);
    set_caption();
    if (p_columndialogaction)
    p_columndialogaction->setEnabled(false);
  //  setFocusProxy(p_design);
}


void hk_kdetablepartwidget::internal_tablebutton_clicked(void)
{
      if (!p_design->alter_table())
        {
//p_toolbar->set_designmode();
            set_mode(designmode);
            return;
        }

    hk_datasource* d=p_grid->datasource();
    if (d!=NULL) d->enable();
   setChildGeometries();
    raiseWidget(p_grid);

    if (p_printaction)p_printaction->setEnabled(true);

    p_toolbar->set_viewmode();
    if (p_viewaction)p_viewaction->setChecked(true);
    if (p_filterdefinitionaction)p_filterdefinitionaction->setEnabled(true);
    set_caption();
    if (p_columndialogaction)
    p_columndialogaction->setEnabled(true);
//    setFocusProxy(p_grid);
}




void hk_kdetablepartwidget::tablebutton_clicked()
{
  set_mode(viewmode);
}


void hk_kdetablepartwidget::designbutton_clicked()
{
  set_mode(designmode);
}


bool  hk_kdetablepartwidget::set_mode(enum_mode s)
{
    hk_dsmodevisible::set_mode(s);
    switch (s)
    {
	case hk_dsmodevisible::designmode :
						internal_designbutton_clicked();
						break;
	case hk_dsmodevisible::viewmode :
						internal_tablebutton_clicked();
						break;

    }
slot_has_changed();
return true;
}

void hk_kdetablepartwidget::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdetablepartwidget::before_source_vanishes");
#endif

    if (p_autoclose)
        close();
    else
    {
        hk_datasource* d=datasource();
        if (d!=NULL)d->disable();
        if (p_grid!=NULL) p_grid->set_datasource(NULL);
    }
}


void hk_kdetablepartwidget::closeEvent ( QCloseEvent* e)
{
    alter_table();
    QWidget::closeEvent(e);
   emit signal_closed(this);
}


void hk_kdetablepartwidget::alter_table(void)
{
   if ( mode()==hk_presentation::designmode)
      p_design->alter_table();
      slot_has_changed();
}


void hk_kdetablepartwidget::close_table(void)
{
    close();
}


void hk_kdetablepartwidget::set_caption(void)
{
    hk_datasource* d=datasource();
    if (d!=NULL)
    {

	QString n=i18n("Table - ");
        if (d->name().size()>0)
	  n+=QString::fromUtf8(l2u(d->name()).c_str());
	else n+=i18n("Unnamed");
        setCaption(QString::fromUtf8(l2u(d->database()->connection()->drivername()).c_str())+" "+n);
	KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
        if (v) v->setCaption(n);
    }

}


hk_dsgrid* hk_kdetablepartwidget::grid() const
{
return p_grid;
}

hk_kdegrid* hk_kdetablepartwidget::kdegrid() const
{
return p_grid;
}

hk_kdetoolbar* hk_kdetablepartwidget::toolbar() const
{
return p_toolbar;
}

KParts::ReadWritePart* hk_kdetablepartwidget::gridpart(void) const
{
 return p_gridpart;
}

bool hk_kdetablepartwidget::in_designmode(void)
{
  return mode()==designmode;
}


void hk_kdetablepartwidget::save_table(void)
{
  p_design->alterbutton_clicked();
  slot_has_changed();

}


void hk_kdetablepartwidget::slot_has_changed(void)
{
 if (p_saveaction)
 {
   p_saveaction->setEnabled(mode()==designmode && p_design->has_changed());
 }
}


void hk_kdetablepartwidget::show_widget(void)
{
  show();
}

void hk_kdetablepartwidget::hide_widget(void)
{
  hide();
}

bool hk_kdetablepartwidget::close_widget(void)
{
  return close();
}

