// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.13 $

//***********************************************
//***  hk_kdequery PART definition             ***
//***********************************************
#include "hk_kdequerypart.h"
#include "hk_kdequerypartfactory.h"
#include "hk_kdeqbe.h"
#include <hk_qbe.h>
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kactionclasses.h>
#include <kparts/partmanager.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
class hk_kdequerypartprivate
{
  public:
  hk_kdequerypartprivate()
  	{
		p_query=NULL;
		activate=false;
	}
   hk_kdequerypartwidget* p_query;
   bool activate;
};

hk_kdequerypart::hk_kdequerypart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdequerypartprivate;
    setInstance(hk_kdequerypartfactory::instance());
    p_private->p_query = new hk_kdequerypartwidget(this,pWidget,0,WDestructiveClose);
    setWidget(p_private->p_query);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
     setXMLFile(locate("data","hk_kdeclasses/hk_kdequerypartqbe.rc"));
    if (p_private->p_query->runtime_only())
    {
    p_private->p_query->p_designaction=NULL;
    p_private->p_query->p_viewaction=NULL;
    }
    else
    {
    p_private->p_query->p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,p_private->p_query,SLOT(designbutton_clicked()),actionCollection(),"designmode");
    p_private->p_query->p_designaction->setEnabled(!p_private->p_query->runtime_only());
    p_private->p_query->p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,p_private->p_query,SLOT(querybutton_clicked()),actionCollection(),"viewmode");
    p_private->p_query->p_designaction->setExclusiveGroup("mode");
    p_private->p_query->p_viewaction->setExclusiveGroup("mode");
    }
    p_private->p_query->p_printaction=new KAction(i18n("&Print"),"fileprint",0,p_private->p_query,SLOT(print()),actionCollection(),"print");
    p_private->p_query->p_qbeaction=new KToggleAction(i18n("use &QBE"),loader->loadIcon("dbdesigner",KIcon::User),0,p_private->p_query,SLOT(action_useqbe()),actionCollection(),"useqbemode");
    p_private->p_query->p_qbeaction->blockSignals(true);
    p_private->p_query->p_qbeaction->setChecked(true);
    p_private->p_query->p_qbeaction->blockSignals(false);
    p_private->p_query->p_qbeaction->setEnabled(!p_private->p_query->runtime_only());

//p_private->p_printaction->setEnabled(false);
    //p_private->p_query->p_closeaction=new KAction(i18n("&Close"),"fileclose",0,p_private->p_query,SLOT(close_query()),actionCollection(),"closequery");
    p_private->p_query->p_saveaction=new KAction(i18n("&Save"),"filesave",0,p_private->p_query,SLOT(savebutton_clicked()),actionCollection(),"save");
    p_private->p_query->p_saveaction->setEnabled(false);

    p_private->p_query->p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,p_private->p_query,SLOT(saveasbutton_clicked()),actionCollection(),"saveas");
    p_private->p_query->p_saveasaction->setEnabled(!p_private->p_query->runtime_only());
    p_private->p_query->p_addaction = new KAction(i18n("&Add datasource"),loader->loadIcon("gridadd22x22",KIcon::User),0,this,SLOT(add_action()),actionCollection(),"add");
    p_private->p_query->p_distinctaction = new KToggleAction(i18n("&Distinct rows"),
    "artsaudiomanager",0,p_private->p_query->kdeqbe(),SLOT(distinct_changed()),actionCollection(),"distinct");


        p_private->p_query->p_cutaction=new KAction(i18n("Cu&t"),"editcut",CTRL+Key_X,p_private->p_query,SLOT(cut_clicked()),actionCollection(),"cut");
        p_private->p_query->p_undoaction=new KAction(i18n("&Undo"),"undo",CTRL+Key_Z,p_private->p_query,SLOT(undo_clicked()),actionCollection(),"undo");

        p_private->p_query->p_redoaction=new KAction(i18n("Re&do"),"redo",CTRL+SHIFT+Key_Z,p_private->p_query,SLOT(redo_clicked()),actionCollection(),"redo");

        p_private->p_query->p_copyaction=new KAction(i18n("&Copy"),"editcopy",CTRL+Key_C,p_private->p_query,SLOT(copy_clicked()),actionCollection(),"copy");
        p_private->p_query->p_copybackendsqlaction=new KAction(i18n("&Copy backend SQL"),0,ALT+Key_C,p_private->p_query,SLOT(copybackendsql_clicked()),actionCollection(),"copybackendsql");
        p_private->p_query->p_pasteaction=new KAction(i18n("&Paste"),"editpaste",CTRL+Key_V,p_private->p_query,SLOT(paste_clicked()),actionCollection(),"paste");
        p_private->p_query->p_replaceaction=new KAction(i18n("&Replace"),0,CTRL+Key_R,p_private->p_query,SLOT(replace_clicked()),actionCollection(),"replace");
        p_private->p_query->p_findaction=new KAction(i18n("&Find"),"find",CTRL+Key_F,p_private->p_query,SLOT(find_clicked()),actionCollection(),"find");
        p_private->p_query->p_findaction=new KAction(i18n("Find &Next"),"forward",Key_F3,p_private->p_query,SLOT(findnext_clicked()),actionCollection(),"findnext");
        p_private->p_query->p_findaction=new KAction(i18n("Find Pre&vious"),"previous",SHIFT+Key_F3,p_private->p_query,SLOT(findprevious_clicked()),actionCollection(),"findprevious");


        p_private->p_query->p_storeresultaction=new KAction(i18n("Store result"),"filesaveas",0,p_private->p_query,SLOT(storeresult_clicked()),actionCollection(),"storeresult");


        p_private->p_query->p_selectallaction=new KAction(i18n("Select &All"),0,CTRL+Key_A,p_private->p_query,SLOT(selectall_clicked()),actionCollection(),"selectall");

        p_private->p_query->p_configeditoraction=new KAction(i18n("Configure &editor"),0,0,p_private->p_query,SLOT(configeditor_clicked()),actionCollection(),"configeditor");



    p_private->p_query->p_qbetypeselect= new QComboBox(0L,"p_qbetypeselect");
    p_private->p_query->p_qbetypeselect->insertItem(i18n("Select query"));
    p_private->p_query->p_qbetypeselect->insertItem(i18n("Groupselect query"));
    p_private->p_query->p_qbetypeselect->insertItem(i18n("Update query"));
    p_private->p_query->p_qbetypeselect->insertItem(i18n("Delete query"));
    p_private->p_query->p_qbetypeselectaction=new KWidgetAction(p_private->p_query->p_qbetypeselect,i18n("&Add datasource"),0,0,0,actionCollection(),"qbetypeselect");

    connect(p_private->p_query->p_qbetypeselect,SIGNAL(activated(int)),this,SLOT(qbetypeselect_action(int)));
    connect(p_private->p_query->kdeqbe(),SIGNAL(signal_qbetype_has_changed()),this,SLOT(qbetypechange_action()));
    connect(p_private->p_query->kdeqbe(),SIGNAL(signal_distinct_has_changed()),this,SLOT(distinct_action()));

}

hk_kdequerypart::~hk_kdequerypart()
{
  if (widget())
  {
    if (p_private->p_query->has_changed())
     p_private->p_query->save_query();
  }
  delete p_private;
}



/*void hk_kdequerypart::show_dbdesignercolumndialog(void)
{
    p_private->p_table->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdequerypart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdequerypart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdequerypart::saveFile()
{
    return true;
}



void hk_kdequerypart::add_action(void)
{
p_private->p_query->kdeqbe()->add_datasource();
}


void hk_kdequerypart::qbetypeselect_action(int t)
{
 hk_qbe::enum_querytype ntype=hk_qbe::qt_select;
 switch (t)
 {
    case 1 : ntype=hk_qbe::qt_groupselect;break;
    case 2 : ntype=hk_qbe::qt_update;break;
    case 3 : ntype=hk_qbe::qt_delete;break;
    default: ntype=hk_qbe::qt_select;
 }
p_private->p_query->kdeqbe()->set_querytype(ntype);

}


void hk_kdequerypart::qbetypechange_action(void)
{
p_private->p_query->p_qbetypeselect->blockSignals(true);
int nr=0;
switch(p_private->p_query->qbe()->querytype())
{
  case hk_qbe::qt_groupselect : nr=1;break;
  case hk_qbe::qt_update : nr=2;break;
  case hk_qbe::qt_delete : nr=3;break;
  default	      :	nr=0;
}
p_private->p_query->p_qbetypeselect->setCurrentItem(nr);
p_private->p_query->p_qbetypeselect->blockSignals(false);
}

void hk_kdequerypart::distinct_action(void)
{
  p_private->p_query->p_distinctaction->setChecked(p_private->p_query->kdeqbe()->distinct());

}



KAboutData* hk_kdequerypart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdequerypart", I18N_NOOP("hk_kdequerypart"),
        "0.1", I18N_NOOP("database query editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}


void hk_kdequerypart::setXMLFile(const QString& file,bool merge,bool setxmldoc)
{
//if (manager()&&manager()->activePart()==this)

KParts::ReadWritePart::setXMLFile(file,merge,setxmldoc);
if (manager()&&manager()->activePart()==this&&! p_private->activate)
{
  p_private->activate=true;
  manager()->setActivePart(NULL);
  manager()->setActivePart(this);
  p_private->activate=false;
}

}



