// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "knodaprogrambase.h"

#include <qvariant.h>
#include <kpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <hk_classes.h>
#include <hk_connection.h>
#include "hk_kdepreferencesdialog.h"
#include <kaboutapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>

#include "knodawin.h"
#include "knodamaindockwindow.h"
#include <kstandarddirs.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kfiledialog.h>

#include <qlineedit.h>
#include <qcheckbox.h>
#include <algorithm>
#include <qvbox.h>
#include <kiconloader.h>




/*
 *  Constructs a knodaprogrambase which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
knodaprogrambase::knodaprogrambase( QWidget* parent,  const char* name, WFlags fl,struct_commandlinefields* cl )
: QWidget( parent, name, fl )
{
    p_selecteddb=QString::fromUtf8(l2u(cl->database).c_str());
    p_selectedform=QString::fromUtf8(l2u(cl->form).c_str());
    p_runtime=cl->runtime_only;
    p_driver=cl->driver;
    p_load_connection=cl->p_guicommands->p_load_connection;
    if ( !name )
        setName( "knodaprogrambase" );
    resize( 350, 241 );
    setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::MinimumExpanding, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 350, 240 ) );
    setMaximumSize( QSize( 32767, 290 ) );
//setCaption( trUtf8( "Knoda" ) );
    knodaprogrambaseLayout = new QHBoxLayout( this, 11, 6, "knodaprogrambaseLayout");
    QVBoxLayout* leftlayout=new QVBoxLayout(this,0,0,"leftlayout");
    logolabel = new QLabel( this, "logolabel" );
    logolabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, logolabel->sizePolicy().hasHeightForWidth() ) );
    logolabel->setMinimumSize( QSize( 219, 219 ) );
    logolabel->setMaximumSize( QSize( 219, 219 ) );
    QFont logolabel_font(  logolabel->font() );
    logolabel_font.setPointSize( 24 );
    logolabel_font.setBold( TRUE );
    logolabel->setFont( logolabel_font );
    logolabel->setFrameShape( QLabel::Box );
    logolabel->setFrameShadow( QLabel::Sunken );
    logolabel->setLineWidth( 1 );
    logolabel->setScaledContents( FALSE );
    logolabel->setAlignment( int( QLabel::AlignCenter ) );
    knodaprogrambaseLayout->addLayout(leftlayout);
    QSpacerItem* spacer=new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    leftlayout->addItem( spacer );
    leftlayout->addWidget( logolabel );

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setFrameShape( QButtonGroup::NoFrame );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 5 );
    ButtonGroup1->layout()->setMargin( 0 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );

    driverlist = new QComboBox( FALSE, ButtonGroup1, "driverlist" );
    driverlist->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 0, 0, driverlist->sizePolicy().hasHeightForWidth() ) );
    driverlist->setMinimumSize( QSize( 100, 0 ) );
    ButtonGroup1Layout->addWidget( driverlist );
    spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    ButtonGroup1Layout->addItem( spacer );

    connectbutton = new KPushButton( ButtonGroup1, "connectbutton" );
    connectbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, 0, 0, connectbutton->sizePolicy().hasHeightForWidth() ) );
    connectbutton->setText( trUtf8( "&Connect" ) );
    ButtonGroup1Layout->addWidget( connectbutton );

    loadconnectionbutton = new KPushButton( ButtonGroup1, "loadconnectionbutton" );
    loadconnectionbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, 0, 0, loadconnectionbutton->sizePolicy().hasHeightForWidth() ) );
    loadconnectionbutton->setText( trUtf8( "&Load" ) );
    ButtonGroup1Layout->addWidget( loadconnectionbutton );

    quitbutton = new KPushButton( ButtonGroup1, "quitbutton" );
    quitbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, 0, 0, quitbutton->sizePolicy().hasHeightForWidth() ) );
    quitbutton->setText( trUtf8( "&Quit" ) );
    ButtonGroup1Layout->addWidget( quitbutton );

    optionbutton = new KPushButton( ButtonGroup1, "optionbutton" );
    optionbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, 0, 0, optionbutton->sizePolicy().hasHeightForWidth() ) );
    optionbutton->setText( trUtf8( "&Options" ) );
    ButtonGroup1Layout->addWidget( optionbutton );

    aboutbutton = new KPushButton( ButtonGroup1, "aboutbutton" );
    aboutbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, 0, 0, aboutbutton->sizePolicy().hasHeightForWidth() ) );
    aboutbutton->setText( trUtf8( "&About" ) );
    ButtonGroup1Layout->addWidget( aboutbutton );
    knodaprogrambaseLayout->addWidget( ButtonGroup1 );

// signals and slots connections
    connect( optionbutton, SIGNAL( clicked() ), this, SLOT( options_clicked() ) );
    connect( quitbutton, SIGNAL( clicked() ), this, SLOT( quit_clicked() ) );
    connect( connectbutton, SIGNAL( clicked() ), this, SLOT( connect_clicked() ) );
    connect( loadconnectionbutton, SIGNAL( clicked() ), this, SLOT( loadconnection_clicked() ) );
    connect( aboutbutton, SIGNAL( clicked() ), this, SLOT( about_clicked() ) );
    p_drivermanager =new hk_drivermanager(p_runtime);
    set_databaselist();
}


/*
 *  Destroys the object and frees any allocated resources
 */
knodaprogrambase::~knodaprogrambase()
{
//hk_class::set_generaldebug(true);

    delete p_drivermanager;
}


/*
 * public slot
 */
void knodaprogrambase::about_clicked()
{
    KAboutApplication* d=new KAboutApplication();
    d->exec();
    delete d;
}


/*
 * public slot
 */
void knodaprogrambase::connect_clicked()
{
    if (!p_load_connection && p_driver.size()>0)
    {
        vector<hk_string>::iterator it=std::find(p_drivermanager->driverlist()->begin(),p_drivermanager->driverlist()->end(),p_driver);
        if (it==p_drivermanager->driverlist()->end())
        {
            hk_string txt=replace_all("%DRIVER%",p_drivermanager->hk_translate("No such driver: %DRIVER%"),p_driver);

            hk_class::show_warningmessage(txt);
            p_driver="";
            return;

        }
    }
    hk_connection* c=NULL;
      bool use_passwddialog=true;
    if (p_load_connection)
    {
      hk_database* db=p_drivermanager->open_connectionfile(u2l(p_selecteddb.utf8().data()));
      if (db)
      {
        hk_string dbname=db->name();
        p_selecteddb=QString::fromUtf8(l2u(dbname).c_str());
        c=db->connection();
        p_load_connection=false;
        use_passwddialog=false;
        p_driver="";
      }
      else
        show_warningmessage(hk_class::hk_translate("Database could not be loaded"));

    }
    else
    c=p_drivermanager->new_connection(u2l(driverlist->currentText().utf8().data()));
    if (c!=NULL)
    {

        if (use_passwddialog &&!c->show_passworddialog())
        {
            delete c;
            c=NULL;
            return;
        }
        if (c->connect())
        {
	   /* if (p_docklook)
	    {
	       knodamaindockwindow* w=new knodamaindockwindow(c,0,0,WDestructiveClose,p_selecteddb,p_selectedform);
	       w->show();
	       return;
	    }*/
            knodamainwindow* w=new knodamainwindow(0L,0,WDestructiveClose,p_selecteddb,p_selectedform);
            p_selecteddb="";
	    w->show();
            w->set_connection(c);
		if (w->parentWidget())w->parentWidget()->move(10,10);
        }
        else
        {
            delete c;
            c=NULL;
        }
    } else
    {
        p_driver="";
    }
}



void knodaprogrambase::loadconnection_clicked()
{
  if (!p_drivermanager) return;
  QStringList l;
  QString xmime="application/x-hk_connection";
  l.append(xmime);
KFileDialog* d=new KFileDialog(":hkc",QString::null,this,0,true);
d->setMimeFilter(l,xmime);
d->exec();
QString filename=d->selectedFile();
  if (!filename.isNull())
  {
//execute new connection
   p_selecteddb=filename;
   p_load_connection=true;
   connect_clicked();
  }
   delete d;

}






void knodaprogrambase::options_clicked()
{
    hk_kdepreferencesdialog* p_dialog= new hk_kdepreferencesdialog(0,0,true);
    p_dialog->timefield->setText(QString::fromUtf8(l2u(hk_class::defaulttimeformat()).c_str())),
    p_dialog->datefield->setText(QString::fromUtf8(l2u(hk_class::defaultdateformat()).c_str())),
    p_dialog->datetimefield->setText(QString::fromUtf8(l2u(hk_class::defaultdatetimeformat()).c_str()));
    p_dialog->localefield->setText(QString::fromUtf8(l2u(hk_class::locale()).c_str()));
    p_dialog->printcommandfield->setText(QString::fromUtf8(l2u(hk_report::printcommand()).c_str()));
    p_dialog->driverpathfield->setText(QString::fromUtf8(l2u(hk_drivermanager::path()).c_str()));
    p_dialog->bepedanticfield->setCurrentItem(hk_class::showpedantic()?0:1);
    p_dialog->maximizedfield->setCurrentItem(hk_visible::open_maximized_windows()?0:1);
    p_dialog->fontfield->setEditText(QString::fromUtf8(l2u(hk_font::defaultfontname()).c_str()));
    p_dialog->fontsizefield->setValue(hk_font::defaultfontsize());
    p_dialog->precisionfield->setValue(hk_dsdatavisible::defaultprecision());
    p_dialog->separatorfield->setCurrentItem(hk_dsdatavisible::defaultuse_numberseparator()?0:1);
    p_dialog->sizetypefield->setCurrentItem(hk_presentation::defaultsizetype()==hk_presentation::relative?0:1);
    p_dialog->measurefield->setCurrentItem(hk_class::measuresystem()==hk_class::cm?0:1);
    p_dialog->snap2gridxfield->setValue(hk_presentation::snap2gridx());
    p_dialog->snap2gridyfield->setValue(hk_presentation::snap2gridy());
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        p_dialog->defaultdriverfield->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
        if ((*it)==hk_class::defaultdriver())
            p_dialog->defaultdriverfield->setCurrentItem(di);
        di++;
    }

    int i=0;

    switch (hk_visible::defaulttextalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    p_dialog->textalignmentfield->setCurrentItem(i);

    switch (hk_visible::defaultnumberalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    p_dialog->numberalignmentfield->setCurrentItem(i);

    int res=p_dialog->exec();

    if (res==QDialog::Accepted)
    {
        hk_class::set_defaultdatetimeformat(
            u2l(p_dialog->timefield->text().utf8().data()),
            u2l(p_dialog->datefield->text().utf8().data()),
            u2l(p_dialog->datetimefield->text().utf8().data())
            );
	 hk_class::set_locale(u2l(p_dialog->localefield->text().utf8().data()));
        hk_class::set_showpedantic( p_dialog->bepedanticfield->currentItem()==0);
        hk_visible::set_open_maximized_windows(p_dialog->maximizedfield->currentItem()==0);
        hk_report::set_printcommand(u2l(p_dialog->printcommandfield->text().utf8().data()));
        hk_drivermanager::set_path(u2l(p_dialog->driverpathfield->text().utf8().data()));
        hk_font::set_defaultfont(u2l(p_dialog->fontfield->currentText().utf8().data()),p_dialog->fontsizefield->value());
	hk_presentation::set_snap2gridx(p_dialog->snap2gridxfield->value());
	hk_presentation::set_snap2gridy(p_dialog->snap2gridyfield->value());
        hk_visible::alignmenttype a=hk_visible::alignleft;
        switch (p_dialog->textalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaulttextalignment(a);
    hk_presentation::set_defaultsizetype(p_dialog->sizetypefield->currentItem()==0?hk_presentation::relative:hk_presentation::absolute);
    hk_class::set_measuresystem(p_dialog->measurefield->currentItem()==0?hk_class::cm:hk_class::inch);

        a=hk_visible::alignleft;
        switch (p_dialog->numberalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaultnumberalignment(a);
        hk_dsdatavisible::set_defaultnumberformat(p_dialog->separatorfield->currentItem()==0,p_dialog->precisionfield->value());
        hk_class::set_defaultdriver(u2l(p_dialog->defaultdriverfield->currentText().utf8().data()));

        hk_class::save_preferences();
        set_databaselist();
    }

    delete p_dialog;
}


/*
 * public slot
 */
void knodaprogrambase::set_databaselist()
{
    driverlist->clear();
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int i=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        driverlist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
        if ((p_driver.size()==0 &&(*it)==hk_class::defaultdriver())||(*it)==p_driver)
            driverlist->setCurrentItem(i);
        i++;
    }
//if (p_driver.size()==0 ) driverlist->setCurrentItem(0);
}


/*
 * public slot
 */
void knodaprogrambase::quit_clicked()
{
    parentWidget()->close();
}
