// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDEGRID
#define HK_KDEGRID
#include <hk_class.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qheader.h>
//#include <qstatusbar.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>

#include "hk_dsgrid.h"

class hk_kderowselector;
class hk_kdesimpleform;
class hk_kdefinddialog;
class hk_kdegridpart;
class hk_kdesimplegrid;

/**
 *
 *@short  shows data in a grid without columnheaders.
 *@version $Revision: 1.32 $
 *@author Horst Knorr (hk_classes@knoda.org)
 *
 *This widget shows data of a datasource in a grid.
 *If the data is not readonly you can edit the data just by typing
 *in the cell. It has column and row headers and a rowselector.
 *
 *Just set the datasource and enable it. For details how you can use it
 *see @ref hk_kdesimplegrid.
 */

class hk_kdegrid :public QFrame, public hk_dsgrid
{
    friend class hk_kdegridpart;
    friend class hk_kdesimplegrid;
    Q_OBJECT
        public:
        hk_kdegrid(QWidget* w=0,const char* n=0,WFlags f=0,hk_kdesimpleform* form=NULL);
        virtual ~hk_kdegrid();
/**
 * the datasource which data it has to show
 */
        void    set_datasource(hk_datasource* d);
/**
 * returns the use hk_kdesimplegrid. Please don't delete it !
 */
        hk_kdesimplegrid* simplegrid(void){return p_grid;}
        hk_kdegridpart*   part(void){return p_part;}
virtual void show_widget(void);
virtual void hide_widget(void);
virtual bool close_widget(void);


    public slots:
//	void datasource_enables(void);
//	void datasource_disables(void);
        void    find_clicked(void);
        void    find_next(void);
        void    findargument_changed(void);
        void    print_grid(void);

    protected:
        virtual bool        widget_specific_coordinates(unsigned int px,unsigned int py,unsigned int pwidth,unsigned int pheight);
        virtual void    widget_specific_presentationdatasource(long p);
        virtual void widget_specific_enable_disable(void);
        virtual void    widget_specific_font_changed(void);

        virtual void resizeEvent (QResizeEvent *);
        virtual void  moveEvent ( QMoveEvent * ) ;
        virtual void        before_row_change(void);
        virtual void widget_specific_backgroundcolour_changed(const hk_colour&);
        virtual void widget_specific_foregroundcolour_changed(const hk_colour&);
	virtual void widget_specific_columns_created(void);
	void widget_specific_rowheight_changes(void);
	virtual bool	presentationmode_changed(void);

    private:
        hk_kdefinddialog* p_finddialog;
        bool          p_findfirstview;
        QHBoxLayout* hbottomlayout;
        QHBoxLayout* hdatalayout;
        QHBoxLayout* htoplayout;
        QVBoxLayout* vbasiclayout;
        hk_kdesimplegrid* p_grid;
        hk_kderowselector* selector;
        QLabel*     statusbar;
        void    reposition(void);
        hk_kdegridpart* p_part;
}


;

/**
 *@internal
 */

#endif
