<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-mysqli.php 437 2007-05-26 10:24:41Z lordlamer $
 */

$KNOWLEDGEROOTDB = 'MYSQL';

/**
 * Class for Connect to Mysql over mysqli
 */
class db {
	var $CLASS = array();
	var $connection = false;
	var $dbtype = "mysqli";
	var $dbname = "mysql";
	var $lastquery = "";
	var $querys = 0;
	var $query_cache = array();
	
	/**
	 * init/start class
	 *
	 * @param array &$class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}
	
	/**
	 * Make a Connect to the mysql Server
	 *
	 * @param string $host
	 * @param string $user
	 * @param string $pass
	 * @param string $db
	 * @param string $schema not required
	 * @param string $enconding not required
	 * @return mixed return connection resource
	 */
	function connect($host,$user,$pass,$db,$schema="",$encoding="") {
		if(isset($this->CLASS['vars']['db']['pconnect']) && $this->CLASS['vars']['db']['pconnect'] == 1) {
			$this->connection = mysqli_pconnect($host,$user,$pass);
		} else {
			$this->connection = mysqli_connect($host,$user,$pass);
		}

		if(!$this->connection) {
			$this->CLASS['error']->log("Cannnot connect to host!",1,"class-mysqli.php::connect");
			exit();
		}

		$conndb = mysqli_select_db($db);
		if(!$conndb) {
			$this->CLASS['error']->log("Wrong Database!",1,"class-mysqli.php::connect");
			exit();
		}
	
		return $this->connection;
	}

	/**
	 * Close mysql connection
	 * @return bool
	 */
	function close() {
		return mysqli_close($this->connection);
	}

	/**
	 * Wrapper function that is not usable with mysql
	 * @return bool will always return false
	 */
	function lo_import($file) {
		return false;
	}

	/**
	 * Will make a query with the mysql server
	 * @param string $query
	 * @return mixed return query result
	 */
	function query($query) {
		$this->lastquery = $query;
		$this->query_cache[] = $query;
		$this->querys += 1;

		$res = mysqli_query($query, $this->connection);

		if($res === false) {
			$this->CLASS['error']->log("ERROR IN QUERY: \"$query\"",1,mysqli_errno() . ":".mysqli_errno());
		}

		return $res;
	}

	/**
	 * Will count the rows of a resultset
	 * @param mixed $result
	 * @return int
	 */
	function num_rows($result) {
		return mysqli_num_rows($result);
	}

	/**
	 * Fetch a Result as Object
	 * @param mixed $result
	 * @return object
	 */
	function fetch_object($result) {
		return mysqli_fetch_object($result);
	}

	/**
	 * Return Result as Array
	 * @param mixed $result
	 * @return array
	 */
	function fetch_row($result) {
		return mysqli_fetch_row($result);
	}

	/**
	 * Return Result as hash array
	 * @param mixed result
	 * @return array
	 */
	function fetch_assoc($result) {
		return mysqli_fetch_assoc($result);
	}

	/**
	 * Return affected rows of a result
	 * @param mixed $result
	 * @return int
	 */
	function affected_rows($result) {
		return mysqli_affected_rows($result);
	}

	/**
	 * Returns the text of the error message from previous MySQL operation
	 * @return string
	 */
	function error() {
		return mysqli_error($this->connection);
	}

	/**
	 * Return the last inserted id from a query
	 * @param string $name not required
	 * @return int
	 */
	function last_id($name = "") {
		return mysqli_insert_id();
	}

	/**
	 * Quote a String with Mysql Quotes
	 * @param string $name
	 * @return string
	 */
	function quoteIdentifier($string) {
		return "`" . $string . "`";
	}

	/**
	 * create database insert with array
	 *
	 * @param string $table
	 * @param array $values
	 * @return mixed will return the result from the query
	 */
	function db_insert($table, $values) {
		if($table != "" && is_array($values)) {
			$sql = "INSERT INTO `" . $table . "` ";

			$coloum = "(";
			$coloumval = "(";

			foreach($values as $key => $value) {
				if(isset($values[$key]['value'])) {
					$coloum .= "`" . $key . "`, ";

					if(isset($values[$key]['type'])) {
						switch($values[$key]['type']) {
						case "integer":
						case "INTEGER":
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf($values[$key]['format'].", ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("%d, ",$values[$key]['value']);
							}
							break;
						case "float":
						case "FLOAT":
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf($values[$key]['format'].", ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("%f, ",$values[$key]['value']);
							}
							break;
						default:
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf($values[$key]['format'].", ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("'%s', ",$values[$key]['value']);
							}
						}
					} else {
						$coloumval .= sprintf("'%s', ",$values[$key]['value']);
					}
				} elseif(isset($values[$key]) && !is_array($values[$key]) && $values[$key] != "") {
					$coloum .= "`" . $key . "`, ";
					$coloumval .= sprintf("'%s', ",$values[$key]);
				}
			}

			// remove last comma
			$coloum = substr($coloum,0,strlen($coloum)-2);
			$coloumval = substr($coloumval,0,strlen($coloumval)-2);

			$coloum .= ")";
			$coloumval .= ")";

			$sql .= $coloum . " VALUES " . $coloumval;

			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $values are not a array',2,'class-mysql.php::db_insert');
			return false;
		}
	}

	/**
	 * create database update with array
	 *
	 * @param string $table
	 * @param array $values
	 * @param string $where
	 * @return mixed will return the result from the query
	 */
	function db_update($table, $values, $where) {
		if($table != "" && is_array($values)) {
			$sql = "UPDATE `" . $table . "` SET ";

			$coloum = "";

			foreach($values as $key => $value) {
				if(isset($values[$key]['value'])) {
					if(isset($values[$key]['type'])) {
						switch($values[$key]['type']) {
						case "integer":
						case "INTEGER":
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("`%s`=".$values[$key]['format'].", ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("`%s`=%d, ",$key,$values[$key]['value']);
							}
							break;
						case "float":
						case "FLOAT":
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("`%s`=".$values[$key]['format'].", ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("`%s`=%f, ",$key,$values[$key]['value']);
							}
							break;
						default:
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("`%s`='".$values[$key]['format']."', ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("`%s`='%s', ",$key,$values[$key]['value']);
							}
						}
					} else {
						$coloum .= sprintf("`%s`='%s'",$key,$values[$key]['value']);
					}
				} elseif(isset($values[$key]) && !is_array($values[$key]) && $values[$key] != "") {
					$coloum .= sprintf("`%s`='%s'",$key,$values[$key]);
				}
			}

			// remove last comma
			$coloum = substr($coloum,0,strlen($coloum)-2);

			if($where == "") $where = "1";

			$sql .= $coloum . " WHERE " . $where;

			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $values are not a array',2,'class-mysql.php::db_update');
			return false;
		}
	}

	/**
	 * make a database delete
	 *
	 * @param string $table
	 * @param string $where
	 * @return mixed will return the result from the query
	 */
	function db_delete($table, $where) {
		if($table != "" && $where != "") {
			$sql = "DELETE FROM `".$table."`";

			if($where != "") {
				$sql .= " WHERE " . $where;
			}

			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $where not set',2,'class-mysql.php::db_delete');
			return false;
		}
	}
}

?>
