/***************************************************************************
                          knutmessagemanager.cpp  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutmessagemanager.h"
#include <qstring.h>

KNutMessageManager::KNutMessageManager(  QObject *parent, const char *name) : QObject (parent, name) {

  myMess =0;
  myMessLevel = knc::infoLevel;
  }

  

KNutMessageManager::~KNutMessageManager(){

  if (myMess) {
    disconnect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
    disconnect (myMess,SIGNAL(slotOk()),this,SLOT(slotEndMessage()));
    myMess->hide();
    delete myMess;
    }
  }


void KNutMessageManager::deleteMessage (void) {
  if (myMess) {
    disconnect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
    disconnect (myMess,SIGNAL(slotOk()),this,SLOT(slotEndMessage()));
    myMess->hide();
    delete myMess;
    myMess = 0;
    }
  }
  
void KNutMessageManager::addMessage (QString text, knc::LevelOfMessage messageLevel, bool useInfoIcon) {

  if (myMess) {
    if (messageLevel < myMessLevel) return;
    disconnect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
    disconnect (myMess,SIGNAL(slotOk()),this,SLOT(slotEndMessage()));
    myMess->hide();
    delete myMess;
    }

  if (useInfoIcon) myMess = new KNutMessage(text,KNutMessage::infoMess,TimeOfValidity);
  else {   
    switch (messageLevel) {
      case knc::infoLevel:
        myMess = new KNutMessage(text,KNutMessage::infoMess,TimeOfValidity);
        break;
      case knc::lowWarningLevel:
        myMess = new KNutMessage(text,KNutMessage::warningMess,TimeOfValidity);
        break;
      case knc::warningLevel:
        myMess = new KNutMessage(text,KNutMessage::warningMess,TimeOfValidity);
        break;
      case knc::errorLevel:
        myMess = new KNutMessage(text,KNutMessage::criticalMess,TimeOfValidity);
        break;
      case knc::criticalLevel:
        myMess = new KNutMessage(text,KNutMessage::criticalMess,TimeOfValidity);
       break;
      }
    }    
  myMessLevel=messageLevel;
  myMess->show();
  connect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
  connect (myMess,SIGNAL(endMessage()),this,SLOT(slotEndMessage()));
  }

void KNutMessageManager::slotFinishedMessage (void) {

  if (myMess) {
    disconnect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
    disconnect (myMess,SIGNAL(endMessage()),this,SLOT(slotEndMessage()));
    myMess->hide();
    myMess->deleteLater();
    myMess=0;
    }
  }  

void KNutMessageManager::slotEndMessage (void) {

  if (myMess) {
    disconnect (myMess,SIGNAL(finished()),this,SLOT(slotFinishedMessage()));
    disconnect (myMess,SIGNAL(endMessage()),this,SLOT(slotEndMessage()));
    myMess->hide();
    delete myMess;
    myMess=0;
    }
  }


#include "knutmessagemanager.moc"
