/***************************************************************************
                          knutnet.h  -  description
                             -------------------
    begin                : Ne led 12 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTNET_H
#define KNUTNET_H

//Od verze 3 je kapp jen odkaz na kapplication
//#include <kapplication.h>
#include <kapp.h>

#include <qobject.h>
//#include <qstring.h>
//#include <qcstring.h>
#include <qsocket.h>
#include <qsocketdevice.h>

#include <sys/time.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/in.h>


#if defined  (KDE_VERSION_MAJOR)
  #if KDE_VERSION_MAJOR >= 3
    #include <qvaluevector.h>
  #else
    #include <qvaluelist.h>
  #endif
#else
  #include <qvaluelist.h>
#endif


  struct upsVar {
    QString upsVarName;
    bool upsVarActivate;
    bool upsVarType;       // typ true(1) RO -  false (0) RW (muzeme menit)
    bool upsValueType;     // typ true(1) char  - false (0) enum (vyctova)
                           // ma vyznam jen pro RW promenne
    int  upsVarMax;        // udave max delku string promenne nebo pocet moznosti pro enum promennou
                           // ma vyznam jen pro RW promenne
    QString upsValue;     // hodnota promene
    QString upsDescription;  // informace o promene
#if defined  (KDE_VERSION_MAJOR)
  #if KDE_VERSION_MAJOR >= 3
    QValueVector<QString>* upsEnumValues;
  #else
    #include <qvaluelist.h>
    QValueList<QString>* upsEnumValues;
  #endif
#else
  #include <qvaluelist.h>
    QValueList<QString>* upsEnumValues;
#endif
    };


   struct upsIComm {
    QString upsCommName;
    QString upsDescription;
    };

class QString;
class QCString;
            

/**
  *@author Daniel Prynych
  */

/**
 * Tato trida zajistuje cteni dat ze serveru NUT.
 * Od verze 0.5 je uplne prepsana a je zmeneno i API.
 * Od verze 0.6.1 proporuje take client-server protokol a promenne pro upsd >= nut 1.3 
 * Pd verze 0.6.1 nepodporuje jmeno ups ve tvaru jmeno_ups@adresa_pc
 * @author Daniel Prynych
 * @short Komunikace s UPS
 * @version 0.6.2
*/
class KNutNet : public QObject {
   Q_OBJECT
public: 

  enum NetState {NotConnected, ConnectError, Connected };
  // neni pripojeno chyba pri pripojeni,pripojeno

  enum typeOfVar {AllVars, ROVars, RWVars };

  enum NetError {
    NoError,
    LowMem,        // nebyla pridelena pamet
    NullAddress,   // nebyla zadana adresa pocitace
    NoSuchHost,    // neexistuje takovy pocitac
    CantConnect,   // Nemohu se spojit se serverem
    SocketErr,     // Nejde vytvorit socket
    ConnectErr,    // Nejde provest connect
    NutProtocolVarErr, // Nelze zjistit verze protokolu
    NoUpsHere,  // na teto adrese neni zadna UPS
    

    SendErr,       // Nejde provest send
    RecvErr,       // Nejde provest recv  // 10
    SelectErr,     // Nejde provest select
    NoData,        // Nebyla prijmuta zadna data, byl prijmut prazdny retezec
    NoBuffer,      // Nebyl zadan zadny buffer
    UnknownAnswer, // Server neodpovedel spravne
    UnknownFormat, // Data nemaji spravnou strukturu
    UnknownFormatVer, // Data vracena po prikazu VER nemaji spravnou strukturu
    NoServerData,  // Melze precist data ze serveru (Sever neodpovida)
    NoUpsnetOk,    // je nastaven UpsNetOk na false
    UnknownErr,    // neznama chyba - neznamy text za ERR
    CommNotFind,   //prikaz nebyl nalezen v seznamu promenych modulu // 20
    VarNotFind,    // promena nebyla nalezena v seznamu promenych modulu
    EnumValueNotFind, //hodnota vyctove promene nebyla nalezena
                    // tyto zpravy vraci server

    AccessDenied,        // pristup odmitnut
    PasswordRequired,    // pro akci je nutno zaslat heslo
    PasswordIncorrect,   //  nespravane heslo
    UnknownUps,          // tato ups neni na zadane adrese
    AlreadyLoggedIn,     // prihlaseni LOGIN jiz bylo provedeno
    AlreadySetPassword,  // heslo jiz bylo zadano
    DataStale,           // neni mozne ziskat z modulu nove data // 29
    MissingArgument,     // chyby argument
    UnknownType,         // neznamy typ promene
    UnknownCommand,      // nezmamy prikaz pr: poslem treba "UPERNAME admin"
    //tyto chyby se vztahuji k driveru pro danny typ UPS-ky
    DriverNotConnected,    // driver neni pripojen
    NoResponse,          // driver pro ups neodpovedel ve vymezenem case
    UnknownReply,        // neznama odpoved
    NotImplemented,
    CommandFailed,       // chybny prikaz
    VarUnknown,          // promena neni driverem podporovana
    VarNotSupported,     // neni mozno zislat data pro tuto promeno
    InvalidValue,        // nespravna hodnota
    UnknownInstCmd,      // neznamy okamzity prikaz
    CmdNotSupported,     // tento okamzity prikaz neni podporovan
    NotConnection};       // operace nelze provest protoze neni provedeno pripojeni

  enum typeOfStatus {
    OFF = 1,    // - UPS is off (not supplying power)
    OL = 2,     // - UPS is online (supplying power from the line/mains)
    OB = 4,     // - UPS is on battery
    LB = 8,     // - UPS battery is low (with OB = shutdown situation)
    CAL = 16,   // - UPS is performing calibration
    TRIM = 32,  // - UPS is trimming incoming voltage (APC "SmartTrim")
    BOOST = 64, // - UPS is boosting incoming voltage (APC "SmartBoost")
    OVER = 128, // - UPS is overloaded
    RB = 256   // - UPS battery needs to be replaced
    }; 

  enum keyWord {
    NONE,
    OK,
    ERR,
    BEGIN,
    END,
    VAR,
    TYPE,
    DESC,
    UPSDESC,
    CMDDESC,
    UPS,
    LIST,
    RW,
    CMD,
    ENUM,
    STARTTLS,
    BEGIN_LIST_VAR,
    BEGIN_LIST_RW,
    BEGIN_LIST_CMD,
    BEGIN_LIST_UPS,
    BEGIN_LIST_ENUM,
    END_LIST_VAR,
    END_LIST_RW,
    END_LIST_CMD,
    END_LIST_UPS,
    END_LIST_ENUM
    };

  enum flagsVar {
    RW_FLAG = 1,
    ENUM_FLAG = 2,
    STRING_FLAG = 4
    };  

    
    
/**
 * Konstruktor pouze nastavi zakladni promene a struktury, ale necte promene se serveru NUT.
 * Od verze 0.5 NAVAZUJE SPOJENI
 *
 * @param netName Je jmeno ups-ky 
 * @param netAddress Je adresa ups-ky (adresa pocitace na ktry je UPS pripojena)
 * netAddress muze byt zadan jako ip adresa nebo domenove jmeno pocitace
 * pr.: localhost  karel.domena.cz 194.212.25.55.
 * @param netProtocol Je kod protokolu tcp=true udp=false default je true.
 * @param port Je cislo portu na kterem nasloucha NUT server, default je 3493.
 *
 * @since  0.7.3
 **/
  KNutNet (const QString netAddress, const QString netName="", const bool netProtocol=false, const unsigned short port=3493, unsigned int countRepeat =0, const unsigned int delay = 50, QObject *parent=0, const char *name=0);
  
/**
 * @since  0.5
 **/
  ~KNutNet();

/**
 * Vraci kod chyby, ktera nastala pri poslednim volani kterekoliv funkce
 * teto tridy (s vyjimkou getError, getState ),
 * chyba NotConnected neni vracena;
 * To znamena ze chyba NotConnected neni zapamatovana.
 * 
 *
 * @since  0.5
 **/
  int getError ( void );


/**
 * Vraci stav pripojeni.
 *
 * @since  0.5
 **/
  int getState ( void );


/**
 * Vraci stav popisu, zda je nahran;
 *
 * @since  0.5
 **/
  bool isDescription ( void );
  

/**
 * Vraci zda doslo k prepnuti z UDP do TCP;
 * Ma vyznam je pro verzi protokolu 2
 *
 * @since  0.1
 **/
bool switchedToTCP ( void );
  

/**
 * Vraci cislo protokolu pro komunikaci s NUT
 * Od verze NUTu 1.3 je zmenen protokol
 *
 * @since  0.1
 **/
  int getNutProtocol ( void );;

/**
 * Vraci cislo verze nazvu NUT-u
 * Od verze NUTu 1.3 jsou zmeneny nazvy promenych
 *
 * @since  0.1
 **/
  int getNutVariables ( void );

        
  
/**
 * Nacte vsechny promene UPS-ky a nastavi jejich typ (znakove/char, vyctove/enum a status)
 * nastavi priznak aktivity jen pro status.
 * Funkce vraci kod chyby nebo 0 pokud k chybe nedojde;
 * Od verze 0.6 jsou nacteny vzdy i hodnoty promenych
 *
 * @since  0.6.1
 **/
  int getUpsVars ( void);  
  

/**
 * Nacte hodnoty vsech promenych UPS-ky pokud je nastaven jejich priznak aktivity,
 * nebo je nastaven allVars na true.
 * Pozor po provedeni getUpsVars je priznak aktivity nastaven jen pro status.
 *
 * @param allVars Urcuje zda se prikaz tyka vsech promenych, nebo jen tech ktere
 * maji nastaven priznak aktivity na TRUE.
 *
 * @since  0.6.1
 **/
  int getUpsValues (const bool allVars=true );


/**
 * Nacte popisy pro kazdou promennou
 *
 * @param always Urcuje zda se nacteny provede vzdy nebo jen kdy popis jeste
 * nebyl nacten.
 *
 * @since  0.6
 **/
  int getDescription (bool always = false);

  
/**
 * Provede okamzity prikaz.
 * Vraci 0 pokud provedeni skoncilo v poradku jinak kod chyby.
 *
 * @param command Udava nazev prikazu.
 * @param userName Udava uzivatelske jmeno.
 * @param password Udava heslo.
 * @param onlyCommand udava zda ma byt poslan pouze prikaz, nebo i nastaveno uzivatelske jmeno a heslo.
 *        POZOR!! uzivatelske jmeno nejde zmenit bez odpojeni a znovu pripojeni.
 *
 * @since  0.7
 **/
  int instantCommand (const QString command, const QString userName, const QString password, const bool onlyCommand = false);
  

/**
 * Nastavi RW promenou.
 * Vraci 0 pokud provedeni skoncilo v poradku jinak kod chyby;
 *
 * @param variable Udava nazev promenne.
 * @param value Udava hodnotu.
 * @param userName Udava uzivatelske jmeno.
 * @param password Udava heslo.
 * @param onlyVariable udava zda ma byt poslana pouze zadost na zmenu promenne, nebo i nastaveno uzivatelske jmeno a heslo.
 *        POZOR!! uzivatelske jmeno nejde zmenit bez odpojeni a znovu pripojeni.
 *
 * @since  0.7
 **/
  int setVariable (const QString variable, const QString value, const QString userName, const QString password, const bool onlyVariable = false);



/**
 * Vrati pocet promenych UPS-ky.
 * Pri chybe vraci -1.
 *
 * @param typVar Udava typ promene pro ktere zjistujeme pocet
 * muze se jednat o RO promenne RW promene nebo o vsechny promenne.
 *
 * @since  0.6
 **/
  int readNumberVars (typeOfVar typVar = AllVars);


/**
 * Vrati pocet prikazu UPS-ky. Pri chybe vraci -1.
 *
 * @since  0.6
 **/
  int readNumberComms (void);



/**
 * Nastavi strukturu udavajici vsechny hodnoty pro prikaz.
 * Pri chybe vrati kod chyby
 *
 * @param seqNumber Udava cislo promene.
 * @param upsIComm Je struktura.
 *
 * @since  0.6
 **/
  int readIComm (const int seqNumber, struct upsIComm& iComm);


/**
 * Nastavi strukturu obsahujici vsechny udaje promene.
 * Pri chybe vrati kod chyby.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.6
 **/
  int readVars (const QString name, struct upsVar& allVar);


/**
 * Nastavi strukturu obsahujici vsechny udaje promene.
 * Pri chybe vrati kod chyby.
 *
 * @param seqNumber Udava poradove cislo promene, ta zacina VZDY cislem 1.
 * @param typVar Udava typ promene /RO/RW/ALL.
 *
 * @since  0.6
 **/
  int readVars (const int seqNumber, struct upsVar& allVar, const typeOfVar typVar = AllVars);
      

/**
 * Vrati hodnotu promenne.
 * Pri chybe vrati 0l.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.6.1
 **/
  QString readStringVar (const QString name);

/**
 * Nacte jednu z hodnot vyctove promenne.
 * Vraci jednu z hodnot vyctove promenne udanou poradovym cislem hodnoty.
 * Pri chybe vrati 0l.
 *
 * @param name Udava nazev vyctove promenne.
 * @param valueNumber Udava poradove cislo hodnoty vyctove promenne.
 * @param enumValue Je naplnena hodnotou vyctove promenne.
 *
 * @since  0.6.1
 **/
  QString readEnumValueVar (const QString name, const int valueNumber);


/**
 * Vraci kod stavu (statusu) UPS-ky
 * kody je mozne scitat napt OB+LB = 12
 * OFF = 1, UPS-ka je vypnuta
 * OL = 2, UPS-ka bezi na sit
 * OB = 4 UPS-ka bezi na baterie
 * LB = 8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
 * CAL = je spustena kalibrace UPS-ky
 * OVER =128 UPS-ka je pretizena
 * RB = 256 UPS-ka pozaduje vymenu baterie
 *
 * @since  0.5
 **/
int readStatus(void);

  
/**
 * Nastavi priznak aktivity.
 * Pri chybe vrati kod chyby.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.6
 **/
  int setActivate ( const QString name );

/**
 * Zrusi nastaveni priznaku aktivity.
 * Pri chybe vrati kod chyby.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.6
 **/
  int unSetActivate ( const QString name );

/**
 * Zrusi nastaveni priznaku aktivity pro VSECHNY promene.
 * Pri chybe vrati kod chyby.
 *
 * @since  0.6
 **/
  int unSetActivateAll ( void );


  
/**
 * Testuje zda existuje promena danneho jmena.
 * POZOR ZMENA v NAVRATOVYCH HODNOTACH
 * Vraci 0  pokud existuje.
 * Pokud neexistuje nebo pri chybe vrati kod chyby.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.6
 **/
  int existName ( const QString name );

/*********   Konstatnty ****************/


static const int initStatus = OL;

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
/*********   Soukroma cast    **********/

  signals:

  void getVarDesc (int count, int item);

  
  private:

// interni funkce

/**
 * Prevede textovy nazev klice na jeho numerickou hodnotu
 * Jen pro protokol verze 2.
 * Funkce vraci kod klice;
 * param@ line textovy nazev klice.
 *
 * @since  0.1
 **/
int setKey (const QString line);

QString parseValue (const QString line);

/**
 * Parsuje typ promenne (RW ENUM STRING).
 * Jen pro protokol verze 2.
 * Funkce vraci soucet kodu typu promenych;
 * param@ line retezec ktery se parsuje.
 * param@ lenString vraci maximalni delka promenne typu STRING.
 *
 * @since  0.1.1
 **/
int parseTypeValue (QString line, int& lenString );



/**
 * Parsuje navratovou hodnotu z upsd (protokol klient-server).
 * Jen pro protokol verze 2.
 * Funkce vraci kod prikazu (UPS, VAR BEGIN_LIST_VAR );
 *
 * @since  0.1
 **/
int parseLine(QString& line, QString& upsName ,QString& varName, QString& value, int& typeValue, int& lenString);



/**
 * Nacte popisy pro kazdou promennou
 * Jen pro protokol verze 1.
 *
 * @param always Urcuje zda se nacteny provede vzdy nebo jen kdy popis jeste
 * nebyl nacten.
 *
 * @since  0.1
 **/
  int getDescription1 (bool always = false);

/**
 * Nacte popisy pro kazdou promennou
 * Jen pro protokol verze 2.
 *
 * @param always Urcuje zda se nacteny provede vzdy nebo jen kdy popis jeste
 * nebyl nacten.
 *
 * @since  0.1
 **/
  int getDescription2 (bool always = false);



/**
 * internal
 * Nacte nazev prvni UPS-ky na danne adrese.
 * Jen pro protokol verze 2
 * Funkce vraci kod chyby nebo 0 pokud k chybe nedojde;
 *
 * @since  0.1
 **/
int getFirstUpsName (QString& firstUpsName);


/**
 * internal
 * Nacte vsechny promene UPS-ky a nastavi jejich typ (znakove/char, vyctove/enum a status)
 * nastavi priznak aktivity jen pro status.
 * Jen pro protokol verze 2
 * Funkce vraci kod chyby nebo 0 pokud k chybe nedojde;
 *
 * @since  0.1
 **/
  int getUpsVars1 ( void);



/**
 * internal
 * Nacte vsechny promene UPS-ky a nastavi jejich typ (znakove/char, vyctove/enum a status)
 * nastavi priznak aktivity jen pro status.
 * Jen pro protokol verze 2
 * Funkce vraci kod chyby nebo 0 pokud k chybe nedojde;
 *
 * @since  0.1
 **/
  int getUpsVars2 ( void);



/**
 * Nacte hodnoty vsech promenych UPS-ky pokud je nastaven jejich priznak aktivity,
 * nebo je nastaven allVars na true.
 *
 * @param allVars Urcuje zda se prikaz tyka vsech promenych, nebo jen tech ktere
 * maji nastaven priznak aktivity na TRUE.
 * Jen pro protokol verze 1
 *
 * @since  0.6
 **/
  int getUpsValues1 (const bool allVars );

/**
 * Nacte hodnoty vsech promenych UPS-ky pokud je nastaven jejich priznak aktivity,
 * nebo je nastaven allVars na true.
 *
 * @param allVars Urcuje zda se prikaz tyka vsech promenych, nebo jen tech ktere
 * maji nastaven priznak aktivity na TRUE.
 * Jen pro protokol verze 2
 *
 * @since  0.6
 **/
  int getUpsValues2 (const bool allVars );

            

/**
 * @internal
 * Pokusi se o vlastni pripojeni.
 *
 * @param countRepeat maximalni pocet pokusu (ne opakovani !!)
 * @param delay zpozdeni, cas mezi opakovani
 */
  int makeConnect (int countRepeat, const int delay);


/**
 * @internal
 * Zjisti verzi upsd
 *
 * @param countRepeat maximalni pocet pokusu (ne opakovani !!)
 * @param delay zpozdeni, cas mezi opakovani
 */
  int version (int countRepeat, const int delay);
  

/**
 * @internal
 * Nenastavuje promenou error.
 */
  int getUpsData (const QCString sbuffer, QString& rbuffer, const QCString endString=0);

/**
 * @internal
 */
  #if defined  (KDE_VERSION_MAJOR)
    #if KDE_VERSION_MAJOR >= 3
    void setRWVars (const QString varName, const bool valueType, const int varMax, QValueVector<QString>* enumValues);
    #else
    void setRWVars (const QString varName, const bool valueType, const int varMax, QValueList<QString>* enumValues);
    #endif
  #else
    void setRWVars (const QString varName, const bool valueType, const int varMax, QValueList<QString>* enumValues);
  #endif

/**
 * @internal
 */
void upsSetType (struct upsVar& uVar, const QString name, const QString value = "");
  
/**
 * @internal
 */
  int upsTranslateError (const QString string);


/**
 * @internal
 */
  void deleteVars (void);

/**
 * @internal
 */
 int upsOldTranslateError (const QString string);
  

/**
 * @internal
 * Pro qt mensi nez 3.0.0 nemuze byt value const
 */
 void genStatusFlags (QString value);

/**
 * @internal
 * Nenastavuje promenou error.
 */
 int sendComm (const QString command, const QString arg1, const QString arg2, const bool useUpsName=false);
      

/**
 * @internal
 */
  int activate ( const QString name, const bool setActivate );


/**
 * @internal
 */
  int activateAll ( const bool setActivate );
  

/**
 * @internal
 */
  int newDescription (const QCString  inBuffer, QString& upsDescription);

                  
  /******* KONSTANTY **********/
  static const int upsGetTimeout1 = 2; // doba cekani na navrat paketu
  static const int upsGetTimeout2 = 1; // doba cekani na navrat paketu pro druhy test - jen UDP
  static const int upsGetTimeout3 = 1; // doba cekani na navrat paketu pro docitani


  /****** PROMENE *************/
  NetState state;
  int error;

  bool protocol;
  int socAddr;

  int nutProtocol;  // 1 for NUT <1.3,  2 for NUT => 1.3
  int nutVariables; // 1 for NUT <1.3,  2 for NUT => 1.3

  struct sockaddr_in upsAddrClient;
  struct sockaddr_in upsAddrServer;

  QString upsAddress;
  QString upsName;


  int numberVars; // pocet vsech promennych
  int numberRWVars;
  int numberIComms;

  int upsStatusVar;
  bool description;

  bool switchToTCP;
  
 // QMutex je v QT az od verze 3.x.x pro to ho zatim nepouzijeme
 // QMutex netMutex; // mutex pro synchronizaci cteni hodnot promenych;
  bool netMutex;


#if defined  (KDE_VERSION_MAJOR)
  #if KDE_VERSION_MAJOR >= 3
    QValueVector<upsVar> listVars;
    QValueVector<upsIComm> listIComms;
  #else
    QValueList<upsVar> listVars;
    QValueList<upsIComm> listIComms;
  #endif
#else
  QValueList<upsVar> listVars;
  QValueList<upsIComm> listIComms;
#endif

/********* Pomocne promenne ***********/
int posChar;
   
};

#endif

