/***************************************************************************
                          knutpanelmeter.h  -  description
                             -------------------
    begin                : t b?e 16 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPANELMETER_H
#define KNUTPANELMETER_H

#include "kanalog.h"
#include "knutvardata.h"

//#include <qwidget.h>
#include <qscrollview.h>
//#include <qlabel.h>
//#include <qfont.h>


    struct analogPanelsRecord {
    int scaleEnd[knc::NumberOfVars];
    int scaleStart[knc::NumberOfVars];
    KAnalog* upsAnalogs[knc::NumberOfVars];
    };

class QLabel;
class QFont;

/**
  *@author Daniel Prynych
  */
class KNutPanelMeter : public QScrollView  {
   Q_OBJECT
public:
   
/**
 * Konstruktor
 *
 * Param taPanelPalette je paleta pozadi subpanelu MERAKU !!!
 * @param tActiveUpsInfo ukazatel na data o aktivni UPS
 * @param tSettingData ukazatel na zakladni data programu (barvy pozadi, mezikruzi, rucicky ... ,fonty atd )
 * @param tAnalogRecords ukazatel na tridu ktera pracuje s daty o upsekach
 *
 * @since  0.2
 **/
  KNutPanelMeter(QPalette taPanelPalette, struct upsInfo* tActiveUpsInfo,SettingDataDef* tSettingData, KNutVarData* tAnalogRecords, QWidget *parent=0, const char *name=0);

/**
 * Destruktor
 *
 * @since  0.1
 **/
  ~KNutPanelMeter();

/**
 * Zrusi analogove panely vcetne uvoneni pameti.
 *
 * @since  0.1
 **/
  void deActivateAnalogs (void);


/**
 * Vytvori a inicializuje analogove panely.
 *
 * @since  0.1
 **/
  void activateAnalogs (void);

/**
 * Rozmisti analogove panely po hlavnim panelu a spocte jeho rozmery.
 *
 * @param showPanels je true jsou rozsviceny (show) subpanely
 * @since  0.2
 **/
  void setSize (bool showPanels = false);


/**
 * Prekresli zmenu rozsahu pro dany analogovy panel (jenom jeden)
 * Pokud panel nepodporuje zmeny rozsahu neprovede nic.
 * Zmenu rozsahu podporuji nasledujici panely: Current,BattVolt,BattCurrent
 *
 * @param panelNumber je cislo analogoveho panelu.
 * @param val je hodnota na kterou je panel nastaven.
 *
 * @since  0.1
 **/
  void repaintScaleAnalogPanel (int panelNumber, float value);

/**
 * Prekresli rucicku pro dany analogovy panel.
 *
 * @param panelNumber je cislo analogoveho panelu.
 * @param val je hodnota na kterou je panel nastaven.
 *
 * @since  0.1
 **/
  void repaintAnalogFinger (int panelNumber, float value);


/**
 * Prekresli a prebarvi analogove panely.
 * Podle nastaveni prekresuje rozsah panelu pro frequency a nepeti na zakldade soucasneho nastaveni.
 *
 * @param repaintFrequencyPanels urcuje ze ma prekreslit panely ktere zobrazuji vstupni frequency.
 * @param repaintVoltagePanels urcuje ze ma prekreslit panely ktere zobrazuji vstupni a vystupni napeti.
 * @param repaintAllPanels urcuje ze ma prebarvit vsechny prvky panelu.
 *
 * @since  0.1
 **/
  void repaintAnalogPanels (bool repaintFrequencyPanels, bool repaintVoltagePanels, bool repaintAllPanels);

/**
  * Nastavi hodnotu vsech panelu na nulu
 *
 * @since  0.1
 **/
   void zeroingPanels (void);

/**
 * Prebarvi pozadi analogovych panelu.
 *
 * @param taPanelPalette je hodnota nove palety pro pozadi
 *
 * @since  0.1
 **/
  void setAnalogBG(QPalette taPanelPalette);

  

/**
 * Vraci soucasnou velikost panelu.
 *
 * @since  0.1
 **/
  virtual QSize sizeHint (void);

public slots:
  
  /**
   * Nastavy novy font ve vsech panelech.
   *
   * @since  0.1
   **/
  void slotSetPanelsFont(QFont newFont);

  
private:
/************ private const *****************/

  static const int SpacePanels = 2; // vzdalenost mezi meraky

  static const int MaxBattVolt = 80;
  static const int MaxCurrent = 25;
  static const int MaxBattCurrent = 30;
/*********** private vars *******************/  

  QLabel* analogArea;

  struct analogPanelsRecord* analogPanels;
  
  struct upsInfo* activeUpsInfo; // hodnoty pro vybrane ups
  SettingDataDef* settingData;  // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci

  KNutVarData* analogRecords;

  QPalette aPanelPalette;

  int widthArea;
  int heightArea;
};

#endif
