/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kapp.h>
#include <kuniqueapplication.h> 

#include "knutclient.h"

#include <stdio.h>
#include <stdlib.h>

static const char *description =
  I18N_NOOP("Client for Network UPS Tool");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] =
{
  {"nodock",I18N_NOOP("Don't dock in Kicker"),0},
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};



int main(int argc, char *argv[])
{

  KAboutData aboutData( "knutclient", I18N_NOOP("KNutClient"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2002, 2003, 2004, Daniel Prynych", "Zajecov, Czech Republic", 0, "Daniel.Prynych@alo.cz");
  aboutData.addAuthor("Daniel Prynych",0, "Daniel.Prynych@alo.cz","http://www.alo.cz/knutclient");
  aboutData.addCredit("Russell Kroll",0,"rkroll@exploits.org","http://www.exploits.org/nut/");
  aboutData.addCredit("Arnaud Quette",0,"arnaud.quette@free.fr",0);
  aboutData.addCredit("MGE",0,0,"http://opensource.mgeups.com");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KUniqueApplication::addCmdLineOptions();

  KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
  bool noDock = args->isSet("dock");
  args->clear();

  if (!KUniqueApplication::start()) {
    fprintf(stderr,"Sorry : KNutClient is already running!");
    exit(0);
    }
  KUniqueApplication a;

//  next line is for testing only.
//  I don't debug KUniqueApplication 

////  KApplication a;

  KNutClient *knutclient = new KNutClient(!noDock);
  int returnCode = a.exec();
  delete knutclient;
  return returnCode;
}
