/*  @(#) kparser.h 1.9 @(#)  */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Parser
\***************************************************************/

#ifndef _KOALAMUD_PARSER_H
#define _KOALAMUD_PARSER_H "@(#) nitehawk@winghove.1ststep.net|include/kparser.h|20001105044148|05136 @(#)"

#include "koalatypes.h"
#include "module.h"

/* Command structures */
/* Arguments */
typedef struct TAG_ARGUMENT {
	enum {
		ARG_INT,
		ARG_CHAR,
		ARG_DOUBLE,
		ARG_WORD,	/* These three are different */
		ARG_STRING,	/* types of the same */
		ARG_LINE,	/* actual type. */
		ARG_NODEID,
	} argtype;
	union {
		int argint;
	} argdata;
	int strlen;
} argument;

/* Command Pointers */
typedef koalaerror (*commandptr)(pdescriptor player, argument *arglist[]);

/* Keys */
typedef struct TAG_KEY {
	struct TAG_KEY *parent, *child, *next;
	char *keyname;
	int keyid;
} key;

/* Command Entry */
typedef struct TAG_COMMANDENTRY {
	struct TAG_COMMANDENTRY *next;
	char *command;
	commandptr	handler;
	enum {	/* This is partially for sorting in 'commands' */
		CMD_GENERIC,	/* and partially for default handler and/or hooks */
		CMD_SOCIAL,
		CMD_COMM,
		CMD_MODULE,
	} commandtype;
	unsigned numargs;	/* Used to set the bounds of the argument list */
	argument *arglist;
	key *unlock;	/* Null key means anyone can use the command */
	dynmod_t *owner;
} commandentry;
typedef commandentry *pcommandentry;

extern pcommandentry ctablehead;

koalaerror commandparser(pdescriptor desc);
pcommandentry clsearch(char *word, bool matchabbrev);
pcommandentry clsearchnorm(char *word);
pcommandentry clsearchabbrev(char *word);
koalaerror registercommand(pcommandentry cmd, dynmod_t *owner);

#endif
