/* @(#) login.c 1.10 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDLOGIN_C "@(#) nitehawk@winghove.1ststep.net|lib/basecommand/login.c|20001105033117|01657 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "memory.h"

/* This function is the first stage of login */
koalaerror clientgetname(pdescriptor desc)
{
	char name[35] = "\0";
	char outbuf[200];
	koalaerror readerr;

	/* Read the first 30 chars from the buffer, then flush the rest */
	readerr = buffer_readline(desc, name, 30);
	if (readerr == KENOTENOUGH)
	{
		return KENOTENOUGH;
	}
	if (readerr == KENOMEM)
	{
		buffer_flushline(desc);
	}

	/* Allocate memory for the player name */
	desc->data.character->name = kmalloc(strlen(name)+1, ALLOC_DESCRIPTOR);
	bzero(desc->data.character->name, strlen(name)+1);

	/* Copy the player name into the descriptor structure */
	strncpy(desc->data.character->name, name, strlen(name));

	/* Set the state to playing */
	desc->data.character->state = STATE_PLAYING;

	/* Reply to confirm the login name and say how to quit */
	snprintf(outbuf, 200,
		"Hello, %s!\r\n"
		"Koala is in early stages of development.  To exit the game, type"
		" 'quit'\r\n", desc->data.character->name);
	buffer_queue(desc, outbuf, strlen(outbuf));

	snprintf(outbuf, 200,
		"Currently implemented: 'say', 'who', 'quit'\r\n");
	buffer_queue(desc, outbuf, strlen(outbuf));

	return KESUCCESS;
}
