/* @(#) memory.c 1.13 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_MEMORY_C "@(#) nitehawk@winghove.1ststep.net|lib/koala/memory.c|20001105061116|24691 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"
#include "memory.h"
#include "llist.h"
#include "network.h"

listnodeptr masterdescriptorlist = NULL;
listnodeptr freedescriptorlist = NULL;
memstate_t memstate[ALLOC_LISTEND];

listnodeptr getdescriptorlist(void)
{
	pdescriptor dummydesc = NULL;

	if (masterdescriptorlist)
		return masterdescriptorlist;

	/* Create descriptor for use as list head of new list */
	if ((dummydesc = allocdescriptor()) == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for master descriptor list");
		return NULL;
	}

	dummydesc->type = DESCRIPTOR_DUMMY;

	masterdescriptorlist = listcreate(dummydesc);

	if (masterdescriptorlist == NULL)
	{
		free(dummydesc);
	}

	return masterdescriptorlist;
}

/* (re)Allocate and null out new descriptor */
pdescriptor allocdescriptor(void)
{
	pdescriptor desc = NULL;

	/* Check to see if the free list is allocated */
	if (freedescriptorlist != NULL)
	{
		/* Since we have a list of free descriptors, we will try to allocate
		 * the descriptor from the free list
		 */
		desc = freedescriptorlist->data.desc;
		if (desc != NULL)
		{
			listremovenode(freedescriptorlist, desc);
		}
	} 

	if (desc == NULL)
	{
		/* Guess there were no free nodes */
		desc = (pdescriptor)kmalloc(sizeof(descriptor), ALLOC_DESCRIPTOR);
		if (desc == NULL)
		{
			logmsg(LOGCRIT, "Error allocating memory for new descriptor");
			return NULL;
		}
	}

	/* Zero out allocated memory */
	bzero(desc, sizeof(descriptor));

	return desc;
}

/* Free an allocated descriptor (add the descriptor to the free list) */
void freedescriptor(pdescriptor desc)
{
	/* Allocate the list if it hasn't been allocated */
	if (freedescriptorlist == NULL)
	{
		freedescriptorlist = listcreate(desc);
	}
	/* Add the node to the list otherwise */
	else
	{
		listaddnode(freedescriptorlist, desc);
	}
}

/* kmalloc - Wrapper around malloc to do size tracking */
KPRODINLINE void *kmalloc(size_t len, kmalloctype type)
{
	void *mem;
	if ((mem = malloc(len)) == NULL)
	{
		return NULL;
	}

	memstate[type].allocsize += len;
	memstate[type].numobjects++;
	return mem;
}

/* kmfree - Wrapper around free to do size tracking */
KPRODINLINE void kmfree(void *ptr, kmalloctype type)
{
	size_t freed;
	freed = memstate[type].allocsize / memstate[type].numobjects--;
	memstate[type].allocsize -= freed;
	if (memstate[type].numobjects == 0)
	{
		memstate[type].allocsize = 0;
	}
	free(ptr);
}

/* krealloc - Wrapper around realloc to do memory tracking */
KPRODINLINE void *krealloc(void *ptr, size_t len, kmalloctype type)
{
	void *mem;
	size_t freed;
	freed = memstate[type].allocsize / memstate[type].numobjects--;
	memstate[type].allocsize -= freed;
	if (memstate[type].numobjects == 0)
	{
		memstate[type].allocsize = 0;
	}

	if ((mem = realloc(ptr, len)) == NULL)
	{
		return NULL;
	}

	memstate[type].allocsize += len;
	memstate[type].numobjects++;
	return mem;
}

/* Init memory state tracking - Automatically called before main */
void initmemstate(void)
{
	int i = 0;

	for (;i< ALLOC_LISTEND; i++)
	{
		memstate[i].allocsize = 0;
		memstate[i].numobjects = 0;
	}
}
