h05521
s 00011/00001/00182
d D 1.8 00/09/10 19:32:14 nitehawk 9 8
c Log a module start command
cC
cK09574
e
s 00002/00002/00181
d D 1.7 00/08/20 21:59:56 nitehawk 8 7
c update mod_db function with new prototype
cC
cK44409
e
s 00013/00002/00170
d D 1.6 00/08/07 20:27:36 nitehawk 7 6
c Make initial preparations for dynamic loader version
cC
cK43960
e
s 00005/00000/00167
d D 1.5 00/08/01 20:26:51 nitehawk 6 5
c add mod_db function for module
cC
cHlocalhost.1ststep.net
cK30351
cZ-07:00
e
s 00013/00000/00154
d D 1.4 00/03/13 23:02:25 nitehawk 5 4
c Move list of backend modules to db.c
cC
cK26724
e
s 00003/00063/00151
d D 1.3 00/03/12 21:47:27 nitehawk 4 3
c Use module list functions in moduleops.c for backend state changes
cC
cK03903
e
s 00137/00015/00077
d D 1.2 00/03/12 09:34:36 nitehawk 3 2
c Loop through list of db modules instead of manually calling them
cC
cK12254
e
s 00092/00000/00000
d D 1.1 00/03/08 15:47:30 nitehawk 2 1
cF1
cK58587
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/08 15:47:30 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/vm/db.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK07182
cPlib/vm/db.c
cRc8082cb6487377f9
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DB_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

I 7
#include <dlfcn.h>

E 7
#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"
I 3
#include "dbback.h"

/* Using this split db API allows us to use our own disk database or linkup
 * with a SQL database and simply query the database server.  At this point,
 * it is unclear which method will result in the fastest setup, but it is
 * guessed that using a SQL server such as Sybase or Oracle on a second
 * machine will be faster then writing our own database code.  Using an
 * external SQL server does however have disadvantages, in that it is not so
 * easy to maintain backups of the database.  I suppose it is possible to use
 * facilities provided by sybase to have the database server do disk backups
 * and then use something like ssh to remove older backups as they age.
 */
E 3

/* This file contains the API interface to the koala db driver
 * 	-	These functions should not be called from outside the VM driver
 */

/* Global variables */

D 3
/* Module state */
modstate_t dbmodstate = MODSTATE_UNDEFINED;
E 3
I 3
/* Module data */
module_t dbmodule =
{
	"DB",
	"%Z% %M% %I% %Z%",
	MODSTATE_UNDEFINED,
	dbstartup,
	dblinkup,
	dbshutdown
};
E 3

I 5
/* DB Backends list.  Define this here to allow dbback to have multiple
 * includes */
pmodule dbbackends[] =
{
#if KOALADB_MYSQL_ENABLE
	&dbmysqlmodule,
#endif
#if KOALADB_KOALA_ENABLE
	&dbkoalamodule,
#endif
	&vmnullmodule,		/* We must have this to terminate the list */
};

E 5
/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */
I 9

/* mod_db is the module entry point for the full database module.  It is
 * responsible for starting up the database code and linking up to the running
 * binary.  It is also responsible for scanning its configuration and
 * determining which database drivers to load.
 */
E 9
I 6
D 7
int mod_db(void)
E 7
I 7
D 8
int mod_db(initfunc init)
E 8
I 8
int mod_db(moduleinfo_t *pinf)
E 8
E 7
{
I 9
	char modname[] = "mod_db";

E 9
D 7
	return dbstartup();
E 7
I 7
D 8
	if (init == NULL)
E 8
I 8
	if (pinf == NULL)
E 8
	{
D 9
		printf("DEBUG: BAD MODULE LOAD!!\r\n", dlerror());
E 9
I 9
		printf("DEBUG: BAD MODULE LOAD!!\r\n");
E 9
		return VMBADSTATE;
	}
I 9

	pinf->pfunc->logmsg(LOGINFO, "Loading Database Module");
E 9

	return 0;
	//return dbstartup();
E 7
}

E 6
D 3
vmerr_t dbstartup(void)
E 3
I 3
int dbstartup(void)
E 3
{
I 7
	
	//dbglog("Loading database drivers");
E 7
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
D 3
	if (dbmodstate != MODSTATE_UNDEFINED ||
			dbmodstate != MODSTATE_STOPPED)
E 3
I 3
	if (!(dbmodule.state == MODSTATE_UNDEFINED ||
			dbmodule.state == MODSTATE_STOPPED))
E 3
		return VMBADSTATE;
	/* Reflect that we are starting up */
D 3
	dbmodstate = MODSTATE_STARTUPINPROGRESS;
E 3
I 3
	dbmodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Startup individual DB backends */
	{
D 4
		/* Loop though the list of backends */
		pmodule cur;
E 4
		int numattempted = 0;
		int errors = 0;

D 4
		cur = dbbackends[0];

		while (cur->name != NULL)
		{
			numattempted++;
			if (cur->startupfn())
			{
				char buf[80];
				snprintf(buf, 80, "Error starting %s backend version %s.",
						cur->name, cur->version);
				logerr(buf);
				errors++;

				/* having a backend fail startup is only a problem if all the
				 * backends fail
				 */
			}
			cur++;
		}
E 4
I 4
		modstartup(dbbackends, &vmnullmodule, &numattempted, &errors);
E 4

		/* Check to make sure at least one backend started */
		if (errors >= numattempted)
		{
			logerr("Unable to start any database backends");
		}
	}
E 3

	/* All done with startup */
D 3
	dbmodstate = MODSTATE_STARTED;
E 3
I 3
	dbmodule.state = MODSTATE_STARTED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
D 3
vmerr_t dblinkup(void)
E 3
I 3
int dblinkup(void)
E 3
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
D 3
	if (dbmodstate != MODSTATE_STARTED)
E 3
I 3
	if (dbmodule.state != MODSTATE_STARTED)
E 3
		return VMBADSTATE;
	/* show that we are doing linkup */
D 3
	dbmodstate = MODSTATE_LINKUPINPROGRESS;
E 3
I 3
	dbmodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Linkup individual DB backends */
	{
D 4
		/* Loop though the list of backends */
		pmodule cur;
E 4
		int numattempted = 0;
		int errors = 0;

D 4
		cur = dbbackends[0];

		while (cur->name != NULL)
		{
			numattempted++;
			if (cur->linkupfn())
			{
				char buf[80];
				snprintf(buf, 80, "Error linking %s backend version %s.",
						cur->name, cur->version);
				logerr(buf);
				errors++;

				/* having a backend fail linking is only a problem if all the
				 * backends fail
				 */
			}
			cur++;
		}
E 4
I 4
		modlinkup(dbbackends, &vmnullmodule, &numattempted, &errors);
E 4

		/* Check to make sure at least one backend linked */
		if (errors >= numattempted)
		{
			logerr("Unable to link any database backends");
		}
	}
E 3

	/* Linkup complete */
D 3
	dbmodstate = MODSTATE_LINKED;
E 3
I 3
	dbmodule.state = MODSTATE_LINKED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
D 3
vmerr_t dbshutdown(void)
E 3
I 3
int dbshutdown(void)
E 3
{
	/* Can't shutdown unless we are currently 'linked' */
D 3
	if (dbmodstate != MODSTATE_LINKED)
E 3
I 3
	if (dbmodule.state != MODSTATE_LINKED)
E 3
		return VMBADSTATE;
	/* show that we are doing shutdown */
D 3
	dbmodstate = MODSTATE_SHUTDOWNINPROGRESS;
E 3
I 3
	dbmodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* Shutdown individual DB backends */
	{
D 4
		/* Loop though the list of backends */
		pmodule cur;
E 4
		int numattempted = 0;
		int errors = 0;

D 4
		cur = dbbackends[0];

		while (cur->name != NULL)
		{
			numattempted++;
			if (cur->shutdownfn())
			{
				char buf[80];
				snprintf(buf, 80, "Error shutting down %s backend version %s.",
						cur->name, cur->version);
				logerr(buf);
				errors++;

				/* having a backend fail linking is only a problem if all the
				 * backends fail
				 */
			}
			cur++;
		}
E 4
I 4
		modshutdown(dbbackends, &vmnullmodule, &numattempted, &errors);
E 4

		/* Check to make sure at least one backend linked */
		if (errors >= numattempted)
		{
			logerr("Unable to shutdown any database backends");
		}
	}
E 3

	/* shutdown complete */
D 3
	dbmodstate = MODSTATE_STOPPED;
E 3
I 3
	dbmodule.state = MODSTATE_STOPPED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}
E 2
I 1
E 1
