/* @(#) db.c 1.8 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DB_C "@(#) nitehawk@localhost.1ststep.net|lib/vm/db.c|20000911023214|09574 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include <dlfcn.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"
#include "dbback.h"

/* Using this split db API allows us to use our own disk database or linkup
 * with a SQL database and simply query the database server.  At this point,
 * it is unclear which method will result in the fastest setup, but it is
 * guessed that using a SQL server such as Sybase or Oracle on a second
 * machine will be faster then writing our own database code.  Using an
 * external SQL server does however have disadvantages, in that it is not so
 * easy to maintain backups of the database.  I suppose it is possible to use
 * facilities provided by sybase to have the database server do disk backups
 * and then use something like ssh to remove older backups as they age.
 */

/* This file contains the API interface to the koala db driver
 * 	-	These functions should not be called from outside the VM driver
 */

/* Global variables */

/* Module data */
module_t dbmodule =
{
	"DB",
	"@(#) db.c 1.8 @(#)",
	MODSTATE_UNDEFINED,
	dbstartup,
	dblinkup,
	dbshutdown
};

/* DB Backends list.  Define this here to allow dbback to have multiple
 * includes */
pmodule dbbackends[] =
{
#if KOALADB_MYSQL_ENABLE
	&dbmysqlmodule,
#endif
#if KOALADB_KOALA_ENABLE
	&dbkoalamodule,
#endif
	&vmnullmodule,		/* We must have this to terminate the list */
};

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */

/* mod_db is the module entry point for the full database module.  It is
 * responsible for starting up the database code and linking up to the running
 * binary.  It is also responsible for scanning its configuration and
 * determining which database drivers to load.
 */
int mod_db(moduleinfo_t *pinf)
{
	char modname[] = "mod_db";

	if (pinf == NULL)
	{
		printf("DEBUG: BAD MODULE LOAD!!\r\n");
		return VMBADSTATE;
	}

	pinf->pfunc->logmsg(LOGINFO, "Loading Database Module");

	return 0;
	//return dbstartup();
}

int dbstartup(void)
{
	
	//dbglog("Loading database drivers");
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
	if (!(dbmodule.state == MODSTATE_UNDEFINED ||
			dbmodule.state == MODSTATE_STOPPED))
		return VMBADSTATE;
	/* Reflect that we are starting up */
	dbmodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Startup individual DB backends */
	{
		int numattempted = 0;
		int errors = 0;

		modstartup(dbbackends, &vmnullmodule, &numattempted, &errors);

		/* Check to make sure at least one backend started */
		if (errors >= numattempted)
		{
			logerr("Unable to start any database backends");
		}
	}

	/* All done with startup */
	dbmodule.state = MODSTATE_STARTED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
int dblinkup(void)
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
	if (dbmodule.state != MODSTATE_STARTED)
		return VMBADSTATE;
	/* show that we are doing linkup */
	dbmodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Linkup individual DB backends */
	{
		int numattempted = 0;
		int errors = 0;

		modlinkup(dbbackends, &vmnullmodule, &numattempted, &errors);

		/* Check to make sure at least one backend linked */
		if (errors >= numattempted)
		{
			logerr("Unable to link any database backends");
		}
	}

	/* Linkup complete */
	dbmodule.state = MODSTATE_LINKED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
int dbshutdown(void)
{
	/* Can't shutdown unless we are currently 'linked' */
	if (dbmodule.state != MODSTATE_LINKED)
		return VMBADSTATE;
	/* show that we are doing shutdown */
	dbmodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* Shutdown individual DB backends */
	{
		int numattempted = 0;
		int errors = 0;

		modshutdown(dbbackends, &vmnullmodule, &numattempted, &errors);

		/* Check to make sure at least one backend linked */
		if (errors >= numattempted)
		{
			logerr("Unable to shutdown any database backends");
		}
	}

	/* shutdown complete */
	dbmodule.state = MODSTATE_STOPPED;

	/* Everything Happy :) */
	return VMSUCCESS;
}
