/*
 *  Copyright (C) 2005-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#pragma once

// clang-format off
#define PLAYER_HAS_MEDIA              1
#define PLAYER_HAS_AUDIO              2
#define PLAYER_HAS_VIDEO              3
#define PLAYER_PLAYING                4
#define PLAYER_PAUSED                 5
#define PLAYER_REWINDING              6
#define PLAYER_REWINDING_2x           7
#define PLAYER_REWINDING_4x           8
#define PLAYER_REWINDING_8x           9
#define PLAYER_REWINDING_16x         10
#define PLAYER_REWINDING_32x         11
#define PLAYER_FORWARDING            12
#define PLAYER_FORWARDING_2x         13
#define PLAYER_FORWARDING_4x         14
#define PLAYER_FORWARDING_8x         15
#define PLAYER_FORWARDING_16x        16
#define PLAYER_FORWARDING_32x        17
#define PLAYER_CACHING               20
// unused id 21
#define PLAYER_PROGRESS              22
#define PLAYER_SEEKBAR               23
#define PLAYER_SEEKTIME              24
#define PLAYER_SEEKING               25
#define PLAYER_SHOWTIME              26
#define PLAYER_TIME                  27
#define PLAYER_TIME_REMAINING        28
#define PLAYER_DURATION              29
#define PLAYER_HASPERFORMEDSEEK      30
#define PLAYER_SHOWINFO              31
#define PLAYER_VOLUME                32
#define PLAYER_MUTED                 33
#define PLAYER_HASDURATION           34
#define PLAYER_CHAPTER               35
#define PLAYER_CHAPTERCOUNT          36
#define PLAYER_TIME_SPEED            37
#define PLAYER_FINISH_TIME           38
#define PLAYER_CACHELEVEL            39
#define PLAYER_CHAPTERNAME           41
#define PLAYER_SUBTITLE_DELAY        42
#define PLAYER_AUDIO_DELAY           43
#define PLAYER_PASSTHROUGH           44
// unused 45
// unused 46
#define PLAYER_SEEKOFFSET            47
#define PLAYER_PROGRESS_CACHE        48
#define PLAYER_ITEM_ART              49
#define PLAYER_CAN_PAUSE             50
#define PLAYER_CAN_SEEK              51
#define PLAYER_START_TIME            52
// unused 53
#define PLAYER_ISINTERNETSTREAM      54
// unused 55
#define PLAYER_SEEKSTEPSIZE          56
#define PLAYER_IS_CHANNEL_PREVIEW_ACTIVE  57
#define PLAYER_SUPPORTS_TEMPO        58
#define PLAYER_IS_TEMPO              59
#define PLAYER_PLAYSPEED             60
#define PLAYER_SEEKNUMERIC           61
#define PLAYER_HAS_GAME              62
#define PLAYER_HAS_PROGRAMS          63
#define PLAYER_HAS_RESOLUTIONS       64
#define PLAYER_FRAMEADVANCE          65
#define PLAYER_ICON                  66
#define PLAYER_CUTLIST               67
#define PLAYER_CHAPTERS              68
#define PLAYER_EDITLIST 69
#define PLAYER_CUTS 70
#define PLAYER_SCENE_MARKERS 71
#define PLAYER_HAS_SCENE_MARKERS 72
// Keep player infolabels that work with offset and position together
#define PLAYER_PATH                  81
#define PLAYER_FILEPATH              82
#define PLAYER_TITLE                 83
#define PLAYER_FILENAME              84

// Range of player infolabels that work with offset and position
#define PLAYER_OFFSET_POSITION_FIRST PLAYER_PATH
#define PLAYER_OFFSET_POSITION_LAST PLAYER_FILENAME

#define WEATHER_CONDITIONS_TEXT     100
#define WEATHER_TEMPERATURE         101
#define WEATHER_LOCATION            102
#define WEATHER_IS_FETCHED          103
#define WEATHER_FANART_CODE         104
#define WEATHER_PLUGIN              105
#define WEATHER_CONDITIONS_ICON     106

#define SYSTEM_TEMPERATURE_UNITS    107
#define SYSTEM_PROGRESS_BAR         108
#define SYSTEM_LANGUAGE             109
#define SYSTEM_TIME                 110
#define SYSTEM_DATE                 111
#define SYSTEM_CPU_TEMPERATURE      112
#define SYSTEM_GPU_TEMPERATURE      113
#define SYSTEM_FAN_SPEED            114
#define SYSTEM_FREE_SPACE_C         115
// #define SYSTEM_FREE_SPACE_D         116 //116 is reserved for space on D
#define SYSTEM_FREE_SPACE_E         117
#define SYSTEM_FREE_SPACE_F         118
#define SYSTEM_FREE_SPACE_G         119
#define SYSTEM_BUILD_VERSION        120
#define SYSTEM_BUILD_DATE           121
#define SYSTEM_ETHERNET_LINK_ACTIVE 122
#define SYSTEM_FPS                  123
#define SYSTEM_ALWAYS_TRUE          125   // useful for <visible fade="10" start="hidden">true</visible>, to fade in a control
#define SYSTEM_ALWAYS_FALSE         126   // used for <visible fade="10">false</visible>, to fade out a control (ie not particularly useful!)
#define SYSTEM_MEDIA_DVD            127
#define SYSTEM_DVDREADY             128
#define SYSTEM_HAS_ALARM            129
#define SYSTEM_SUPPORTS_CPU_USAGE   130
#define SYSTEM_SCREEN_MODE          132
#define SYSTEM_SCREEN_WIDTH         133
#define SYSTEM_SCREEN_HEIGHT        134
#define SYSTEM_CURRENT_WINDOW       135
#define SYSTEM_CURRENT_CONTROL      136
#define SYSTEM_CURRENT_CONTROL_ID   137
#define SYSTEM_DVD_LABEL            138
#define SYSTEM_HASLOCKS             140
#define SYSTEM_ISMASTER             141
#define SYSTEM_TRAYOPEN             142
#define SYSTEM_SHOW_EXIT_BUTTON     143
#define SYSTEM_ALARM_POS            144
#define SYSTEM_LOGGEDON             145
#define SYSTEM_PROFILENAME          146
#define SYSTEM_PROFILETHUMB         147
#define SYSTEM_HAS_LOGINSCREEN      148
#define SYSTEM_HAS_ACTIVE_MODAL_DIALOG  149
#define SYSTEM_HDD_SMART            150
#define SYSTEM_HDD_TEMPERATURE      151
#define SYSTEM_HDD_MODEL            152
#define SYSTEM_HDD_SERIAL           153
#define SYSTEM_HDD_FIRMWARE         154
#define SYSTEM_HAS_VISIBLE_MODAL_DIALOG  155
#define SYSTEM_HDD_PASSWORD         156
#define SYSTEM_HDD_LOCKSTATE        157
#define SYSTEM_HDD_LOCKKEY          158
#define SYSTEM_INTERNET_STATE       159
#define SYSTEM_HAS_INPUT_HIDDEN     160
#define SYSTEM_HAS_PVR_ADDON        161
#define SYSTEM_ALARM_LESS_OR_EQUAL  180
#define SYSTEM_PROFILECOUNT         181
#define SYSTEM_ISFULLSCREEN         182
#define SYSTEM_ISSTANDALONE         183
#define SYSTEM_IDLE_SHUTDOWN_INHIBITED 184
#define SYSTEM_HAS_SHUTDOWN         185
#define SYSTEM_HAS_PVR              186
#define SYSTEM_STARTUP_WINDOW       187
#define SYSTEM_STEREOSCOPIC_MODE    188
#define SYSTEM_BUILD_VERSION_SHORT  189

#define NETWORK_IP_ADDRESS          190
#define NETWORK_MAC_ADDRESS         191
#define NETWORK_IS_DHCP             192
#define NETWORK_LINK_STATE          193
#define NETWORK_SUBNET_MASK         194
#define NETWORK_GATEWAY_ADDRESS     195
#define NETWORK_DNS1_ADDRESS        196
#define NETWORK_DNS2_ADDRESS        197
#define NETWORK_DHCP_ADDRESS        198

// Keep musicplayer infolabels that work with offset and position together
#define MUSICPLAYER_TITLE           200
#define MUSICPLAYER_ALBUM           201
#define MUSICPLAYER_ARTIST          202
#define MUSICPLAYER_GENRE           203
#define MUSICPLAYER_YEAR            204
#define MUSICPLAYER_DURATION        205
#define MUSICPLAYER_TRACK_NUMBER    208
#define MUSICPLAYER_COVER           210
#define MUSICPLAYER_BITRATE         211
#define MUSICPLAYER_PLAYLISTLEN     212
#define MUSICPLAYER_PLAYLISTPOS     213
#define MUSICPLAYER_CHANNELS        214
#define MUSICPLAYER_BITSPERSAMPLE   215
#define MUSICPLAYER_SAMPLERATE      216
#define MUSICPLAYER_CODEC           217
#define MUSICPLAYER_DISC_NUMBER     218
#define MUSICPLAYER_RATING          219
#define MUSICPLAYER_COMMENT         220
#define MUSICPLAYER_LYRICS          221
#define MUSICPLAYER_ALBUM_ARTIST    222
#define MUSICPLAYER_PLAYCOUNT       223
#define MUSICPLAYER_LASTPLAYED      224
#define MUSICPLAYER_USER_RATING     225
#define MUSICPLAYER_RATING_AND_VOTES     226
#define MUSICPLAYER_VOTES           227
#define MUSICPLAYER_MOOD            228
#define MUSICPLAYER_CONTRIBUTORS    229
#define MUSICPLAYER_CONTRIBUTOR_AND_ROLE 230
#define MUSICPLAYER_DBID            231
#define MUSICPLAYER_DISC_TITLE      232
#define MUSICPLAYER_RELEASEDATE     233
#define MUSICPLAYER_ORIGINALDATE    234
#define MUSICPLAYER_BPM             235

// Range of musicplayer infolabels that work with offset and position
#define MUSICPLAYER_OFFSET_POSITION_FIRST MUSICPLAYER_TITLE
#define MUSICPLAYER_OFFSET_POSITION_LAST MUSICPLAYER_BPM

#define MUSICPLAYER_PROPERTY        236
#define MUSICPLAYER_CHANNEL_NAME    237
#define MUSICPLAYER_CHANNEL_GROUP   238
#define MUSICPLAYER_CHANNEL_NUMBER  239
#define MUSICPLAYER_TOTALDISCS      240
#define MUSICPLAYER_STATIONNAME     241

// Musicplayer infobools
#define MUSICPLAYER_HASPREVIOUS     242
#define MUSICPLAYER_HASNEXT         243
#define MUSICPLAYER_EXISTS          244
#define MUSICPLAYER_PLAYLISTPLAYING 245
#define MUSICPLAYER_CONTENT         246
#define MUSICPLAYER_ISMULTIDISC     247

// Videoplayer infolabels
#define VIDEOPLAYER_HDR_TYPE          249
// Keep videoplayer infolabels that work with offset and position together
#define VIDEOPLAYER_TITLE             250
#define VIDEOPLAYER_GENRE             251
#define VIDEOPLAYER_DIRECTOR          252
#define VIDEOPLAYER_YEAR              253
#define VIDEOPLAYER_COVER             254
#define VIDEOPLAYER_ORIGINALTITLE     255
#define VIDEOPLAYER_PLOT              256
#define VIDEOPLAYER_PLOT_OUTLINE      257
#define VIDEOPLAYER_EPISODE           258
#define VIDEOPLAYER_SEASON            259
#define VIDEOPLAYER_RATING            260
#define VIDEOPLAYER_TVSHOW            261
#define VIDEOPLAYER_PREMIERED         262
#define VIDEOPLAYER_STUDIO            263
#define VIDEOPLAYER_MPAA              264
#define VIDEOPLAYER_ARTIST            265
#define VIDEOPLAYER_ALBUM             266
#define VIDEOPLAYER_WRITER            267
#define VIDEOPLAYER_TAGLINE           268
#define VIDEOPLAYER_TOP250            269
#define VIDEOPLAYER_RATING_AND_VOTES  270
#define VIDEOPLAYER_TRAILER           271
#define VIDEOPLAYER_COUNTRY           272
#define VIDEOPLAYER_PLAYCOUNT         273
#define VIDEOPLAYER_LASTPLAYED        274
#define VIDEOPLAYER_VOTES             275
#define VIDEOPLAYER_IMDBNUMBER        276
#define VIDEOPLAYER_USER_RATING       277
#define VIDEOPLAYER_DBID              278
#define VIDEOPLAYER_TVSHOWDBID        279
#define VIDEOPLAYER_ART               280

// Range of videoplayer infolabels that work with offset and position
#define VIDEOPLAYER_OFFSET_POSITION_FIRST VIDEOPLAYER_TITLE
#define VIDEOPLAYER_OFFSET_POSITION_LAST VIDEOPLAYER_ART

#define VIDEOPLAYER_AUDIO_BITRATE     281
#define VIDEOPLAYER_VIDEO_BITRATE     282
#define VIDEOPLAYER_VIDEO_CODEC       283
#define VIDEOPLAYER_VIDEO_RESOLUTION  284
#define VIDEOPLAYER_AUDIO_CODEC       285
#define VIDEOPLAYER_AUDIO_CHANNELS    286
#define VIDEOPLAYER_VIDEO_ASPECT      287
#define VIDEOPLAYER_SUBTITLES_LANG    288
#define VIDEOPLAYER_AUDIO_LANG        290
#define VIDEOPLAYER_STEREOSCOPIC_MODE 291
#define VIDEOPLAYER_CAST              292
#define VIDEOPLAYER_CAST_AND_ROLE     293
#define VIDEOPLAYER_UNIQUEID          294
#define VIDEOPLAYER_AUDIOSTREAMCOUNT  295

// Videoplayer infobools
#define VIDEOPLAYER_HASSUBTITLES      300
#define VIDEOPLAYER_SUBTITLESENABLED  301
#define VIDEOPLAYER_USING_OVERLAYS    302
#define VIDEOPLAYER_ISFULLSCREEN      303
#define VIDEOPLAYER_HASMENU           304
#define VIDEOPLAYER_PLAYLISTLEN       305
#define VIDEOPLAYER_PLAYLISTPOS       306
#define VIDEOPLAYER_CONTENT           307
#define VIDEOPLAYER_HAS_INFO          308
#define VIDEOPLAYER_HASTELETEXT       309
#define VIDEOPLAYER_IS_STEREOSCOPIC   310

// PVR infolabels
#define VIDEOPLAYER_EVENT             313
#define VIDEOPLAYER_EPISODENAME       314
#define VIDEOPLAYER_STARTTIME         315
#define VIDEOPLAYER_ENDTIME           316
#define VIDEOPLAYER_NEXT_TITLE        317
#define VIDEOPLAYER_NEXT_GENRE        318
#define VIDEOPLAYER_NEXT_PLOT         319
#define VIDEOPLAYER_NEXT_PLOT_OUTLINE 320
#define VIDEOPLAYER_NEXT_STARTTIME    321
#define VIDEOPLAYER_NEXT_ENDTIME      322
#define VIDEOPLAYER_NEXT_DURATION     323
#define VIDEOPLAYER_CHANNEL_NAME      324
#define VIDEOPLAYER_CHANNEL_GROUP     325
#define VIDEOPLAYER_PARENTAL_RATING   326
#define VIDEOPLAYER_CHANNEL_NUMBER    327

// PVR infobools
#define VIDEOPLAYER_HAS_EPG           328
#define VIDEOPLAYER_CAN_RESUME_LIVE_TV 329

#define RETROPLAYER_VIDEO_FILTER      330
#define RETROPLAYER_STRETCH_MODE      331
#define RETROPLAYER_VIDEO_ROTATION    332

#define CONTAINER_HAS_PARENT_ITEM    341
#define CONTAINER_CAN_FILTER         342
#define CONTAINER_CAN_FILTERADVANCED 343
#define CONTAINER_FILTERED           344

#define CONTAINER_SCROLL_PREVIOUS   345
#define CONTAINER_MOVE_PREVIOUS     346
// unused 347
#define CONTAINER_MOVE_NEXT         348
#define CONTAINER_SCROLL_NEXT       349
#define CONTAINER_ISUPDATING        350
#define CONTAINER_HASFILES          351
#define CONTAINER_HASFOLDERS        352
#define CONTAINER_STACKED           353
#define CONTAINER_FOLDERNAME        354
#define CONTAINER_SCROLLING         355
#define CONTAINER_PLUGINNAME        356
#define CONTAINER_PROPERTY          357
#define CONTAINER_SORT_DIRECTION    358
#define CONTAINER_NUM_ITEMS         359
#define CONTAINER_FOLDERPATH        360
#define CONTAINER_CONTENT           361
#define CONTAINER_HAS_THUMB         362
#define CONTAINER_SORT_METHOD       363
#define CONTAINER_CURRENT_ITEM      364
#define CONTAINER_ART               365
#define CONTAINER_HAS_FOCUS         366
#define CONTAINER_ROW               367
#define CONTAINER_COLUMN            368
#define CONTAINER_POSITION          369
#define CONTAINER_VIEWMODE          370
#define CONTAINER_HAS_NEXT          371
#define CONTAINER_HAS_PREVIOUS      372
#define CONTAINER_SUBITEM           373
#define CONTAINER_NUM_PAGES         374
#define CONTAINER_CURRENT_PAGE      375
#define CONTAINER_SHOWPLOT          376
#define CONTAINER_TOTALTIME         377
#define CONTAINER_SORT_ORDER        378
#define CONTAINER_TOTALWATCHED      379
#define CONTAINER_TOTALUNWATCHED    380
#define CONTAINER_VIEWCOUNT         381
#define CONTAINER_SHOWTITLE         382
#define CONTAINER_PLUGINCATEGORY    383
#define CONTAINER_NUM_ALL_ITEMS     384
#define CONTAINER_NUM_NONFOLDER_ITEMS 385

#define MUSICPM_ENABLED             390
#define MUSICPM_SONGSPLAYED         391
#define MUSICPM_MATCHINGSONGS       392
#define MUSICPM_MATCHINGSONGSPICKED 393
#define MUSICPM_MATCHINGSONGSLEFT   394
#define MUSICPM_RELAXEDSONGSPICKED  395
#define MUSICPM_RANDOMSONGSPICKED   396

#define PLAYLIST_LENGTH             400
#define PLAYLIST_POSITION           401
#define PLAYLIST_RANDOM             402
#define PLAYLIST_REPEAT             403
#define PLAYLIST_ISRANDOM           404
#define PLAYLIST_ISREPEAT           405
#define PLAYLIST_ISREPEATONE        406

#define VISUALISATION_LOCKED        410
#define VISUALISATION_PRESET        411
#define VISUALISATION_NAME          412
#define VISUALISATION_ENABLED       413
#define VISUALISATION_HAS_PRESETS   414

#define STRING_IS_EMPTY             420
#define STRING_IS_EQUAL             421
#define STRING_STARTS_WITH          422
#define STRING_ENDS_WITH            423
#define STRING_CONTAINS             424

#define INTEGER_IS_EQUAL            450
#define INTEGER_GREATER_THAN        451
#define INTEGER_GREATER_OR_EQUAL    452
#define INTEGER_LESS_THAN           453
#define INTEGER_LESS_OR_EQUAL       454
#define INTEGER_EVEN                455
#define INTEGER_ODD                 456
#define INTEGER_VALUEOF             457

#define SKIN_BOOL                   600
#define SKIN_STRING                 601
#define SKIN_STRING_IS_EQUAL        602
#define SKIN_THEME                  604
#define SKIN_COLOUR_THEME           605
#define SKIN_HAS_THEME              606
#define SKIN_ASPECT_RATIO           607
#define SKIN_FONT                   608
#define SKIN_INTEGER 609
#define SKIN_TIMER_IS_RUNNING 610
#define SKIN_TIMER_ELAPSEDSECS 611

#define SYSTEM_IS_SCREENSAVER_INHIBITED 641
#define SYSTEM_ADDON_UPDATE_COUNT   642
#define SYSTEM_PRIVACY_POLICY       643
#define SYSTEM_TOTAL_MEMORY         644
#define SYSTEM_CPU_USAGE            645
#define SYSTEM_USED_MEMORY_PERCENT  646
#define SYSTEM_USED_MEMORY          647
#define SYSTEM_FREE_MEMORY          648
#define SYSTEM_FREE_MEMORY_PERCENT  649
#define SYSTEM_UPTIME               654
#define SYSTEM_TOTALUPTIME          655
#define SYSTEM_CPUFREQUENCY         656
#define SYSTEM_SCREEN_RESOLUTION    659
#define SYSTEM_VIDEO_ENCODER_INFO   660
#define SYSTEM_OS_VERSION_INFO      667
#define SYSTEM_FREE_SPACE           679
#define SYSTEM_USED_SPACE           680
#define SYSTEM_TOTAL_SPACE          681
#define SYSTEM_USED_SPACE_PERCENT   682
#define SYSTEM_FREE_SPACE_PERCENT   683
#define SYSTEM_ADDON_IS_ENABLED     703
#define SYSTEM_GET_BOOL             704
#define SYSTEM_GET_CORE_USAGE       705
#define SYSTEM_HAS_CORE_ID          706
#define SYSTEM_RENDER_VENDOR        707
#define SYSTEM_RENDER_RENDERER      708
#define SYSTEM_RENDER_VERSION       709
#define SYSTEM_SETTING              710
#define SYSTEM_HAS_ADDON            711
#define SYSTEM_ADDON_TITLE          712
#define SYSTEM_ADDON_ICON           713
#define SYSTEM_BATTERY_LEVEL        714
#define SYSTEM_IDLE_TIME            715
#define SYSTEM_FRIENDLY_NAME        716
#define SYSTEM_SCREENSAVER_ACTIVE   717
#define SYSTEM_ADDON_VERSION        718
#define SYSTEM_DPMS_ACTIVE          719

#define LIBRARY_HAS_MUSIC           720
#define LIBRARY_HAS_VIDEO           721
#define LIBRARY_HAS_MOVIES          722
#define LIBRARY_HAS_MOVIE_SETS      723
#define LIBRARY_HAS_TVSHOWS         724
#define LIBRARY_HAS_MUSICVIDEOS     725
#define LIBRARY_HAS_SINGLES         726
#define LIBRARY_HAS_COMPILATIONS    727
#define LIBRARY_IS_SCANNING         728
#define LIBRARY_IS_SCANNING_VIDEO   729
#define LIBRARY_IS_SCANNING_MUSIC   730
#define LIBRARY_HAS_ROLE            735
#define LIBRARY_HAS_BOXSETS         736
#define LIBRARY_HAS_NODE            737

#define SYSTEM_PLATFORM_LINUX       741
#define SYSTEM_PLATFORM_WINDOWS     742
#define SYSTEM_PLATFORM_DARWIN      743
#define SYSTEM_PLATFORM_DARWIN_OSX  744
#define SYSTEM_PLATFORM_DARWIN_IOS  745
#define SYSTEM_PLATFORM_UWP         746
#define SYSTEM_PLATFORM_ANDROID     747
#define SYSTEM_PLATFORM_WINDOWING   748
#define SYSTEM_PLATFORM_WIN10       749

#define SYSTEM_CAN_POWERDOWN        750
#define SYSTEM_CAN_SUSPEND          751
#define SYSTEM_CAN_HIBERNATE        752
#define SYSTEM_CAN_REBOOT           753
#define SYSTEM_MEDIA_AUDIO_CD       754

#define SYSTEM_PLATFORM_DARWIN_TVOS 755
#define SYSTEM_SUPPORTED_HDR_TYPES 756

#define SLIDESHOW_ISPAUSED          800
#define SLIDESHOW_ISRANDOM          801
#define SLIDESHOW_ISACTIVE          802
#define SLIDESHOW_ISVIDEO           803

#define SLIDESHOW_LABELS_START          900
#define SLIDESHOW_FILE_NAME             (SLIDESHOW_LABELS_START)
#define SLIDESHOW_FILE_PATH             (SLIDESHOW_LABELS_START + 1)
#define SLIDESHOW_FILE_SIZE             (SLIDESHOW_LABELS_START + 2)
#define SLIDESHOW_FILE_DATE             (SLIDESHOW_LABELS_START + 3)
#define SLIDESHOW_INDEX                 (SLIDESHOW_LABELS_START + 4)
#define SLIDESHOW_RESOLUTION            (SLIDESHOW_LABELS_START + 5)
#define SLIDESHOW_COMMENT               (SLIDESHOW_LABELS_START + 6)
#define SLIDESHOW_COLOUR                (SLIDESHOW_LABELS_START + 7)
#define SLIDESHOW_PROCESS               (SLIDESHOW_LABELS_START + 8)

#define SLIDESHOW_EXIF_LONG_DATE        (SLIDESHOW_LABELS_START + 17)
#define SLIDESHOW_EXIF_LONG_DATE_TIME   (SLIDESHOW_LABELS_START + 18)
#define SLIDESHOW_EXIF_DATE             (SLIDESHOW_LABELS_START + 19) /* Implementation only to just get localized date */
#define SLIDESHOW_EXIF_DATE_TIME        (SLIDESHOW_LABELS_START + 20)
#define SLIDESHOW_EXIF_DESCRIPTION      (SLIDESHOW_LABELS_START + 21)
#define SLIDESHOW_EXIF_CAMERA_MAKE      (SLIDESHOW_LABELS_START + 22)
#define SLIDESHOW_EXIF_CAMERA_MODEL     (SLIDESHOW_LABELS_START + 23)
#define SLIDESHOW_EXIF_COMMENT          (SLIDESHOW_LABELS_START + 24)
#define SLIDESHOW_EXIF_SOFTWARE         (SLIDESHOW_LABELS_START + 25)
#define SLIDESHOW_EXIF_APERTURE         (SLIDESHOW_LABELS_START + 26)
#define SLIDESHOW_EXIF_FOCAL_LENGTH     (SLIDESHOW_LABELS_START + 27)
#define SLIDESHOW_EXIF_FOCUS_DIST       (SLIDESHOW_LABELS_START + 28)
#define SLIDESHOW_EXIF_EXPOSURE         (SLIDESHOW_LABELS_START + 29)
#define SLIDESHOW_EXIF_EXPOSURE_TIME    (SLIDESHOW_LABELS_START + 30)
#define SLIDESHOW_EXIF_EXPOSURE_BIAS    (SLIDESHOW_LABELS_START + 31)
#define SLIDESHOW_EXIF_EXPOSURE_MODE    (SLIDESHOW_LABELS_START + 32)
#define SLIDESHOW_EXIF_FLASH_USED       (SLIDESHOW_LABELS_START + 33)
#define SLIDESHOW_EXIF_WHITE_BALANCE    (SLIDESHOW_LABELS_START + 34)
#define SLIDESHOW_EXIF_LIGHT_SOURCE     (SLIDESHOW_LABELS_START + 35)
#define SLIDESHOW_EXIF_METERING_MODE    (SLIDESHOW_LABELS_START + 36)
#define SLIDESHOW_EXIF_ISO_EQUIV        (SLIDESHOW_LABELS_START + 37)
#define SLIDESHOW_EXIF_DIGITAL_ZOOM     (SLIDESHOW_LABELS_START + 38)
#define SLIDESHOW_EXIF_CCD_WIDTH        (SLIDESHOW_LABELS_START + 39)
#define SLIDESHOW_EXIF_GPS_LATITUDE     (SLIDESHOW_LABELS_START + 40)
#define SLIDESHOW_EXIF_GPS_LONGITUDE    (SLIDESHOW_LABELS_START + 41)
#define SLIDESHOW_EXIF_GPS_ALTITUDE     (SLIDESHOW_LABELS_START + 42)
#define SLIDESHOW_EXIF_ORIENTATION      (SLIDESHOW_LABELS_START + 43)
#define SLIDESHOW_EXIF_XPCOMMENT        (SLIDESHOW_LABELS_START + 44)

#define SLIDESHOW_IPTC_SUBLOCATION      (SLIDESHOW_LABELS_START + 57)
#define SLIDESHOW_IPTC_IMAGETYPE        (SLIDESHOW_LABELS_START + 58)
#define SLIDESHOW_IPTC_TIMECREATED      (SLIDESHOW_LABELS_START + 59)
#define SLIDESHOW_IPTC_SUP_CATEGORIES   (SLIDESHOW_LABELS_START + 60)
#define SLIDESHOW_IPTC_KEYWORDS         (SLIDESHOW_LABELS_START + 61)
#define SLIDESHOW_IPTC_CAPTION          (SLIDESHOW_LABELS_START + 62)
#define SLIDESHOW_IPTC_AUTHOR           (SLIDESHOW_LABELS_START + 63)
#define SLIDESHOW_IPTC_HEADLINE         (SLIDESHOW_LABELS_START + 64)
#define SLIDESHOW_IPTC_SPEC_INSTR       (SLIDESHOW_LABELS_START + 65)
#define SLIDESHOW_IPTC_CATEGORY         (SLIDESHOW_LABELS_START + 66)
#define SLIDESHOW_IPTC_BYLINE           (SLIDESHOW_LABELS_START + 67)
#define SLIDESHOW_IPTC_BYLINE_TITLE     (SLIDESHOW_LABELS_START + 68)
#define SLIDESHOW_IPTC_CREDIT           (SLIDESHOW_LABELS_START + 69)
#define SLIDESHOW_IPTC_SOURCE           (SLIDESHOW_LABELS_START + 70)
#define SLIDESHOW_IPTC_COPYRIGHT_NOTICE (SLIDESHOW_LABELS_START + 71)
#define SLIDESHOW_IPTC_OBJECT_NAME      (SLIDESHOW_LABELS_START + 72)
#define SLIDESHOW_IPTC_CITY             (SLIDESHOW_LABELS_START + 73)
#define SLIDESHOW_IPTC_STATE            (SLIDESHOW_LABELS_START + 74)
#define SLIDESHOW_IPTC_COUNTRY          (SLIDESHOW_LABELS_START + 75)
#define SLIDESHOW_IPTC_TX_REFERENCE     (SLIDESHOW_LABELS_START + 76)
#define SLIDESHOW_IPTC_DATE             (SLIDESHOW_LABELS_START + 77)
#define SLIDESHOW_IPTC_URGENCY          (SLIDESHOW_LABELS_START + 78)
#define SLIDESHOW_IPTC_COUNTRY_CODE     (SLIDESHOW_LABELS_START + 79)
#define SLIDESHOW_IPTC_REF_SERVICE      (SLIDESHOW_LABELS_START + 80)
#define SLIDESHOW_LABELS_END            SLIDESHOW_IPTC_REF_SERVICE

#define FANART_COLOR1               1000
#define FANART_COLOR2               1001
#define FANART_COLOR3               1002
#define FANART_IMAGE                1003

#define SYSTEM_PROFILEAUTOLOGIN     1004

#define SYSTEM_HAS_CMS              1006
#define SYSTEM_BUILD_VERSION_CODE 1007
#define SYSTEM_BUILD_VERSION_GIT 1008

#define PVR_CONDITIONS_START        1100
#define PVR_IS_RECORDING            (PVR_CONDITIONS_START)
#define PVR_HAS_TIMER               (PVR_CONDITIONS_START + 1)
#define PVR_HAS_NONRECORDING_TIMER  (PVR_CONDITIONS_START + 2)
#define PVR_IS_PLAYING_TV           (PVR_CONDITIONS_START + 3)
#define PVR_IS_PLAYING_RADIO        (PVR_CONDITIONS_START + 4)
#define PVR_IS_PLAYING_RECORDING    (PVR_CONDITIONS_START + 5)
#define PVR_ACTUAL_STREAM_ENCRYPTED (PVR_CONDITIONS_START + 6)
#define PVR_HAS_TV_CHANNELS         (PVR_CONDITIONS_START + 7)
#define PVR_HAS_RADIO_CHANNELS      (PVR_CONDITIONS_START + 8)
#define PVR_IS_TIMESHIFTING         (PVR_CONDITIONS_START + 9)
#define PVR_IS_RECORDING_TV               (PVR_CONDITIONS_START + 10)
#define PVR_HAS_TV_TIMER                  (PVR_CONDITIONS_START + 11)
#define PVR_HAS_NONRECORDING_TV_TIMER     (PVR_CONDITIONS_START + 12)
#define PVR_IS_RECORDING_RADIO            (PVR_CONDITIONS_START + 13)
#define PVR_HAS_RADIO_TIMER               (PVR_CONDITIONS_START + 14)
#define PVR_HAS_NONRECORDING_RADIO_TIMER  (PVR_CONDITIONS_START + 15)
#define PVR_IS_PLAYING_EPGTAG       (PVR_CONDITIONS_START + 16)
#define PVR_CAN_RECORD_PLAYING_CHANNEL    (PVR_CONDITIONS_START + 17)
#define PVR_IS_RECORDING_PLAYING_CHANNEL  (PVR_CONDITIONS_START + 18)
#define PVR_IS_PLAYING_ACTIVE_RECORDING   (PVR_CONDITIONS_START + 19)
#define PVR_CONDITIONS_END          PVR_IS_PLAYING_ACTIVE_RECORDING

#define PVR_STRINGS_START           1200
#define PVR_NEXT_RECORDING_CHANNEL  (PVR_STRINGS_START)
#define PVR_NEXT_RECORDING_CHAN_ICO (PVR_STRINGS_START + 1)
#define PVR_NEXT_RECORDING_DATETIME (PVR_STRINGS_START + 2)
#define PVR_NEXT_RECORDING_TITLE    (PVR_STRINGS_START + 3)
#define PVR_NOW_RECORDING_CHANNEL   (PVR_STRINGS_START + 4)
#define PVR_NOW_RECORDING_CHAN_ICO  (PVR_STRINGS_START + 5)
#define PVR_NOW_RECORDING_DATETIME  (PVR_STRINGS_START + 6)
#define PVR_NOW_RECORDING_TITLE     (PVR_STRINGS_START + 7)
#define PVR_BACKEND_NAME            (PVR_STRINGS_START + 8)
#define PVR_BACKEND_VERSION         (PVR_STRINGS_START + 9)
#define PVR_BACKEND_HOST            (PVR_STRINGS_START + 10)
#define PVR_BACKEND_DISKSPACE       (PVR_STRINGS_START + 11)
#define PVR_BACKEND_CHANNELS        (PVR_STRINGS_START + 12)
#define PVR_BACKEND_TIMERS          (PVR_STRINGS_START + 13)
#define PVR_BACKEND_RECORDINGS      (PVR_STRINGS_START + 14)
#define PVR_BACKEND_DELETED_RECORDINGS (PVR_STRINGS_START + 15)
#define PVR_BACKEND_NUMBER          (PVR_STRINGS_START + 16)
#define PVR_TOTAL_DISKSPACE         (PVR_STRINGS_START + 17)
#define PVR_NEXT_TIMER              (PVR_STRINGS_START + 18)
#define PVR_EPG_EVENT_DURATION      (PVR_STRINGS_START + 19)
#define PVR_EPG_EVENT_ELAPSED_TIME  (PVR_STRINGS_START + 20)
#define PVR_EPG_EVENT_PROGRESS      (PVR_STRINGS_START + 21)
#define PVR_ACTUAL_STREAM_CLIENT    (PVR_STRINGS_START + 22)
#define PVR_ACTUAL_STREAM_DEVICE    (PVR_STRINGS_START + 23)
#define PVR_ACTUAL_STREAM_STATUS    (PVR_STRINGS_START + 24)
#define PVR_ACTUAL_STREAM_SIG       (PVR_STRINGS_START + 25)
#define PVR_ACTUAL_STREAM_SNR       (PVR_STRINGS_START + 26)
#define PVR_ACTUAL_STREAM_SIG_PROGR (PVR_STRINGS_START + 27)
#define PVR_ACTUAL_STREAM_SNR_PROGR (PVR_STRINGS_START + 28)
#define PVR_ACTUAL_STREAM_BER       (PVR_STRINGS_START + 29)
#define PVR_ACTUAL_STREAM_UNC       (PVR_STRINGS_START + 30)
#define PVR_ACTUAL_STREAM_CRYPTION  (PVR_STRINGS_START + 34)
#define PVR_ACTUAL_STREAM_SERVICE   (PVR_STRINGS_START + 35)
#define PVR_ACTUAL_STREAM_MUX       (PVR_STRINGS_START + 36)
#define PVR_ACTUAL_STREAM_PROVIDER  (PVR_STRINGS_START + 37)
#define PVR_BACKEND_DISKSPACE_PROGR (PVR_STRINGS_START + 38)
#define PVR_TIMESHIFT_START_TIME    (PVR_STRINGS_START + 39)
#define PVR_TIMESHIFT_END_TIME      (PVR_STRINGS_START + 40)
#define PVR_TIMESHIFT_PLAY_TIME     (PVR_STRINGS_START + 41)
#define PVR_TIMESHIFT_PROGRESS      (PVR_STRINGS_START + 42)
#define PVR_TV_NOW_RECORDING_TITLE     (PVR_STRINGS_START + 43)
#define PVR_TV_NOW_RECORDING_CHANNEL   (PVR_STRINGS_START + 44)
#define PVR_TV_NOW_RECORDING_CHAN_ICO  (PVR_STRINGS_START + 45)
#define PVR_TV_NOW_RECORDING_DATETIME  (PVR_STRINGS_START + 46)
#define PVR_TV_NEXT_RECORDING_TITLE    (PVR_STRINGS_START + 47)
#define PVR_TV_NEXT_RECORDING_CHANNEL  (PVR_STRINGS_START + 48)
#define PVR_TV_NEXT_RECORDING_CHAN_ICO (PVR_STRINGS_START + 49)
#define PVR_TV_NEXT_RECORDING_DATETIME (PVR_STRINGS_START + 50)
#define PVR_RADIO_NOW_RECORDING_TITLE     (PVR_STRINGS_START + 51)
#define PVR_RADIO_NOW_RECORDING_CHANNEL   (PVR_STRINGS_START + 52)
#define PVR_RADIO_NOW_RECORDING_CHAN_ICO  (PVR_STRINGS_START + 53)
#define PVR_RADIO_NOW_RECORDING_DATETIME  (PVR_STRINGS_START + 54)
#define PVR_RADIO_NEXT_RECORDING_TITLE    (PVR_STRINGS_START + 55)
#define PVR_RADIO_NEXT_RECORDING_CHANNEL  (PVR_STRINGS_START + 56)
#define PVR_RADIO_NEXT_RECORDING_CHAN_ICO (PVR_STRINGS_START + 57)
#define PVR_RADIO_NEXT_RECORDING_DATETIME (PVR_STRINGS_START + 58)
#define PVR_CHANNEL_NUMBER_INPUT          (PVR_STRINGS_START + 59)
#define PVR_EPG_EVENT_REMAINING_TIME      (PVR_STRINGS_START + 60)
#define PVR_EPG_EVENT_FINISH_TIME         (PVR_STRINGS_START + 61)
#define PVR_TIMESHIFT_OFFSET              (PVR_STRINGS_START + 62)
#define PVR_EPG_EVENT_SEEK_TIME           (PVR_STRINGS_START + 63)
#define PVR_TIMESHIFT_PROGRESS_PLAY_POS   (PVR_STRINGS_START + 64)
#define PVR_TIMESHIFT_PROGRESS_DURATION   (PVR_STRINGS_START + 65)
#define PVR_TIMESHIFT_PROGRESS_EPG_START  (PVR_STRINGS_START + 66)
#define PVR_TIMESHIFT_PROGRESS_EPG_END    (PVR_STRINGS_START + 67)
#define PVR_TIMESHIFT_PROGRESS_BUFFER_START (PVR_STRINGS_START + 68)
#define PVR_TIMESHIFT_PROGRESS_BUFFER_END (PVR_STRINGS_START + 69)
#define PVR_TIMESHIFT_PROGRESS_START_TIME (PVR_STRINGS_START + 70)
#define PVR_TIMESHIFT_PROGRESS_END_TIME   (PVR_STRINGS_START + 71)
#define PVR_EPG_EVENT_ICON                (PVR_STRINGS_START + 72)
#define PVR_TIMESHIFT_SEEKBAR             (PVR_STRINGS_START + 73)
#define PVR_BACKEND_PROVIDERS             (PVR_STRINGS_START + 74)
#define PVR_BACKEND_CHANNEL_GROUPS        (PVR_STRINGS_START + 75)
#define PVR_STRINGS_END                   PVR_BACKEND_CHANNEL_GROUPS

#define RDS_DATA_START              1400
#define RDS_HAS_RDS                 (RDS_DATA_START)
#define RDS_HAS_RADIOTEXT           (RDS_DATA_START + 1)
#define RDS_HAS_RADIOTEXT_PLUS      (RDS_DATA_START + 2)
#define RDS_GET_RADIOTEXT_LINE      (RDS_DATA_START + 3)
#define RDS_TITLE                   (RDS_DATA_START + 4)
#define RDS_BAND                    (RDS_DATA_START + 5)
#define RDS_ARTIST                  (RDS_DATA_START + 6)
#define RDS_COMPOSER                (RDS_DATA_START + 7)
#define RDS_CONDUCTOR               (RDS_DATA_START + 8)
#define RDS_ALBUM                   (RDS_DATA_START + 9)
#define RDS_ALBUM_TRACKNUMBER       (RDS_DATA_START + 10)
#define RDS_GET_RADIO_STYLE         (RDS_DATA_START + 11)
#define RDS_COMMENT                 (RDS_DATA_START + 12)
#define RDS_INFO_NEWS               (RDS_DATA_START + 13)
#define RDS_INFO_NEWS_LOCAL         (RDS_DATA_START + 14)
#define RDS_INFO_STOCK              (RDS_DATA_START + 15)
#define RDS_INFO_STOCK_SIZE         (RDS_DATA_START + 16)
#define RDS_INFO_SPORT              (RDS_DATA_START + 17)
#define RDS_INFO_SPORT_SIZE         (RDS_DATA_START + 18)
#define RDS_INFO_LOTTERY            (RDS_DATA_START + 19)
#define RDS_INFO_LOTTERY_SIZE       (RDS_DATA_START + 20)
#define RDS_INFO_WEATHER            (RDS_DATA_START + 21)
#define RDS_INFO_WEATHER_SIZE       (RDS_DATA_START + 22)
#define RDS_INFO_CINEMA             (RDS_DATA_START + 23)
#define RDS_INFO_CINEMA_SIZE        (RDS_DATA_START + 24)
#define RDS_INFO_HOROSCOPE          (RDS_DATA_START + 25)
#define RDS_INFO_HOROSCOPE_SIZE     (RDS_DATA_START + 26)
#define RDS_INFO_OTHER              (RDS_DATA_START + 27)
#define RDS_INFO_OTHER_SIZE         (RDS_DATA_START + 28)
#define RDS_PROG_STATION            (RDS_DATA_START + 29)
#define RDS_PROG_NOW                (RDS_DATA_START + 30)
#define RDS_PROG_NEXT               (RDS_DATA_START + 31)
#define RDS_PROG_HOST               (RDS_DATA_START + 32)
#define RDS_PROG_EDIT_STAFF         (RDS_DATA_START + 33)
#define RDS_PROG_HOMEPAGE           (RDS_DATA_START + 34)
#define RDS_PROG_STYLE              (RDS_DATA_START + 35)
#define RDS_PHONE_HOTLINE           (RDS_DATA_START + 36)
#define RDS_PHONE_STUDIO            (RDS_DATA_START + 37)
#define RDS_SMS_STUDIO              (RDS_DATA_START + 38)
#define RDS_EMAIL_HOTLINE           (RDS_DATA_START + 39)
#define RDS_EMAIL_STUDIO            (RDS_DATA_START + 40)
#define RDS_HAS_HOTLINE_DATA        (RDS_DATA_START + 41)
#define RDS_HAS_STUDIO_DATA         (RDS_DATA_START + 42)
#define RDS_AUDIO_LANG              (RDS_DATA_START + 43)
#define RDS_CHANNEL_COUNTRY         (RDS_DATA_START + 44)
#define RDS_DATA_END                RDS_CHANNEL_COUNTRY

#define PLAYER_PROCESS              1500
#define PLAYER_PROCESS_VIDEODECODER (PLAYER_PROCESS)
#define PLAYER_PROCESS_DEINTMETHOD (PLAYER_PROCESS + 1)
#define PLAYER_PROCESS_PIXELFORMAT (PLAYER_PROCESS + 2)
#define PLAYER_PROCESS_VIDEOWIDTH (PLAYER_PROCESS + 3)
#define PLAYER_PROCESS_VIDEOHEIGHT (PLAYER_PROCESS + 4)
#define PLAYER_PROCESS_VIDEOFPS (PLAYER_PROCESS + 5)
#define PLAYER_PROCESS_VIDEODAR (PLAYER_PROCESS + 6)
#define PLAYER_PROCESS_VIDEOHWDECODER (PLAYER_PROCESS + 7)
#define PLAYER_PROCESS_AUDIODECODER (PLAYER_PROCESS + 8)
#define PLAYER_PROCESS_AUDIOCHANNELS (PLAYER_PROCESS + 9)
#define PLAYER_PROCESS_AUDIOSAMPLERATE (PLAYER_PROCESS + 10)
#define PLAYER_PROCESS_AUDIOBITSPERSAMPLE (PLAYER_PROCESS + 11)
#define PLAYER_PROCESS_VIDEOSCANTYPE (PLAYER_PROCESS + 12)

#define ADDON_INFOS                 1600
#define ADDON_SETTING_STRING        (ADDON_INFOS)
#define ADDON_SETTING_BOOL          (ADDON_INFOS + 1)
#define ADDON_SETTING_INT           (ADDON_INFOS + 2)

#define WINDOW_PROPERTY             9993
#define WINDOW_IS_VISIBLE           9995
#define WINDOW_NEXT                 9996
#define WINDOW_PREVIOUS             9997
#define WINDOW_IS_MEDIA             9998
#define WINDOW_IS_ACTIVE            9999
#define WINDOW_IS                   10000
#define WINDOW_IS_DIALOG_TOPMOST    10001
#define WINDOW_IS_MODAL_DIALOG_TOPMOST 10002

#define CONTROL_GET_LABEL           29996
#define CONTROL_IS_ENABLED          29997
#define CONTROL_IS_VISIBLE          29998
#define CONTROL_GROUP_HAS_FOCUS     29999
#define CONTROL_HAS_FOCUS           30000

#define LISTITEM_START              35000
#define LISTITEM_THUMB              (LISTITEM_START)
#define LISTITEM_LABEL              (LISTITEM_START + 1)
#define LISTITEM_TITLE              (LISTITEM_START + 2)
#define LISTITEM_TRACKNUMBER        (LISTITEM_START + 3)
#define LISTITEM_ARTIST             (LISTITEM_START + 4)
#define LISTITEM_ALBUM              (LISTITEM_START + 5)
#define LISTITEM_YEAR               (LISTITEM_START + 6)
#define LISTITEM_GENRE              (LISTITEM_START + 7)
#define LISTITEM_ICON               (LISTITEM_START + 8)
#define LISTITEM_DIRECTOR           (LISTITEM_START + 9)
#define LISTITEM_OVERLAY            (LISTITEM_START + 10)
#define LISTITEM_LABEL2             (LISTITEM_START + 11)
#define LISTITEM_FILENAME           (LISTITEM_START + 12)
#define LISTITEM_DATE               (LISTITEM_START + 13)
#define LISTITEM_SIZE               (LISTITEM_START + 14)
#define LISTITEM_RATING             (LISTITEM_START + 15)
#define LISTITEM_PROGRAM_COUNT      (LISTITEM_START + 16)
#define LISTITEM_DURATION           (LISTITEM_START + 17)
#define LISTITEM_ISPLAYING          (LISTITEM_START + 18)
#define LISTITEM_ISSELECTED         (LISTITEM_START + 19)
#define LISTITEM_PLOT               (LISTITEM_START + 20)
#define LISTITEM_PLOT_OUTLINE       (LISTITEM_START + 21)
#define LISTITEM_EPISODE            (LISTITEM_START + 22)
#define LISTITEM_SEASON             (LISTITEM_START + 23)
#define LISTITEM_TVSHOW             (LISTITEM_START + 24)
#define LISTITEM_PREMIERED          (LISTITEM_START + 25)
#define LISTITEM_COMMENT            (LISTITEM_START + 26)
#define LISTITEM_ACTUAL_ICON        (LISTITEM_START + 27)
#define LISTITEM_PATH               (LISTITEM_START + 28)
#define LISTITEM_PICTURE_PATH       (LISTITEM_START + 29)

#define LISTITEM_PICTURE_START      (LISTITEM_START + 30)
#define LISTITEM_PICTURE_RESOLUTION (LISTITEM_PICTURE_START) // => SLIDESHOW_RESOLUTION
#define LISTITEM_PICTURE_LONGDATE   (LISTITEM_START + 31)    // => SLIDESHOW_EXIF_LONG_DATE
#define LISTITEM_PICTURE_LONGDATETIME (LISTITEM_START + 32)    // => SLIDESHOW_EXIF_LONG_DATE_TIME
#define LISTITEM_PICTURE_DATE       (LISTITEM_START + 33)    // => SLIDESHOW_EXIF_DATE
#define LISTITEM_PICTURE_DATETIME   (LISTITEM_START + 34)    // => SLIDESHOW_EXIF_DATE_TIME
#define LISTITEM_PICTURE_COMMENT    (LISTITEM_START + 35)    // => SLIDESHOW_COMMENT
#define LISTITEM_PICTURE_CAPTION    (LISTITEM_START + 36)    // => SLIDESHOW_IPTC_CAPTION
#define LISTITEM_PICTURE_DESC       (LISTITEM_START + 37)    // => SLIDESHOW_EXIF_DESCRIPTION
#define LISTITEM_PICTURE_KEYWORDS   (LISTITEM_START + 38)    // => SLIDESHOW_IPTC_KEYWORDS
#define LISTITEM_PICTURE_CAM_MAKE   (LISTITEM_START + 39)    // => SLIDESHOW_EXIF_CAMERA_MAKE
#define LISTITEM_PICTURE_CAM_MODEL  (LISTITEM_START + 40)    // => SLIDESHOW_EXIF_CAMERA_MODEL
#define LISTITEM_PICTURE_APERTURE   (LISTITEM_START + 41)    // => SLIDESHOW_EXIF_APERTURE
#define LISTITEM_PICTURE_FOCAL_LEN  (LISTITEM_START + 42)    // => SLIDESHOW_EXIF_FOCAL_LENGTH
#define LISTITEM_PICTURE_FOCUS_DIST (LISTITEM_START + 43)    // => SLIDESHOW_EXIF_FOCUS_DIST
#define LISTITEM_PICTURE_EXP_MODE   (LISTITEM_START + 44)    // => SLIDESHOW_EXIF_EXPOSURE_MODE
#define LISTITEM_PICTURE_EXP_TIME   (LISTITEM_START + 45)    // => SLIDESHOW_EXIF_EXPOSURE_TIME
#define LISTITEM_PICTURE_ISO        (LISTITEM_START + 46)    // => SLIDESHOW_EXIF_ISO_EQUIV
#define LISTITEM_PICTURE_AUTHOR           (LISTITEM_START + 47) // => SLIDESHOW_IPTC_AUTHOR
#define LISTITEM_PICTURE_BYLINE           (LISTITEM_START + 48) // => SLIDESHOW_IPTC_BYLINE
#define LISTITEM_PICTURE_BYLINE_TITLE     (LISTITEM_START + 49) // => SLIDESHOW_IPTC_BYLINE_TITLE
#define LISTITEM_PICTURE_CATEGORY         (LISTITEM_START + 50) // => SLIDESHOW_IPTC_CATEGORY
#define LISTITEM_PICTURE_CCD_WIDTH        (LISTITEM_START + 51) // => SLIDESHOW_EXIF_CCD_WIDTH
#define LISTITEM_PICTURE_CITY             (LISTITEM_START + 52) // => SLIDESHOW_IPTC_CITY
#define LISTITEM_PICTURE_URGENCY          (LISTITEM_START + 53) // => SLIDESHOW_IPTC_URGENCY
#define LISTITEM_PICTURE_COPYRIGHT_NOTICE (LISTITEM_START + 54) // => SLIDESHOW_IPTC_COPYRIGHT_NOTICE
#define LISTITEM_PICTURE_COUNTRY          (LISTITEM_START + 55) // => SLIDESHOW_IPTC_COUNTRY
#define LISTITEM_PICTURE_COUNTRY_CODE     (LISTITEM_START + 56) // => SLIDESHOW_IPTC_COUNTRY_CODE
#define LISTITEM_PICTURE_CREDIT           (LISTITEM_START + 57) // => SLIDESHOW_IPTC_CREDIT
#define LISTITEM_PICTURE_IPTCDATE         (LISTITEM_START + 58) // => SLIDESHOW_IPTC_DATE
#define LISTITEM_PICTURE_DIGITAL_ZOOM     (LISTITEM_START + 59) // => SLIDESHOW_EXIF_DIGITAL_ZOOM
#define LISTITEM_PICTURE_EXPOSURE         (LISTITEM_START + 60) // => SLIDESHOW_EXIF_EXPOSURE
#define LISTITEM_PICTURE_EXPOSURE_BIAS    (LISTITEM_START + 61) // => SLIDESHOW_EXIF_EXPOSURE_BIAS
#define LISTITEM_PICTURE_FLASH_USED       (LISTITEM_START + 62) // => SLIDESHOW_EXIF_FLASH_USED
#define LISTITEM_PICTURE_HEADLINE         (LISTITEM_START + 63) // => SLIDESHOW_IPTC_HEADLINE
#define LISTITEM_PICTURE_COLOUR           (LISTITEM_START + 64) // => SLIDESHOW_COLOUR
#define LISTITEM_PICTURE_LIGHT_SOURCE     (LISTITEM_START + 65) // => SLIDESHOW_EXIF_LIGHT_SOURCE
#define LISTITEM_PICTURE_METERING_MODE    (LISTITEM_START + 66) // => SLIDESHOW_EXIF_METERING_MODE
#define LISTITEM_PICTURE_OBJECT_NAME      (LISTITEM_START + 67) // => SLIDESHOW_IPTC_OBJECT_NAME
#define LISTITEM_PICTURE_ORIENTATION      (LISTITEM_START + 68) // => SLIDESHOW_EXIF_ORIENTATION
#define LISTITEM_PICTURE_PROCESS          (LISTITEM_START + 69) // => SLIDESHOW_PROCESS
#define LISTITEM_PICTURE_REF_SERVICE      (LISTITEM_START + 70) // => SLIDESHOW_IPTC_REF_SERVICE
#define LISTITEM_PICTURE_SOURCE           (LISTITEM_START + 71) // => SLIDESHOW_IPTC_SOURCE
#define LISTITEM_PICTURE_SPEC_INSTR       (LISTITEM_START + 72) // => SLIDESHOW_IPTC_SPEC_INSTR
#define LISTITEM_PICTURE_STATE            (LISTITEM_START + 73) // => SLIDESHOW_IPTC_STATE
#define LISTITEM_PICTURE_SUP_CATEGORIES   (LISTITEM_START + 74) // => SLIDESHOW_IPTC_SUP_CATEGORIES
#define LISTITEM_PICTURE_TX_REFERENCE     (LISTITEM_START + 75) // => SLIDESHOW_IPTC_TX_REFERENCE
#define LISTITEM_PICTURE_WHITE_BALANCE    (LISTITEM_START + 76) // => SLIDESHOW_EXIF_WHITE_BALANCE
#define LISTITEM_PICTURE_IMAGETYPE        (LISTITEM_START + 77) // => SLIDESHOW_IPTC_IMAGETYPE
#define LISTITEM_PICTURE_SUBLOCATION      (LISTITEM_START + 78) // => SLIDESHOW_IPTC_SUBLOCATION
#define LISTITEM_PICTURE_TIMECREATED      (LISTITEM_START + 79) // => SLIDESHOW_IPTC_TIMECREATED
#define LISTITEM_PICTURE_GPS_LAT    (LISTITEM_START + 80)    // => SLIDESHOW_EXIF_GPS_LATITUDE
#define LISTITEM_PICTURE_GPS_LON    (LISTITEM_START + 81)    // => SLIDESHOW_EXIF_GPS_LONGITUDE
#define LISTITEM_PICTURE_GPS_ALT    (LISTITEM_START + 82)    // => SLIDESHOW_EXIF_GPS_ALTITUDE
#define LISTITEM_PICTURE_END        (LISTITEM_PICTURE_GPS_ALT)

#define LISTITEM_STUDIO             (LISTITEM_START + 83)
#define LISTITEM_MPAA               (LISTITEM_START + 84)
#define LISTITEM_CAST               (LISTITEM_START + 85)
#define LISTITEM_CAST_AND_ROLE      (LISTITEM_START + 86)
#define LISTITEM_WRITER             (LISTITEM_START + 87)
#define LISTITEM_TAGLINE            (LISTITEM_START + 88)
#define LISTITEM_TOP250             (LISTITEM_START + 89)
#define LISTITEM_RATING_AND_VOTES   (LISTITEM_START + 90)
#define LISTITEM_TRAILER            (LISTITEM_START + 91)
#define LISTITEM_APPEARANCES        (LISTITEM_START + 92)
#define LISTITEM_FILENAME_AND_PATH  (LISTITEM_START + 93)
#define LISTITEM_SORT_LETTER        (LISTITEM_START + 94)
#define LISTITEM_ALBUM_ARTIST       (LISTITEM_START + 95)
#define LISTITEM_FOLDERNAME         (LISTITEM_START + 96)
#define LISTITEM_VIDEO_CODEC        (LISTITEM_START + 97)
#define LISTITEM_VIDEO_RESOLUTION   (LISTITEM_START + 98)
#define LISTITEM_VIDEO_ASPECT       (LISTITEM_START + 99)
#define LISTITEM_AUDIO_CODEC        (LISTITEM_START + 100)
#define LISTITEM_AUDIO_CHANNELS     (LISTITEM_START + 101)
#define LISTITEM_AUDIO_LANGUAGE     (LISTITEM_START + 102)
#define LISTITEM_SUBTITLE_LANGUAGE  (LISTITEM_START + 103)
#define LISTITEM_IS_FOLDER          (LISTITEM_START + 104)
#define LISTITEM_ORIGINALTITLE      (LISTITEM_START + 105)
#define LISTITEM_COUNTRY            (LISTITEM_START + 106)
#define LISTITEM_PLAYCOUNT          (LISTITEM_START + 107)
#define LISTITEM_LASTPLAYED         (LISTITEM_START + 108)
#define LISTITEM_FOLDERPATH         (LISTITEM_START + 109)
#define LISTITEM_DISC_NUMBER        (LISTITEM_START + 110)
#define LISTITEM_FILE_EXTENSION     (LISTITEM_START + 111)
#define LISTITEM_IS_RESUMABLE       (LISTITEM_START + 112)
#define LISTITEM_PERCENT_PLAYED     (LISTITEM_START + 113)
#define LISTITEM_DATE_ADDED         (LISTITEM_START + 114)
#define LISTITEM_DBTYPE             (LISTITEM_START + 115)
#define LISTITEM_DBID               (LISTITEM_START + 116)
#define LISTITEM_ART                (LISTITEM_START + 117)
#define LISTITEM_STARTTIME          (LISTITEM_START + 118)
#define LISTITEM_ENDTIME            (LISTITEM_START + 119)
#define LISTITEM_STARTDATE          (LISTITEM_START + 120)
#define LISTITEM_ENDDATE            (LISTITEM_START + 121)
#define LISTITEM_NEXT_TITLE         (LISTITEM_START + 122)
#define LISTITEM_NEXT_GENRE         (LISTITEM_START + 123)
#define LISTITEM_NEXT_PLOT          (LISTITEM_START + 124)
#define LISTITEM_NEXT_PLOT_OUTLINE  (LISTITEM_START + 125)
#define LISTITEM_NEXT_STARTTIME     (LISTITEM_START + 126)
#define LISTITEM_NEXT_ENDTIME       (LISTITEM_START + 127)
#define LISTITEM_NEXT_STARTDATE     (LISTITEM_START + 128)
#define LISTITEM_NEXT_ENDDATE       (LISTITEM_START + 129)
#define LISTITEM_NEXT_DURATION      (LISTITEM_START + 130)
#define LISTITEM_CHANNEL_NAME       (LISTITEM_START + 131)
#define LISTITEM_CHANNEL_GROUP      (LISTITEM_START + 132)
#define LISTITEM_HASTIMER           (LISTITEM_START + 133)
#define LISTITEM_ISRECORDING        (LISTITEM_START + 134)
#define LISTITEM_ISENCRYPTED        (LISTITEM_START + 135)
#define LISTITEM_PARENTAL_RATING    (LISTITEM_START + 136)
#define LISTITEM_PROGRESS           (LISTITEM_START + 137)
#define LISTITEM_HAS_EPG            (LISTITEM_START + 138)
#define LISTITEM_VOTES              (LISTITEM_START + 139)
#define LISTITEM_STEREOSCOPIC_MODE  (LISTITEM_START + 140)
#define LISTITEM_IS_STEREOSCOPIC    (LISTITEM_START + 141)
#define LISTITEM_INPROGRESS         (LISTITEM_START + 142)
#define LISTITEM_HASRECORDING       (LISTITEM_START + 143)
#define LISTITEM_HASREMINDER        (LISTITEM_START + 144)
#define LISTITEM_CHANNEL_NUMBER     (LISTITEM_START + 145)
#define LISTITEM_IMDBNUMBER         (LISTITEM_START + 146)
#define LISTITEM_EPISODENAME        (LISTITEM_START + 147)
#define LISTITEM_IS_COLLECTION      (LISTITEM_START + 148)
#define LISTITEM_HASTIMERSCHEDULE   (LISTITEM_START + 149)
#define LISTITEM_TIMERTYPE          (LISTITEM_START + 150)
#define LISTITEM_EPG_EVENT_TITLE    (LISTITEM_START + 151)
#define LISTITEM_DATETIME           (LISTITEM_START + 152)
#define LISTITEM_USER_RATING        (LISTITEM_START + 153)
#define LISTITEM_TAG                (LISTITEM_START + 154)
#define LISTITEM_SET                (LISTITEM_START + 155)
#define LISTITEM_SETID              (LISTITEM_START + 156)
#define LISTITEM_IS_PARENTFOLDER    (LISTITEM_START + 157)
#define LISTITEM_MOOD               (LISTITEM_START + 158)
#define LISTITEM_CONTRIBUTORS       (LISTITEM_START + 159)
#define LISTITEM_CONTRIBUTOR_AND_ROLE (LISTITEM_START + 160)
#define LISTITEM_TIMERISACTIVE      (LISTITEM_START + 161)
#define LISTITEM_TIMERHASCONFLICT   (LISTITEM_START + 162)
#define LISTITEM_TIMERHASERROR      (LISTITEM_START + 163)

#define LISTITEM_ADDON_NAME         (LISTITEM_START + 164)
#define LISTITEM_ADDON_VERSION      (LISTITEM_START + 165)
#define LISTITEM_ADDON_CREATOR      (LISTITEM_START + 166)
#define LISTITEM_ADDON_SUMMARY      (LISTITEM_START + 167)
#define LISTITEM_ADDON_DESCRIPTION  (LISTITEM_START + 168)
#define LISTITEM_ADDON_DISCLAIMER   (LISTITEM_START + 169)
#define LISTITEM_ADDON_BROKEN       (LISTITEM_START + 170)
#define LISTITEM_ADDON_LIFECYCLE_TYPE (LISTITEM_START + 171)
#define LISTITEM_ADDON_LIFECYCLE_DESC (LISTITEM_START + 172)
#define LISTITEM_ADDON_TYPE         (LISTITEM_START + 173)
#define LISTITEM_ADDON_INSTALL_DATE (LISTITEM_START + 174)
#define LISTITEM_ADDON_LAST_UPDATED (LISTITEM_START + 175)
#define LISTITEM_ADDON_LAST_USED    (LISTITEM_START + 176)
#define LISTITEM_STATUS             (LISTITEM_START + 177)
#define LISTITEM_ENDTIME_RESUME     (LISTITEM_START + 178)
#define LISTITEM_ADDON_ORIGIN       (LISTITEM_START + 179)
#define LISTITEM_ADDON_NEWS         (LISTITEM_START + 180)
#define LISTITEM_ADDON_SIZE         (LISTITEM_START + 181)
#define LISTITEM_EXPIRATION_DATE    (LISTITEM_START + 182)
#define LISTITEM_EXPIRATION_TIME    (LISTITEM_START + 183)
#define LISTITEM_PROPERTY           (LISTITEM_START + 184)
#define LISTITEM_EPG_EVENT_ICON     (LISTITEM_START + 185)
#define LISTITEM_HASREMINDERRULE    (LISTITEM_START + 186)
#define LISTITEM_HASARCHIVE         (LISTITEM_START + 187)
#define LISTITEM_ISPLAYABLE         (LISTITEM_START + 188)
#define LISTITEM_FILENAME_NO_EXTENSION (LISTITEM_START + 189)
#define LISTITEM_CURRENTITEM        (LISTITEM_START + 190)
#define LISTITEM_IS_NEW             (LISTITEM_START + 191)
#define LISTITEM_DISC_TITLE         (LISTITEM_START + 192)
#define LISTITEM_IS_BOXSET          (LISTITEM_START + 193)
#define LISTITEM_TOTALDISCS         (LISTITEM_START + 194)
#define LISTITEM_RELEASEDATE        (LISTITEM_START + 195)
#define LISTITEM_ORIGINALDATE       (LISTITEM_START + 196)
#define LISTITEM_BPM                (LISTITEM_START + 197)
#define LISTITEM_UNIQUEID           (LISTITEM_START + 198)
#define LISTITEM_BITRATE            (LISTITEM_START + 199)
#define LISTITEM_SAMPLERATE         (LISTITEM_START + 200)
#define LISTITEM_MUSICCHANNELS      (LISTITEM_START + 201)
#define LISTITEM_IS_PREMIERE        (LISTITEM_START + 202)
#define LISTITEM_IS_FINALE          (LISTITEM_START + 203)
#define LISTITEM_IS_LIVE            (LISTITEM_START + 204)
#define LISTITEM_TVSHOWDBID         (LISTITEM_START + 205)
#define LISTITEM_ALBUMSTATUS        (LISTITEM_START + 206)
#define LISTITEM_ISAUTOUPDATEABLE   (LISTITEM_START + 207)
#define LISTITEM_VIDEO_HDR_TYPE     (LISTITEM_START + 208)

#define LISTITEM_END                (LISTITEM_START + 2500)

#define CONDITIONAL_LABEL_START       (LISTITEM_END + 1) // 37501
#define CONDITIONAL_LABEL_END         39999

// the multiple information vector
#define MULTI_INFO_START              40000
#define MULTI_INFO_END                99999
#define COMBINED_VALUES_START        100000

// listitem info Flags
// Stored in the top 8 bits of GUIInfo::m_data1
// therefore we only have room for 8 flags
#define INFOFLAG_LISTITEM_WRAP        (static_cast<uint32_t>(1 << 25))  // Wrap ListItem lookups
#define INFOFLAG_LISTITEM_POSITION    (static_cast<uint32_t>(1 << 26))  // ListItem lookups based on cursor position
#define INFOFLAG_LISTITEM_ABSOLUTE    (static_cast<uint32_t>(1 << 27))  // Absolute ListItem lookups
#define INFOFLAG_LISTITEM_NOWRAP      (static_cast<uint32_t>(1 << 28))  // Do not wrap ListItem lookups
#define INFOFLAG_LISTITEM_CONTAINER   (static_cast<uint32_t>(1 << 29))  // Lookup the item in given container
// clang-format on
