/***************************************************************************
                          iplook.h  -  description
                             -------------------
    begin                : Tue Apr 25 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPLOOK_H
#define IPLOOK_H

#include <kprocess.h>
#include <qstring.h>
#include <qobject.h>

/**
  *@author Frank Schwanz
  */
class MyHostItem;

class IPLook:public QObject
{
Q_OBJECT public:
  IPLook (QObject * parent, MyHostItem * hostitem);
  virtual ~IPLook ();
  void getIP ();
  MyHostItem *getHost ()
  {
    return host;
  };
private:			// Private attributes
  KProcess * proc;		// The Process
  MyHostItem *host;
  QString out;
  QString nextline (QString & in, int &index);
  public slots:			// Public slots
  /** Read Stdout and set IP */
  void IPLookStdout (KProcess * p, char *buffer, int n);
  /** Wird aufgerufen wenn der Process sich beendet */
  void onProcExit (KProcess * killedproc);
signals:			// Signals
  void isExited (IPLook * m);
};

#endif
