/***************************************************************************
                          komba2.cpp  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kdebug.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstatusbar.h>

// application specific includes
#include "komba2.h"
#include "komba2view.h"
#include "komba2doc.h"
#include "preferences.h"
#include "myktreelistitem.h"

#define ID_STATUS_MSG 1

Komba2App::Komba2App (QWidget *, const char *name, const char *option):
KMainWindow (0, name)
{
  canquit = true;
  waitforquit = false;
  config = kapp->config ();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar ();
  initActions ();
  initDocument (option);
  initView ();

  readOptions ();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  enableShareMountedMenu (false);
  enableShareUnmountedMenu (false);
  enableWorkgroupMenu (false);
  enableHostMenu (false);
}

Komba2App::~Komba2App ()
{

}

void
Komba2App::initActions ()
{
  fileNewWindow =
    new KAction (i18n ("New &Window"), 0, 0, this,
		 SLOT (slotFileNewWindow ()), actionCollection (),
		 "file_new_window");
  fileQuit =
    KStdAction::quit (this, SLOT (slotFileQuit ()), actionCollection ());
  fileOpenRecent =
    new RecentMounts (i18n ("Recent mounts"), 0, this,
		      SLOT (slotFileOpenRecent (int)), actionCollection (),
		      "recentmounts");
  viewToolBar =
    KStdAction::showToolbar (this, SLOT (slotViewToolBar ()),
			     actionCollection ());
  viewStatusBar =
    KStdAction::showStatusbar (this, SLOT (slotViewStatusBar ()),
			       actionCollection ());
  prefDialog =
    new KAction (i18n ("Configure"), 0, 0, this, SLOT (slotPreferences ()),
		 actionCollection (), "preferences");
  mount =
    new KAction (i18n ("Mount"), 0, 0, this, SLOT (slotMount ()),
		 actionCollection (), "mount");
  mount_to =
    new KAction (i18n ("Mount on ..."), 0, 0, this, SLOT (slotMountTo ()),
		 actionCollection (), "mount_to");
  unmount =
    new KAction (i18n ("Unmount"), 0, 0, this, SLOT (slotUnmount ()),
		 actionCollection (), "unmount");

  share_ask_for_password =
    new KToggleAction (i18n ("Ask for password"), 0, this,
		       SLOT (slotToggleAskForPassword ()),
		       actionCollection (), "share_ask_for_account");
  host_ask_for_password =
    new KToggleAction (i18n ("Ask for password"), 0, this,
		       SLOT (slotToggleAskForPassword ()),
		       actionCollection (), "host_ask_for_account");
  set_wgaccount =
    new KAction (i18n ("Set password"), 0, 0, this, SLOT (slotSetAccount ()),
		 actionCollection (), "wg_account");
  set_account =
    new KAction (i18n ("Set password"), 0, 0, this, SLOT (slotSetAccount ()),
		 actionCollection (), "set_account");
  set_hostaccount =
    new KAction (i18n ("Set password"), 0, 0, this, SLOT (slotSetAccount ()),
		 actionCollection (), "host_account");
  set_shareaccount =
    new KAction (i18n ("Set password"), 0, 0, this, SLOT (slotSetAccount ()),
		 actionCollection (), "share_account");
  send_message =
    new KAction (i18n ("Send message"), 0, 0, this, SLOT (slotSendMessage ()),
		 actionCollection (), "send_message");
  host_send_message =
    new KAction (i18n ("Send message"), 0, 0, this, SLOT (slotSendMessage ()),
		 actionCollection (), "host_send_message");
  wg_send_message =
    new KAction (i18n ("Send message"), 0, 0, this, SLOT (slotSendMessage ()),
		 actionCollection (), "wg_send_message");
  net_send_message =
    new KAction (i18n ("Send message"), 0, 0, this, SLOT (slotSendMessage ()),
		 actionCollection (), "net_send_message");
  net_rescan =
    new KAction (i18n ("Reload"), 0, 0, this, SLOT (slotRescan ()),
		 actionCollection (), "net_rescan");
  wg_rescan =
    new KAction (i18n ("Reload"), 0, 0, this, SLOT (slotRescan ()),
		 actionCollection (), "wg_rescan");
  host_rescan =
    new KAction (i18n ("Reload"), 0, 0, this, SLOT (slotRescan ()),
		 actionCollection (), "host_rescan");
  explore =
    new KAction (i18n ("Explore"), 0, 0, this, SLOT (slotExplore ()),
		 actionCollection (), "explore");
  rescan =
    new KAction (i18n ("Reload"), 0, 0, this, SLOT (slotRescan ()),
		 actionCollection (), "rescan");
  ping =
    new KAction (i18n ("Ping"), 0, this, SLOT (slotPing ()),
		 actionCollection (), "ping");
  traceroute =
    new KAction (i18n ("Traceroute"), 0, this, SLOT (slotTraceroute ()),
		 actionCollection (), "traceroute");
  mountall =
    new KAction (i18n ("MountAll"), 0, this, SLOT (slotMountAll ()),
		 actionCollection (), "mountall");
  unmountall =
    new KAction (i18n ("UnMountAll"), 0, this, SLOT (slotUnmountAll ()),
		 actionCollection (), "unmountall");

  rescan->setStatusText (i18n ("Deletes all items in it and rescan"));

  fileOpenRecent->setStatusText (i18n ("Mount a recently mounted share"));
  fileNewWindow->setStatusText (i18n ("Opens a new application window"));
  fileQuit->setStatusText (i18n ("Quits the application"));
  viewToolBar->setStatusText (i18n ("Enables/disables the toolbar"));
  viewStatusBar->setStatusText (i18n ("Enables/disables the statusbar"));
  // use the absolute path to your komba2ui.rc file for testing purpose in createGUI();
  createGUI ();
}


void
Komba2App::initStatusBar ()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar ()->insertItem (i18n ("Ready."), ID_STATUS_MSG);
}

void
Komba2App::initDocument (const char *option)
{
  int opt = Komba2Doc::optNothing;
  if (option)
    {
      if (option[0] == 'm')
	opt = Komba2Doc::optMount;
      if (option[0] == 'u')
	opt = Komba2Doc::optUnmount;
    }
  doc = new Komba2Doc (this, "KombaDoc", opt);
  doc->newDocument ();
}

void
Komba2App::initView ()
{
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.
  view = new Komba2View (this);
  doc->addView (view);
  setCentralWidget (view);
}

void
Komba2App::openDocumentFile (const KURL &)
{
  slotStatusMsg (i18n ("Opening file..."));

  slotStatusMsg (i18n ("Ready."));
}


Komba2Doc *
Komba2App::getDocument () const
{
  return doc;
}

void
Komba2App::saveOptions ()
{
  config->setGroup ("General Options");
  config->writeEntry ("Geometry", size ());
  config->writeEntry ("Show Toolbar", viewToolBar->isChecked ());
  config->writeEntry ("Show Statusbar", viewStatusBar->isChecked ());
  config->writeEntry ("ToolBarPos", (int) toolBar ("mainToolBar")->barPos ());
  fileOpenRecent->saveEntries (config, "Recent Files");
  if (getDocument ())
    config->writeEntry ("ViewSizes", getDocument ()->getViewSizes ());
}


void
Komba2App::readOptions ()
{

  config->setGroup ("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry ("Show Toolbar", true);
  viewToolBar->setChecked (bViewToolbar);
  slotViewToolBar ();

  bool bViewStatusbar = config->readBoolEntry ("Show Statusbar", true);
  viewStatusBar->setChecked (bViewStatusbar);
  slotViewStatusBar ();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos =
    (KToolBar::BarPosition) config->readNumEntry ("ToolBarPos",
						  KToolBar::Top);
  toolBar ("mainToolBar")->setBarPos (toolBarPos);

  // initialize the recent file list
  fileOpenRecent->loadEntries (config, "Recent Files");
//      if (getDocument())
//              getDocument()->initRecentHosts();


  QSize size = config->readSizeEntry ("Geometry");
  if (!size.isEmpty ())
    {
      resize (size);
    }
  QValueList < int >viewsize = config->readIntListEntry ("ViewSizes");
  if (getDocument () && !viewsize.isEmpty ())
    getDocument ()->setViewSizes (viewsize);
}

void
Komba2App::saveProperties (KConfig *)
{
}


void
Komba2App::readProperties (KConfig *)
{
}

bool Komba2App::queryClose ()
{
  // last Window Unmount all Shares
  if (memberList->count () == 1)
    {
      if (!waitForQuit ())
	{
	  bool
	    b =
	    getDocument ()->
	    UnmountAll ();
	  setCanQuit (!b);
	  setWaitForQuit (b);
	}
    }
  return doc->saveModified ();
}

bool Komba2App::queryExit ()
{
  saveOptions ();
  return canQuit ();
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void
Komba2App::slotFileNewWindow ()
{
  slotStatusMsg (i18n ("Opening a new application window..."));

  Komba2App *new_window = new Komba2App ();
  new_window->show ();

  slotStatusMsg (i18n ("Ready."));
}

void
Komba2App::slotFileQuit ()
{
  slotStatusMsg (i18n ("Exiting..."));
  saveOptions ();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow *w;
  if (memberList)
    {
      for (w = memberList->first (); w != 0; w = memberList->first ())
	{
	  // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
	  // the window and the application stay open.
	  if (!w->close ())
	    break;
	}
    }
}


void
Komba2App::slotViewToolBar ()
{
  slotStatusMsg (i18n ("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if (!viewToolBar->isChecked ())
    {
      toolBar ("mainToolBar")->hide ();
    }
  else
    {
      toolBar ("mainToolBar")->show ();
    }

  slotStatusMsg (i18n ("Ready."));
}

void
Komba2App::slotViewStatusBar ()
{
  slotStatusMsg (i18n ("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if (!viewStatusBar->isChecked ())
    {
      statusBar ()->hide ();
    }
  else
    {
      statusBar ()->show ();
    }

  slotStatusMsg (i18n ("Ready."));
}


void
Komba2App::slotStatusMsg (const QString & text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar ()->clear ();
  statusBar ()->changeItem (text, ID_STATUS_MSG);
}

void
Komba2App::slotPreferences ()
{
  if (getDocument ())
    {
      Preferences *pref = new Preferences ((QWidget *) this, "Prefs",
					   getDocument ()->options ());
      pref->exec ();
    }
}

/** Mount a share if a share is selected in view */
void
Komba2App::slotMount ()
{
  if (getDocument ())
    disableRescan ();
  getDocument ()->mountAktShare ();
}

/** Mount a share if a share is selected in view */
void
Komba2App::slotMountTo ()
{
  if (getDocument ())
    {
      disableRescan ();
      getDocument ()->mountAktShare (true);
    }
}

/** Mount a share if a share is selected in view */
void
Komba2App::slotUnmount ()
{
  if (getDocument ())
    {
      disableRescan ();
      getDocument ()->unmountAktShare ();
    }
}

void
Komba2App::slotSetAccount ()
{
  if (getDocument ())
    getDocument ()->setAccount ();

}

void
Komba2App::slotSendMessage ()
{
  if (getDocument ())
    getDocument ()->sendMessage ();
}

void
Komba2App::slotRescan ()
{
  if (getDocument ())
    {
      disableRescan ();
      getDocument ()->rescan ();
    }
}

void
Komba2App::enableNetworkMenu (bool enable)
{
  rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  net_rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  send_message->setEnabled (enable);
  net_send_message->setEnabled (enable);
}

void
Komba2App::enableWorkgroupMenu (bool enable)
{
  set_wgaccount->setEnabled (enable);
  set_account->setEnabled (enable);
  wg_rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  send_message->setEnabled (enable);
  wg_send_message->setEnabled (enable);
}

void
Komba2App::enableHostMenu (bool enable)
{
  set_hostaccount->setEnabled (enable);
  set_account->setEnabled (enable);
  host_rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  rescan->setEnabled (enable && !getDocument ()->hasOpenProcesses ());
  send_message->setEnabled (enable);
  host_send_message->setEnabled (enable);
  ping->setEnabled (enable);
  traceroute->setEnabled (enable);
}

void
Komba2App::enableShareMountedMenu (bool enable)
{
  set_shareaccount->setEnabled (enable);
  set_account->setEnabled (enable);
  unmount->setEnabled (enable);
  explore->setEnabled (enable);
}

void
Komba2App::enableShareUnmountedMenu (bool enable)
{
  set_shareaccount->setEnabled (enable);
  set_account->setEnabled (enable);
  mount->setEnabled (enable);
  mount_to->setEnabled (enable);
}

void
Komba2App::slotExplore ()
{
  getDocument ()->explore ();
}

void
Komba2App::slotFileOpenRecent (int id)
{
  slotStatusMsg (i18n ("Mount Share..."));
  MyShareItem *share =
    fileOpenRecent->getShareItem (getDocument ()->getNetwork (), id);
  if ((share) && (share->getMountPath ().length () == 0))
    share->mount (fileOpenRecent->getMountPath (id));
  slotStatusMsg (i18n ("Ready."));
}

void
Komba2App::popupMenu (const QString mmenu, const QPoint & p)
{
  KPopupMenu *pop = (KPopupMenu *) factory ()->container (mmenu, this);
  if (pop)
    pop->popup (p);
}

void
Komba2App::slotPing ()
{
  getDocument ()->ping ();
}

void
Komba2App::slotTraceroute ()
{
  getDocument ()->traceroute ();
}

void
Komba2App::slotMountAll ()
{
  getDocument ()->MountAll ();
}

void
Komba2App::slotUnmountAll ()
{
  getDocument ()->UnmountAll (true);
}

void
Komba2App::slotToggleAskForPassword ()
{
  getDocument ()->toggleAskForPassword ();
}

void
Komba2App::disableRescan ()
{
  net_rescan->setEnabled (false);
  rescan->setEnabled (false);
  wg_rescan->setEnabled (false);
  host_rescan->setEnabled (false);
}

void
Komba2App::addFileOpenRecent (MyShareItem * item)
{
  fileOpenRecent->addRecentMount (item);
}

void
Komba2App::setHostAskForPassword (bool b)
{
  kdDebug (7199) << "host_ask_for_password=" << b << endl;
  host_ask_for_password->setChecked (b);
}

void
Komba2App::setShareAskForPassword (bool b)
{
  kdDebug (7199) << "share_ask_for_password=" << b << endl;
  share_ask_for_password->setChecked (b);
}
