/***************************************************************************
                          socketserver.h  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOCKETSERVER_H
#define SOCKETSERVER_H

#include <assert.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#include <qtimer.h>
#include <qsocketnotifier.h>
#include <qobject.h>
#include <qptrlist.h>
#include "nmbhdr.h"


/**Nimmt Rckrufe entgegen und gibt die Informationen ans Hauptprogramm weiter
  *@author 
  */

struct ipcount
{
  unsigned short counter;
  u_long ip;
};

class Socketserver:public QObject
{
  Q_OBJECT private:int socket_client;
  void sock_unblock (int s);
  unsigned short counter;
  int todocount;
  void trim (char *str);
    QPtrList < struct ipcount >*iplist;
  QTimer *timer;
  int timercount;
public:
    Socketserver (QObject * parent = 0, const char *name = 0);
   virtual ~Socketserver ();
  void getNMBInfo (u_long ip, unsigned short oldcount);
  /** Gibt socket zurck */
  int getsocket ();
  QSocketNotifier *notify;
  void clearIpList ()
  {
    iplist->clear ();
    counter = 0;
  };
signals:
  void insert_host (char *machine, char *workgroup, u_long ip, bool ismaster);
  /**  */
  void isExited (Socketserver * s);

  public slots:			// Public slots
  /** Diese Funktion nimmt die eingehenden Rufe an 
			und verarbeitet sie. */
  void incomming_request ();
  /**  */
  void timerOut ();
protected:			// Protected methods
  /**  sucht die IP fr angegebenen counter  */
  u_long getIP (unsigned short c, bool isback = false);
};
#endif
