/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configdialogimpl.h"

#include <klocale.h>
#include <kicondialog.h>
#include <kiconloader.h>
#include <qlineedit.h>
#include <kshell.h>
#include <qmessagebox.h>
#include <kkeybutton.h>
#include <kcolorbutton.h>
#include <qslider.h>

#include "menulistviewitem.h"


ConfigDialogImpl::ConfigDialogImpl(QWidget* parent, const char* name, WFlags fl)
	: ConfigDialog(parent,name,true,fl),
		sysTray(this,"SysTray"),
		Shortcut(this,"Shortcut"),
		configChanged(false)
{
	//activate the systray icons
	sysTray.setPixmap(sysTray.loadIcon("kommando"));
	sysTray.show();
	
	//initialize the form
	shortcutFrame->hide();
	colorFrame->hide();
	menuListView->setSorting(-1);

	new QListBoxPixmap(listBox,MainBarIcon("kommando",KIcon::SizeLarge),"Menu");
	new QListBoxPixmap(listBox,MainBarIcon("configure_shortcuts",KIcon::SizeLarge),"Shortcuts");
	new QListBoxPixmap(listBox,MainBarIcon("colors",KIcon::SizeLarge),"Appearance");
	listBox->setSelected(listBox->topItem(),true);

	//get the configuration
	Config& config = Config::getSingleton();
	config.setConfigPath(KShell::homeDir("")+"/.kommandorc");
	if(!config.readConfigFile()){
		QMessageBox mb(i18n("Could not read configfile"),i18n(	"The configfile could not be read."
																"\nKommando is starting the configuration dialog "
																"with default values..."),
										QMessageBox::Information,
										QMessageBox::Ok,
										QMessageBox::NoButton,
										QMessageBox::NoButton);
		mb.exec();
		config.setDefaultValues(menuListView);
		config.fromConfigDlg(menuListView);
		config.toKommandoMenu(&kommandoWin);
		configChanged=true;
		show();
	} else {
		config.toConfigDlg(menuListView);
		config.toKommandoMenu(&kommandoWin);
	}
	kColorButton1->setColor(config.tintColor());
	slider1->setValue(config.opacity()*100);
	//set upshortcut(s)
	Shortcut.insert("Toggle",
					i18n("Toggle"),
					i18n("This shortcut toggles the visibility of the Kommando menu"),
					KShortcut(config.Shortcut()),
					KShortcut(config.Shortcut()),
					&kommandoWin,
					SLOT( slotGlobAccel() ) );
					Shortcut.setEnabled(true);
					Shortcut.updateConnections();
	kKeyButton1->setText(config.Shortcut());
	connect(kKeyButton1,SIGNAL(capturedShortcut(const KShortcut&)),this,SLOT(slotShortcutChanged(const KShortcut&)) );
}

ConfigDialogImpl::~ConfigDialogImpl()
{
}

/*$SPECIALIZATION$*/
void ConfigDialogImpl::slotCommandoTyped(const QString& commando)
{
	menuListView->selectedItem()->setText(1,commando);
	configChanged=true;
	buttonApply->setEnabled(true);
	buttonReset->setEnabled(true);
}

void ConfigDialogImpl::slotMenuViewClicked(QListViewItem* item)
{
	MenuListViewItem* temp = static_cast<MenuListViewItem*>(item);
	if(item==NULL){
		iconButton->resetIcon();
		iconButton->setEnabled(false);
		commandoEdit->setEnabled(false);
		remove->setEnabled(false);
	} else {
		if(temp->iconPath()!=NULL){
			iconButton->setIcon(temp->iconPath());
		} else {
			iconButton->resetIcon();
		}
		if(temp->type()==MenuListViewItem::Button){
			commandoEdit->setEnabled(true);
			commandoEdit->setText(temp->text(1));
		} else {
			commandoEdit->setEnabled(false);
		}
		iconButton->setEnabled(true);
		remove->setEnabled(true);
	}
}

void ConfigDialogImpl::slotNewIcon()
{
	MenuListViewItem* temp = static_cast<MenuListViewItem*>(menuListView->selectedItem());
	temp->setIcon(iconButton->icon());
	configChanged=true;
	buttonApply->setEnabled(true);
	buttonReset->setEnabled(true);
}

void ConfigDialogImpl::slotRemoveClicked()
{
	QListViewItem* temp = menuListView->selectedItem()->nextSibling();
	delete menuListView->selectedItem();
	menuListView->setSelected(temp,true);
	if(temp==NULL){
		remove->setEnabled(false);
	}
	configChanged=true;
	buttonApply->setEnabled(true);
	buttonReset->setEnabled(true);
}

void ConfigDialogImpl::slotAddButtonClicked()
{
	QListViewItem* parent=NULL;
	QListViewItem* newItem;
	MenuListViewItem* temp =static_cast<MenuListViewItem*>(menuListView->selectedItem());
	
	if(temp!=NULL){
		if(temp->type()==MenuListViewItem::Menu){
			parent=temp;
		} else if(temp->parent()!=NULL){
			parent=temp->parent();
		}
	}
	if(parent!=NULL){
		newItem=new MenuListViewItem(parent,"Button",MenuListViewItem::Button);
	} else {
		newItem=new MenuListViewItem(menuListView,"Button",MenuListViewItem::Button);
	}
	menuListView->setSelected(newItem,true);
	configChanged=true;
	buttonApply->setEnabled(true);
	buttonReset->setEnabled(true);
}

void ConfigDialogImpl::slotAddMenuClicked()
{
	MenuListViewItem* temp =static_cast<MenuListViewItem*>(menuListView->selectedItem());
	QListViewItem* parent=NULL;
	if(temp!=NULL){
		if(temp->type()==MenuListViewItem::Menu){
			parent=temp;
		} else if(temp->parent()!=NULL){
			parent=temp->parent();
		}
	}
	QListViewItem* newItem;
	if(parent!=NULL){
		newItem=new MenuListViewItem(parent,"Menu",MenuListViewItem::Menu);
	} else {
		newItem=new MenuListViewItem(menuListView,"Menu",MenuListViewItem::Menu);
	}
	menuListView->setSelected(newItem,true);
	newItem->setOpen(true);
	configChanged=true;
	buttonApply->setEnabled(true);
	buttonReset->setEnabled(true);
}

void ConfigDialogImpl::slotListBoxClicked(QListBoxItem* item)
{
	if(item!=NULL){
		if(item->text()=="Menu"){
			shortcutFrame->hide();
			colorFrame->hide();
			MenuFrame->show();
		} else if(item->text()=="Shortcuts"){
			MenuFrame->hide();
			colorFrame->hide();
			shortcutFrame->show();
		} else if(item->text()=="Appearance"){
			MenuFrame->hide();
			colorFrame->show();
			shortcutFrame->hide();
		}
	}
}

void ConfigDialogImpl::slotResetClicked()
{
		menuListView->clear();
		Config::getSingleton().toConfigDlg(menuListView);
		commandoEdit->setEnabled(false);
		
		configChanged=false;
		buttonApply->setEnabled(false);
		buttonReset->setEnabled(false);
}

void ConfigDialogImpl::slotApplyClicked()
{
		Config::getSingleton().fromConfigDlg(menuListView);
		Config::getSingleton().writeConfigFile();
		Config::getSingleton().toKommandoMenu(&kommandoWin);
		
		configChanged=false;
		buttonApply->setEnabled(false);
		buttonReset->setEnabled(false);
}

void ConfigDialogImpl::reject()
{
	if(configChanged){
		slotResetClicked();
	}
	hide();
}

void ConfigDialogImpl::accept()
{
	if(configChanged){
		slotApplyClicked();
	}
	hide();
}

void ConfigDialogImpl::slotShortcutChanged(const KShortcut & cut )
{
	if(!KKeyChooser::checkGlobalShortcutsConflict(cut,true,this)){
		Shortcut.setShortcut("Toggle",cut);
		Shortcut.updateConnections();
		kKeyButton1->setText(cut.toString());
		Config::getSingleton().setShortcut(cut.toString());
		configChanged=true;
	}
}

void ConfigDialogImpl::slotColorButtonClicked(const QColor& color)
{
	Config::getSingleton().setTintColor(color);
	configChanged=true;
	buttonApply->setEnabled(true);
}

void ConfigDialogImpl::slotOpacitySliderChanged( int value )
{
	Config::getSingleton().setOpacity(static_cast<float>(value)/100.0f);
	configChanged=true;
	buttonApply->setEnabled(true);
}

#include "configdialogimpl.moc"



