/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel   *
 *   the_docter@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "menulistviewitem.h"

#include <kiconloader.h>

MenuListViewItem::MenuListViewItem(QListViewItem* parent, QListViewItem* after, QString col1, ItemType type, QString iconPath, QString col2)
	: QListViewItem(parent,after,col1,col2),mType(type)
{
	setIconPath(iconPath);
}

MenuListViewItem::MenuListViewItem(QListView* parent, QListViewItem* after, QString col1, ItemType type, QString iconPath, QString col2)
	: QListViewItem(parent,after,col1,col2),mType(type)
{
	setIconPath(iconPath);
}

MenuListViewItem::~MenuListViewItem()
{
}

void MenuListViewItem::setIconPath(const QString& path)
{
	mIconPath = path;
	if(mIconPath!=NULL)
	{
		setPixmap(0,SmallIcon(mIconPath));
	}
}

MenuListViewItem * MenuListViewItem::lastChild( )
{
	MenuListViewItem* temp=static_cast<MenuListViewItem*>(firstChild());
	MenuListViewItem* child=NULL;
	while(temp!=NULL){
		child=temp;
		temp=static_cast<MenuListViewItem*>(temp->nextSibling());
	}
	return child;
}
