/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLISTVIEWITEMDUPS_H_
#define _KLISTVIEWITEMDUPS_H_

#include "klistviewitemsingle.h" // for enum FILTER

class KListView;
class KFileItemExt;

class KListViewItemDups : public QListViewItem
{
	public:
		KListViewItemDups( KListView *parent, KFileItemExt *_item,
			const QString &parent_url1_str, const QString &parent_url2_str );
		~KListViewItemDups();

		QString key( int column, bool ) const;

		void paintCell ( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );

		bool isDuplicatesPair();
		void updateColor();

		void addFilter( FILTER filter );
		void removeFilter( FILTER filter );
		void setVisibility();

		KFileItemExt *item;

	private:
		KURL m_parent_url1, m_parent_url2;
		QColor m_color, m_my_blue;
		int m_filter;

		bool compareKURLs( const KURL &url1, const KURL &url2, int parent_dir_of_first );
};

#endif
