/***************************************************************************
 *   Copyright (C) 2005-2007 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLISTVIEWITEMDUPS_H_
#define _KLISTVIEWITEMDUPS_H_

#include "klistviewitemsingle.h" // for enum FILTER

class KListView;
class KFileItemExt;

class KListViewItemDups : public QListViewItem
{
	public:
		KListViewItemDups( KListView *parent, KFileItemExt *_item );
		~KListViewItemDups();

		QString key( int column, bool ) const;

		void paintCell ( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );

		void setUseColor( bool use_color );
		bool useColor();

		bool isDuplicatesPair();
		void updateColor();

		void addFilter( FILTER filter );
		void removeFilter( FILTER filter );
		void setVisibility();

		KFileItemExt *item;

	private:
		QColor m_color, m_my_blue;
		int m_filter;
		bool m_use_color;
};

#endif
