/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kglobal.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include <qlabel.h>
#include <qtoolbutton.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qdir.h>

#include "kompileuserinstall.h"

KompileUserInstall::KompileUserInstall(QWidget *parent, const char *name)
    :KompileUserInstallBase(parent, name)
{
    pxmWarning->setPixmap(KGlobal::iconLoader()->loadIcon("messagebox_warning", KIcon::NoGroup, 48));
    btnBrowse->setPixmap(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));    
    btnInstall->setPixmap(KGlobal::iconLoader()->loadIcon("exec", KIcon::Desktop, 22));
    btnAbort->setPixmap(KGlobal::iconLoader()->loadIcon("cancel", KIcon::Desktop, 22));

    selected = -1;
}

void KompileUserInstall::bgUserChoice_clicked(int)
{
    gbDirectory->setEnabled(bgUserChoice->selectedId() == 2);
}

void KompileUserInstall::btnAbort_clicked()
{
    this->reject();
}

void KompileUserInstall::btnBrowse_clicked()
{
   txtPath->setText(KFileDialog::getExistingDirectory(txtPath->text(), this, "Select installation directory"));
}

int KompileUserInstall::getInstallationMethod()
{
    return selected;
}

QString KompileUserInstall::getInstallationDirectory()
{
   return txtPath->text();
}

void KompileUserInstall::btnInstall_clicked()
{
    selected = bgUserChoice->selectedId();

    if (selected == 2) 
    {
        QFileInfo file(txtPath->text());

        if (!file.exists()) 
        {
            QDir  * dir = new QDir();
            if (!dir->mkdir(txtPath->text()))
            {
                KMessageBox::error(this, "Kompile is unable to create the specified destination directory.\nYou must specify a writable directory for binaries install.", "Invalid Directory Selected");
            }
          
            delete dir;
            selected = -1;
            return;
        }
        
        if (!file.isDir()) 
        {
            KMessageBox::error(this, "The installation path selected seems to be a file.\nYou must specify a writable directory for binaries install.", "Invalid Directory Selected");
            selected = -1;
            return;
        }

        if (!file.isWritable()) 
        {
           KMessageBox::error(this, "You don't have permissions to write into the installation path selected.\nYou must specify a writable directory for binaries install.", "Invalid Directory Selected");
            selected = -1;
            return;
        }
    }

    this->accept();
}


#include "kompileuserinstall.moc"
