/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOMPILEWIDGET_H_
#define _KOMPILEWIDGET_H_

#include "kompilewidgetbase.h"
#include "kompile.h"

#include <qprocess.h>
#include <qstringlist.h>
#include <qtimer.h>

class Kompile;

class KompileWidget : public KompileWidgetBase
{
    Q_OBJECT
    Kompile * parent;
    QString tarball;
    QProcess * process;
    int step;
    bool do_uninstall;
    int installation_type;
    QString user_dir;
    QTimer * timer;
    int seconds_left;
    
    void decompress();
    void configure();
    void make();
    void install();
    void uninstall();

public:
    KompileWidget(QString& tarball, bool uninstall = TRUE, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~KompileWidget();
    /*$PUBLIC_FUNCTIONS$*/
    void compileAndInstall();
    bool removeSources();
    

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void btnDetails_clicked();
    virtual void processReadFromStdout();
    virtual void btnAbout_clicked();
    virtual void btnAbort_clicked();
    virtual void txtConsole_textChanged();
    virtual void processReadFromStderr();
    virtual void processExited();
    virtual void autoclose_timeout();
    

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

