/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kdialogbase.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kpushbutton.h>

#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlineedit.h>

#include "kompilesetupgeneral.h"

KompileSetupGeneral::KompileSetupGeneral(QWidget *parent, const char *name)
    :KompileSetupGeneralWidgetBase(parent, name)
{
  btnSoundNoErrors->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnSoundFails->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));

  KConfig * config_load = KGlobal::config();
  config_load->setGroup("General");

  if (config_load->readEntry("kde_integration_type", "standalone") == "standalone")
    bgIntegration->setButton(1);
  else
    bgIntegration->setButton(0);


  if (config_load->readEntry("autoclose_enabled", "false") == "true")
  {
    chkAutoclose->setChecked(TRUE);
  }

  QString num(config_load->readEntry("autoclose_seconds", "20"));
  txtAutocloseSeconds->setValue(num.toInt());

  QString sounds_noerrors = config_load->readEntry("sound_noerrors", "").stripWhiteSpace();
  QString sounds_fails = config_load->readEntry("sound_fails", "").stripWhiteSpace();

  txtSoundNoErrors->setText(sounds_noerrors);
  txtSoundFails->setText(sounds_fails);

  if (sounds_noerrors.length() != 0 || sounds_fails.length() != 0)
    gbSounds->setChecked(TRUE);

  config_load->setGroup("Notification Messages");
  if (config_load->readEntry("ask_exit", "") != "")
  {
    chkAskExit->setChecked(TRUE);
  }
}

void KompileSetupGeneral::btnSoundNoErrors_clicked()
{
  QString sounds_noerrors = KFileDialog::getOpenFileName(locate("sound", "KDE_Notify.wav"), "*.wav *.ogg *.mp3 *.mid|Sound files", this, "Installation/Uninstallation Sound");

  if (sounds_noerrors)
    txtSoundNoErrors->setText(sounds_noerrors);
}

void KompileSetupGeneral::gbSounds_toggled(bool toggled)
{
  if (toggled && txtSoundNoErrors->text().stripWhiteSpace().length() == 0 && txtSoundFails->text().stripWhiteSpace().length() == 0)
  {
    QString sounds_noerrors = locate("sound", "KDE_Notify.wav");
    QString sounds_fails = locate("sound", "KDE_Error_1.ogg");

    txtSoundNoErrors->setText(sounds_noerrors);
    txtSoundFails->setText(sounds_fails);
  }
}

void KompileSetupGeneral::btnSoundFails_clicked()
{
  QString sounds_fails = KFileDialog::getOpenFileName(locate("sound", "KDE_Error_1.ogg"), "*.wav *.ogg *.mp3 *.mid|Sound files", this, "Failed Installation/Uninstallation Sound");

  if (sounds_fails)
    txtSoundFails->setText(sounds_fails);
}





#include "kompilesetupgeneral.moc"
