/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kaboutapplication.h>
#include <kuser.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <kio/job.h>
#include <kprocess.h>
#include <khelpmenu.h>
#include <kpushbutton.h>
#include <ksystemtray.h>

#include <qlabel.h>
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qpoint.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <qdialog.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qsound.h>

#include "kompilewidget.h"
#include "kompileinfowidget.h"
#include "kompileuserinstall.h"

KompileWidget::KompileWidget(KConfig * profile, bool uninstall, QWidget* parent, const char* name, WFlags fl)
    : KompileWidgetBase(parent,name,fl)
{
  this->do_uninstall = uninstall;
  this->parent = (KDialogBase *) parent;
  this->status = STATUS_INITIALIZING;
  this->finish_timer = NULL;
  this->profile = profile;
  this->process = NULL;
  this->operation_time = 0;
  this->tarball = profile->readEntry("tarball", "");

  gbConsole->hide();
  parent->adjustSize();

  pbProgress->setProgress(0);

  pxmInstallation->setPixmap(KGlobal::iconLoader()->loadIcon("kpackage", KIcon::Desktop, 128));
  pxmDecompress->setPixmap(KGlobal::iconLoader()->loadIcon("ark", KIcon::MainToolbar, 22, KIcon::DisabledState));
  pxmConfigure->setPixmap(KGlobal::iconLoader()->loadIcon("configure", KIcon::MainToolbar, 22, KIcon::DisabledState));
  btnAbort->setIconSet(KGlobal::iconLoader()->loadIconSet("button_cancel", KIcon::MainToolbar));
  btnDetails->setIconSet(KGlobal::iconLoader()->loadIconSet("2rightarrow", KIcon::MainToolbar));
  btnHelp->setIconSet(KGlobal::iconLoader()->loadIconSet("help", KIcon::MainToolbar));
  btnSuspend->setIconSet(KGlobal::iconLoader()->loadIconSet("player_pause", KIcon::MainToolbar));
  btnShowReadme->setIconSet(KGlobal::iconLoader()->loadIconSet("readme", KIcon::MainToolbar));
  btnShowInstall->setIconSet(KGlobal::iconLoader()->loadIconSet("package_applications", KIcon::MainToolbar));
  btnShowChangelog->setIconSet(KGlobal::iconLoader()->loadIconSet("log", KIcon::MainToolbar));

  KHelpMenu *helpMenu = new KHelpMenu(this, KGlobal::instance()->aboutData(), false);

  btnHelp->setPopup((QPopupMenu*) helpMenu->menu());

  KUser * whoami = new KUser();
  installation_type = KompileUserInstall::FORCECONTINUE;
  if (!whoami->isSuperUser())
  {
    QString simple_user_install_mode = profile->readEntry("simple_user_install_mode", "");

    if (simple_user_install_mode.isEmpty() || simple_user_install_mode == "ask")
    {
      KompileUserInstall * user_install = new KompileUserInstall( this );
      user_install->setModal(TRUE);
      user_install->exec();
      txtConsole->setText(txtConsole->text() + tr2i18n("User hasn't privileges for package installation. Need more privilegies...<br>"));

      if (user_install->result() == QDialog::Rejected)
      {
        this->parent->cancel();
      }

      installation_type = user_install->getInstallationMethod();
      if (installation_type == KompileUserInstall::USERINSTALLATION)
        user_dir = user_install->getInstallationDirectory();

      delete user_install;
    }
    else
    {
      if (simple_user_install_mode == "su")
      {
        installation_type = KompileUserInstall::REQUESTROOOTPASSWORD;
      }
      else if (simple_user_install_mode == "dir")
      {
        installation_type = KompileUserInstall::USERINSTALLATION;
        user_dir = profile->readEntry("simple_user_install_path", "~/");
      }
      else
      {
        installation_type = KompileUserInstall::FORCECONTINUE;
      }
    }

    if (installation_type == KompileUserInstall::REQUESTROOOTPASSWORD)
    {
      txtConsole->setText(txtConsole->text() + tr2i18n("Perform super user installation (Ask user root password)...<br>"));
    }
    else if (installation_type == KompileUserInstall::FORCECONTINUE)
    {
      txtConsole->setText(txtConsole->text() + tr2i18n("Try install with my user privileges (Probably get installation error)...<br>"));
    }
    else
    {
      txtConsole->setText(txtConsole->text() + tr2i18n("Perform simple user installation (Ask user writable destination directory)...<br>"));
      lblTaskStatus->setText(tr2i18n("<b>Installation status (simple user)</b>:"));
    }
  }

  delete whoami;

  if (!do_uninstall)
  {
    pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("make_kdevelop", KIcon::MainToolbar, 22, KIcon::DisabledState));
    pxmInstall->setPixmap(KGlobal::iconLoader()->loadIcon("exec", KIcon::MainToolbar, 22, KIcon::DisabledState));
    if (installation_type == KompileUserInstall::USERINSTALLATION)
      lblTaskStatus->setText(tr2i18n("<b>Installation status (simple user)</b>:"));
    else
      lblTaskStatus->setText(tr2i18n("<b>Installation status (super user)</b>:"));
  }
  else
  {
    pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::MainToolbar, 22, KIcon::DisabledState));
    pxmInstall->hide();
    lblMakeInstall->hide();
    lblMake->setText(tr2i18n("Uninstall binaries"));
    QToolTip::add(btnAbort, tr2i18n("Abort uninstallation"));
    gbProgress->setTitle(tr2i18n("Total Uninstallation Progress"));
    pbProgress->setTotalSteps(75);

    lblInstallStatusLabel->setText(tr2i18n("Uninstall status"));
    lblInstallTimeLabel->setText(tr2i18n("Uninstall operation time:"));
    if (installation_type == KompileUserInstall::USERINSTALLATION)
      lblTaskStatus->setText(tr2i18n("<b>Uninstallation status (simple user)</b>:"));
    else
      lblTaskStatus->setText(tr2i18n("<b>Uninstallation status (super user)</b>:"));
  }

  KConfig * config_load = KGlobal::config();
  config_load->setGroup("General");

  if (config_load->readEntry("autoclose_enabled", "false") == "true")
  {
    chkAutoclose->setChecked(TRUE);
  }

  QToolTip::add(chkAutoclose, "Automatic close Kompile in " + config_load->readEntry("autoclose_seconds", "20") + " seconds after installation finish");
  QString num(config_load->readEntry("autoclose_seconds", "20"));
  this->seconds_left = num.toInt();

  QStringList tokens = QStringList::split("/", this->tarball);
  parent->setCaption(tokens[tokens.count() - 1]);
  gbConsole->hide();
  adjustSize();
  parent->adjustSize();
  compileAndInstall();
}


KompileWidget::~KompileWidget()
{}

void KompileWidget::btnDetails_clicked()
{
  if (!gbConsole->isVisible())
  {
    btnDetails->setText(tr2i18n("Hide &Details"));
    QToolTip::add(btnDetails, tr2i18n("Hide console output"));
    btnDetails->setIconSet(KGlobal::iconLoader()->loadIcon("2leftarrow", KIcon::MainToolbar));
    gbConsole->show();
    adjustSize();
    parent->adjustSize();

  }
  else
  {
    btnDetails->setText(tr2i18n("Show &Details"));
    QToolTip::add(btnDetails, tr2i18n("Show console output"));
    btnDetails->setIconSet(KGlobal::iconLoader()->loadIcon("2rightarrow", KIcon::MainToolbar));

    gbConsole->hide();
    adjustSize();
    parent->adjustSize();

  }
}


void KompileWidget::compileAndInstall()
{
  const QPixmap& pix = KGlobal::iconLoader()->loadIcon("1rightarrow", KIcon::MainToolbar);
  pxmArrowDecompress->setPixmap(pix);
  pxmArrowConfigure->setPixmap(pix);
  pxmArrowMake->setPixmap(pix);
  pxmArrowInstall->setPixmap(pix);

  pxmArrowConfigure->hide();
  pxmArrowMake->hide();
  pxmArrowInstall->hide();

  if (!do_uninstall)
    txtConsole->setText(txtConsole->text() + tr2i18n("Start <b>'") + tarball + tr2i18n("'</b> installation...<br>"));
  else
    txtConsole->setText(txtConsole->text() + tr2i18n("Start <b>'") + tarball + tr2i18n("'</b> uninstallation...<br>"));


  if (!profile->readEntry("name", "").isEmpty())
  {
    QString profile_name(profile->readEntry("name", ""));
    if (!profile->readEntry("version", "").isEmpty())
      profile_name.append("-" + profile->readEntry("version", ""));
    if (!profile->readEntry("release", ""))
      profile_name.append("-" + profile->readEntry("release", ""));

    lblProfileText->setText(profile_name);
  }

  kompile_timer = new QTimer();

  connect(kompile_timer, SIGNAL(timeout()), this, SLOT(total_timeout()));

  kompile_timer->start(1000, FALSE);
  installation_time.start();

  decompress();
}


void KompileWidget::decompress()
{
  status = STATUS_DECOMPRESSING;
  operation_time = 0;
  lblDecompressionStatusText->setText("In Progress");
  txtConsole->setText(txtConsole->text() + tr2i18n("Decompression of source tarball...<br>"));
  lblDecompress->setText(tr2i18n("<b>Decompress archive</b>"));
  pxmDecompress->setPixmap(KGlobal::iconLoader()->loadIcon("ark", KIcon::MainToolbar));

  process = new KProcess( this );

  connect( process, SIGNAL(receivedStdout( KProcess *, char *, int)), this, SLOT(processReadFromStdout(KProcess *, char *, int)));
  connect( process, SIGNAL(receivedStderr( KProcess *, char *, int)), this, SLOT(processReadFromStderr(KProcess *, char *, int)));
  connect( process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));

  QString directory;
  if (profile->readEntry("use_decompression_user_dir", "false") == "true")
    directory = profile->readEntry("decompression_user_dir", "/tmp/kompile-tmp/");
  else
    directory = "/tmp/kompile-tmp/";

  lblDecompressionPathText->setText(directory);
  QDir * dir = new QDir();
  dir->mkdir(directory);
  delete dir;

  *process<<"/bin/tar";
  *process<<"-x";
  *process<<"-v";
  if (tarball.endsWith(".gz"))
    *process<<"-z";
  else if (tarball.endsWith(".bz2"))
    *process<<"-j";

  *process<<"-f";
  *process<<tarball;
  *process<<"-C";
  *process<<directory;


  txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
  QValueList< QCString > list = process->args();

  for (unsigned int index = 0; index < list.count(); index++)
  {
    txtConsole->setText(txtConsole->text().append(list[index]) + " ");
  }

  txtConsole->setText(txtConsole->text() + "</font><br>");
  pbProgress->setProgress(12);

  if (!process->start(KProcess::NotifyOnExit, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Can't start archive decompression.</font><br>"));
  }
  else
    process->resume();
}

void KompileWidget::configure()
{
  status = STATUS_CONFIGURING;
  operation_time = 0;

  txtConsole->setText(txtConsole->text() + tr2i18n("Configuring sources...<br>"));
  lblConfigurationStatusText->setText("In Progress");
  lblConfigure->setText(tr2i18n("<b>Configuring sources</b>"));
  pxmConfigure->setPixmap(KGlobal::iconLoader()->loadIcon("configure", KIcon::MainToolbar));
  pxmArrowDecompress->setPixmap(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Desktop, 22));
  pxmArrowConfigure->show();

  QDir * dir = new QDir();

  if (!dir->setCurrent(path))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to change current path.<br>Installation aborted!</font><br>"));
    KMessageBox::error(this, tr2i18n("Kompile is unable to change current path to application's sources folder.\nYou should try to manually enter into sources folder '") + path + tr2i18n("' and type:\n~]# ./configure && make && make install.\nInstallation failed"), tr2i18n("Installation failed"));
    status = STATUS_ERROR;
    return;
  }

  txtConsole->setText(txtConsole->text() + tr2i18n("Moved to ") + dir->current().path() + "<br>");

  if (dir->entryList().find("configure") == dir->entryList().end())
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to find configuration script.<br>Package compiling my require particular compilation procedure. You should try compile package manually.<br>Installation failed!</font><br>"));
    KMessageBox::error(this, tr2i18n("Kompile is unable to find the configuration script in the application's sources folder.\n.Package compiling my require particular compilation procedure. You should try to compile sources manually.\nInstallation failed!"), tr2i18n("Installation failed"));
    status = STATUS_ERROR;
    btnAbort->setText(tr2i18n("&Close"));
  }
  delete dir;

  delete process;
  process = new KProcess( );

  connect( process, SIGNAL(receivedStdout( KProcess *, char *, int)), this, SLOT(processReadFromStdout(KProcess *, char *, int)));
  connect( process, SIGNAL(receivedStderr( KProcess *, char *, int)), this, SLOT(processReadFromStderr(KProcess *, char *, int)));
  connect( process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));


  QString flags("");

  if (!profile->readEntry("CC" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CC", profile->readEntry("CC" ,"").stripWhiteSpace());
    flags += "CC=" + profile->readEntry("CC" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CFLAGS" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CFLAGS", profile->readEntry("CFLAGS" ,"").stripWhiteSpace());
    flags += "CFLAGS=" + profile->readEntry("CFLAGS" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CPP" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CPP", profile->readEntry("CPP" ,"").stripWhiteSpace());
    flags += "CPP=" + profile->readEntry("CPP" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CPPFLAGS" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CPPFLAGS", profile->readEntry("CPPFLAGS" ,"").stripWhiteSpace());
    flags += "CPPFLAGS=" + profile->readEntry("CPPFLAGS" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CXX" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CXX", profile->readEntry("CXX" ,"").stripWhiteSpace());
    flags += "CXX=" + profile->readEntry("CXX" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CXXCPP" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CXXCPP", profile->readEntry("CXXCPP" ,"").stripWhiteSpace());
    flags += "CXXCPP=" + profile->readEntry("CXXCPP" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("CXXFLAGS" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "CXXFLAGS", profile->readEntry("CXXFLAGS" ,"").stripWhiteSpace());
    flags += "CXXFLAGS=" + profile->readEntry("CXXFLAGS" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("FF" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "FF", profile->readEntry("FF" ,"").stripWhiteSpace());
    flags += "FF=" + profile->readEntry("FF" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("FFLAGS" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "FFLAGS", profile->readEntry("FFLAGS" ,"").stripWhiteSpace());
    flags += "FFLAGS=" + profile->readEntry("FFLAGS" ,"").stripWhiteSpace() + "<br>";
  }
  if (!profile->readEntry("LDFLAGS" ,"").stripWhiteSpace().isEmpty())
  {
    process->setEnvironment( "LDFLAGS", profile->readEntry("LDFLAGS" ,"").stripWhiteSpace());
    flags += "LDFLAGS=" + profile->readEntry("LDFLAGS" ,"").stripWhiteSpace() + "<br>";
  }


  txtConfigurationOptionsText->setText(profile->readEntry("configuration_options" ,""));
  txtBuildingFlagsText->setText(flags);

  *process<<"/bin/sh";
  *process<<"configure";

  QStringList arguments = QStringList::split(" ", profile->readEntry("configuration_options" ,""));
  for (QStringList::Iterator arg = arguments.begin(); arg != arguments.end(); ++arg)
  {
    *process<<*arg;
  }

  if (installation_type == KompileUserInstall::USERINSTALLATION)
  {
    *process<<"--prefix=" + user_dir;
  }

  txtConsole->setText(txtConsole->text() + tr2i18n("Configuring sources...<br>"));

  txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
  QValueList< QCString > list = process->args();

  for (QValueList< QCString >::Iterator it = list.begin(); it != list.end(); ++it)
  {
    txtConsole->setText(txtConsole->text().append(" " + *it));
  }

  txtConsole->setText(txtConsole->text() + "</font><br>");

  if (!process->start(KProcess::NotifyOnExit, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to start sources configuration..</font><br>"));
  }
}

void KompileWidget::make()
{
  status = STATUS_BUILDINGING;
  operation_time=0;
  lblBuildingStatusText->setText("In Progress");
  txtConsole->setText(txtConsole->text() + tr2i18n("Building sources...<br>"));
  lblMake->setText(tr2i18n("<b>Building sources</b>"));
  pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("make_kdevelop", KIcon::MainToolbar));
  pxmArrowMake->show();
  pxmArrowConfigure->setPixmap(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Desktop, 22));

  delete process;
  process = new KProcess( );

  connect( process, SIGNAL(receivedStdout( KProcess *, char *, int)), this, SLOT(processReadFromStdout(KProcess *, char *, int)));
  connect( process, SIGNAL(receivedStderr( KProcess *, char *, int)), this, SLOT(processReadFromStderr(KProcess *, char *, int)));
  connect( process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));

  *process<<"/usr/bin/make";

  txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
  QValueList< QCString > list = process->args();

  for (QValueList< QCString >::Iterator it = list.begin(); it != list.end(); ++it)
    txtConsole->setText(txtConsole->text().append(*it));

  txtConsole->setText(txtConsole->text() + "</font><br>");
  if (!process->start(KProcess::NotifyOnExit, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable build sources.</font><br>"));
  }
}

void KompileWidget::install()
{
  status = STATUS_INSTALLING;
  operation_time = 0;
  lblInstallStatusText->setText("In Progress");

  if (profile->readEntry("do_not_install", "false") == "true")
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("Skip package installation (specified in current profile)...<br>"));
    processExited( process );
    return;
  }

  txtConsole->setText(txtConsole->text() + tr2i18n("Installing binaries...<br>"));
  lblMakeInstall->setText(tr2i18n("<b>Installing bineries</b>"));
  pxmInstall->setPixmap(KGlobal::iconLoader()->loadIcon("exec", KIcon::MainToolbar));
  pxmArrowInstall->show();
  pxmArrowMake->setPixmap(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Desktop, 22));

  delete process;
  process = new KProcess( );

  connect( process, SIGNAL(receivedStdout( KProcess *, char *, int)), this, SLOT(processReadFromStdout(KProcess *, char *, int)));
  connect( process, SIGNAL(receivedStderr( KProcess *, char *, int)), this, SLOT(processReadFromStderr(KProcess *, char *, int)));
  connect( process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));


  if (installation_type == KompileUserInstall::REQUESTROOOTPASSWORD)
  {
    *process<<KStandardDirs::findExe("kdesu");
  }

  if (profile->readEntry("use_checkinstall", "false") == "true")
  {
    *process<<profile->readEntry("checkinstall_path");
    *process<<"-y";
    *process<<"--type=" + profile->readEntry("checkinstall_package_type");
    *process<<"--pkgname=" + profile->readEntry("name");
    if (!profile->readEntry("version", "").isEmpty())
      *process<<"--pkgversion=" + profile->readEntry("version", "xx");
    if (!profile->readEntry("release", "").isEmpty())
      *process<<"--pkgrelease=" + profile->readEntry("release", "xx");
    if (!profile->readEntry("release", "").isEmpty())
      *process<<"--pkglicense=" + profile->readEntry("license", "xx");

    *process<<"--pakdir=~/";
    *process<<"--nodoc";


  }
  else
  {
    *process<<"/usr/bin/make";
    *process<<"install";
  }

  txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
  QValueList< QCString > list = process->args();

  for (QValueList< QCString >::Iterator it = list.begin(); it != list.end(); ++it)
    txtConsole->setText(txtConsole->text().append(*it));

  txtConsole->setText(txtConsole->text() + "</font><br>");
  if (!process->start(KProcess::NotifyOnExit, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to install binaries.</font><br>"));
  }
}

void KompileWidget::uninstall()
{
  status = STATUS_UNINSTALLING;
  operation_time = 0;
  lblInstallStatusText->setText("In Progress");
  txtConsole->setText(txtConsole->text() + tr2i18n("Uninstalling binaries...<br>"));
  lblMake->setText(tr2i18n("<b>Uninstalling binaries</b>"));
  pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::MainToolbar));
  pxmArrowMake->show();

  delete process;
  process = new KProcess( );

  connect( process, SIGNAL(receivedStdout( KProcess *, char *, int)), this, SLOT(processReadFromStdout(KProcess *, char *, int)));
  connect( process, SIGNAL(receivedStderr( KProcess *, char *, int)), this, SLOT(processReadFromStderr(KProcess *, char *, int)));
  connect( process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));

  if (installation_type == KompileUserInstall::REQUESTROOOTPASSWORD)
  {
    *process<<KStandardDirs::findExe("kdesu");
  }

  *process<<"/usr/bin/make";
  *process<<"uninstall";

  txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
  QValueList< QCString > list = process->args();

  for (QValueList< QCString >::Iterator it = list.begin(); it != list.end(); ++it)
    txtConsole->setText(txtConsole->text().append(*it));

  txtConsole->setText(txtConsole->text() + "</font><br>");
  if (!process->start(KProcess::NotifyOnExit, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to uninstall bineries.</font><br>"));
  }
}

void KompileWidget::processReadFromStdout( KProcess * proc, char * buffer, int buflen )
{
  QString string = QString::fromLatin1( buffer, buflen);

  if (!string.isEmpty())
  {
    txtConsole->setText(txtConsole->text() + string + "<br>");
  }
}

void KompileWidget::processReadFromStderr( KProcess * proc, char * buffer, int buflen )
{
  QString string = QString::fromLatin1( buffer, buflen);

  if (!string.isEmpty())
  {
    txtConsole->setText(txtConsole->text() + "<font color=#AA6666>" + buffer + "</font>" + "<br>");
  }
}

bool KompileWidget::removeSources()
{
  QString directory("/tmp/kompile-tmp/");

  if (profile->readEntry("use_decompression_user_dir", "false") == "true")
  {
    if (profile->readEntry("remove_decompression_user_dir", "false") == "true")
      directory = profile->readEntry("decompression_user_dir", "/tmp/kompile-tmp/");
    else
      return true;

  }

  txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#6666AA>Remove source directory...</font><br>"));

  if (profile->readEntry("use_checkinstall", "false") == "true")
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#6A6A6A>Kompile skip source directory removing because directory contains a package create by <b>checkinstall</b>...</font><br>"));
  }

  delete process;
  process = new KProcess( );
  process->clearArguments();

  *process<<"/bin/rm";
  *process<<"-fvr";
  *process<<directory;

  QValueList< QCString > list = process->args();

  for (QValueList< QCString >::Iterator it = list.begin(); it != list.end(); ++it)
    txtConsole->setText(txtConsole->text().append(*it).append(" "));

  if (!process->start(KProcess::Block, KProcess::AllOutput))
  {
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Unable to remove source directory...</font><br>"));
    return FALSE;
  }

  txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#6666AA>Source directory removed.</font><br>"));
  return TRUE;
}

void KompileWidget::processExited( KProcess * )
{
  QString op_string(tr2i18n("Installation"));
  QTime op_time(0,0,0);
  KConfig * config_load = KGlobal::config();
  config_load->setGroup("General");

  if (do_uninstall)
    QString op_string(tr2i18n("Uninstallation"));

  switch (status)
  {
  case STATUS_DECOMPRESSING:
    lblDecompressionTimeText->setText(op_time.addMSecs(operation_time).toString("hh:mm:ss"));

    if (!process->normalExit() || process->exitStatus() != 0 || process->exitStatus() != 0)
    {
      lblDecompressionStatusText->setText("Error during decompression");
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Error during archive decompression. " + op_string + " aborted!</font>" + "<br>"));
      KMessageBox::error(this, tr2i18n("Kompile is unable to decompress archive.\n You should try to decompress archive and compile sources manually.\n") + op_string + tr2i18n(" failed!"), op_string + tr2i18n(" failed"));
      status = STATUS_ERROR;
      btnAbort->setText(tr2i18n("&Close"));
      if (config_load->readEntry("sound_fails", "").stripWhiteSpace().length() != 0)
      {
        QSound fails(config_load->readEntry("sound_fails", "").stripWhiteSpace());
        fails.play();
      }

      return;
    }

    lblDecompressionStatusText->setText("Decompression Completed");
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#66AA66>Archive decompressed.</font><br>"));
    pbProgress->setProgress(25);
    lblDecompress->setText(tr2i18n("Archive decompressed"));

    searchInfoFiles();
    configure();
    break;
  case STATUS_CONFIGURING:
    lblConfigurationTimeText->setText(op_time.addMSecs(operation_time).toString("hh:mm:ss"));

    if (!process->normalExit() || process->exitStatus() != 0)
    {
      lblConfigurationStatusText->setText("Error during source configuration");
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Error during sources configuration. " )+ op_string + tr2i18n(" aborted!</font>") + "<br>");
      int res = KMessageBox::warningYesNo(this, tr2i18n("Kompile is unable to start sources configuration.\n ") + op_string + tr2i18n(" failed!\nWhould you like to see configuration log?"), op_string + tr2i18n(" failed"));

      if (res == KMessageBox::Yes)
      {
        delete process;
        process = new KProcess( );

        QString log_path = path + "/config.log";

        KDialogBase * dialog = new KDialogBase(this, "ConfigLog", FALSE, tr2i18n("Configuration Log"), KDialogBase::Close);
        KompileInfoWidget * info = new KompileInfoWidget(log_path, dialog, "ConfigLogInfoWidget");
        dialog->setMainWidget( info );
        dialog->show();
        dialog->adjustSize();
      }

      status = STATUS_ERROR;
      btnAbort->setText(tr2i18n("&Close"));
      if (config_load->readEntry("sound_fails", "").stripWhiteSpace().length() != 0)
      {
        QSound::play(config_load->readEntry("sound_fails", "").stripWhiteSpace());
      }

      return;
    }

    lblConfigurationStatusText->setText("Configuration Completed");
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#66AA66>Sources configured.</font><br>"));
    pbProgress->setProgress(50);
    lblConfigure->setText(tr2i18n("Sources configured"));
    if (do_uninstall)
      uninstall();
    else
      make();
    break;
  case STATUS_BUILDINGING:
    lblBuildingTimeText->setText(op_time.addMSecs(operation_time).toString("hh:mm:ss"));
    if (!process->normalExit() || process->exitStatus() != 0)
    {
      lblBuildingStatusText->setText("Error during sources build.");
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Error during sources build. ") + op_string + tr2i18n(" aborted!</font>") + "<br>");
      KMessageBox::error(this, tr2i18n("Kompile is unable to start sources building.\n You should try to compile sources manually.\n") + op_string + tr2i18n(" failed!"), op_string + tr2i18n(" failed"));
      status = STATUS_ERROR;
      btnAbort->setText(tr2i18n("&Close"));
      if (config_load->readEntry("sound_fails", "").stripWhiteSpace().length() != 0)
      {
        QSound::play(config_load->readEntry("sound_fails", "").stripWhiteSpace());

      }

      return;
    }

    lblBuildingStatusText->setText("Sources builded.");
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#66AA66>Sources builded.</font><br>"));
    pbProgress->setProgress(75);
    lblMake->setText(tr2i18n("Sources builded"));
    install();
    break;
  case STATUS_INSTALLING:
    lblInstallTimeText->setText(op_time.addMSecs(operation_time).toString("hh:mm:ss"));
    if (!process->normalExit() || process->exitStatus() != 0)
    {
      lblInstallStatusText->setText("Binaries installation error");
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Error binaries installation. ") + op_string + tr2i18n(" aborted!</font>") + "<br>");
      KMessageBox::error(this, tr2i18n("Kompile is unable to start binary installation.\n You should try to compile and install sources manually.\n") + op_string + tr2i18n(" failed!"), op_string + tr2i18n(" failed"));
      status = STATUS_ERROR;
      btnAbort->setText(tr2i18n("&Close"));
      if (config_load->readEntry("sound_fails", "").stripWhiteSpace().length() != 0)
      {
        QSound fails(config_load->readEntry("sound_fails", "").stripWhiteSpace());
        fails.play();
      }

      return;
    }

    if (profile->readEntry( "archive_tarball", "false" ) == "true")
    {
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#6666AA>Copy tarball in archive directory....</font><br>"));
      QStringList file_tokens = QStringList::split( "/", profile->readEntry( "tarball", "" ) );

      QDir archive_dir(locateLocal("appdata", "") + "/tarballs/");
      if (!archive_dir.exists())
        archive_dir.mkdir( locateLocal("appdata", "") + "/tarballs/" );

      KURL source( profile->readEntry( "tarball", "" ) );
      if (file_tokens.count() == 0)
        break;

      KURL dest( locateLocal("appdata", "") + "/tarballs/" + file_tokens[file_tokens.count() - 1] );
      KIO::file_copy( source, dest );
      profile->writeEntry( "tarball", locateLocal("appdata", "") + "/tarballs/" + file_tokens[file_tokens.count() - 1]);
    }

    profile->writeEntry( "installed", "true" );
    profile->sync();
    lblInstallStatusText->setText("Binaries installed");
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#66AA66>Binaries installed.</font><br>"));
    pbProgress->setProgress(100);
    kompile_timer->stop();
    btnAbort->setText(tr2i18n("&Finish"));
    QToolTip::add(btnAbort, tr2i18n("Close Kompile"));
    pxmArrowInstall->setPixmap(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Desktop, 22));
    btnAbort->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::MainToolbar));
    status = STATUS_FINISHED;
    lblMakeInstall->setText(tr2i18n("Binaries installed"));

    if (chkAutoclose->isChecked())
    {
      finish_timer = new QTimer();
      connect(finish_timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
      chkAutoclose->setText(tr2i18n("Kompile close in " + config_load->readEntry("autoclose_seconds", "20") + " seconds"));
      finish_timer->start(1000);
    }
    else
      chkAutoclose->setEnabled(FALSE);

    if (config_load->readEntry("sound_noerrors", "").stripWhiteSpace().length() != 0)
    {
      QSound::play(config_load->readEntry("sound_noerrors", "").stripWhiteSpace());
    }
    break;
  case STATUS_UNINSTALLING:
    if (!process->normalExit() || process->exitStatus() != 0)
    {
      lblInstallStatusText->setText("Binaries uninstallation error");
      txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#AA6666>Error binaries uninstallation. ") + op_string + tr2i18n(" aborted!</font>") + "<br>");
      KMessageBox::error(this, tr2i18n("Kompile is unable to start binary uninstallation.\n You should try to uninstall sources manually.\n") + op_string + tr2i18n(" failed!"), op_string + tr2i18n(" failed"));
      status = STATUS_ERROR;
      btnAbort->setText(tr2i18n("&Close"));
      if (config_load->readEntry("sound_fails", "").stripWhiteSpace().length() != 0)
      {
        QSound::play(config_load->readEntry("sound_fails", "").stripWhiteSpace());
      }

      return;
    }

    profile->writeEntry( "installed", "false" );
    profile->sync();
    lblInstallStatusText->setText("Binaries uninstalled");
    txtConsole->setText(txtConsole->text() + tr2i18n("<font color=#66AA66>Binaries uninstalled.</font><br>"));
    pbProgress->setProgress(75);
    btnAbort->setText(tr2i18n("&Finish"));
    QToolTip::add(btnAbort, tr2i18n("Close Kompile"));

    btnAbort->setIconSet(KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
    status = STATUS_FINISHED;
    lblMake->setText(tr2i18n("Binaries uninstalled"));
    if (chkAutoclose->isChecked())
    {
      finish_timer = new QTimer();
      connect(finish_timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
      chkAutoclose->setText(tr2i18n("Kompile close in " + config_load->readEntry("autoclose_seconds", "20") + " seconds"));
      finish_timer->start(1000);
    }
    else
      chkAutoclose->setEnabled(FALSE);

    if (config_load->readEntry("sound_noerrors", "").stripWhiteSpace().length() != 0)
    {
      QSound::play(config_load->readEntry("sound_noerrors", "").stripWhiteSpace());
    }

    break;
  }
}

void KompileWidget::txtConsole_textChanged()
{
  txtConsole->scrollToBottom();
}

void KompileWidget::btnAbort_clicked()
{
  if (status == STATUS_FINISHED)
  {
    if (process->isRunning())
    {
      disconnect(process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));
      process->kill();

    }

    if (!removeSources())
      KMessageBox::detailedSorry(this, tr2i18n("Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/"), tr2i18n("Warning"));

    parent->close();
  }
  else if (status == STATUS_ERROR)
  {
    if (process->isRunning())
    {
      disconnect(process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));
      process->kill();

    }

    if (!removeSources())
      if (!removeSources())
        KMessageBox::detailedSorry(this, tr2i18n("Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/"), txtConsole->text(), tr2i18n("Warning"));
    parent->cancel();
  }
  else
  {
    process->kill(SIGSTOP);
    if (KMessageBox::warningYesNo(this, tr2i18n("Installation of '") + tarball + tr2i18n("' isn't completed'.\nAre you sure you want abort installation and lost all buildings status already done?"), tr2i18n("Abort")) == KMessageBox::Yes)
    {
      if (process->isRunning())
      {
        disconnect(process, SIGNAL(processExited( KProcess * )), this, SLOT(processExited( KProcess * )));
        process->kill(SIGKILL);
      }

      if (!removeSources())
        KMessageBox::detailedSorry(this, tr2i18n("Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/"), txtConsole->text(), tr2i18n("Warning"));
      
      status = STATUS_ABORTED;
      parent->cancel();
    }
    else
      process->kill(SIGCONT);

  }
}

void KompileWidget::btnAbout_clicked()
{
  KAboutApplication about( this );
  about.exec();
}

void KompileWidget::autoclose_timeout()
{
  seconds_left--;
  if (seconds_left == 0)
  {
    disconnect(finish_timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
    btnAbort_clicked();
  }

  QString * seconds = new QString();
  chkAutoclose->setText(tr2i18n("Kompile close in ") + seconds->setNum(seconds_left) + "s");
  delete seconds;
}

void KompileWidget::total_timeout()
{
  operation_time+=1000;

  QTime time(0,0,0);
  lblTotalTimeText->setText(time.addMSecs(installation_time.elapsed()).toString("hh:mm:ss"));

  QTime optime(0,0,0);
  switch (status)
  {
  case STATUS_DECOMPRESSING:
    lblDecompressionTimeText->setText(optime.addMSecs(operation_time).toString("hh:mm:ss"));
    break;
  case STATUS_CONFIGURING:
    lblConfigurationTimeText->setText(optime.addMSecs(operation_time).toString("hh:mm:ss"));
    break;
  case STATUS_BUILDINGING:
    lblBuildingTimeText->setText(optime.addMSecs(operation_time).toString("hh:mm:ss"));
    break;
  case STATUS_INSTALLING:
    lblInstallTimeText->setText(optime.addMSecs(operation_time).toString("hh:mm:ss"));
    break;
  case STATUS_UNINSTALLING:
    lblInstallTimeText->setText(optime.addMSecs(operation_time).toString("hh:mm:ss"));
    break;
  }
}

void KompileWidget::btnSuspend_clicked()
{
  if (btnSuspend->isOn())
  {
    QToolTip::add(btnSuspend, "Resume installation process");
    btnSuspend->setIconSet(KGlobal::iconLoader()->loadIconSet("player_play", KIcon::MainToolbar));
    process->kill(SIGSTOP);
  }
  else
  {
    QToolTip::add(btnSuspend, "Suspend installation process");
    btnSuspend->setIconSet(KGlobal::iconLoader()->loadIconSet("player_pause", KIcon::MainToolbar));
    process->kill(SIGCONT);
  }
}

void KompileWidget::btnShowReadme_clicked()
{
  QString readme_path = path + "README";
  KDialogBase * dialog = new KDialogBase(this, "ReadmeInfo", FALSE, tr2i18n("Package README file content"), KDialogBase::Close);
  KompileInfoWidget * info = new KompileInfoWidget(readme_path, dialog, "ReadmeInfoWidget");
  dialog->setMainWidget( info );
  dialog->show();
  dialog->adjustSize();
}

void KompileWidget::btnShowInstall_clicked()
{
  QString readme_path = path + "INSTALL";
  KDialogBase * dialog = new KDialogBase(this, "ReadmeInfo", FALSE, tr2i18n("Package INSTALL file content"), KDialogBase::Close);
  KompileInfoWidget * info = new KompileInfoWidget(readme_path, dialog, "InstallInfoWidget");
  dialog->setMainWidget( info );
  dialog->show();
  dialog->adjustSize();
}

void KompileWidget::btnShowChangelog_clicked()
{
  QString readme_path = path + "ChangeLog";
  KDialogBase * dialog = new KDialogBase(this, "ReadmeInfo", FALSE, tr2i18n("Package CHANGELOG file content"), KDialogBase::Close);
  KompileInfoWidget * info = new KompileInfoWidget(readme_path, dialog, "ChangeLogInfoWidget");
  dialog->setMainWidget( info );
  dialog->show();
  dialog->adjustSize();
}

void KompileWidget::searchInfoFiles()
{
  QString directory("/tmp/kompile-tmp/");

  if (profile->readEntry("use_decompression_user_dir", "false") == "true")
  {
    directory = profile->readEntry("decompression_user_dir", "/tmp/kompile-tmp/");
  }

  QDir * dir = new QDir(directory);
  dir->setSorting(QDir::Time);
  QStringList entries = dir->entryList();
  path = directory + entries[entries.count() - 1] + "/";

  if (dir->entryList().find("README") != entries.end())
  {
    btnShowReadme->setEnabled(true);
  }

  if (dir->entryList().find("INSTALL") != entries.end())
  {
    btnShowInstall->setEnabled(true);
  }

  if (dir->entryList().find("ChangeLog") != entries.end())
  {
    btnShowChangelog->setEnabled(true);
  }

}

int KompileWidget::getStatus()
{
  return status;
}

#include "kompilewidget.moc"
