/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/


#include "ExecThread.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>


ExecThread::ExecThread(const QString &command, QTcpSocket *socket, char* path)
    : commandText(command), socketThread(socket), contextKontrol(path)
{
    xmlCreator = new XmlCreatorClient();
    setTerminationEnabled(true);

}

void ExecThread::run()
{
    command_handler();
    terminate();
    quit();
    exit(0);

}

QString ExecThread::getCommandContext()
{
    QString commandBackUp = QString(commandText);
    char path[2000] = {0};
    char bufContext[3000];
    char *contextFinal;
    strcpy(path, "");
    strcat(path, qPrintable(commandText));
    qDebug(qPrintable(commandText));
    contextFinal = path;

    getContext(contextFinal);
    strcpy(bufContext, "cd ");
    QString contextPath = QString(contextFinal);

#ifdef WIN32
    contextPath.replace(QString("\\\\"), QString("\\"));
#elif defined (linux)
    contextPath.replace(QString("//"), QString("/"));
#elif defined __APPLE__
    contextPath.replace(QString("//"), QString("/"));
#endif
    QString contextXml = xmlCreator->createXmlForCommandContext(contextPath);
    setContext(qPrintable(contextPath));
    qDebug(qPrintable(contextPath));
    if (commandBackUp.contains(" cd ", Qt::CaseInsensitive) || commandBackUp.startsWith("cd ", Qt::CaseInsensitive))
    {
        return contextXml;
    }
    strcat(bufContext, contextFinal);
#ifdef WIN32
    strcat(bufContext, " & ");
#elif defined (linux)
    strcat(bufContext, " && ");
#elif defined __APPLE__
    strcat(bufContext, " && ");
#endif
    strcat(bufContext, qPrintable(commandText));
    strcpy(bufContextGlobal, bufContext);
    return contextXml;
}

QString ExecThread::command_handler ()
{
  //  QTimer::singleShot(1000, this, SLOT(endCommandExecution()));
    receivedChar = 0;
    cmd = popen (bufContextGlobal, "r");
    while (fgets(buf, sizeof(buf), cmd))
    {
        receivedChar = receivedChar + QString(buf).length();

        QByteArray block2;
        QDataStream out2(&block2, QIODevice::WriteOnly);
        out2.setVersion(QDataStream::Qt_4_0);
        out2 << QString(buf);
        socketThread->write(block2);
        if (receivedChar > 30000) {
            break;
        }
    }
    pclose(cmd);
    QByteArray block3;
    QDataStream out3(&block3, QIODevice::WriteOnly);
    out3.setVersion(QDataStream::Qt_4_0);
    out3 << QString("####EXECUTED COMMAND####\n");
    socketThread->write(block3);
    return QString("");
}

void ExecThread::endCommandExecution()
{
  //  receivedChar = 50000;
  //  qDebug("TERMINATE");
}

int ExecThread::isDirectory(char *pathToCheck)
{
    DIR* dirStructP;
    char pwd[1500];
    strcpy(pwd,pathToCheck);
    if ((dirStructP = opendir(pwd)) != NULL)
    {
        closedir(dirStructP);
        return 1;
    } else
    {
        return 0;
    }
}

void ExecThread::cd_DotDot_Handling(char *pathToReduce)
{
    char relativePath[1000] = {0};
    char *command;
#ifdef WIN32
    command = strrchr(pathToReduce, '\\');
#elif defined (linux)
    command = strrchr(pathToReduce, '/');
#elif defined __APPLE__
    command = strrchr(pathToReduce, '/');
#endif
    int lenght = strlen(command);
    if (lenght == 1)
    {
    }
    else
    {
        strncat(relativePath, pathToReduce, strlen(pathToReduce) - lenght);
#ifdef WIN32
        if (strlen(relativePath) < 3)
        {
            strcat(relativePath, "\\");
        }
#elif defined (linux)
        if (strlen(relativePath) < 1)
        {
            strcat(relativePath, "/");
        }
#elif defined __APPLE__
        if (strlen(relativePath) < 1)
        {
            strcat(relativePath, "/");
        }
#endif
        strcpy(pathToReduce, relativePath);
    }
}

void ExecThread::cd_Path_Handling(char *pathToAdd)
{
    char path[1000] = {0};
    char appendToContext[1355];
    QString str = QString(pathToAdd);
    int cdIndex = str.indexOf("cd ");
    QString pathString = str.mid(cdIndex, (str.size() - cdIndex));
    pathString.replace("cd ", "");
    pathString.simplified();
    if (pathString.contains("&"))
    {
        int andIndex = pathString.indexOf("&");
        QString finalPath = pathString.mid(0, andIndex);
        finalPath.simplified();
        pathString = finalPath;
    }
    strcpy(path, qPrintable(pathString));  
#ifdef WIN32
    if (str.contains(":"))
#elif defined (linux)
        if (path[0] == '/')
#elif defined __APPLE__
            if (path[0] == '/')
#endif
            {
        strcpy(pathToAdd, path);
    } else {
        strcpy(appendToContext, contextKontrol);
#ifdef WIN32
        strcat(appendToContext, "\\");
#elif defined (linux)
        strcat(appendToContext, "/");
#elif defined __APPLE__
        strcat(appendToContext, "/");
#endif
        strcat(appendToContext, path);
        strcpy(pathToAdd, appendToContext);
    }
}

void ExecThread::getContext(char *pathToObtain)
{
    if (strstr(pathToObtain, " cd ..") != NULL)
    {
        cd_DotDot_Handling(contextKontrol);
        strcpy(pathToObtain, contextKontrol);
    }
    else if (strncmp(pathToObtain, "cd ..", 5) == 0)
    {
        cd_DotDot_Handling(contextKontrol);
        strcpy(pathToObtain, contextKontrol);
    }
    else if (strstr(pathToObtain, " cd ") != NULL)
    {
        cd_Path_Handling(pathToObtain);
        QDir dir = QDir(QString(pathToObtain));
        isDirectory(pathToObtain);
        if (!dir.exists())
        {
            // cd_DotDot_Handling(contextKontrol);
            strcpy(pathToObtain, contextKontrol);
        }
    }
    else if (strncmp(pathToObtain, "cd ", 3) == 0)
    {
        if (strstr(pathToObtain, " cd ") != NULL) {
            cd_Path_Handling(pathToObtain);
            QDir dir = QDir(QString(pathToObtain));
            isDirectory(pathToObtain);
            if (!dir.exists())
            {
                //  cd_DotDot_Handling(contextKontrol);
                strcpy(pathToObtain, contextKontrol);
            }
        }
        else
        {
            cd_Path_Handling(pathToObtain);
            QDir dir = QDir(QString(pathToObtain));
            isDirectory(pathToObtain);
            if (!dir.exists())
            {
                // cd_DotDot_Handling(contextKontrol);
                strcpy(pathToObtain, contextKontrol);
            }
        }
    } else 
    {
        strcpy(pathToObtain, contextKontrol);
    }
}

QString ExecThread::getQStringContext()
{
    QString qStringContext = QString(contextKontrol);
    return qStringContext;
}

void ExecThread::setContext(const char *contextToSet)
{
    strcpy(contextKontrol, contextToSet);
}
