/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "DefinedCommand.h"

DefinedCommand::DefinedCommand(QString operatingSystem)
        : os(operatingSystem)
{	
    QGridLayout *layout = new QGridLayout(this);
    copyButton = new QPushButton(tr("Copy file"), this);
    copyButton->setIcon(QIcon(":/icons/edit-cut.png"));
    mkDirButton = new QPushButton(tr("Create directory"), this);
    mkDirButton->setIcon(QIcon(":/icons/folder-new.png"));
    setButton = new QPushButton(QIcon(":/icons/utilities-system-monitor.png"), tr("environment variables"), this);
    setButton->setIcon(QIcon(":/icons/utilities-system-monitor.png"));
    delFileButton = new QPushButton(tr("delete file"), this);
    delFileButton->setIcon(QIcon(":/icons/edit-delete.png"));
    delFolderButton = new QPushButton(tr("delete folder"), this);
    delFolderButton->setIcon(QIcon(":/icons/edit-delete.png"));
    shutdownButton = new QPushButton(tr("Shutdown"), this);
    shutdownButton->setIcon(QIcon(":/icons/exit.png"));
    ipconfigButton = new QPushButton(tr("IP configuration"), this);
    ipconfigButton->setIcon(QIcon(":/icons/utilities-system-monitor.png"));
    //pingButton = new QPushButton(tr("Ping"), this);
    //pingButton->setIcon(QIcon(":/icons/applications-internet.png"));
    networkStatsButton = new QPushButton(tr("Network connections"), this);
    networkStatsButton->setIcon(QIcon(":/icons/network-wireless.png"));
    routeTableButton = new QPushButton(tr("Routing table"), this);
    routeTableButton->setIcon(QIcon(":/icons/network-wired.png"));
	
    layout->addWidget(copyButton, 0, 0);
    layout->addWidget(mkDirButton, 0, 1);
    layout->addWidget(setButton, 0, 2);
    layout->addWidget(delFileButton, 0, 3);
    layout->addWidget(delFolderButton, 0, 4);
    layout->addWidget(shutdownButton, 1, 0);
    layout->addWidget(ipconfigButton, 1, 1);
   // layout->addWidget(pingButton, 1, 2);
    layout->addWidget(networkStatsButton, 1, 2);
    layout->addWidget(routeTableButton, 1, 3);

    connect(copyButton, SIGNAL(clicked()), this, SLOT(copyAction()));
    connect(mkDirButton, SIGNAL(clicked()), this, SLOT(mkDirAction()));
    connect(setButton, SIGNAL(clicked()), this, SLOT(setAction()));
    connect(delFileButton, SIGNAL(clicked()), this, SLOT(delFileAction()));
    connect(delFolderButton, SIGNAL(clicked()), this, SLOT(delFolderAction()));
    connect(shutdownButton, SIGNAL(clicked()), this, SLOT(shutdownAction()));
    connect(ipconfigButton, SIGNAL(clicked()), this, SLOT(ipconfigAction()));
    //connect(pingButton, SIGNAL(clicked()), this, SLOT(pingAction()));
    connect(networkStatsButton, SIGNAL(clicked()), this, SLOT(networkStatsAction()));
    connect(routeTableButton, SIGNAL(clicked()), this, SLOT(routeTableAction()));
}

void DefinedCommand::copyAction()
{
    CopyDialog *copy = new CopyDialog(os);
    connect(copy, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    copy->exec();
}

void DefinedCommand::mkDirAction()
{
    MkDirDialog *mkdir = new MkDirDialog(os);
    connect(mkdir, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    mkdir->exec();
}

void DefinedCommand::setAction()
{
    emit executeCommand("set");
}

void DefinedCommand::delFileAction()
{
    DelFileDialog *delFile = new DelFileDialog(os);
    connect(delFile, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    delFile->exec();
}

void DefinedCommand::delFolderAction()
{
    DelDirDialog *deldir = new DelDirDialog(os);
    connect(deldir, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    deldir->exec();
}

void DefinedCommand::executeDefinedCommand(QString command)
{
    emit executeCommand(command);
}

void DefinedCommand::shutdownAction()
{
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("halt");
        QMessageBox::information(this, tr("Warning"), tr("The remote computer is shutting down."));
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
        emit executeCommand("SHUTDOWN -s");
        QMessageBox::information(this, tr("Warning"), tr("The remote computer is shutting down."));
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
        emit executeCommand("halt");
        QMessageBox::information(this, tr("Warning"), tr("The remote computer is shutting down."));
    }
}

void DefinedCommand::ipconfigAction()
{
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("/sbin/ifconfig");
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
        emit executeCommand("IPCONFIG");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
        emit executeCommand("/sbin/ifconfig");
    }
}

void DefinedCommand::networkStatsAction()
{
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("netstat");
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
        emit executeCommand("netstat -a");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
        emit executeCommand("netstat");
    }
}

void DefinedCommand::pingAction()
{
    //PingDialog *pingDialog = new PingDialog(os);
    //connect(pingDialog, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    //pingDialog->exec();
}

void DefinedCommand::routeTableAction()
{
    if (os.startsWith(QString("LINUX"), Qt::CaseInsensitive))
    {
        emit executeCommand("netstat -r");
    }
    else if (os.startsWith("WINDOWS", Qt::CaseInsensitive))
    {
            emit executeCommand("netstat -r");
    }
    else if (os.startsWith("MACOSX", Qt::CaseInsensitive))
    {
            emit executeCommand("netstat -r");
    }
}
