/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#ifndef HEADER_MAINWINDOW
#define HEADER_MAINWINDOW

#include <QtGui>
#include <QObject>
#include <QTcpServer>
#include "QListCyborgWidget.h"
#include "main/common/AboutDialog.h"
#include "datastore/XmlDataStore.h"
#include "CentralWindow.h"
#include "IpBlackList.h"
#include "ScriptEditorDialog.h"
#include "LoadingWidget.h"
#include "main/common/xml_constants.h"

class MainWindow : public QMainWindow
{
	Q_OBJECT

public: 
	MainWindow();
	QCompleter *completer;
	QStatusBar *toolBar;
        QProgressBar *progressBar;
	QDockWidget *dock;
	QDockWidget *contextDock;
	ScriptEditorDialog *scriptEditorDialog;
	bool status;
	Server *server;
	QLineEdit *commandLineEdit;
	QString *serverIpAddress;
	QString *serverPort;
	AboutDialog *aboutDialog;
        LoadingWidget *loading;
	QListCyborgWidget *commandsList;
	QListCyborgWidget *contextsList;
        QTimer *timer;
	QSystemTrayIcon *trayIcon;
	QMenu *trayIconMenu;
	QAction *minimizeAction;
	QAction *maximizeAction;
        bool isFileTransferring;
        bool isExecuting;
	QAction *restoreAction;
	QAction *qAction;
	QAction *aboutTrayIConAction;
	CentralWindow *centralWindow;
	IpBlackList *ipBlackList;
	int index;
	QStringList commandsStringList;
	QStringListModel *commandModel;
	QStringList contextStringList;
	QStringList pathPosssibility;
	QStringListModel *contextModel;
	void createActions();
	void createTrayIcon();
        void refreshFilesList();

public slots:
	void iconActivated(QSystemTrayIcon::ActivationReason reason);
	void displayUrl();
	void refreshServerTitle();
	void displayAbout();
	void displayContextDock();
	void displayCommandsDock();
	void showBlackListDialog();
	void appendToDock(QString msg);
	void displayContext(QString msg);
	void clicCommandSelection();
        void fullScreenMode();
	void clicContextSelection();
	void execCommandFromDialog(QString commandToExec);
	void displayPathPossibility(QStringList list);
	void startedServer(QString ipAddress, QString port);
	void startStopServer();
	void showSettings();
	void sendCommandToThread(QString command, int clientNbr);
	void sendCommandToAllThread();
	void sendSpecificCommandToAllThread(QString command);
	void scriptEditorAction();
	void errorOccuredWhileStartingServer(QString msg);
	void getClientParameters(QStringList parameters, int clientNbr);
	void removeTab(QString title, int clientNbr);
	void warning(QString msg);
	void sendFilePathToFileServer(QString filePath, int clientNbr);
        void displayFileTransfered(QString msg);
        void askFileFromRemoteClient(QString filePath, int clientNbr);
	void switchMode();
        void resetProgressBar(int clientNbr);
        void incrementProgressBar();
        void bytesSent(int sizeSent);
        void clientBytesSent(int sizeSent, int fileSize);
        void fileSent(int clientNbr);

signals:
	void sendCommand(QString commands);
	void appendCommandToDock(QString command);
	void showServerSettingsDialog();
	void setCommandLine(QString commandToChange);
	void sendPathListForCompletion(QStringList pathList);
	void displayStartedServer(QString ipAddress, QString port, bool status);
	void removeAlltab();
	void sendClientParameters(QStringList params, int clientNbr);
	void sendRemoveTab(QString title, int clientNbr);
	void commandFromScriptEditorNotExecuted();
        void fileSentSignal(int clientNbr);
	
protected:
	void closeEvent(QCloseEvent *event);
};


#endif
