/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QWidget>
#include <QString>
#include <QTextEdit>
#include <QLabel>
#include <QGridLayout>
#include <QGroupBox>
#include <QSplitter>
#include <QHostInfo>
#include <QList>
#include <QStringList>
#include <QHostAddress>
#include <QPushButton>
#include <QGroupBox>
#include "NetworkMapDialog.h"
#include "DnsResolverUi.h"
#include "Workstation.h"

class ServerHome : public QWidget
{
    Q_OBJECT

public:
        ServerHome(QTextEdit *textBrowser, QWidget *parent);
        QList<QHostAddress> addresses;
        QList<Workstation*> *workstationList;
		QStringList ipList;
        QLabel *image;
        DnsResolverUi *resolver;
        QTextEdit *textEdit;
        QGroupBox *groupBox;
        QLabel *path;
        void addWorkstation(Workstation *workstation);
        void removeWorkstation(Workstation *workstation);
public slots:
    void showNetworkMap();
    void showDNSResolver();
signals:

protected:


};


