// Copyright(C) 2005,2006 Stefan Siegl <stesie@brokenpipe.de>
// Copyright(C) 2006 Martin Albrecht <malb@informatik.uni-bremen.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "silcbuddycontactinfowidget.h"
#include "silcbuddycontact.h"
#include "silcbuddyattributes.h"

#include <kdebug.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>

SilcBuddyContactInfoWidget::SilcBuddyContactInfoWidget(SilcBuddyContact *b)
  : SilcBuddyContactInfo(), _buddy(b)
{
  b->whoami();
  fingerprint->setText(b->fingerprint());
  fpTrusted->setChecked(b->fpTrusted());
  chkAllowRichText->setChecked(b->allowRichText());
  nickname->setText(QString("%1 (%2)").arg(b->nickName()).arg(b->_username));
  realname->setText(QString(b->_realname));
  update->setText(b->_update.toString("dd.MM.yyyy hh:mm:ss"));
  labelAttributes->setText(b->attributes->getInformations()); 

  // show list of channels ...
  channels->setText(b->channelList().join(" "));

  QObject::connect((QObject *) buttonApply, SIGNAL(clicked()),
		   this, SLOT(slotApply()));
  QObject::connect((QObject *) buttonOk, SIGNAL(clicked()),
		   this, SLOT(slotOk()));
  QObject::connect((QObject *) buttonCancel, SIGNAL(clicked()),
		   this, SLOT(slotCancel()));

  QObject::connect((QObject *)b, SIGNAL(signalWhois(QString, QString, QString)),
		   this, SLOT(slotWhois(QString, QString, QString)));

  show();
}

SilcBuddyContactInfoWidget::~SilcBuddyContactInfoWidget()
{
}

void
SilcBuddyContactInfoWidget::slotApply(void)
{
  _buddy->setFpTrusted(fpTrusted->isChecked());
  _buddy->setAllowRichText(chkAllowRichText->isChecked());
}

void
SilcBuddyContactInfoWidget::slotOk(void)
{
  slotApply();
  delete this;
}

void
SilcBuddyContactInfoWidget::slotCancel(void)
{
  delete this;
}

void
SilcBuddyContactInfoWidget::slotWhois(QString _nickname, QString _username,
QString _realname)
{
  nickname->setText(QString("%1 (%2)").arg(_nickname).arg(_username));
  realname->setText(QString(_realname));
  update->setText(QDateTime::currentDateTime().
		  toString("dd.MM.yyyy hh:mm:ss"));

  // show list of channels ...
  channels->setText(_buddy->channelList().join(" "));
  // Show Attributes 
  labelAttributes->setText(_buddy->attributes->getInformations()); 
}


#include "silcbuddycontactinfowidget.moc"

