/*
 *  Copyright (C) 1999 Brad Stephens
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <assert.h>
#include "../ballistics.h"
#include "../gfx.h"
#include "../log.h"


void wgxDrawBurningNapalmShot(struct Projectilepos_bal *prjpos, void *info)
{
    int tx = prjpos->x;
    int ty = prjpos->y;
    int otx = prjpos->rox;
    int oty = prjpos->roy;


    int sx = gfxTerrainToScreenXCoord(tx);
    int sy = gfxTerrainToScreenYCoord(ty);

    gfxDrawArea(otx - gfxScaleScreenToTerrainXDimen(2),
		oty - gfxScaleScreenToTerrainYDimen(2),
		gfxScaleScreenToTerrainXDimen(5),
		gfxScaleScreenToTerrainYDimen(5));

    if(tx == -1 && ty == -1)
	return;

    ggiPutPixel(gfx_vis, sx, sy, gfx_red);
    ggiPutPixel(gfx_vis, sx + 1, sy, gfx_red);
    ggiPutPixel(gfx_vis, sx - 1, sy, gfx_red);
    ggiPutPixel(gfx_vis, sx, sy + 1, gfx_red);
    ggiPutPixel(gfx_vis, sx, sy - 1, gfx_red);
}

void wgxDrawBurningNapalmExplosion(void *info)
{
    int i, y;
    ggi_color c;
    ggi_pixel gfx_burning;
    int duration = ((struct DurationExplosion_wep*)info)->duration;
    int tx=((struct DurationExplosion_wep*)info)->x;
    int twidth=((struct DurationExplosion_wep*)info)->width;
    int sx = 0;
    int sy = 0;

    if(duration%2)
    {
	c.g = 0xDFFF;
    }
    else
    {
	c.g = 0x1FFF;
    }
    c.r = 0xFFFF;
    c.b = 0x0;
    c.a = 0xFF << 8;

    if(duration <= 0)
    {
	c.r = 0xEF;
	c.g = 0xEF;
	c.b = 0xEF;
	c.a = 0xFF << 8;
    }
    gfx_burning = ggiMapColor(gfx_vis, &c);
    ggiSetGCForeground(gfx_vis, gfx_burning);
    for(i = (tx - (twidth / 2)); i <= (tx + (twidth / 2)); i++)
    {
	int ii = i; /* sometimes i is a invalid value, but ii is always valid */
	if(i < 0)
	    ii = i + ter_sizex;
	else if(i >= ter_sizex)
	    ii = i - ter_sizex;
	y = terGetHeight(&ter_data[ii]);
	sx = gfxTerrainToScreenXCoord(ii);
	sy = gfxTerrainToScreenYCoord(y);
	assert(terCheckPos(ter_data, ii, y));
	ggiPutPixel(gfx_vis, sx, sy + 1, gfx_burning);
	ggiPutPixel(gfx_vis, sx, sy + 2, gfx_burning);
	ggiPutPixel(gfx_vis, sx, sy + 3, gfx_burning);
    }
}
