/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* imageconfig.h
 */
#ifndef imageconfig_h
#define imageconfig_h

#include <qwidget.h>

namespace KoverArtist
{
   class Image;
}

class KURLRequester;
class QCheckBox;
class QComboBox;
class QLabel;


/** A high level gui widget for changing the various configuration elements
 * of a koverartist image.
 */
class ImageConfig: public QWidget
{
   Q_OBJECT
   typedef QWidget Inherited;

public:
   ImageConfig(KoverArtist::Image* img, QWidget* parent=0, const char* name=0);
   virtual ~ImageConfig();

signals:
   /** Emitted when the user changed image settings. */
   void changed();

public slots:
   /** Update the gui elements from the image. */
   virtual void update();

   virtual void setPosition(int);
   virtual void setFileName(const QString&);
   virtual void setOnSides(bool);

protected:
   KoverArtist::Image *mImage;
   QComboBox *mCboPosition;
   KURLRequester *mEdtFileName;
   QCheckBox *mCbxOnSides;
};

#endif /*imageconfig_h*/
