/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// main.cpp

#include "mainwindow.h"
#include "case.h"

#include "../config.h"

#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include <iostream>


#ifdef FOR_POFILE_ONLY
I18N_NOOP("_: NAME OF TRANSLATORS\nYour names");
I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails");
#endif

static const char description[] =
   I18N_NOOP("A program for cd/dvd cover creation");

static const char version[] = VERSION;


static KCmdLineOptions options[] =
{
   { "+[URL]", I18N_NOOP( "Project to open" ), 0 },
   KCmdLineLastOption
};


int main(int argc, char **argv)
{
   KAboutData about("koverartist", "KoverArtist", version, description,
		     KAboutData::License_GPL_V2, "(C) 2006 Stefan Taferner",
		     0, 0, "taferner@kde.org");
   about.addAuthor("Stefan Taferner", 0, "taferner@kde.org");
   KCmdLineArgs::init(argc, argv, &about);
   KCmdLineArgs::addCmdLineOptions(options);
   KApplication app;

   KoverArtist::Case::loadCases();

   // register ourselves as a dcop client
   app.dcopClient()->registerAs(app.name(), false);

   // see if we are starting with session management
   if (app.isRestored())
   {
      RESTORE(MainWindow);
   }
   else
   {
      // no session.. just start up normally
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
      if (args->count() == 0)
      {
	 MainWindow *widget = new MainWindow;
	 widget->show();
      }
      else
      {
	 for (int i=0; i<args->count(); i++)
	 {
	    MainWindow *mw = new MainWindow;
	    mw->show();
	    mw->load(args->url(i));
	 }
      }
      args->clear();
   }

   return app.exec();
}
