#ifndef DSPOUTALSA_H_INCLUDED
#define DSPOUTALSA_H_INCLUDED

#include <alsa/asoundlib.h>
#include "dspout.h"

class DspOutAlsa : public DspOut
{
public:
	/**
	 * Constructs a DspOutAlsa object representing the given
	 * filename.  Default is default.
	 */
	DspOutAlsa( const QString &fileName = "default" ); //Changed by bobosch

	/**
	 * Destructor.  Will close the device if it is open.
	 */
	virtual ~DspOutAlsa( void );

	bool openDevice( DeviceMode mode );
	bool writeBuffer( void );
	unsigned int readableBytes( void );
	bool readBuffer( int bytes );
	int audio_fd;

private:
	int err;
	snd_pcm_t *handle;
	snd_pcm_hw_params_t *hw_params;
	snd_pcm_uframes_t buffer_size;
	QString devname;         // device filename
};

#endif  // DSPOUTOSS_H_INCLUDED
